/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.codeeditor;

import jamiebalfour.codeeditor.CodeEditorView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;

class SyntaxHighlighter
extends DefaultStyledDocument {
    private final String quoteDelimiters;
    private final String varDelimiters;
    private static Graphics2D g;
    private final DefaultStyledDocument doc = this;
    private final Element rootElement;
    private boolean multiLineComment;
    private final HashMap<String, SimpleAttributeSet> keywords;
    private int fontSize = 18;
    private String fontName = "Monospaced";
    private final CodeEditorView codeEdit;
    JEditorPane edit;

    SyntaxHighlighter(CodeEditorView c, HashMap<String, SimpleAttributeSet> keywords, String quotes, String variables, String eol) {
        this.codeEdit = c;
        this.rootElement = this.doc.getDefaultRootElement();
        this.putProperty("__EndOfLine__", eol);
        this.keywords = keywords;
        this.quoteDelimiters = quotes;
        this.varDelimiters = variables;
    }

    public SyntaxHighlighter(CodeEditorView c, final HashMap<String, SimpleAttributeSet> keywords, final String quotes, final String variables) {
        this.codeEdit = c;
        this.rootElement = this.doc.getDefaultRootElement();
        this.putProperty("__EndOfLine__", "\n");
        this.keywords = keywords;
        this.quoteDelimiters = quotes;
        this.varDelimiters = variables;
        StyledEditorKit editorKit = new StyledEditorKit(){

            @Override
            public Document createDefaultDocument() {
                return new SyntaxHighlighter(SyntaxHighlighter.this.codeEdit, keywords, quotes, variables, "\n");
            }
        };
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        g = ge.createGraphics(new BufferedImage(1, 1, 1));
        this.edit = new JEditorPane();
        this.edit.setEditorKitForContentType("text/java", editorKit);
        this.edit.setContentType("text/java");
    }

    private void embolden(MutableAttributeSet x, boolean v) {
        Font f = this.getFont(x);
        Font nFont = v ? new Font(f.getName(), 1, f.getSize()) : new Font(f.getName(), 0, f.getSize());
        SyntaxHighlighter.setAttributeFont(x, nFont);
    }

    public void makeBold(boolean v) {
        this.embolden(CodeEditorView.DEFAULT_NULL, v);
        this.embolden(CodeEditorView.DEFAULT_NORMAL, v);
        this.embolden(CodeEditorView.DEFAULT_COMMENT, v);
        this.embolden(CodeEditorView.DEFAULT_STRING, v);
        this.embolden(CodeEditorView.DEFAULT_PREDEFINED_FUNCTION, v);
        this.embolden(CodeEditorView.DEFAULT_HEREDOC, v);
        this.embolden(CodeEditorView.DEFAULT_BOOLEAN, v);
        this.embolden(CodeEditorView.DEFAULT_VAR, v);
    }

    public void setAttributeFont(CodeEditorView.ATTR_TYPE attr, int style) {
        Font f = new Font(this.fontName, style, this.fontSize);
        if (attr == CodeEditorView.ATTR_TYPE.Comment) {
            SyntaxHighlighter.setAttributeFont(CodeEditorView.DEFAULT_COMMENT, f);
        } else if (attr == CodeEditorView.ATTR_TYPE.Quote) {
            SyntaxHighlighter.setAttributeFont(CodeEditorView.DEFAULT_STRING, f);
        } else if (attr == CodeEditorView.ATTR_TYPE.Keyword) {
            SyntaxHighlighter.setAttributeFont(CodeEditorView.DEFAULT_KEYWORD, f);
        } else if (attr == CodeEditorView.ATTR_TYPE.Function) {
            SyntaxHighlighter.setAttributeFont(CodeEditorView.DEFAULT_PREDEFINED_FUNCTION, f);
        } else if (attr == CodeEditorView.ATTR_TYPE.Heredoc) {
            SyntaxHighlighter.setAttributeFont(CodeEditorView.DEFAULT_HEREDOC, f);
        } else if (attr == CodeEditorView.ATTR_TYPE.Bool) {
            SyntaxHighlighter.setAttributeFont(CodeEditorView.DEFAULT_BOOLEAN, f);
        } else if (attr == CodeEditorView.ATTR_TYPE.Var) {
            SyntaxHighlighter.setAttributeFont(CodeEditorView.DEFAULT_VAR, f);
        } else if (attr == CodeEditorView.ATTR_TYPE.Doc) {
            SyntaxHighlighter.setAttributeFont(CodeEditorView.DEFAULT_DOC, f);
        } else if (attr == CodeEditorView.ATTR_TYPE.Type) {
            SyntaxHighlighter.setAttributeFont(CodeEditorView.DEFAULT_TYPE, f);
        } else {
            SyntaxHighlighter.setAttributeFont(CodeEditorView.DEFAULT_NORMAL, f);
        }
    }

    public static SimpleAttributeSet getAttributeStyle(CodeEditorView.ATTR_TYPE attr) {
        if (attr == CodeEditorView.ATTR_TYPE.Comment) {
            return CodeEditorView.DEFAULT_COMMENT;
        }
        if (attr == CodeEditorView.ATTR_TYPE.Quote) {
            return CodeEditorView.DEFAULT_STRING;
        }
        if (attr == CodeEditorView.ATTR_TYPE.Keyword) {
            return CodeEditorView.DEFAULT_KEYWORD;
        }
        if (attr == CodeEditorView.ATTR_TYPE.Function) {
            return CodeEditorView.DEFAULT_PREDEFINED_FUNCTION;
        }
        if (attr == CodeEditorView.ATTR_TYPE.Heredoc) {
            return CodeEditorView.DEFAULT_HEREDOC;
        }
        if (attr == CodeEditorView.ATTR_TYPE.Bool) {
            return CodeEditorView.DEFAULT_BOOLEAN;
        }
        if (attr == CodeEditorView.ATTR_TYPE.Var) {
            return CodeEditorView.DEFAULT_VAR;
        }
        if (attr == CodeEditorView.ATTR_TYPE.Doc) {
            return CodeEditorView.DEFAULT_DOC;
        }
        if (attr == CodeEditorView.ATTR_TYPE.Type) {
            return CodeEditorView.DEFAULT_TYPE;
        }
        return CodeEditorView.DEFAULT_NORMAL;
    }

    public static void setAttributeFont(MutableAttributeSet attr, Font f) {
        StyleConstants.setBold(attr, f.isBold());
        StyleConstants.setItalic(attr, f.isItalic());
        StyleConstants.setFontFamily(attr, f.getFamily());
        StyleConstants.setFontSize(attr, f.getSize());
    }

    public void setAttributeColor(CodeEditorView.ATTR_TYPE attr, Color c) {
        if (attr == CodeEditorView.ATTR_TYPE.Comment) {
            SyntaxHighlighter.setAttributeColor(CodeEditorView.DEFAULT_COMMENT, c);
        } else if (attr == CodeEditorView.ATTR_TYPE.Quote) {
            SyntaxHighlighter.setAttributeColor(CodeEditorView.DEFAULT_STRING, c);
        } else if (attr == CodeEditorView.ATTR_TYPE.Keyword) {
            SyntaxHighlighter.setAttributeColor(CodeEditorView.DEFAULT_KEYWORD, c);
        } else if (attr == CodeEditorView.ATTR_TYPE.Function) {
            SyntaxHighlighter.setAttributeColor(CodeEditorView.DEFAULT_PREDEFINED_FUNCTION, c);
        } else if (attr == CodeEditorView.ATTR_TYPE.Heredoc) {
            SyntaxHighlighter.setAttributeColor(CodeEditorView.DEFAULT_HEREDOC, c);
        } else if (attr == CodeEditorView.ATTR_TYPE.Bool) {
            SyntaxHighlighter.setAttributeColor(CodeEditorView.DEFAULT_BOOLEAN, c);
        } else if (attr == CodeEditorView.ATTR_TYPE.Var) {
            SyntaxHighlighter.setAttributeColor(CodeEditorView.DEFAULT_VAR, c);
        } else if (attr == CodeEditorView.ATTR_TYPE.Doc) {
            SyntaxHighlighter.setAttributeColor(CodeEditorView.DEFAULT_DOC, c);
        } else if (attr == CodeEditorView.ATTR_TYPE.Type) {
            SyntaxHighlighter.setAttributeColor(CodeEditorView.DEFAULT_TYPE, c);
        } else if (attr == CodeEditorView.ATTR_TYPE.Special) {
            SyntaxHighlighter.setAttributeColor(CodeEditorView.DEFAULT_SPECIAL, c);
        } else {
            SyntaxHighlighter.setAttributeColor(CodeEditorView.DEFAULT_NORMAL, c);
        }
    }

    public static void setAttributeColor(MutableAttributeSet attr, Color c) {
        StyleConstants.setForeground(attr, c);
    }

    public void addKeyword(String keyword, SimpleAttributeSet attr) {
        this.keywords.put(keyword, attr);
    }

    public MutableAttributeSet getKeywordFormatting(String keyword) {
        return this.keywords.get(keyword);
    }

    public void removeKeyword(String keyword) {
        this.keywords.remove(keyword);
    }

    public void setTabs(int charactersPerTab) {
        Font f = new Font(this.fontName, 0, this.fontSize);
        FontMetrics fm = g.getFontMetrics(f);
        int charWidth = fm.charWidth('w');
        int tabWidth = charWidth * charactersPerTab;
        TabStop[] tabs = new TabStop[35];
        for (int j = 0; j < tabs.length; ++j) {
            int tab = j + 1;
            tabs[j] = new TabStop(tab * tabWidth);
        }
        TabSet tabSet = new TabSet(tabs);
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setTabSet(attributes, tabSet);
        int length = this.getLength();
        this.setParagraphAttributes(0, length, attributes, false);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        boolean wasBrace = false;
        switch (str) {
            case "{": {
                str = this.addMatchingBrace(offset, "{", "}", false);
                wasBrace = true;
                break;
            }
            case "(": {
                str = this.addMatchingBrace(offset, "(", ")", false);
                wasBrace = true;
                break;
            }
            case "[": {
                str = this.addMatchingBrace(offset, "[", "]", false);
                wasBrace = true;
                break;
            }
            case "\"": {
                str = this.addMatchingBrace(offset, "\"", "\"", false);
                wasBrace = true;
                break;
            }
            case "'": {
                str = this.addMatchingBrace(offset, "'", "'", false);
                wasBrace = true;
            }
        }
        super.insertString(offset, str, a);
        this.processChangedLines(offset, str.length());
        if (wasBrace) {
            this.codeEdit.lineNumbers.editor.setCaretPosition(this.codeEdit.lineNumbers.editor.getCaretPosition() - 1);
        }
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.processChangedLines(offset, 0);
    }

    public void processChangedLines(int offset, int length) throws BadLocationException {
        String content = this.doc.getText(0, this.doc.getLength());
        int startLine = this.rootElement.getElementIndex(offset);
        int endLine = this.rootElement.getElementIndex(offset + length);
        this.setMultiLineComment(this.commentLinesBefore(content, startLine));
        for (int i = startLine; i <= endLine; ++i) {
            this.applyHighlighting(content, i);
        }
        if (this.isMultiLineComment()) {
            this.commentLinesAfter(content, endLine);
        } else {
            this.highlightLinesAfter(content, endLine);
        }
    }

    private boolean commentLinesBefore(String content, int line) {
        int offset = this.rootElement.getElement(line).getStartOffset();
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), offset - 2);
        if (startDelimiter < 0) {
            return false;
        }
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), startDelimiter);
        if (endDelimiter < offset & endDelimiter != -1) {
            return false;
        }
        this.doc.setCharacterAttributes(startDelimiter, offset - startDelimiter + 1, CodeEditorView.DEFAULT_COMMENT, false);
        return true;
    }

    private void commentLinesAfter(String content, int line) {
        int offset = this.rootElement.getElement(line).getEndOffset();
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (endDelimiter < 0) {
            return;
        }
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), endDelimiter);
        if (startDelimiter < 0 || startDelimiter <= offset) {
            this.doc.setCharacterAttributes(offset, endDelimiter - offset + 1, CodeEditorView.DEFAULT_COMMENT, false);
        }
    }

    private void highlightLinesAfter(String content, int line) {
        int delimiter;
        int offset = this.rootElement.getElement(line).getEndOffset();
        int startDelimiter = this.indexOf(content, this.getStartDelimiter(), offset);
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (startDelimiter < 0) {
            startDelimiter = content.length();
        }
        if (endDelimiter < 0) {
            endDelimiter = content.length();
        }
        if ((delimiter = Math.min(startDelimiter, endDelimiter)) < offset) {
            return;
        }
        int endLine = this.rootElement.getElementIndex(delimiter);
        for (int i = line + 1; i < endLine; ++i) {
            Element branch = this.rootElement.getElement(i);
            Element leaf = this.doc.getCharacterElement(branch.getStartOffset());
            AttributeSet as = leaf.getAttributes();
            if (!as.isEqual(CodeEditorView.DEFAULT_COMMENT)) continue;
            this.applyHighlighting(content, i);
        }
    }

    private void applyHighlighting(String content, int line) {
        int startOffset = this.rootElement.getElement(line).getStartOffset();
        int endOffset = this.rootElement.getElement(line).getEndOffset() - 1;
        int lineLength = endOffset - startOffset;
        int contentLength = content.length();
        if (endOffset >= contentLength) {
            endOffset = contentLength - 1;
        }
        if (this.endingMultiLineComment(content, startOffset, endOffset) || this.isMultiLineComment() || this.startingMultiLineComment(content, startOffset, endOffset)) {
            this.doc.setCharacterAttributes(startOffset, endOffset - startOffset + 1, CodeEditorView.DEFAULT_COMMENT, false);
            return;
        }
        this.doc.setCharacterAttributes(startOffset, lineLength, CodeEditorView.DEFAULT_NORMAL, true);
        int index = content.indexOf(this.getSingleLineDelimiter(), startOffset);
        if (index > -1 && index < endOffset) {
            this.doc.setCharacterAttributes(index, endOffset - index + 1, CodeEditorView.DEFAULT_COMMENT, false);
            endOffset = index - 1;
        }
        this.checkForTokens(content, startOffset, endOffset);
    }

    private boolean startingMultiLineComment(String content, int startOffset, int endOffset) {
        int index = this.indexOf(content, this.getStartDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(true);
        return true;
    }

    private boolean endingMultiLineComment(String content, int startOffset, int endOffset) {
        int index = this.indexOf(content, this.getEndDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(false);
        return true;
    }

    private boolean isMultiLineComment() {
        return this.multiLineComment;
    }

    private void setMultiLineComment(boolean value) {
        this.multiLineComment = value;
    }

    private void checkForTokens(String content, int startOffset, int endOffset) {
        while (startOffset <= endOffset) {
            while (this.isDelimiter(content.substring(startOffset, startOffset + 1))) {
                if (startOffset < endOffset) {
                    ++startOffset;
                    continue;
                }
                return;
            }
            startOffset = this.isQuoteDelimiter(content.substring(startOffset, startOffset + 1)) ? this.getQuoteToken(content, startOffset, endOffset) : (this.isVarDelimiter(content.substring(startOffset, startOffset + 1)) ? this.getVarToken(content, startOffset) : this.getOtherToken(content, startOffset, endOffset));
            this.doc.setCharacterAttributes(startOffset, endOffset, CodeEditorView.DEFAULT_NULL, false);
        }
    }

    private int getQuoteToken(String content, int startOffset, int endOffset) {
        String quoteDelimiter = content.substring(startOffset, startOffset + 1);
        String escapeString = this.getEscapeString(quoteDelimiter);
        int endOfQuote = startOffset;
        int index = content.indexOf(escapeString, endOfQuote + 1);
        while (index > -1 && index < endOffset) {
            endOfQuote = index + 1;
            index = content.indexOf(escapeString, endOfQuote);
        }
        index = content.indexOf(quoteDelimiter, endOfQuote + 1);
        endOfQuote = index < 0 || index > endOffset ? endOffset : index;
        this.doc.setCharacterAttributes(startOffset, endOfQuote - startOffset + 1, CodeEditorView.DEFAULT_STRING, false);
        return endOfQuote + 1;
    }

    private int getVarToken(String content, int startOffset) {
        String c;
        int index;
        String quoteDelimiter = content.substring(startOffset, startOffset + 1);
        for (index = startOffset; !(index >= content.length() || this.isDelimiter(c = content.substring(index, index + 1)) && !c.equals(quoteDelimiter) || c.equals(" ")); ++index) {
        }
        this.doc.setCharacterAttributes(startOffset, index - startOffset, CodeEditorView.DEFAULT_VAR, false);
        return index;
    }

    private int getOtherToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1)); ++endOfToken) {
        }
        String token = content.substring(startOffset, endOfToken);
        MutableAttributeSet attr = this.keywords.get(token);
        if (attr != null) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, attr, false);
        }
        return endOfToken + 1;
    }

    private int indexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.indexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index + 1;
        }
        return index;
    }

    private int lastIndexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.lastIndexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index - 1;
        }
        return index;
    }

    private String getLine(String content, int offset) {
        int line = this.rootElement.getElementIndex(offset);
        Element lineElement = this.rootElement.getElement(line);
        int start = lineElement.getStartOffset();
        int end = lineElement.getEndOffset();
        return content.substring(start, end - 1);
    }

    protected boolean isDelimiter(String character) {
        String operands = "();&{}[],:+-*/!";
        return Character.isWhitespace(character.charAt(0)) || operands.contains(character);
    }

    protected boolean isQuoteDelimiter(String character) {
        return this.quoteDelimiters.contains(character);
    }

    protected boolean isVarDelimiter(String character) {
        return this.varDelimiters.contains(character);
    }

    protected String getStartDelimiter() {
        return "/*";
    }

    protected String getEndDelimiter() {
        return "*/";
    }

    protected String getSingleLineDelimiter() {
        return "//";
    }

    protected String getEscapeString(String quoteDelimiter) {
        return "\\" + quoteDelimiter;
    }

    protected String addMatchingBrace(int offset, String startBrace, String endBrace, boolean addLines) throws BadLocationException {
        String temp;
        StringBuilder whiteSpace = new StringBuilder(16);
        int line = this.rootElement.getElementIndex(offset);
        int i = this.rootElement.getElement(line).getStartOffset();
        while ((temp = this.doc.getText(i, 1)).equals(" ") || temp.equals("\t")) {
            whiteSpace.append(temp);
            ++i;
        }
        Object lineSpace = "";
        if (addLines) {
            lineSpace = "\n" + String.valueOf(whiteSpace) + "\t\n" + String.valueOf(whiteSpace);
        }
        return startBrace + (String)lineSpace + endBrace;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        StyleConstants.setFontSize(CodeEditorView.DEFAULT_NULL, fontSize);
        StyleConstants.setFontSize(CodeEditorView.DEFAULT_NORMAL, fontSize);
        StyleConstants.setFontSize(CodeEditorView.DEFAULT_STRING, fontSize);
        StyleConstants.setFontSize(CodeEditorView.DEFAULT_COMMENT, fontSize);
        StyleConstants.setFontSize(CodeEditorView.DEFAULT_KEYWORD, fontSize);
        StyleConstants.setFontSize(CodeEditorView.DEFAULT_PREDEFINED_FUNCTION, fontSize);
        StyleConstants.setFontSize(CodeEditorView.DEFAULT_HEREDOC, fontSize);
        StyleConstants.setFontSize(CodeEditorView.DEFAULT_BOOLEAN, fontSize);
        StyleConstants.setFontSize(CodeEditorView.DEFAULT_VAR, fontSize);
        StyleConstants.setFontSize(CodeEditorView.DEFAULT_DOC, fontSize);
        StyleConstants.setFontSize(CodeEditorView.DEFAULT_TYPE, fontSize);
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
        StyleConstants.setFontFamily(CodeEditorView.DEFAULT_NORMAL, fontName);
        StyleConstants.setFontFamily(CodeEditorView.DEFAULT_STRING, fontName);
        StyleConstants.setFontFamily(CodeEditorView.DEFAULT_COMMENT, fontName);
        StyleConstants.setFontFamily(CodeEditorView.DEFAULT_KEYWORD, fontName);
        StyleConstants.setFontFamily(CodeEditorView.DEFAULT_PREDEFINED_FUNCTION, fontName);
        StyleConstants.setFontFamily(CodeEditorView.DEFAULT_HEREDOC, fontName);
        StyleConstants.setFontFamily(CodeEditorView.DEFAULT_BOOLEAN, fontName);
        StyleConstants.setFontFamily(CodeEditorView.DEFAULT_VAR, fontName);
        StyleConstants.setFontFamily(CodeEditorView.DEFAULT_DOC, fontName);
        StyleConstants.setFontFamily(CodeEditorView.DEFAULT_TYPE, fontName);
    }

    public Component getEditPane() {
        return this.edit;
    }
}

