/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.codeeditor;

import jamiebalfour.codeeditor.LineNumberEditor;
import jamiebalfour.codeeditor.SyntaxHighlighter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.BreakIterator;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class CodeEditorView {
    SyntaxHighlighter mainSyntax;
    LineNumberEditor lineNumbers;
    public static SimpleAttributeSet DEFAULT_NULL = new SimpleAttributeSet();
    public static SimpleAttributeSet DEFAULT_NORMAL;
    public static SimpleAttributeSet DEFAULT_COMMENT;
    public static SimpleAttributeSet DEFAULT_STRING;
    public static SimpleAttributeSet DEFAULT_KEYWORD;
    public static SimpleAttributeSet DEFAULT_PREDEFINED_FUNCTION;
    public static SimpleAttributeSet DEFAULT_HEREDOC;
    public static SimpleAttributeSet DEFAULT_BOOLEAN;
    public static SimpleAttributeSet DEFAULT_VAR;
    public static SimpleAttributeSet DEFAULT_DOC;
    public static SimpleAttributeSet DEFAULT_TYPE;
    public static SimpleAttributeSet DEFAULT_SPECIAL;
    public static final String DEFAULT_FONT_FAMILY = "Monospaced";
    public static final int DEFAULT_FONT_SIZE = 18;

    public CodeEditorView(HashMap<String, SimpleAttributeSet> keywords, String quotes, String variables) {
        this.mainSyntax = new SyntaxHighlighter(this, keywords, quotes, variables);
        this.lineNumbers = new LineNumberEditor(this.mainSyntax.edit);
    }

    public Component getEditPane() {
        return this.mainSyntax.getEditPane();
    }

    public void setAttributeColor(ATTR_TYPE attr, Color c) {
        this.mainSyntax.setAttributeColor(attr, c);
    }

    public void setFontSize(int fontSize) {
        this.mainSyntax.setFontSize(fontSize);
    }

    public void makeBold(boolean v) {
        this.mainSyntax.makeBold(v);
    }

    public void setFontName(String fontName) {
        this.mainSyntax.setFontName(fontName);
    }

    public void setTextUnicodeSafe(String text) throws BadLocationException {
        Font base = new Font(DEFAULT_FONT_FAMILY, 0, 18);
        Font emoji = new Font(CodeEditorView.emojiFontForOS(), 0, 18);
        SimpleAttributeSet baseStyle = new SimpleAttributeSet();
        StyleConstants.setFontFamily(baseStyle, base.getFamily());
        StyleConstants.setFontSize(baseStyle, base.getSize());
        SimpleAttributeSet emojiStyle = new SimpleAttributeSet();
        StyleConstants.setFontFamily(emojiStyle, emoji.getFamily());
        StyleConstants.setFontSize(emojiStyle, emoji.getSize());
        this.mainSyntax.remove(0, this.mainSyntax.getLength());
        BreakIterator it = BreakIterator.getCharacterInstance(Locale.ROOT);
        it.setText(text);
        int s = it.first();
        int e = it.next();
        while (e != -1) {
            String cluster = text.substring(s, e);
            boolean renderable = base.canDisplayUpTo(cluster) == -1;
            this.mainSyntax.insertString(this.mainSyntax.getLength(), cluster, renderable ? baseStyle : emojiStyle);
            s = e;
            e = it.next();
        }
        this.mainSyntax.processChangedLines(0, this.mainSyntax.getLength());
    }

    private static String emojiFontForOS() {
        String os = System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        if (os.contains("mac")) {
            return "Apple Color Emoji";
        }
        if (os.contains("win")) {
            return "Segoe UI Emoji";
        }
        return "Noto Color Emoji";
    }

    public void setTextSafely(String text) {
        try {
            this.mainSyntax.setFontName(DEFAULT_FONT_FAMILY);
            this.setTextUnicodeSafe(text);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void updateFont(Font f) {
        this.lineNumbers.updateFont(f);
    }

    public JComponent getEditor() {
        return this.lineNumbers;
    }

    public void repaint() {
        this.lineNumbers.repaint();
    }

    static {
        StyleConstants.setFontSize(DEFAULT_NULL, 18);
        DEFAULT_NORMAL = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_NORMAL, Color.BLACK);
        StyleConstants.setFontFamily(DEFAULT_NORMAL, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_NORMAL, 18);
        DEFAULT_COMMENT = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_COMMENT, new Color(170, 170, 170));
        StyleConstants.setItalic(DEFAULT_COMMENT, true);
        StyleConstants.setFontFamily(DEFAULT_COMMENT, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_COMMENT, 18);
        DEFAULT_STRING = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_STRING, new Color(0, 150, 0));
        StyleConstants.setFontFamily(DEFAULT_STRING, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_STRING, 18);
        DEFAULT_KEYWORD = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_KEYWORD, new Color(200, 0, 255));
        StyleConstants.setBold(DEFAULT_KEYWORD, true);
        StyleConstants.setFontFamily(DEFAULT_KEYWORD, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_KEYWORD, 18);
        DEFAULT_PREDEFINED_FUNCTION = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_PREDEFINED_FUNCTION, new Color(24, 155, 220));
        StyleConstants.setFontFamily(DEFAULT_PREDEFINED_FUNCTION, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_PREDEFINED_FUNCTION, 18);
        DEFAULT_HEREDOC = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_HEREDOC, new Color(24, 155, 220));
        StyleConstants.setFontFamily(DEFAULT_HEREDOC, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_HEREDOC, 18);
        DEFAULT_BOOLEAN = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_BOOLEAN, new Color(200, 100, 0));
        StyleConstants.setFontFamily(DEFAULT_BOOLEAN, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_BOOLEAN, 18);
        DEFAULT_VAR = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_VAR, new Color(255, 0, 0));
        StyleConstants.setFontFamily(DEFAULT_VAR, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_VAR, 18);
        DEFAULT_DOC = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_DOC, new Color(46, 159, 175));
        StyleConstants.setBold(DEFAULT_DOC, true);
        StyleConstants.setFontFamily(DEFAULT_DOC, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_DOC, 18);
        DEFAULT_TYPE = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_TYPE, new Color(150, 0, 150));
        StyleConstants.setBold(DEFAULT_TYPE, false);
        StyleConstants.setFontFamily(DEFAULT_TYPE, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_TYPE, 18);
        DEFAULT_SPECIAL = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_SPECIAL, new Color(148, 113, 154));
        StyleConstants.setBold(DEFAULT_SPECIAL, true);
        StyleConstants.setFontFamily(DEFAULT_SPECIAL, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(DEFAULT_SPECIAL, 18);
    }

    public static enum ATTR_TYPE {
        Normal,
        Comment,
        Quote,
        Keyword,
        Function,
        Heredoc,
        Bool,
        Var,
        Doc,
        Type,
        Special;

    }
}

