/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class RecentFilesManager {
    private static final String RECENT_KEY = "recentFiles";
    private static final int MAX_RECENT = 10;
    private final List<String> recentFiles = new ArrayList<String>();
    private final String propsFile;
    private final String programName;

    public RecentFilesManager(String propsFile, String programName) {
        this.propsFile = propsFile;
        this.programName = programName;
        this.load();
    }

    public List<String> getRecentFiles() {
        return new ArrayList<String>(this.recentFiles);
    }

    public void addRecentFile(String path) {
        this.recentFiles.remove(path);
        this.recentFiles.add(0, path);
        while (this.recentFiles.size() > 10) {
            this.recentFiles.remove(this.recentFiles.size() - 1);
        }
        this.save();
    }

    private void load() {
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileInputStream in = new FileInputStream(this.propsFile);){
                props.load(in);
                String csv = props.getProperty(RECENT_KEY, "");
                this.recentFiles.clear();
                if (!csv.isBlank()) {
                    this.recentFiles.addAll(Arrays.asList(csv.split("\\|")));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    private void save() {
        Properties props = new Properties();
        props.setProperty(RECENT_KEY, String.join((CharSequence)"|", this.recentFiles));
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream out = new FileOutputStream(this.propsFile);){
                props.store(out, String.valueOf(this.programName) + " Recent Files");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

