/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.parser;

import jamiebalfour.zpe.parser.Tokeniser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class ZenithParsingEngine {
    public static final String VERSION = "1.4";
    private String program = "";
    private byte current_symbol = (byte)-128;
    private String current_word = "";
    private int current_line = 0;
    private byte previous_symbol;
    private int program_counter = 0;
    private boolean case_insensitive = false;
    private Tokeniser tokens;
    private ArrayList<String> word_list = new ArrayList();
    private ArrayList<Byte> byte_list = new ArrayList();
    private String whitespaces = "";
    private Map<String, String> replaceables = new HashMap<String, String>();
    private ArrayList<MultilineComment> comments = new ArrayList();
    private boolean ignore_quotes = false;
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String CRLF = "\r\n";

    public ZenithParsingEngine(String program_code, boolean caseInsensitive, Tokeniser t) {
        this.case_insensitive = caseInsensitive;
        this.tokens = t;
        if (this.tokens.listOfComments() != null) {
            this.comments = this.tokens.listOfComments();
        }
        this.program = program_code;
        this.program = ZenithParsingEngine.prepareString(this.program);
    }

    private static String prepareString(String s) {
        String out = "";
        Scanner scanner = new Scanner(s);
        while (scanner.hasNextLine()) {
            String ln = scanner.nextLine();
            out = String.valueOf(out) + ln + " " + System.getProperty("line.separator");
        }
        scanner.close();
        return out;
    }

    public void ignoreQuotes(boolean v) {
        this.ignore_quotes = v;
    }

    public void skipSymbol(byte s) {
        if (this.getCurrentSymbol() == s) {
            this.getNextSymbol();
        }
    }

    public byte stringToByte(String s) {
        return this.tokens.stringToByteCode(s);
    }

    public void setCurrentSymbol(byte s) {
        this.current_symbol = s;
    }

    public void setCurrentWord(String s) {
        this.current_word = s;
    }

    public void setProgram(String p) {
        this.program = p;
    }

    public void insertProgramAtCounter(String p) {
        String output;
        String start = this.program.substring(0, this.program_counter);
        String end = this.program.substring(this.program_counter + 1);
        this.program = output = String.valueOf(start) + ZenithParsingEngine.prepareString(p) + end;
    }

    public ArrayList<Byte> getByteList() {
        return this.byte_list;
    }

    public ArrayList<String> getWordList() {
        return this.word_list;
    }

    public String getProgram() {
        return this.program;
    }

    public int getProgramCounter() {
        return this.program_counter;
    }

    public byte getCurrentSymbol() {
        return this.current_symbol;
    }

    public int getCurrentLine() {
        return this.current_line;
    }

    public void addConstant(String n, String v) {
        this.replaceables.put(n, v);
    }

    public String getWhitespace() {
        return this.whitespaces;
    }

    public char getNextChar() {
        ++this.program_counter;
        return this.program.charAt(this.program_counter);
    }

    public String parseTo(byte symb) {
        String output = "";
        this.next(false);
        while (this.program_counter < this.program.length()) {
            if (this.current_symbol == symb) {
                return output;
            }
            output = String.valueOf(output) + this.whitespaces + this.current_word;
            this.next(false);
        }
        return output;
    }

    public String getCurrentWord() {
        return this.getCurrentWord(true);
    }

    public String getCurrentWord(boolean replaceQuotes) {
        String s = this.current_word;
        if (replaceQuotes && s.length() > 0 && s != null) {
            char currChar = s.charAt(0);
            if (this.tokens.quoteTypes() != null && this.tokens.quoteTypes().contains("" + currChar) && (s = s.substring(1, s.length())).charAt(s.length() - 1) == currChar) {
                s = s.substring(0, s.length() - 1);
            }
        }
        if (this.replaceables.containsKey(s)) {
            s = this.current_word = this.replaceables.get(s);
        }
        return s;
    }

    public boolean hasNext() {
        return this.current_symbol != -2;
    }

    public byte getNextSymbol() {
        this.current_symbol = this.next(false);
        this.word_list.add(this.current_word);
        this.byte_list.add(this.current_symbol);
        return this.current_symbol;
    }

    public int getPreviousSymbol() {
        return this.previous_symbol;
    }

    public boolean checkProgramCounter() {
        return this.program_counter < this.program.length();
    }

    public byte peekAhead() {
        return this.peekAhead(1);
    }

    public byte peekAhead(int n) {
        int tempPc = this.program_counter;
        byte curSymb = this.current_symbol;
        byte curPrevSymb = this.previous_symbol;
        int cline = this.current_line;
        String curWord = this.current_word;
        String cWhitespace = this.whitespaces;
        int q = 0;
        byte i = 0;
        q = 0;
        while (q < n) {
            i = this.next(true);
            ++q;
        }
        this.program_counter = tempPc;
        this.current_symbol = curSymb;
        this.previous_symbol = curPrevSymb;
        this.current_word = curWord;
        this.current_line = cline;
        this.whitespaces = cWhitespace;
        return i;
    }

    private byte next(boolean peeking) {
        this.whitespaces = "";
        if (this.program_counter >= this.program.length()) {
            return -2;
        }
        this.previous_symbol = this.current_symbol;
        String word = "";
        word = this.getNextWord(peeking);
        if (word == null || word.length() == 0) {
            return -2;
        }
        this.current_word = word;
        this.current_symbol = this.case_insensitive ? this.tokens.stringToByteCode(word.toLowerCase()) : this.tokens.stringToByteCode(word);
        return this.current_symbol;
    }

    private boolean isBoundWord(String s) {
        String[] stringArray = this.tokens.listOfBoundWords();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String q = stringArray[n2];
            if (q.equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void throwBoundWordError() {
        System.err.println("Zenith Parsing Engine: Bound word exception found at " + this.program_counter);
    }

    /*
     * Unable to fully structure code
     */
    private String getNextWord(boolean peeking) {
        word = "";
        in_comment = this.parserIsCommentStart();
        if (in_comment != null) {
            this.parserEatComments(in_comment);
        }
        this.whitespaces = String.valueOf(this.whitespaces) + this.parser_eat_whitespace();
        if (this.program_counter >= this.program.length()) {
            return null;
        }
        ch = this.program.charAt(this.program_counter);
        if (ch != '\u0000') ** GOTO lbl104
        return null;
lbl-1000:
        // 1 sources

        {
            ch = this.program.charAt(this.program_counter);
            var8_11 = this.tokens.listOfSubsequentCharacters();
            var7_10 = var8_11.length;
            var6_7 = 0;
            while (var6_7 < var7_10) {
                s = var8_11[var6_7];
                end = this.program.length() - this.program_counter + s.length();
                if (end < this.program.length() && end > this.program_counter && this.program.substring(this.program_counter, end).equals(s)) {
                    if (!word.equals("")) {
                        return word;
                    }
                    this.program_counter += s.length();
                    if (this.isBoundWord(s) && this.isWhitespace() != null) {
                        this.throwBoundWordError();
                    }
                    return s;
                }
                ++var6_7;
            }
            if (this.program_counter + 1 < this.program.length()) {
                double_char = String.valueOf(String.valueOf(ch)) + String.valueOf(this.program.charAt(this.program_counter + 1));
                var9_14 = this.tokens.listOfSubsequentCharacters();
                var8_12 = var9_14.length;
                var7_10 = 0;
                while (var7_10 < var8_12) {
                    s = var9_14[var7_10];
                    if (s.startsWith(double_char)) {
                        new_word = double_char;
                        if (s.length() > 2) {
                            for (count = 2; this.program_counter + count < this.program.length() && count < s.length(); ++count) {
                                new_word = String.valueOf(new_word) + this.program.charAt(this.program_counter + count);
                                if (!new_word.equals(s)) continue;
                                this.program_counter += new_word.length();
                                if (!word.equals("")) {
                                    return word;
                                }
                                return new_word;
                            }
                        } else {
                            if (!word.equals("")) {
                                return word;
                            }
                            this.program_counter += 2;
                            return double_char;
                        }
                        if (this.isBoundWord(new_word) && this.isWhitespace() != null) {
                            this.throwBoundWordError();
                        }
                        if (new_word.equals(s)) {
                            this.program_counter += new_word.length();
                            if (!word.equals("")) {
                                return word;
                            }
                            return new_word;
                        }
                    }
                    ++var7_10;
                }
            }
            if (ch == '.' && (allNumeric = word.matches("[0-9]+"))) {
                word = String.valueOf(word) + ".";
                ++this.program_counter;
                while (this.program_counter < this.program.length()) {
                    ch = this.program.charAt(this.program_counter);
                    if (ZenithParsingEngine.isNumeric("" + ch)) {
                        word = String.valueOf(word) + ch;
                        ++this.program_counter;
                        continue;
                    }
                    if (ch == 'E') {
                        if (this.program_counter + 1 < this.program.length()) {
                            chnext = this.program.charAt(this.program_counter + 1);
                            if (ZenithParsingEngine.isNumeric(String.valueOf(word) + 'E' + chnext)) {
                                word = String.valueOf(word) + 'E';
                                ++this.program_counter;
                                continue;
                            }
                            return word;
                        }
                        return word;
                    }
                    return word;
                }
            }
            if (ch == 'E' && word.matches("[0-9]+")) {
                word = String.valueOf(word) + "E";
                ++this.program_counter;
                while (this.program_counter < this.program.length()) {
                    ch = this.program.charAt(this.program_counter);
                    if (ch == '-') {
                        word = String.valueOf(word) + "-";
                        if (this.program_counter + 1 < this.program.length()) {
                            ++this.program_counter;
                            ch = this.program.charAt(this.program_counter);
                        }
                    }
                    if (ZenithParsingEngine.isNumeric("" + ch)) {
                        word = String.valueOf(word) + ch;
                        ++this.program_counter;
                        continue;
                    }
                    return word;
                }
            }
            if (this.parserIsDelimiterCharacter(ch)) {
                ch = this.program.charAt(this.program_counter);
                if (word.equals("")) {
                    ++this.program_counter;
                    if (this.isBoundWord("" + ch) && this.isWhitespace() != null) {
                        this.throwBoundWordError();
                    }
                    return "" + ch;
                }
                if (this.isBoundWord(word) && this.isWhitespace() != null) {
                    this.throwBoundWordError();
                }
                return word;
            }
            word = this.ignore_quotes == false && this.parserIsQuote(ch) != false ? this.readString(ch) : String.valueOf(word) + ch;
            ++this.program_counter;
lbl104:
            // 2 sources

            ** while (this.program_counter < this.program.length())
        }
lbl105:
        // 1 sources

        return word;
    }

    private String readString(char quoteSymbol) {
        String word = "\"";
        ++this.program_counter;
        while (this.program_counter < this.program.length() && (this.program_counter - 1 < 0 || this.program.charAt(this.program_counter - 1) == '/' || this.program.charAt(this.program_counter) != quoteSymbol)) {
            word = String.valueOf(word) + this.program.charAt(this.program_counter);
            ++this.program_counter;
        }
        word = String.valueOf(word) + "\"";
        return word;
    }

    private String parser_eat_whitespace() {
        String output = "";
        boolean terminate = false;
        while (this.program_counter < this.program.length() && !terminate) {
            String ws = this.isWhitespace();
            if (ws == null) {
                terminate = true;
                continue;
            }
            this.program_counter += ws.length();
            output = String.valueOf(output) + ws;
        }
        MultilineComment in_comment = this.parserIsCommentStart();
        if (in_comment != null) {
            this.parserEatComments(in_comment);
        }
        return output;
    }

    private String isWhitespace() {
        String[] stringArray = this.tokens.listOfWhitespaces();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (this.nextWordMatches(t)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    private boolean parserIsQuote(char comp) {
        String c = "" + comp;
        return this.tokens.quoteTypes() != null && this.tokens.quoteTypes().contains(c);
    }

    private MultilineComment parserIsCommentStart() {
        for (MultilineComment s : this.comments) {
            if (this.program_counter >= this.program.length() || this.program.charAt(this.program_counter) != s.start.charAt(0) || !this.nextWordMatches(s.start)) continue;
            return s;
        }
        return null;
    }

    private void parserEatComments(MultilineComment comment_type) {
        char searchChar = comment_type.end.charAt(0);
        while (this.program_counter < this.program.length()) {
            if (this.program.charAt(this.program_counter) == searchChar && this.nextWordMatches(comment_type.end)) {
                this.program_counter += comment_type.end.length();
                this.parser_eat_whitespace();
                MultilineComment in_comment = this.parserIsCommentStart();
                if (in_comment != null) {
                    this.parserEatComments(in_comment);
                }
                return;
            }
            ++this.program_counter;
        }
    }

    private boolean nextWordMatches(String comp) {
        int t = 0;
        while (t + this.program_counter < this.program.length() && t < comp.length()) {
            if (this.program.charAt(t + this.program_counter) != comp.charAt(t)) {
                return false;
            }
            ++t;
        }
        return true;
    }

    private boolean parserIsDelimiterCharacter(char comp) {
        String c = "" + comp;
        return this.tokens.delimiterCharacters().contains(c);
    }

    private static boolean isNumeric(Object s) {
        if (s == null) {
            return false;
        }
        return s.toString().matches("(-)?[0-9]+(\\.[0-9]+)?(E(-?)[0-9]+)?");
    }

    public String toString() {
        String s = String.valueOf(this.current_symbol) + " : " + this.current_word + " : " + this.program_counter;
        return s;
    }

    public static class MultilineComment {
        String start = "/*";
        String end = "*/";

        public MultilineComment(String start, String end) {
            this.start = start;
            this.end = end;
        }
    }
}

