/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import java.nio.channels.SelectableChannel;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.fusesource.hawtdispatch.CustomDispatchSource;
import org.fusesource.hawtdispatch.DispatchPriority;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.DispatchSource;
import org.fusesource.hawtdispatch.Dispatcher;
import org.fusesource.hawtdispatch.EventAggregator;
import org.fusesource.hawtdispatch.internal.DispatcherConfig;
import org.fusesource.hawtdispatch.internal.GlobalDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtCustomDispatchSource;
import org.fusesource.hawtdispatch.internal.HawtDispatchQueue;
import org.fusesource.hawtdispatch.internal.NioDispatchSource;
import org.fusesource.hawtdispatch.internal.SerialDispatchQueue;
import org.fusesource.hawtdispatch.internal.ThreadDispatchQueue;
import org.fusesource.hawtdispatch.internal.TimerThread;
import org.fusesource.hawtdispatch.internal.WorkerThread;
import org.fusesource.hawtdispatch.jmx.JmxService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HawtDispatcher
implements Dispatcher {
    public static final ThreadLocal<HawtDispatchQueue> CURRENT_QUEUE = new ThreadLocal();
    final GlobalDispatchQueue DEFAULT_QUEUE;
    private final Object HIGH_MUTEX = new Object();
    private GlobalDispatchQueue HIGH_QUEUE;
    private final Object LOW_MUTEX = new Object();
    private GlobalDispatchQueue LOW_QUEUE;
    private final String label;
    volatile TimerThread timerThread;
    private final int threads;
    private volatile boolean profile;
    final int drains;
    final boolean jmx;
    final AtomicInteger shutdownState = new AtomicInteger(0);
    volatile Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    public static final WeakHashMap<HawtDispatchQueue, Object> queues = new WeakHashMap();

    public HawtDispatcher(DispatcherConfig config) {
        this.threads = config.getThreads();
        this.label = config.getLabel();
        this.profile = config.isProfile();
        this.drains = config.getDrains();
        this.jmx = config.isJmx();
        if (this.jmx) {
            try {
                JmxService.register(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.DEFAULT_QUEUE = new GlobalDispatchQueue(this, DispatchPriority.DEFAULT, config.getThreads());
        this.DEFAULT_QUEUE.start();
        this.DEFAULT_QUEUE.profile(this.profile);
        this.timerThread = new TimerThread(this);
        this.timerThread.start();
    }

    public DispatchQueue getGlobalQueue() {
        return this.getGlobalQueue(DispatchPriority.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalDispatchQueue getGlobalQueue(DispatchPriority priority) {
        switch (priority) {
            case DEFAULT: {
                return this.DEFAULT_QUEUE;
            }
            case HIGH: {
                Object object = this.HIGH_MUTEX;
                synchronized (object) {
                    if (this.HIGH_QUEUE == null) {
                        this.HIGH_QUEUE = new GlobalDispatchQueue(this, DispatchPriority.HIGH, this.threads);
                        this.HIGH_QUEUE.start();
                        this.HIGH_QUEUE.profile(this.profile);
                    }
                    return this.HIGH_QUEUE;
                }
            }
            case LOW: {
                Object object = this.LOW_MUTEX;
                synchronized (object) {
                    if (this.LOW_QUEUE == null) {
                        this.LOW_QUEUE = new GlobalDispatchQueue(this, DispatchPriority.LOW, this.threads);
                        this.LOW_QUEUE.start();
                        this.LOW_QUEUE.profile(this.profile);
                    }
                    return this.LOW_QUEUE;
                }
            }
        }
        throw new AssertionError((Object)"switch missing case");
    }

    @Override
    public SerialDispatchQueue createQueue(String label) {
        SerialDispatchQueue rc = new SerialDispatchQueue(label);
        rc.setTargetQueue(this.getGlobalQueue());
        rc.profile(this.profile);
        return rc;
    }

    @Override
    public DispatchSource createSource(SelectableChannel channel, int interestOps, DispatchQueue queue) {
        return new NioDispatchSource(this, channel, interestOps, queue);
    }

    @Override
    public <Event, MergedEvent> CustomDispatchSource<Event, MergedEvent> createSource(EventAggregator<Event, MergedEvent> aggregator, DispatchQueue queue) {
        return new HawtCustomDispatchSource<Event, MergedEvent>(this, aggregator, queue);
    }

    public String getLabel() {
        return this.label;
    }

    public DispatchQueue getCurrentQueue() {
        return CURRENT_QUEUE.get();
    }

    public ThreadDispatchQueue getCurrentThreadQueue() {
        WorkerThread thread2 = WorkerThread.currentWorkerThread();
        if (thread2 == null) {
            return null;
        }
        return thread2.getDispatchQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void track(HawtDispatchQueue queue) {
        WeakHashMap<HawtDispatchQueue, Object> weakHashMap = queues;
        synchronized (weakHashMap) {
            queues.put(queue, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void untrack(HawtDispatchQueue queue) {
        WeakHashMap<HawtDispatchQueue, Object> weakHashMap = queues;
        synchronized (weakHashMap) {
            queues.remove(queue);
        }
    }

    public boolean profile() {
        return this.profile;
    }

    String assertMessage(String label) {
        StringBuilder sb = new StringBuilder();
        sb.append("Dispatch queue '");
        if (label != null) {
            sb.append(label);
        } else {
            sb.append("<no-label>");
        }
        sb.append("' was not executing, (currently executing: '");
        DispatchQueue q = this.getCurrentQueue();
        if (q != null) {
            if (q.getLabel() != null) {
                sb.append(q.getLabel());
            } else {
                sb.append("<no-label>");
            }
        } else {
            sb.append("<not-dispatched>");
        }
        sb.append("')");
        return sb.toString();
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }
}

