/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.fusesource.hawtdispatch.DispatchPriority;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.ShutdownException;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.TaskWrapper;
import org.fusesource.hawtdispatch.internal.HawtDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;
import org.fusesource.hawtdispatch.internal.ThreadDispatchQueue;
import org.fusesource.hawtdispatch.internal.WorkerPool;
import org.fusesource.hawtdispatch.internal.pool.SimplePool;
import org.fusesource.hawtdispatch.internal.util.IntrospectionSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GlobalDispatchQueue
implements HawtDispatchQueue {
    public final HawtDispatcher dispatcher;
    volatile String label;
    private final DispatchPriority priority;
    final WorkerPool workers;

    public GlobalDispatchQueue(HawtDispatcher dispatcher, DispatchPriority priority, int threads) {
        this.dispatcher = dispatcher;
        this.priority = priority;
        this.label = priority.toString();
        this.workers = new SimplePool(this, threads, priority);
        dispatcher.track(this);
    }

    public void start() {
        this.workers.start();
    }

    @Override
    public HawtDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean isExecuting() {
        ThreadDispatchQueue tq = this.dispatcher.getCurrentThreadQueue();
        if (tq != null) {
            return tq.globalQueue == this;
        }
        return false;
    }

    @Override
    public LinkedList<Task> getSourceQueue() {
        ThreadDispatchQueue tq = this.dispatcher.getCurrentThreadQueue();
        if (tq != null) {
            return tq.getSourceQueue();
        }
        return null;
    }

    @Override
    public void assertExecuting() {
        assert (this.isExecuting()) : this.getDispatcher().assertMessage(this.getLabel());
    }

    @Override
    @Deprecated
    public void execute(Runnable runnable2) {
        this.execute(new TaskWrapper(runnable2));
    }

    @Override
    public void execute(Task task) {
        if (this.dispatcher.shutdownState.get() > 1) {
            throw new ShutdownException();
        }
        this.workers.execute(task);
    }

    @Override
    public void executeAfter(long delay, TimeUnit unit, Task task) {
        if (this.dispatcher.shutdownState.get() > 0) {
            throw new ShutdownException();
        }
        this.dispatcher.timerThread.addRelative(task, this, delay, unit);
    }

    @Override
    public ThreadDispatchQueue getTargetQueue() {
        return null;
    }

    @Override
    public void resume() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspend() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSuspended() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTargetQueue(DispatchQueue queue) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return IntrospectionSupport.toString(this);
    }

    @Override
    public DispatchQueue.QueueType getQueueType() {
        return DispatchQueue.QueueType.GLOBAL_QUEUE;
    }

    public void profile(boolean profile) {
    }
}

