/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.types;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEMemberType;
import jamiebalfour.zpe.interfaces.ZPEIndexableElement;
import jamiebalfour.zpe.interfaces.ZPEReferenceMethod;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPENumber;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Random;

public class ZPEString
extends ZPEMemberType
implements Iterable,
Comparable,
Serializable,
ZPEIndexableElement {
    private static final long serialVersionUID = -3248684484655054377L;
    String value = "";

    public ZPEString(char c) {
        this.value = "" + c;
        this.addMethods();
    }

    public ZPEString(String s) {
        this.value = s;
        this.addMethods();
    }

    public ZPEString(ZPEString s) {
        this.value = s.value;
        this.addMethods();
    }

    @Override
    public ZPEType copyOfMe() {
        return new ZPEString(this);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    private void addMethods() {
        this.addMethod("get", new get_Command());
        this.addMethod("append", new append_Command());
        this.addMethod("prepend", new prepend_Command());
        this.addMethod("cut", new cut_Command());
        this.addMethod("length", new length_Command());
        this.addMethod("empty", new empty_Command());
    }

    public int length() {
        return this.value.length();
    }

    public char charAt(int index) {
        if (ZPEInstance.getOptionBase1Property()) {
            --index;
        }
        return this.value.charAt(index);
    }

    public char charAt(ZPENumber index) {
        int i = index.intValue();
        if (ZPEInstance.getOptionBase1Property()) {
            --i;
        }
        return this.value.charAt(i);
    }

    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    public void set(String s) {
        this.value = s;
    }

    public String toString() {
        return this.value;
    }

    public Iterator iterator() {
        return new CharacterIterator(this.value);
    }

    @Override
    public ZPEString copy() {
        return new ZPEString(this.value);
    }

    public int compareNumerically(ZPEString str) {
        if (this.value.length() < str.length()) {
            return -1;
        }
        if (this.value.length() > str.length()) {
            return 1;
        }
        int len = Math.max(this.value.length(), str.length());
        for (int i = 0; i < len; ++i) {
            if (this.value.charAt(i) < str.charAt(i)) {
                return -1;
            }
            if (this.value.charAt(i) <= str.charAt(i)) continue;
            return 1;
        }
        return 0;
    }

    public int compareTo(Object o) {
        return o.toString().compareTo(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ZPEString)) {
            return false;
        }
        return o.toString().equals(this.value);
    }

    public boolean equalsStr(String s) {
        return s.equals(this.value);
    }

    @Override
    public Object getIndex(Object pos) {
        return Character.valueOf(this.charAt(HelperFunctions.stringToInteger(pos.toString())));
    }

    static class CharacterIterator
    implements Iterator<ZPEString> {
        private final String str;
        private int pos = 0;

        public CharacterIterator(String str) {
            this.str = str;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.str.length();
        }

        @Override
        public ZPEString next() {
            return new ZPEString(this.str.charAt(this.pos++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class empty_Command
    implements ZPEReferenceMethod {
        empty_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            return new ZPEBoolean(ZPEString.this.value.isEmpty());
        }
    }

    class length_Command
    implements ZPEReferenceMethod {
        length_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            return new ZPENumber(ZPEString.this.value.length());
        }
    }

    class cut_Command
    implements ZPEReferenceMethod {
        cut_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            int index1 = HelperFunctions.stringToInteger(arguments[0].toString());
            int index2 = HelperFunctions.stringToInteger(arguments[1].toString());
            String nVal = ZPEString.this.value.substring(0, index1) + ZPEString.this.value.substring(index2);
            String output = ZPEString.this.value.substring(index1, index2);
            ZPEString.this.value = nVal;
            return new ZPEString(output);
        }
    }

    class prepend_Command
    implements ZPEReferenceMethod {
        prepend_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            String prepend = arguments[0].toString();
            ZPEString.this.value = prepend + ZPEString.this.value;
            return owner;
        }
    }

    class append_Command
    implements ZPEReferenceMethod {
        append_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            String append = arguments[0].toString();
            ZPEString.this.value = ZPEString.this.value + append;
            return owner;
        }
    }

    class get_Command
    implements ZPEReferenceMethod {
        get_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            int index = HelperFunctions.stringToInteger(arguments[0].toString());
            if (arguments[0].toString().equalsIgnoreCase("any")) {
                int maximum = ZPEString.this.value.length() - 1;
                int minimum = 0;
                Random rand = new Random();
                index = rand.nextInt(maximum - minimum + 1) + minimum;
            }
            return new ZPEString("" + ZPEString.this.value.charAt(index));
        }
    }
}

