/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.objects;

import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEString;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;

public class SequentialFileObject
extends ZPEStructure {
    private static final long serialVersionUID = 258448201218703335L;
    BufferedReader br = null;
    String current = null;

    public SequentialFileObject(ZPERuntimeEnvironment z, ZPEPropertyWrapper p) throws ZPERuntimeException {
        super(z, p, "SequentialFileObject");
        this.addNativeMethod("open", new open_Command());
        this.addNativeMethod("has_next", new has_next_Command());
        this.addNativeMethod("read_line", new read_line_Command());
        this.addNativeMethod("get_current", new get_current_Command());
    }

    private void getNext() {
        try {
            this.current = this.br.readLine();
        }
        catch (Exception e) {
            this.current = null;
        }
    }

    public boolean open(String file) throws FileNotFoundException {
        this.current = null;
        this.br = new BufferedReader(new FileReader(file));
        this.getNext();
        return true;
    }

    class get_current_Command
    implements ZPEObjectNativeMethod {
        get_current_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return new ZPEString(SequentialFileObject.this.current);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "get_current";
        }
    }

    class read_line_Command
    implements ZPEObjectNativeMethod {
        read_line_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            String s = SequentialFileObject.this.current;
            SequentialFileObject.this.getNext();
            return new ZPEString(s);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "read_line";
        }
    }

    class has_next_Command
    implements ZPEObjectNativeMethod {
        has_next_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return new ZPEBoolean(SequentialFileObject.this.current != null);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "has_next";
        }
    }

    class open_Command
    implements ZPEObjectNativeMethod {
        open_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"file"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            String file = parameters.get("file").toString();
            try {
                return new ZPEBoolean(SequentialFileObject.this.open(file));
            }
            catch (Exception e) {
                ZPE.log(e.getMessage());
                return new ZPEBoolean(false);
            }
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 4;
        }

        @Override
        public String getName() {
            return "open";
        }
    }
}

