/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.objects;

import jamiebalfour.HelperFunctions;
import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.exceptions.IncorrectDataTypeException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPEString;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateObject
extends ZPEStructure {
    private static final long serialVersionUID = 5509274683876442075L;
    Date date = new Date();

    public DateObject(ZPERuntimeEnvironment z, ZPEPropertyWrapper p) throws ZPERuntimeException {
        super(z, p, "DateObject");
        this.addNativeMethod("set_date", new set_date_Command());
        this.addNativeMethod("set_to_now", new set_to_now_Command());
        this.addNativeMethod("convert_to_string", new convert_to_string_Command());
        this.addNativeMethod("date_diff", new date_diff_Command());
        this.addNativeMethod("hour", new hour_Command());
        this.addNativeMethod("minute", new minute_Command());
        this.addNativeMethod("second", new second_Command());
        this.addNativeMethod("day", new day_Command());
        this.addNativeMethod("month", new month_Command());
        this.addNativeMethod("year", new year_Command());
        this.addNativeMethod("time", new time_Command());
        this.addNativeMethod("_beautify", new _beautify_Command());
        this.addNativeMethod("compare_date", new compare_date_Command());
    }

    public void setDate(Date d) {
        this.date = d;
    }

    @Override
    public String toString() {
        return this.date.toString();
    }

    private ZPEString getIt(String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return new ZPEString(dateFormat.format(this.date));
    }

    @Override
    public ZPEType copyOfMe() {
        try {
            DateObject o = new DateObject(this.ownerRuntime, this.getParent());
            o.date = this.date;
            this.copyData(o);
            return o;
        }
        catch (Exception e) {
            ZPE.log(e.getMessage());
            return null;
        }
    }

    class time_Command
    implements ZPEObjectNativeMethod {
        time_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return new ZPENumber(DateObject.this.date.getTime());
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "time";
        }
    }

    class date_diff_Command
    implements ZPEObjectNativeMethod {
        date_diff_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"date", "format"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) throws IncorrectDataTypeException {
            if (parameters.get("date") instanceof DateObject) {
                String type = "days";
                DateObject d2 = (DateObject)parameters.get("date");
                if (parameters.containsKey("format")) {
                    type = parameters.get("format").toString();
                }
                switch (type) {
                    case "seconds": {
                        return new ZPENumber((int)((DateObject.this.date.getTime() - d2.date.getTime()) / 1000L));
                    }
                    case "minutes": {
                        return new ZPENumber((int)((DateObject.this.date.getTime() - d2.date.getTime()) / 60000L));
                    }
                    case "hours": {
                        return new ZPENumber((int)((DateObject.this.date.getTime() - d2.date.getTime()) / 3600000L));
                    }
                    case "weeks": {
                        return new ZPENumber((int)((DateObject.this.date.getTime() - d2.date.getTime()) / 86400000L / 7L));
                    }
                }
                return new ZPENumber((int)((DateObject.this.date.getTime() - d2.date.getTime()) / 86400000L));
            }
            throw new IncorrectDataTypeException("DateObject", "date_diff", "1");
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "date_diff";
        }
    }

    class compare_date_Command
    implements ZPEObjectNativeMethod {
        compare_date_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"date"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) throws IncorrectDataTypeException {
            if (parameters.get("date") instanceof DateObject) {
                Date date1 = DateObject.this.date;
                Date date2 = ((DateObject)parameters.get((String)"date")).date;
                if (date1.after(date2)) {
                    return new ZPENumber(1);
                }
                if (date1.before(date2)) {
                    return new ZPENumber(-1);
                }
                if (date1.equals(date2)) {
                    return new ZPENumber(0);
                }
            } else {
                throw new IncorrectDataTypeException("DateObject", "compare_date", "1");
            }
            return new ZPEBoolean(false);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "compare_date";
        }
    }

    class set_to_now_Command
    implements ZPEObjectNativeMethod {
        set_to_now_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            DateObject.this.date = new Date();
            return new ZPEString(DateObject.this.date.toString());
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "set_to_now";
        }
    }

    class set_date_Command
    implements ZPEObjectNativeMethod {
        set_date_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"date", "format"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) throws ZPERuntimeException {
            String format = "yyyy-MM-dd";
            if (parameters.containsKey("format")) {
                format = parameters.get("format").toString();
            }
            try {
                DateObject.this.date = HelperFunctions.stringToDate(parameters.get("date").toString(), format);
                return new ZPEBoolean(true);
            }
            catch (Exception e) {
                throw new ZPERuntimeException("Date creation failed. Possible format issue");
            }
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "set_date";
        }
    }

    class convert_to_string_Command
    implements ZPEObjectNativeMethod {
        convert_to_string_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"format"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) throws ZPERuntimeException {
            String format = parameters.get("format").toString();
            format = format.replace("FULL_YEAR", "yyyy");
            format = format.replace("SHORT_YEAR", "yy");
            format = format.replace("FULL_MONTH", "MMM");
            format = format.replace("SHORT_MONTH", "MM");
            format = format.replace("FULL_DAY", "EEE");
            format = format.replace("SHORT_DAY", "dd");
            format = format.replace("SHORT_HOUR", "H");
            format = format.replace("FULL_HOUR", "h");
            format = format.replace("MINUTES", "mm");
            format = format.replace("SECONDS", "ss");
            format = format.replace("MILLISECONDS", "SSS");
            format = format.replace("AM_OR_PM", "a");
            format = format.replace("DAY_IN_YEAR", "D");
            format = format.replace("WEEK_IN_YEAR", "w");
            format = format.replace("WEEK_IN_MONTH", "W");
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                return new ZPEString(dateFormat.format(DateObject.this.date));
            }
            catch (Exception e) {
                ZPE.printError("convert_to_string: Invalid date format");
                return new ZPEString("");
            }
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "convert_to_string";
        }
    }

    class second_Command
    implements ZPEObjectNativeMethod {
        second_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return DateObject.this.getIt("ss");
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "second";
        }
    }

    class minute_Command
    implements ZPEObjectNativeMethod {
        minute_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return DateObject.this.getIt("mm");
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "minute";
        }
    }

    class hour_Command
    implements ZPEObjectNativeMethod {
        hour_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return DateObject.this.getIt("h");
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "hour";
        }
    }

    class day_Command
    implements ZPEObjectNativeMethod {
        day_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return DateObject.this.getIt("dd");
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "day";
        }
    }

    class month_Command
    implements ZPEObjectNativeMethod {
        month_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return DateObject.this.getIt("MM");
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "month";
        }
    }

    class year_Command
    implements ZPEObjectNativeMethod {
        year_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return DateObject.this.getIt("yyyy");
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "year";
        }
    }

    class _beautify_Command
    implements ZPEObjectNativeMethod {
        _beautify_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return new ZPEString(DateObject.this.date.toString());
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "beautify";
        }
    }
}

