/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.gui;

import jamiebalfour.HelperFunctions;
import jamiebalfour.ui.BalfAboutDialog;
import jamiebalfour.ui.BalfRoundedButton;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.editor.CodeEditorView;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.interfaces.ZPEType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.SimpleAttributeSet;

public class ZPEMacroInterface
extends JFrame {
    private static final long serialVersionUID = 4508802298090684343L;
    static FileNameExtensionFilter filter1 = new FileNameExtensionFilter("YASS files (*.yas)", "yas");
    CodeEditorView mainSyntax;
    ZPERuntimeEnvironment environment;
    private final ZPEMacroInterface _this = this;
    private final JTextArea outputBox;
    private final JEditorPane mainEditor;
    private final PrintStream originalOut = System.out;
    private final PrintStream originalErr = System.err;

    public ZPEMacroInterface(ZPERuntimeEnvironment z, ZPEObject[] modifiableObjects) {
        this.outputBox = new JTextArea(4, 40);
        ZPE.IGNORE_STARTUP = true;
        JTextAreaOutputStream outStream = new JTextAreaOutputStream(this.outputBox);
        PrintStream ps = new PrintStream(outStream, true);
        System.setOut(ps);
        System.setErr(ps);
        int modifierKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.setOut(ZPEMacroInterface.this.originalOut);
                System.setErr(ZPEMacroInterface.this.originalErr);
                e.getWindow().dispose();
            }
        });
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.environment = z;
        JPanel mainPanel = new JPanel();
        this.getContentPane().add(mainPanel);
        mainPanel.setLayout(new BorderLayout(0, 0));
        final JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBackground(Color.white);
        scrollPane.setEnabled(false);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(31);
        HashMap<String, SimpleAttributeSet> YASSKeywords = new HashMap<String, SimpleAttributeSet>(16);
        for (String type : ZPEKit.getTypeKeywords()) {
            YASSKeywords.put(type, CodeEditorView.DEFAULT_TYPE);
        }
        for (String keyword : ZPEKit.getKeywords()) {
            YASSKeywords.put(keyword, CodeEditorView.DEFAULT_KEYWORD);
        }
        YASSKeywords.put("null", CodeEditorView.DEFAULT_NULL);
        YASSKeywords.put("NULL", CodeEditorView.DEFAULT_NULL);
        StringBuilder editorComment = new StringBuilder();
        if (modifiableObjects.length > 0) {
            editorComment.append("// Available predefined objects: ");
        }
        int c = 0;
        for (ZPEObject o : modifiableObjects) {
            YASSKeywords.put(o.getId(), CodeEditorView.DEFAULT_KEYWORD);
            editorComment.append(o.getId());
            if (c != modifiableObjects.length - 1) {
                editorComment.append(", ");
            }
            ++c;
        }
        editorComment.append("\n");
        YASSKeywords.put("+", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("-", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("^", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("==", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("!", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("<", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put(">", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("<=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put(">=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("!=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("+=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("-=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("*=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("/=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("^=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("&", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("|", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("#breakpoint#", CodeEditorView.DEFAULT_SPECIAL);
        YASSKeywords.put("true", CodeEditorView.DEFAULT_BOOLEAN);
        YASSKeywords.put("false", CodeEditorView.DEFAULT_BOOLEAN);
        YASSKeywords.put("this", CodeEditorView.DEFAULT_VAR);
        for (String directive : ZPEKit.getDirectiveKeywords()) {
            YASSKeywords.put(directive, CodeEditorView.DEFAULT_DOC);
        }
        for (String cmd : ZPEKit.getAllCommands()) {
            YASSKeywords.put(cmd, CodeEditorView.DEFAULT_PREDEFINED_FUNCTION);
        }
        for (String cmd : ZPEKit.getAllAliases()) {
            YASSKeywords.put(cmd, CodeEditorView.DEFAULT_PREDEFINED_FUNCTION);
        }
        this.mainSyntax = new CodeEditorView(YASSKeywords, "\"'", "$");
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Normal, Color.black);
        this.mainEditor = (JEditorPane)this.mainSyntax.getEditPane();
        this.mainEditor.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        scrollPane.setViewportView(this.mainEditor);
        if (HelperFunctions.isMac()) {
            this.mainEditor.setFont(new Font("Consolas", 0, 14));
        } else {
            this.mainEditor.setFont(new Font("Courier New", 0, 14));
        }
        scrollPane.setRowHeaderView(this.mainSyntax.getEditor());
        this.mainSyntax.setFontSize(14);
        this.mainSyntax.repaint();
        this.mainEditor.setText("// ZPE Macro Scripting Interface\n" + editorComment);
        JMenuBar menuBar = new JMenuBar();
        JMenu mnFileMenu = new JMenu("File");
        menuBar.add(mnFileMenu);
        JMenuItem saveAsMenuItem = new JMenuItem("Save As");
        saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, modifierKey));
        saveAsMenuItem.addActionListener(e -> {
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(filter1);
            fc.setAcceptAllFileFilterUsed(false);
            int returnVal = fc.showSaveDialog(this.getContentPane());
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                String extension = "yas";
                try {
                    HelperFunctions.writeFile(file.getAbsolutePath() + "." + extension, this.mainEditor.getText(), false);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this.mainEditor, "The file could not be saved.", "Error", 0);
                }
            }
        });
        mnFileMenu.add(saveAsMenuItem);
        mnFileMenu.add(new JSeparator());
        JMenuItem mntmOpenMenuItem = new JMenuItem("Open");
        mntmOpenMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, modifierKey));
        mntmOpenMenuItem.addActionListener(e -> {
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(filter1);
            int returnVal = fc.showOpenDialog(this.getContentPane());
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                try {
                    this.mainEditor.setText(HelperFunctions.readFileAsString(file.getAbsolutePath()));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ZPEMacroInterface.this.mainEditor.setCaretPosition(0);
                            scrollPane.getVerticalScrollBar().setValue(0);
                        }
                    });
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this.getContentPane(), "The file could not be opened.", "Error", 0);
                }
            }
        });
        mnFileMenu.add(mntmOpenMenuItem);
        JMenu scriptMenu = new JMenu("Script");
        menuBar.add(scriptMenu);
        JMenuItem executeMenuItem = new JMenuItem("Execute");
        scriptMenu.add(executeMenuItem);
        executeMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, modifierKey));
        executeMenuItem.addActionListener(e -> this.executeCode(modifiableObjects));
        scriptMenu.add(new JSeparator());
        JMenuItem validateScriptMenuItem = new JMenuItem("Validate Script");
        scriptMenu.add(validateScriptMenuItem);
        validateScriptMenuItem.addActionListener(e -> {
            try {
                if (ZPEKit.validateCode(this.mainEditor.getText())) {
                    JOptionPane.showMessageDialog(this._this, "Your code is valid", "ZPE Code Validation", 1);
                } else {
                    JOptionPane.showMessageDialog(this._this, "Your code is invalid", "ZPE Code Validation", 0);
                }
            }
            catch (CompileException ex) {
                JOptionPane.showMessageDialog(this._this, "Your code is invalid", "ZPE Code Validation", 0);
            }
        });
        JMenu helpMenu = new JMenu("Help");
        menuBar.add(helpMenu);
        JMenuItem aboutMenuItem = new JMenuItem("About ZPE");
        helpMenu.add(aboutMenuItem);
        aboutMenuItem.addActionListener(e -> {
            Object msg = "";
            msg = (String)msg + "ZPE version 1.13.7." + ZPE.getBuildVersion() + " [Fossgate]\n";
            msg = (String)msg + "Built on: " + ZPE.getBuildDate() + " at " + ZPE.getBuildTime() + "\n";
            msg = (String)msg + "Copyright Jamie B Balfour 2011 - 2025";
            msg = (String)msg + "\n\nFor more information visit\nhttps://www.jamiebalfour.scot/projects/zpe/";
            BalfRoundedButton btnVisitWebsiteButton = new BalfRoundedButton("Visit website");
            btnVisitWebsiteButton.addActionListener(event -> {
                try {
                    HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.getContentPane(), "Could not open the ZPE website", "Failure", 0);
                }
            });
            URL imagePath = this.getClass().getResource("/files/ZPELogoLighter.png");
            assert (imagePath != null);
            ImageIcon lighterLogoFull = new ImageIcon(imagePath);
            Image newimg = lighterLogoFull.getImage().getScaledInstance(60, 60, 4);
            ImageIcon lighterLogo = new ImageIcon(newimg);
            JOptionPane op = new JOptionPane(new BalfAboutDialog("ZPE & YASS", (String)msg, btnVisitWebsiteButton).getContentPane(), -1, -1, lighterLogo, new String[0]);
            JDialog dlg = op.createDialog(this._this, "About ZPE");
            dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            dlg.setVisible(true);
        });
        helpMenu.add(new JSeparator());
        JMenuItem websiteItem = new JMenuItem("Visit the ZPE website");
        helpMenu.add(websiteItem);
        websiteItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/");
            }
            catch (IOException | URISyntaxException ex) {
                JOptionPane.showMessageDialog(this._this, "Could not load the website.", "Failure", 0);
            }
        });
        this.add((Component)menuBar, "North");
        this.setSize(new Dimension(600, 400));
        BalfRoundedButton executeBtn = new BalfRoundedButton("Execute");
        executeBtn.setPreferredSize(new Dimension(120, 40));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        this.outputBox.setEditable(false);
        this.outputBox.setLineWrap(true);
        this.outputBox.setWrapStyleWord(true);
        if (HelperFunctions.isMac()) {
            this.outputBox.setFont(new Font("Consolas", 0, 13));
        } else {
            this.outputBox.setFont(new Font("Courier New", 0, 13));
        }
        this.outputBox.setBorder(BorderFactory.createTitledBorder("Immediate Output"));
        JScrollPane outputScroll = new JScrollPane(this.outputBox);
        outputScroll.setVerticalScrollBarPolicy(22);
        JPanel bottomButtons = new JPanel();
        bottomButtons.add(executeBtn);
        bottomPanel.add((Component)bottomButtons, "North");
        bottomPanel.add((Component)outputScroll, "Center");
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(scrollPane);
        splitPane.setBottomComponent(bottomPanel);
        splitPane.setDividerLocation(200);
        splitPane.setResizeWeight(0.85);
        splitPane.setContinuousLayout(false);
        mainPanel.add((Component)splitPane, "Center");
        executeBtn.addActionListener(e -> this.executeCode(modifiableObjects));
        this.setTitle("ZPE Macro Interface Editor");
    }

    private void executeCode(ZPEObject[] modifiableObjects) {
        this.outputBox.setText("");
        HashMap<String, ZPEType> vars = new HashMap<String, ZPEType>();
        for (ZPEObject o : modifiableObjects) {
            vars.put(o.getId(), o);
        }
        try {
            ZPEKit.interpret(this.environment, this.mainEditor.getText(), new ZPEType[0], false, vars, false);
        }
        catch (BreakPointHalt | CompileException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
        catch (ExitHalt ex) {
            throw new RuntimeException(ex);
        }
    }

    static class JTextAreaOutputStream
    extends OutputStream {
        private final JTextArea textArea;

        public JTextAreaOutputStream(JTextArea textArea) {
            this.textArea = textArea;
        }

        @Override
        public void write(int b) {
            SwingUtilities.invokeLater(() -> {
                this.textArea.append(String.valueOf((char)b));
                this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            });
        }

        @Override
        public void write(byte[] b, int off, int len) {
            String text = new String(b, off, len);
            SwingUtilities.invokeLater(() -> {
                this.textArea.append(text);
                this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            });
        }
    }
}

