/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.daemon;

import jamiebalfour.HelperFunctions;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.types.ZPEMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class ZPERuntimeDaemon {
    private int port = 9342;
    private final int permission_level;

    public ZPERuntimeDaemon(int permission_level) {
        this.permission_level = permission_level;
    }

    public ZPERuntimeDaemon(int permission_level, int port) {
        this.permission_level = permission_level;
        this.port = port;
    }

    public void start() throws IOException {
        PrintStream outOrg = System.out;
        PrintStream errOrg = System.err;
        ServerSocket serverSocket = null;
        serverSocket = new ServerSocket(this.port);
        ZenithJSONParser p = new ZenithJSONParser();
        while (true) {
            try {
                while (true) {
                    Socket clientSocket = serverSocket.accept();
                    BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                    PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                    out.println("Ready");
                    String line = in.readLine();
                    try {
                        ZPEMap data = (ZPEMap)p.jsonDecode(line, false);
                        System.setOut(new PrintStream(clientSocket.getOutputStream()));
                        System.setErr(new PrintStream(clientSocket.getOutputStream()));
                        System.setIn(clientSocket.getInputStream());
                        if (data.get("mode").toString().equals("-r")) {
                            try {
                                ZPEKit.interpret(HelperFunctions.readFileAsString(data.get("file").toString()), this.permission_level);
                            }
                            catch (Exception ex) {
                                System.out.println(ex.getMessage());
                            }
                        } else if (data.get("mode").toString().equals("-i")) {
                            out.flush();
                            while (!line.equals("exit")) {
                                line = in.readLine();
                                System.out.println(line);
                                try {
                                    ZPEKit.interpret(line, this.permission_level);
                                }
                                catch (Exception ex) {
                                    System.out.println(ex.getMessage());
                                }
                                out.write("EOF");
                                out.flush();
                            }
                        }
                        System.setOut(outOrg);
                        System.setErr(errOrg);
                    }
                    catch (Exception e) {
                        System.setOut(outOrg);
                        System.setErr(errOrg);
                        System.err.println(e.getMessage());
                    }
                    clientSocket.close();
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }
}

