/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.YASSCompiler;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.parser.Tokeniser;
import jamiebalfour.zpe.parser.ZPEComment;
import jamiebalfour.zpe.parser.v4.ZenithParsingEngine;
import java.util.ArrayList;

public class YASSTemplateCompiler {
    private final ZenithParsingEngine parser;
    private final YASSCompiler compiler = new YASSCompiler();

    public YASSTemplateCompiler(String str) {
        this.parser = new ZenithParsingEngine(str, false, new TemplateByteCodes());
    }

    void addGlobals(YASSCompiler basis) {
        this.compiler.global = new YASSCompiler.CompilerFunction(basis);
        for (YASSCompiler.CompilerFunction f : basis.functionList) {
            for (String v : f.keySet()) {
                this.compiler.global.setVariable(v, f.get(v));
            }
        }
    }

    public IAST toIAST() throws CompileException {
        IAST top;
        this.parser.disableEscapeCharacters(true);
        IAST current = top = new IAST();
        this.parser.getNextSymbol();
        while (this.parser.hasNext()) {
            if (this.parser.getCurrentSymbol() == 1) {
                if (this.parser.peekAhead() == 2) {
                    this.parser.getNextSymbol();
                    IAST expression = new IAST();
                    expression.type = (byte)-9;
                    String s = this.parser.parseTo((byte)3);
                    expression.value = this.compiler.compile((String)s).next;
                    if (((IAST)expression.value).next != null && ZPEHelperFunctions.isMathsOperatorByte(((IAST)expression.value).next.type)) {
                        IAST wrap = new IAST();
                        wrap.type = (byte)-9;
                        wrap.value = expression.value;
                        expression.value = wrap;
                    }
                    current = current.next = expression;
                }
            } else {
                IAST n = new IAST();
                n.type = (byte)4;
                n.value = this.parser.getCurrentWord();
                current = current.next = n;
            }
            this.parser.getNextSymbol();
        }
        return top.next;
    }

    public static class TemplateByteCodes
    implements Tokeniser {
        public static final byte DOLLAR = 1;
        public static final byte LBRACE = 2;
        public static final byte RBRACE = 3;
        public static final byte STRING = 4;

        @Override
        public byte stringToByteCode(String w) {
            switch (w) {
                case "$": {
                    return 1;
                }
                case "{": {
                    return 2;
                }
                case "}": {
                    return 3;
                }
            }
            return 4;
        }

        @Override
        public String symbolToString(int i) {
            return "";
        }

        @Override
        public String delimiterCharacters() {
            return "{}$";
        }

        @Override
        public String quoteTypes() {
            return "~~";
        }

        @Override
        public String[] listOfSubsequentCharacters() {
            return new String[0];
        }

        @Override
        public String[] listOfBoundWords() {
            return new String[]{"$"};
        }

        @Override
        public String[] listOfWhitespaces() {
            return new String[]{" ", System.lineSeparator()};
        }

        @Override
        public ArrayList<ZPEComment> listOfComments() {
            return new ArrayList<ZPEComment>();
        }
    }
}

