/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.border.EmptyBorder;

public class FloatingTooltip
extends JWindow {
    private final JPanel contentPanel = new JPanel();
    private final JLabel titleLabel;
    private final JLabel subtitleLabel;
    private final JTextArea descriptionArea;

    public FloatingTooltip(Window owner) {
        super(owner);
        this.contentPanel.setLayout(new BorderLayout(10, 10));
        this.contentPanel.setBackground(new Color(50, 50, 50));
        this.contentPanel.setBorder(new EmptyBorder(10, 15, 10, 15));
        this.contentPanel.setOpaque(true);
        JPanel topPanel = new JPanel(new GridLayout(2, 1));
        topPanel.setOpaque(false);
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(new Font("SansSerif", 1, 14));
        this.titleLabel.setForeground(new Color(102, 153, 255));
        this.subtitleLabel = new JLabel();
        this.subtitleLabel.setFont(new Font("Monospaced", 0, 13));
        this.subtitleLabel.setForeground(new Color(255, 200, 130));
        topPanel.add(this.titleLabel);
        topPanel.add(this.subtitleLabel);
        this.descriptionArea = new JTextArea();
        this.descriptionArea.setFont(new Font("SansSerif", 0, 13));
        this.descriptionArea.setForeground(Color.WHITE);
        this.descriptionArea.setBackground(new Color(50, 50, 50));
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setFocusable(false);
        this.descriptionArea.setOpaque(false);
        this.contentPanel.add((Component)topPanel, "North");
        this.contentPanel.add((Component)this.descriptionArea, "Center");
        this.setContentPane(this.contentPanel);
        this.pack();
    }

    public void setTitleText(String text) {
        this.titleLabel.setText(text);
    }

    public void setSubtitleText(String text) {
        this.subtitleLabel.setText(text);
    }

    public void setDescriptionText(String text) {
        this.descriptionArea.setText(text);
    }

    public void showTooltipRelativeTo(Component relativeTo, int offsetX, int offsetY) {
        Point location = relativeTo.getLocationOnScreen();
        this.setLocation(location.x + offsetX, location.y + offsetY);
        this.pack();
        this.setVisible(true);
    }

    public void showTooltip(int x, int y) {
        this.setLocation(x, y);
        this.pack();
        this.setVisible(true);
    }

    public void hideTooltip() {
        this.setVisible(false);
    }
}

