/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui;

import jamiebalfour.ui.BalfLafManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class BalfScrollbar
extends JScrollPane {
    Color orgBackground = this.getBackground();

    public BalfScrollbar() {
        BalfLafManager.getInstance().addListener(enabled -> {
            if (enabled) {
                this.enableDarkMode();
            } else {
                this.disableDarkMode();
            }
        });
    }

    public BalfScrollbar(Component view) {
        super(view);
        BalfLafManager.getInstance().addListener(enabled -> {
            if (enabled) {
                this.enableDarkMode();
            } else {
                this.disableDarkMode();
            }
        });
    }

    private void enableDarkMode() {
        this.setUpScrollBar(BalfLafManager.getInstance().getDarkColorBackground(), Color.decode("#777777"));
        this.setBackground(BalfLafManager.getInstance().getDarkColorBackground());
        this.getViewport().setBackground(BalfLafManager.getInstance().getDarkColorBackground());
    }

    private void disableDarkMode() {
        this.setUpScrollBar(Color.decode("#dddddd"), Color.decode("#aaaaaa"));
        this.setBackground(this.orgBackground);
        this.getViewport().setBackground(this.orgBackground);
    }

    private void setUpScrollBar(final Color trackColour, final Color thumbColour) {
        this.getVerticalScrollBar().setUI(new BasicScrollBarUI(){

            @Override
            protected void configureScrollBarColors() {
                this.thumbColor = thumbColour;
                this.trackColor = trackColour;
                this.scrollBarWidth = 7;
            }

            @Override
            protected JButton createDecreaseButton(int orientation) {
                return BalfScrollbar.this.createZeroButton();
            }

            @Override
            protected JButton createIncreaseButton(int orientation) {
                return BalfScrollbar.this.createZeroButton();
            }

            @Override
            protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(this.thumbColor);
                int arc = 10;
                g2.fillRoundRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, arc, arc);
                g2.dispose();
            }
        });
        this.getHorizontalScrollBar().setUI(new BasicScrollBarUI(){

            @Override
            protected void configureScrollBarColors() {
                this.thumbColor = thumbColour;
                this.trackColor = trackColour;
                this.scrollBarWidth = 7;
            }

            @Override
            protected JButton createDecreaseButton(int orientation) {
                return BalfScrollbar.this.createZeroButton();
            }

            @Override
            protected JButton createIncreaseButton(int orientation) {
                return BalfScrollbar.this.createZeroButton();
            }

            @Override
            protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(this.thumbColor);
                int arc = 10;
                g2.fillRoundRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, arc, arc);
                g2.dispose();
            }
        });
    }

    private JButton createZeroButton() {
        JButton button = new JButton();
        Dimension zeroDim = new Dimension(0, 0);
        button.setPreferredSize(zeroDim);
        button.setMinimumSize(zeroDim);
        button.setMaximumSize(zeroDim);
        return button;
    }
}

