/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui;

import jamiebalfour.ui.BalfLafManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;

public class BalfRoundedButton
extends JButton {
    private boolean hovered = false;
    private boolean jbButtons = false;

    public BalfRoundedButton(String text) {
        this.setText(text);
        this.setMinimumSize(new Dimension(200, 140));
        if (this.getPreferredSize() == null) {
            this.setPreferredSize(new Dimension(200, 140));
        }
        this.setFocusPainted(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setOpaque(false);
        this.setBorderPainted(false);
        this.setBorder(new EmptyBorder(12, 20, 12, 20));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                BalfRoundedButton.this.hovered = true;
                BalfRoundedButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                BalfRoundedButton.this.hovered = false;
                BalfRoundedButton.this.repaint();
            }
        });
        BalfLafManager.getInstance().addListener(e -> {
            this.setForeground(Color.BLACK);
            if (e) {
                this.setForeground(BalfLafManager.getInstance().getDarkColorForeground());
            }
            this.repaint();
        });
    }

    public void useJBStyle(boolean enable) {
        this.jbButtons = enable;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        int arcWidth = this.getHeight();
        int arcHeight = this.getHeight();
        int inset = 1;
        int width = this.getWidth();
        int height = this.getHeight();
        Color fillColor = Color.WHITE;
        if (BalfLafManager.getInstance().darkMode) {
            fillColor = BalfLafManager.getInstance().getDarkColorComponentBackground();
        }
        if (this.hovered) {
            fillColor = new Color(235, 235, 235);
            if (BalfLafManager.getInstance().darkMode) {
                fillColor = BalfLafManager.getInstance().getDarkColorComponentBackground().darker();
            }
        }
        if (!this.jbButtons) {
            g2.setColor(fillColor);
        } else if (this.hovered) {
            Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
            Point2D.Float end = new Point2D.Float(this.getWidth(), this.getHeight());
            float[] dist = new float[]{0.0f, 1.0f};
            Color[] colors = new Color[]{new Color(16754176), new Color(13373400)};
            LinearGradientPaint paint = new LinearGradientPaint(start, end, dist, colors);
            g2.setPaint(paint);
        } else {
            g2.setColor(fillColor);
        }
        g2.fillRoundRect(inset, inset, width - inset * 2, height - inset * 2, arcWidth, arcHeight);
        Color borderColor = new Color(220, 220, 220);
        if (BalfLafManager.getInstance().darkMode) {
            borderColor = new Color(19, 23, 43);
        }
        if (this.hasFocus()) {
            borderColor = new Color(255, 128, 0);
            if (BalfLafManager.getInstance().darkMode) {
                borderColor = new Color(46, 13, 80);
            }
        }
        if (this.hovered) {
            borderColor = new Color(200, 200, 200);
            if (BalfLafManager.getInstance().darkMode) {
                borderColor = new Color(17, 31, 64);
            }
        }
        g2.setColor(borderColor);
        g2.setStroke(new BasicStroke(1.0f));
        if (!this.jbButtons) {
            g2.drawRoundRect(inset, inset, width - inset * 2, height - inset * 2, arcWidth, arcHeight);
        } else {
            g2.setColor(fillColor);
            int borderThickness = 3;
            float scale = (float)(width - (inset + borderThickness) * 2) / (float)(width - inset * 2);
            int innerArcWidth = Math.round((float)arcWidth * scale);
            int innerArcHeight = Math.round((float)arcHeight * scale);
            g2.fillRoundRect(inset + borderThickness, inset + borderThickness, width - (inset + borderThickness) * 2, height - (inset + borderThickness) * 2, innerArcWidth, innerArcHeight);
        }
        super.paintComponent(g);
        g2.dispose();
    }
}

