/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui;

import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.BalfSearchBox;
import jamiebalfour.ui.BalfSeparator;
import jamiebalfour.ui.BalfTitleBar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class BalfMenuBar
extends JMenuBar {
    Color backgroundColor;
    Color backgroundColorAlt;
    Color foregroundColor;
    Color menuColour;
    BalfSearchBox searchBox;
    Color hoverColor;
    private BalfTitleBar titleBar;
    boolean isApple = false;
    static EmptyBorder borderStyle = new EmptyBorder(6, 0, 6, 7);
    boolean darkMode = false;

    static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    public BalfMenuBar(Color background, Color backgroundColorAlt, Color foreground, Color menuBackground) {
        UIManager.put("PopupMenu.opacity", false);
        this.backgroundColor = background;
        this.backgroundColorAlt = backgroundColorAlt;
        this.foregroundColor = foreground;
        this.menuColour = menuBackground;
        this.hoverColor = menuBackground.brighter().brighter();
        if (this.hoverColor.equals(menuBackground)) {
            this.hoverColor = menuBackground.darker().darker();
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2) {
                    System.out.println("Yes");
                    if (BalfMenuBar.this.titleBar != null) {
                        System.out.println("YesYes");
                        BalfMenuBar.this.titleBar.activateMaximise();
                    }
                }
            }
        });
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (!BalfMenuBar.isMac()) {
            this.setFont(new Font("Segoe UI", 0, 12));
        }
        BalfLafManager.getInstance().addListener(enabled -> {
            if (enabled) {
                this.enableDarkMode();
            } else {
                this.disableDarkMode();
            }
            this.repaint();
        });
    }

    private JMenu convertCustomMenuToJMenu(Menu customMenu) {
        JMenu jMenu = new JMenu(customMenu.getText());
        jMenu.setMnemonic(customMenu.getMnemonic());
        for (Component comp : customMenu.getMenuComponents()) {
            if (comp instanceof Menu) {
                jMenu.add(this.convertCustomMenuToJMenu((Menu)comp));
                continue;
            }
            if (comp instanceof MenuItem) {
                MenuItem customItem = (MenuItem)comp;
                JMenuItem jItem = new JMenuItem(customItem.getText());
                jItem.setAccelerator(customItem.getAccelerator());
                for (ActionListener al : customItem.getActionListeners()) {
                    jItem.addActionListener(al);
                }
                jMenu.add(jItem);
                continue;
            }
            if (comp instanceof CheckBoxMenuItem) {
                CheckBoxMenuItem customCheck = (CheckBoxMenuItem)comp;
                JCheckBoxMenuItem jCheck = new JCheckBoxMenuItem(customCheck.getText(), customCheck.isSelected());
                jCheck.setAccelerator(customCheck.getAccelerator());
                for (ActionListener al : customCheck.getActionListeners()) {
                    jCheck.addActionListener(al);
                }
                jMenu.add(jCheck);
                continue;
            }
            if (!(comp instanceof Separator)) continue;
            jMenu.addSeparator();
        }
        return jMenu;
    }

    public JMenuBar toJMenuBar() {
        JMenuBar swingMenuBar = new JMenuBar();
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof Menu)) continue;
            swingMenuBar.add(this.convertCustomMenuToJMenu((Menu)comp));
        }
        return swingMenuBar;
    }

    void attachTitleBar(BalfTitleBar titleBar) {
        this.titleBar = titleBar;
    }

    public BalfSearchBox addSearchBox() {
        this.add(Box.createHorizontalGlue());
        this.searchBox = new BalfSearchBox();
        this.add(this.searchBox);
        this.add(new BalfSeparator(10, 30));
        return this.searchBox;
    }

    private void enableDarkMode() {
        this.darkMode = true;
    }

    private void disableDarkMode() {
        this.darkMode = false;
    }

    private void recurseItems(Component comp) {
        if (comp instanceof MenuItem) {
            MenuItem cmi = (MenuItem)comp;
            for (Component c : cmi.getComponents()) {
                c.setForeground(this.foregroundColor);
                c.repaint();
            }
        }
    }

    public void setColours(Color backgroundColor, Color backgroundColorAlt, Color foreground) {
        this.backgroundColor = backgroundColor;
        this.backgroundColorAlt = backgroundColorAlt;
        this.foregroundColor = foreground;
        for (Component c : this.getComponents()) {
            this.recurseItems(c);
            c.setForeground(foreground);
            c.repaint();
        }
    }

    @Override
    public JMenu add(JMenu menu) {
        super.add(menu);
        menu.setForeground(this.foregroundColor);
        this.setForeground(this.foregroundColor);
        return menu;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color c1 = this.backgroundColor;
        Color c2 = this.backgroundColorAlt;
        if (this.darkMode) {
            c1 = BalfLafManager.getInstance().getDarkColorBackground();
            c2 = BalfLafManager.getInstance().getDarkColorBackground();
        }
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, c1, 0.0f, this.getHeight(), c2);
        g2d.setPaint(gp);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.dispose();
    }

    public static class Separator
    extends JSeparator {
        BalfMenuBar menuBar;

        public Separator(BalfMenuBar menuBar) {
            this.menuBar = menuBar;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(this.menuBar.menuColour);
            if (this.menuBar.darkMode) {
                g2.setColor(new Color(20, 20, 20));
            }
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setColor(this.menuBar.foregroundColor.darker().darker());
            if (g2.getColor() == this.menuBar.foregroundColor) {
                g2.setColor(this.menuBar.foregroundColor.brighter().brighter());
            }
            if (this.menuBar.darkMode) {
                g2.setColor(new Color(70, 70, 70));
            }
            g2.fillRect(10, this.getHeight() / 2 - 1, this.getWidth() - 20, 1);
            g2.dispose();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(1, 6);
        }
    }

    static class EmptyIcon
    implements Icon {
        private final int size = 16;

        EmptyIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    public static class CheckBoxMenuItem
    extends JMenuItem {
        boolean hovered = false;
        BalfMenuBar menuBar;

        public CheckBoxMenuItem(String text, BalfMenuBar menuBar) {
            super(text);
            this.menuBar = menuBar;
            if (!BalfMenuBar.isMac()) {
                this.setFont(new Font("Segoe UI", 0, 12));
            }
            this.setOpaque(false);
            this.setForeground(menuBar.foregroundColor);
            this.setBorder(borderStyle);
            this.setFocusPainted(false);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.mouseListener();
            this.setIcon(null);
            this.setSelectedIcon(null);
        }

        void mouseListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    hovered = true;
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    hovered = false;
                    this.setSelected(!this.isSelected());
                    this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    hovered = false;
                    this.setSelected(!this.isSelected());
                    this.repaint();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.menuBar.darkMode) {
                if (this.hovered) {
                    g2.setColor(BalfLafManager.getInstance().getDarkColorMenuHoverBackground());
                } else {
                    g2.setColor(new Color(20, 20, 20));
                }
            } else if (this.hovered) {
                g2.setColor(this.menuBar.hoverColor);
            } else {
                g2.setColor(this.menuBar.menuColour);
            }
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.isSelected()) {
                g2.setColor(this.getForeground());
                int x = 16;
                int y = this.getHeight() / 2;
                g2.setStroke(new BasicStroke(2.0f));
                g2.drawLine(x, y + 2, x + 3, y + 5);
                g2.drawLine(x + 3, y + 5, x + 8, y - 2);
            }
            super.paintComponent(g);
            g2.dispose();
        }

        @Override
        public Insets getInsets() {
            return new Insets(6, 20, 6, 7);
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public Icon getSelectedIcon() {
            return null;
        }
    }

    public static class MenuItem
    extends JMenuItem {
        boolean hovered = false;
        BalfMenuBar menuBar;

        public MenuItem(BalfMenuBar menuBar) {
            this.setup(menuBar);
        }

        public MenuItem(String text, BalfMenuBar menuBar) {
            super(text);
            this.setup(menuBar);
        }

        public MenuItem(String text, Icon icon, BalfMenuBar menuBar) {
            super(text, icon);
            this.setup(menuBar);
        }

        private void setup(BalfMenuBar menuBar) {
            this.menuBar = menuBar;
            this.setOpaque(false);
            this.setForeground(menuBar.foregroundColor);
            this.setBorder(borderStyle);
            this.setIcon(new EmptyIcon());
            this.mouseListener();
            if (!BalfMenuBar.isMac()) {
                this.setFont(new Font("Segoe UI", 0, 12));
            }
        }

        public MenuItem(Action a, BalfMenuBar menuBar) {
            super(a);
            this.setup(menuBar);
            if (!BalfMenuBar.isMac()) {
                this.setFont(new Font("Segoe UI", 0, 12));
            }
        }

        void mouseListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    hovered = true;
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.hovered) {
                g2.setColor(this.menuBar.hoverColor);
                if (this.menuBar.darkMode) {
                    g2.setColor(BalfLafManager.getInstance().getDarkColorMenuHoverBackground());
                }
            } else {
                g2.setColor(this.menuBar.menuColour);
                if (this.menuBar.darkMode) {
                    g2.setColor(new Color(20, 20, 20));
                }
            }
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
            g2.dispose();
        }
    }

    public static class Menu
    extends JMenu {
        int level = 0;
        boolean hovered = false;
        BalfMenuBar menuBar;

        public Menu(int level, BalfMenuBar menuBar) {
            this.setup(level, menuBar);
        }

        public Menu(String title, int level, BalfMenuBar menuBar) {
            super(title);
            this.setup(level, menuBar);
        }

        private void setup(int level, BalfMenuBar menuBar) {
            this.menuBar = menuBar;
            if (!BalfMenuBar.isMac()) {
                this.setFont(new Font("Segoe UI", 0, 12));
            }
            this.level = level;
            this.getPopupMenu().setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            this.setForeground(menuBar.foregroundColor);
            this.setOpaque(false);
            this.setBorder(borderStyle);
            if (level == 0) {
                this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 6));
            } else {
                this.setIcon(new EmptyIcon());
            }
            this.mouseListener();
        }

        @Override
        public JMenuItem add(String text) {
            JMenuItem x = super.add(text);
            x.setForeground(Color.white);
            return x;
        }

        @Override
        public Component add(Component c) {
            Component x = super.add(c);
            x.setForeground(Color.white);
            return x;
        }

        @Override
        public JMenuItem add(JMenuItem m) {
            JMenuItem x = super.add(m);
            x.setForeground(Color.white);
            return x;
        }

        void mouseListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    hovered = true;
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (this.level > 0) {
                int width = this.getWidth();
                int height = this.getHeight();
                if (this.hovered || this.isPopupMenuVisible()) {
                    g2.setColor(this.menuBar.hoverColor);
                    if (this.menuBar.darkMode) {
                        g2.setColor(BalfLafManager.getInstance().getDarkColorMenuHoverBackground());
                    }
                } else {
                    g2.setColor(this.menuBar.menuColour);
                    if (this.menuBar.darkMode) {
                        g2.setColor(new Color(20, 20, 20));
                    }
                }
                g2.fillRect(0, 0, width, height);
            } else if (this.isPopupMenuVisible()) {
                g2.setColor(new Color(255, 128, 0));
                g2.drawLine(2, this.getHeight() - 2, this.getWidth() - 2, this.getHeight() - 2);
            }
            super.paintComponent(g);
        }
    }
}

