/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui;

import jamiebalfour.ui.BalfLafManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BalfFooter
extends JPanel {
    JLabel label;
    Color background;
    boolean darkMode = false;

    public BalfFooter(String text, Color background, Color foreground) {
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.setLayout(new BorderLayout());
        this.setForeground(Color.lightGray);
        this.background = background;
        this.setOpaque(false);
        this.label = new JLabel(text);
        this.label.setHorizontalAlignment(0);
        this.label.setText(text);
        this.label.setForeground(foreground);
        this.add((Component)this.label, "Center");
        BalfLafManager.getInstance().addListener(enabled -> {
            if (enabled) {
                this.enableDarkMode();
                this.setBackground(BalfLafManager.getInstance().getDarkColorBackground());
            } else {
                this.disableDarkMode();
                this.setForeground(foreground);
            }
            this.repaint();
        });
    }

    private void enableDarkMode() {
        this.darkMode = true;
    }

    private void disableDarkMode() {
        this.darkMode = false;
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(this.background);
        if (this.darkMode) {
            g2.setColor(BalfLafManager.getInstance().getDarkColorBackground());
        }
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.dispose();
    }
}

