/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.parsers.xml;

import jamiebalfour.zpe.parser.Tokeniser;
import jamiebalfour.zpe.parser.ZPEComment;
import java.util.ArrayList;

class ZenithXMLParserByteCodes
implements Tokeniser {
    static final String VAR_INT = "(((-[0-9]+)|[1-9][0-9]*)(E[0-9]+)?)";
    static final String VAR_DOUBLE = "(-?[0-9]+((\\.)?[0-9]*))(E(-?)[0-9]+)?";
    static final String VAR_STRING = "(\".*\")|('.*')";
    static final String VAR_NULL = "null";
    static final String VAR_TRUE = "true";
    static final String VAR_FALSE = "false";
    static final String VAR_BOOLEAN = "(true|false)";
    static final String NAME_STRING = "(_?[A-z][:A-z0-9_]*)";
    public static final byte INT = 0;
    public static final byte DOUBLE = 1;
    public static final byte BOOL = 2;
    public static final byte STRING = 3;
    public static final byte LIST = 4;
    public static final byte NAME = 5;
    public static final byte LT = 10;
    public static final byte GT = 11;
    public static final byte EQUALS = 12;
    public static final byte QUESTION = 13;
    public static final byte FORWARD_SLASH = 14;

    ZenithXMLParserByteCodes() {
    }

    @Override
    public byte stringToByteCode(String w) {
        if (w.matches(VAR_INT)) {
            return 0;
        }
        if (w.matches(VAR_DOUBLE)) {
            return 1;
        }
        if (w.matches(VAR_BOOLEAN)) {
            return 2;
        }
        if (w.matches(VAR_STRING)) {
            return 3;
        }
        if (w.matches(NAME_STRING)) {
            return 5;
        }
        if (w.equals("<")) {
            return 10;
        }
        if (w.equals(">")) {
            return 11;
        }
        if (w.equals("=")) {
            return 12;
        }
        if (w.equals("?")) {
            return 13;
        }
        if (w.equals("/")) {
            return 14;
        }
        return -1;
    }

    @Override
    public String symbolToString(int i) {
        switch (i) {
            case 0: {
                return "INT";
            }
            case 1: {
                return "DOUBLE";
            }
            case 2: {
                return "BOOL";
            }
            case 3: {
                return "STRING";
            }
            case 4: {
                return "LIST";
            }
            case 10: {
                return "LT";
            }
            case 11: {
                return "GT";
            }
            case 12: {
                return "EQUALS";
            }
            case 13: {
                return "QUESTION";
            }
            case 14: {
                return "FORWARD_SLASH";
            }
        }
        return "!UNKNOWN!";
    }

    @Override
    public String delimiterCharacters() {
        return " =<>/" + System.lineSeparator();
    }

    @Override
    public String[] listOfSubsequentCharacters() {
        return new String[0];
    }

    @Override
    public String quoteTypes() {
        return "\"'";
    }

    @Override
    public String[] listOfWhitespaces() {
        return new String[]{" ", "\n", "\r", System.lineSeparator()};
    }

    @Override
    public String[] listOfBoundWords() {
        return new String[0];
    }

    @Override
    public ArrayList<ZPEComment> listOfComments() {
        ArrayList<ZPEComment> a = new ArrayList<ZPEComment>();
        a.add(new ZPEComment("<!--", "-->"));
        return a;
    }
}

