/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.parsers.toml;

import jamiebalfour.zpe.parser.Tokeniser;
import jamiebalfour.zpe.parser.ZPEComment;
import java.util.ArrayList;

public class ZenithTOMLParserByteCodes
implements Tokeniser {
    static final String VAR_INT = "(((-[0-9]+)|[1-9][0-9]*)(E[0-9]+)?)";
    static final String VAR_DOUBLE = "(-?[0-9]+((\\.)?[0-9]*))(E(-?)[0-9]+)?";
    static final String VAR_STRING = "\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)\"";
    public static final byte LSQBR = 1;
    public static final byte RSQBR = 2;
    public static final byte EQUALS = 3;
    public static final byte ENDOFLINE = 4;
    public static final byte VALUE = 5;
    public static final byte INT = 6;
    public static final byte DOUBLE = 7;
    public static final byte STRING = 8;
    public static final byte BOOL = 9;
    public static final byte COMMA = 10;

    @Override
    public byte stringToByteCode(String s) {
        if (s.equals("=")) {
            return 3;
        }
        if (s.equals("[")) {
            return 1;
        }
        if (s.equals("]")) {
            return 2;
        }
        if (s.equals("true") || s.equals("false")) {
            return 9;
        }
        if (s.equals(",")) {
            return 10;
        }
        if (s.equals(System.lineSeparator())) {
            return 4;
        }
        if (s.matches(VAR_INT)) {
            return 6;
        }
        if (s.matches(VAR_DOUBLE)) {
            return 7;
        }
        if (s.matches(VAR_STRING)) {
            return 8;
        }
        return 5;
    }

    @Override
    public String symbolToString(int i) {
        return "";
    }

    @Override
    public String delimiterCharacters() {
        return "=[]," + System.lineSeparator();
    }

    @Override
    public String quoteTypes() {
        return "\"";
    }

    @Override
    public String[] listOfSubsequentCharacters() {
        return new String[0];
    }

    @Override
    public String[] listOfBoundWords() {
        return new String[0];
    }

    @Override
    public String[] listOfWhitespaces() {
        return new String[]{" "};
    }

    @Override
    public ArrayList<ZPEComment> listOfComments() {
        ArrayList<ZPEComment> comments = new ArrayList<ZPEComment>();
        comments.add(new ZPEComment("#", System.lineSeparator()));
        return comments;
    }
}

