/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.parsers.toml;

import jamiebalfour.HelperFunctions;
import jamiebalfour.parsers.toml.MalformedTOMLException;
import jamiebalfour.parsers.toml.ZenithTOMLParserByteCodes;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.parser.v4.ZenithParsingEngine;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPEString;
import java.util.Objects;

public class ZenithTOMLParser {
    ZenithParsingEngine parser;

    private static ZPEType produceOne(ZenithParsingEngine parser) throws MalformedTOMLException {
        if (parser.getCurrentSymbol() == 8) {
            return new ZPEString(parser.getCurrentWord());
        }
        if (parser.getCurrentSymbol() == 7) {
            return new ZPENumber(HelperFunctions.stringToDouble(parser.getCurrentWord()));
        }
        if (parser.getCurrentSymbol() == 6) {
            return new ZPENumber(HelperFunctions.stringToLong(parser.getCurrentWord()));
        }
        if (parser.getCurrentSymbol() == 9) {
            return new ZPEBoolean(ZPEHelperFunctions.ToBoolean(parser.getCurrentWord()));
        }
        if (parser.getCurrentSymbol() == 1) {
            ZPEList list = new ZPEList();
            parser.getNextSymbol();
            while (parser.getCurrentSymbol() != 2) {
                while (parser.getCurrentSymbol() == 4) {
                    parser.getNextSymbol();
                }
                ZPEType v = ZenithTOMLParser.produceOne(parser);
                list.add(v);
                parser.getNextSymbol();
                while (parser.getCurrentSymbol() == 4) {
                    parser.getNextSymbol();
                }
                if (parser.getCurrentSymbol() == 2) break;
                while (parser.getCurrentSymbol() == 4) {
                    parser.getNextSymbol();
                }
                if (parser.getCurrentSymbol() != 10) {
                    throw new MalformedTOMLException("ZenithTOMLParser: Expected comma.");
                }
                parser.getNextSymbol();
                while (parser.getCurrentSymbol() == 4) {
                    parser.getNextSymbol();
                }
            }
            return list;
        }
        return null;
    }

    public ZPEMap parseTOMLToMap(String s) throws MalformedTOMLException {
        ZPEMap output = new ZPEMap();
        ZPEMap group = null;
        String currentGroup = "";
        this.parser = new ZenithParsingEngine(s, false, new ZenithTOMLParserByteCodes());
        this.parser.getNextSymbol();
        while (this.parser.getCurrentSymbol() != -2) {
            while (this.parser.getCurrentSymbol() == 4) {
                this.parser.getNextSymbol();
            }
            if (this.parser.getCurrentSymbol() == -2) continue;
            if (this.parser.getCurrentSymbol() == 1) {
                String newGroup = this.parser.parseTo((byte)2).trim();
                if (!newGroup.equals(currentGroup) && !currentGroup.isEmpty()) {
                    output.put(new ZPEString(currentGroup), group);
                }
                currentGroup = newGroup;
                group = new ZPEMap();
                this.parser.getNextSymbol();
                continue;
            }
            if (this.parser.getCurrentSymbol() == 4) continue;
            String key = this.parser.getCurrentWord().trim();
            this.parser.getNextSymbol();
            if (!this.parser.getCurrentWord().equals("=")) {
                throw new MalformedTOMLException("ZenithTOMLParser: Unexpected value " + this.parser.getCurrentWord());
            }
            this.parser.getNextSymbol();
            ZPEType value = ZenithTOMLParser.produceOne(this.parser);
            this.parser.getNextSymbol();
            Objects.requireNonNullElse(group, output).put(new ZPEString(key), value);
        }
        if (!output.containsKey(new ZPEString(currentGroup))) {
            output.put(new ZPEString(currentGroup), group);
        }
        return output;
    }
}

