/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.parsers.json;

import jamiebalfour.zpe.parser.Tokeniser;
import jamiebalfour.zpe.parser.ZPEComment;
import java.util.ArrayList;

class ZenithJSONParserByteCodes
implements Tokeniser {
    static final String VAR_INT = "(((-[0-9]+)|[1-9][0-9]*)(E[0-9]+)?)";
    static final String VAR_DOUBLE = "(-?[0-9]+((\\.)?[0-9]*))(E(-?)[0-9]+)?";
    static final String VAR_STRING = "\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)\"";
    static final String VAR_NULL = "null";
    static final String VAR_TRUE = "true";
    static final String VAR_FALSE = "false";
    static final String VAR_BOOLEAN = "(true|false)";
    public static final byte INT = 0;
    public static final byte DOUBLE = 1;
    public static final byte BOOL = 2;
    public static final byte STRING = 3;
    public static final byte LIST = 4;
    public static final byte NULL = 5;
    public static final byte COLON = 10;
    public static final byte COMMA = 11;
    public static final byte LSQBR = 12;
    public static final byte RSQBR = 13;
    public static final byte LBRACE = 14;
    public static final byte RBRACE = 15;

    ZenithJSONParserByteCodes() {
    }

    @Override
    public byte stringToByteCode(String w) {
        if (w.matches(VAR_INT)) {
            return 0;
        }
        if (w.matches(VAR_DOUBLE)) {
            return 1;
        }
        if (w.matches(VAR_BOOLEAN)) {
            return 2;
        }
        if (w.matches(VAR_STRING)) {
            return 3;
        }
        if (w.equals(",")) {
            return 11;
        }
        if (w.equals("[")) {
            return 12;
        }
        if (w.equals("]")) {
            return 13;
        }
        if (w.equals("{")) {
            return 14;
        }
        if (w.equals(VAR_NULL)) {
            return 5;
        }
        if (w.equals("}")) {
            return 15;
        }
        if (w.equals(":")) {
            return 10;
        }
        return -1;
    }

    @Override
    public String symbolToString(int i) {
        switch (i) {
            case 0: {
                return "INT";
            }
            case 1: {
                return "DOUBLE";
            }
            case 2: {
                return "BOOL";
            }
            case 3: {
                return "STRING";
            }
            case 4: {
                return "LIST";
            }
            case 11: {
                return "COMMA";
            }
            case 12: {
                return "LSQBR";
            }
            case 13: {
                return "RSQBR";
            }
            case 14: {
                return "LBRACE";
            }
            case 15: {
                return "RBRACE";
            }
            case 10: {
                return "COLON";
            }
            case 5: {
                return "NULL";
            }
        }
        return "!UNKNOWN!";
    }

    @Override
    public String delimiterCharacters() {
        return "[]{}:, " + System.lineSeparator();
    }

    @Override
    public String[] listOfSubsequentCharacters() {
        return new String[0];
    }

    @Override
    public String quoteTypes() {
        return "\"";
    }

    @Override
    public String[] listOfWhitespaces() {
        return new String[]{" ", "\n", "\r", System.lineSeparator()};
    }

    @Override
    public String[] listOfBoundWords() {
        return new String[0];
    }

    @Override
    public ArrayList<ZPEComment> listOfComments() {
        ArrayList<ZPEComment> output = new ArrayList<ZPEComment>();
        output.add(new ZPEComment("//", System.lineSeparator()));
        return output;
    }
}

