/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.parsers.json;

import jamiebalfour.HelperFunctions;
import jamiebalfour.parsers.json.MalformedJSONException;
import jamiebalfour.parsers.json.ZenithJSONParserByteCodes;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.parser.v5.ZenithParsingEngine;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPEOrderedAssociativeArray;
import jamiebalfour.zpe.types.ZPEString;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class ZenithJSONParser {
    ZenithParsingEngine parser;

    public static void main(String[] args2) {
        try {
            String s = HelperFunctions.readFileAsString("/Users/jamiebalfour/test.json", "utf-8");
            ZenithJSONParser jbjson = new ZenithJSONParser();
            ZPEType json = jbjson.jsonDecode(s, false);
            System.out.println(json);
            System.out.println(jbjson.jsonEncode(json));
            System.out.println("Done");
        }
        catch (ZPERuntimeException | IOException e) {
            ZPE.printError("File not found!");
        }
        catch (MalformedJSONException e) {
            ZPE.printError(e.getMessage());
        }
    }

    private String line_trimmer(String s) {
        StringBuilder out = new StringBuilder();
        Scanner scanner = new Scanner(s);
        while (scanner.hasNextLine()) {
            String ln = scanner.nextLine();
            if ((ln = ln.trim()).isEmpty()) continue;
            out.append(ln).append(" ");
        }
        scanner.close();
        return out.toString();
    }

    public String jsonEncode(Object o) {
        if (o instanceof Map) {
            return this.mapToJSON(o);
        }
        if (o instanceof List) {
            return this.listToJSON(o);
        }
        if (o instanceof ZPEObject) {
            return this.zpeObjectToJSON(o);
        }
        if (o instanceof String || o instanceof ZPEString) {
            return "\"" + o + "\"";
        }
        if (o == null) {
            return "null";
        }
        return o.toString();
    }

    public ZPEType jsonDecode(String json, boolean useObjects) throws ZPERuntimeException, MalformedJSONException {
        ZenithJSONParserByteCodes bytecodes = new ZenithJSONParserByteCodes();
        this.parser = new ZenithParsingEngine(this.line_trimmer(json), false, bytecodes);
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() == 12) {
            return this.jsonToList(useObjects);
        }
        if (this.parser.getCurrentSymbol() == 14) {
            if (useObjects) {
                return this.jsonToZPEObject();
            }
            return this.jsonToMap();
        }
        if (this.parser.getCurrentSymbol() == 5) {
            return null;
        }
        return null;
    }

    private String getInnerValue(Object o) {
        if (o instanceof Map) {
            return this.mapToJSON(o);
        }
        if (o instanceof List) {
            return this.listToJSON(o);
        }
        if (o instanceof ZPEObject) {
            return this.zpeObjectToJSON(o);
        }
        if (o instanceof Integer || o instanceof Double || o instanceof Long) {
            return o.toString();
        }
        if (o == null) {
            return "null";
        }
        return "\"" + o + "\"";
    }

    private String zpeObjectToJSON(Object obj) {
        ZPEObject o = (ZPEObject)obj;
        StringBuilder out = new StringBuilder("{");
        int size = o.getProperties().length;
        int i = 0;
        for (String var : o.getProperties()) {
            ZPEType v = o.getProperty(var.toString());
            out.append(this.jsonEncode(var)).append(":").append(this.jsonEncode(v));
            if (i + 1 != size) {
                out.append(",");
            }
            ++i;
        }
        out.append("}");
        return out.toString();
    }

    private String listToJSON(Object o) {
        List x = (List)o;
        StringBuilder out = new StringBuilder("[");
        for (int i = 0; i < x.size(); ++i) {
            out.append(this.getInnerValue(x.get(i)));
            if (i + 1 == x.size()) continue;
            out.append(",");
        }
        return out + "]";
    }

    private String mapToJSON(Object o) {
        Map x = (Map)o;
        StringBuilder out = new StringBuilder("{");
        Object[] s = x instanceof ZPEOrderedAssociativeArray ? ((ZPEOrderedAssociativeArray)x).keys() : x.keySet().toArray();
        for (int i = 0; i < s.length; ++i) {
            out.append(this.jsonEncode(s[i])).append(" : ").append(this.getInnerValue(x.get(s[i])));
            if (i + 1 == x.size()) continue;
            out.append(",");
        }
        return out + "}";
    }

    private ZPEType jsonValueToValueObject(boolean useObjects) throws ZPERuntimeException, MalformedJSONException {
        byte symb = this.parser.getCurrentSymbol();
        if (symb == 3 || symb == 1 || symb == 0 || symb == 2) {
            return new ZPEString(this.parser.getCurrentWord());
        }
        if (symb == 5) {
            return null;
        }
        if (symb == 12) {
            return this.jsonToList(useObjects);
        }
        if (symb == 14) {
            if (useObjects) {
                return this.jsonToZPEObject();
            }
            return this.jsonToMap();
        }
        throw new MalformedJSONException("ZenithJSONParser: Unexpected value");
    }

    private ZPEList jsonToList(boolean useObjects) throws ZPERuntimeException, MalformedJSONException {
        ZPEList out = new ZPEList();
        if (this.parser.getCurrentSymbol() != 12) {
            throw new MalformedJSONException("No LSQBR found.");
        }
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() == 13) {
            return out;
        }
        while (true) {
            out.add(this.jsonValueToValueObject(useObjects));
            if (this.parser.getNextSymbol() != 11) break;
            this.parser.getNextSymbol();
        }
        if (this.parser.getCurrentSymbol() != 13) {
            throw new MalformedJSONException("No RSQBR found.");
        }
        return out;
    }

    private ZPEMap jsonToMap() throws ZPERuntimeException, MalformedJSONException {
        ZPEMap out = new ZPEMap();
        if (this.parser.getCurrentSymbol() != 14) {
            throw new MalformedJSONException("No LBRACE found.");
        }
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() == 15) {
            return out;
        }
        while (true) {
            if (this.parser.getCurrentSymbol() != 3) {
                throw new MalformedJSONException("No STRING found.");
            }
            String key = this.parser.getCurrentWord();
            if (this.parser.getNextSymbol() != 10) {
                throw new MalformedJSONException("No COLON found.");
            }
            this.parser.getNextSymbol();
            ZPEType value = this.jsonValueToValueObject(false);
            out.put(new ZPEString(key), value);
            if (this.parser.getNextSymbol() != 11) break;
            this.parser.getNextSymbol();
        }
        if (this.parser.getCurrentSymbol() != 15) {
            throw new MalformedJSONException("No RBRACE found.");
        }
        return out;
    }

    private ZPEObject jsonToZPEObject() throws ZPERuntimeException, MalformedJSONException {
        ZPEObject out = null;
        out = new ZPEObject(new ZPERuntimeEnvironment(), out, "Anonymous object");
        if (this.parser.getCurrentSymbol() != 14) {
            throw new MalformedJSONException("No LBRACE found.");
        }
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() == 15) {
            return out;
        }
        while (true) {
            if (this.parser.getCurrentSymbol() != 3) {
                throw new MalformedJSONException("No STRING found.");
            }
            String key = this.parser.getCurrentWord();
            if (this.parser.getNextSymbol() != 10) {
                throw new MalformedJSONException("No COLON found.");
            }
            this.parser.getNextSymbol();
            ZPEType value = this.jsonValueToValueObject(true);
            out.setProperty(key, value);
            if (this.parser.getNextSymbol() != 11) break;
            this.parser.getNextSymbol();
        }
        if (this.parser.getCurrentSymbol() != 15) {
            throw new MalformedJSONException("No RBRACE found.");
        }
        return out;
    }
}

