/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.parsers.jbml;

import jamiebalfour.zpe.parser.Tokeniser;
import jamiebalfour.zpe.parser.ZPEComment;
import java.util.ArrayList;

class ZenithJBMLParserByteCodes
implements Tokeniser {
    static final String VAR_INT = "(((-[0-9]+)|[1-9][0-9]*)(E[0-9]+)?)";
    static final String VAR_DOUBLE = "(-?[0-9]+((\\.)?[0-9]*))(E(-?)[0-9]+)?";
    static final String VAR_STRING = "(\"(.|\\s)*\")|('(.\\s)*')";
    public static final byte LSQBR = 1;
    public static final byte RSQBR = 2;
    public static final byte EQUALS = 3;
    public static final byte ENDOFLINE = 4;
    public static final byte VALUE = 5;
    public static final byte INT = 6;
    public static final byte DOUBLE = 7;
    public static final byte STRING = 8;
    public static final byte BOOL = 9;
    public static final byte COMMA = 10;
    public static final byte ASSOCIATION = 11;
    public static final byte LBRACE = 12;
    public static final byte RBRACE = 13;
    public static final byte CONCAT = 14;

    ZenithJBMLParserByteCodes() {
    }

    @Override
    public byte stringToByteCode(String s) {
        switch (s) {
            case ":": {
                return 11;
            }
            case "=": {
                return 3;
            }
            case "[": {
                return 1;
            }
            case "]": {
                return 2;
            }
            case "{": {
                return 12;
            }
            case "}": {
                return 13;
            }
            case "&": {
                return 14;
            }
            case "true": 
            case "false": 
            case "TRUE": 
            case "FALSE": {
                return 9;
            }
            case ",": {
                return 10;
            }
        }
        if (s.equals(System.lineSeparator())) {
            return 4;
        }
        if (s.matches(VAR_INT)) {
            return 6;
        }
        if (s.matches(VAR_DOUBLE)) {
            return 7;
        }
        if (s.matches(VAR_STRING)) {
            return 8;
        }
        return 5;
    }

    @Override
    public String symbolToString(int i) {
        return "";
    }

    @Override
    public String delimiterCharacters() {
        return " =[],:{}&" + System.lineSeparator();
    }

    @Override
    public String quoteTypes() {
        return "\"'";
    }

    @Override
    public String[] listOfSubsequentCharacters() {
        return new String[]{"=>"};
    }

    @Override
    public String[] listOfBoundWords() {
        return new String[0];
    }

    @Override
    public String[] listOfWhitespaces() {
        return new String[]{" "};
    }

    @Override
    public ArrayList<ZPEComment> listOfComments() {
        ArrayList<ZPEComment> comments = new ArrayList<ZPEComment>();
        comments.add(new ZPEComment("#", System.lineSeparator()));
        return comments;
    }
}

