/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class JBHashMap<K, V> {
    private static final int INITIAL_CAPACITY = 16;
    private static final double LOAD_FACTOR_THRESHOLD = 0.75;
    private LinkedList<Entry<K, V>>[] buckets = new LinkedList[16];
    private int size = 0;

    private int getBucketIndex(K key) {
        return Math.abs(key.hashCode()) % this.buckets.length;
    }

    public void put(K key, V value) {
        int index = this.getBucketIndex(key);
        if (this.buckets[index] == null) {
            this.buckets[index] = new LinkedList();
        }
        for (Entry entry : this.buckets[index]) {
            if (!entry.key.equals(key)) continue;
            entry.value = value;
            return;
        }
        this.buckets[index].add(new Entry<K, V>(key, value));
        ++this.size;
        if ((double)this.size / (double)this.buckets.length > 0.75) {
            this.resize();
        }
    }

    public V get(K key) {
        int index = this.getBucketIndex(key);
        if (this.buckets[index] == null) {
            return null;
        }
        for (Entry entry : this.buckets[index]) {
            if (!entry.key.equals(key)) continue;
            return entry.value;
        }
        return null;
    }

    public void remove(K key) {
        int index = this.getBucketIndex(key);
        if (this.buckets[index] == null) {
            return;
        }
        this.buckets[index].removeIf(entry -> entry.key.equals(key));
        --this.size;
    }

    private void resize() {
        LinkedList<Entry<K, V>>[] oldBuckets = this.buckets;
        this.buckets = new LinkedList[oldBuckets.length * 2];
        this.size = 0;
        for (LinkedList<Entry<K, V>> bucket : oldBuckets) {
            if (bucket == null) continue;
            for (Entry entry : bucket) {
                this.put(entry.key, entry.value);
            }
        }
    }

    public int size() {
        return this.size;
    }

    public Set<Entry<K, V>> entrySet() {
        HashSet<Entry<K, V>> entries = new HashSet<Entry<K, V>>();
        for (LinkedList<Entry<K, V>> bucket : this.buckets) {
            if (bucket == null) continue;
            entries.addAll(bucket);
        }
        return entries;
    }

    public Set<K> keySet() {
        HashSet keys2 = new HashSet();
        for (LinkedList<Entry<K, V>> bucket : this.buckets) {
            if (bucket == null) continue;
            for (Entry entry : bucket) {
                keys2.add(entry.key);
            }
        }
        return keys2;
    }

    public Collection<V> values() {
        ArrayList values2 = new ArrayList();
        for (LinkedList<Entry<K, V>> bucket : this.buckets) {
            if (bucket == null) continue;
            for (Entry entry : bucket) {
                values2.add(entry.value);
            }
        }
        return values2;
    }

    public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    public boolean containsValue(V value) {
        for (LinkedList<Entry<K, V>> bucket : this.buckets) {
            if (bucket == null) continue;
            for (Entry entry : bucket) {
                if (!entry.value.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public void putAll(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.buckets = new LinkedList[16];
        this.size = 0;
    }

    public static class Entry<K, V> {
        K key;
        V value;

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Entry entry = (Entry)obj;
            return Objects.equals(this.key, entry.key) && Objects.equals(this.value, entry.value);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

