/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.mqtt.client.Callback;
import org.fusesource.mqtt.client.CallbackConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Listener {
    private final MQTT mqtt = new MQTT();
    private final ArrayList<Topic> topics = new ArrayList();
    private boolean debug;
    private boolean showTopic;

    private static void displayHelpAndExit(int exitCode) {
        Listener.stdout("");
        Listener.stdout("This is a simple mqtt client that will subscribe to topics and print all messages it receives.");
        Listener.stdout("");
        Listener.stdout("Arguments: [-h host] [-k keepalive] [-c] [-i id] [-u username [-p password]]");
        Listener.stdout("           [--will-topic topic [--will-payload payload] [--will-qos qos] [--will-retain]]");
        Listener.stdout("           [-d] [-s]");
        Listener.stdout("           ( [-q qos] -t topic )+");
        Listener.stdout("");
        Listener.stdout("");
        Listener.stdout(" -h : mqtt host uri to connect to. Defaults to tcp://localhost:1883.");
        Listener.stdout(" -k : keep alive in seconds for this client. Defaults to 60.");
        Listener.stdout(" -c : disable 'clean session' (store subscription and pending messages when client disconnects).");
        Listener.stdout(" -i : id to use for this client. Defaults to a random id.");
        Listener.stdout(" -u : provide a username (requires MQTT 3.1 broker)");
        Listener.stdout(" -p : provide a password (requires MQTT 3.1 broker)");
        Listener.stdout(" --will-topic : the topic on which to publish the client Will.");
        Listener.stdout(" --will-payload : payload for the client Will, which is sent by the broker in case of");
        Listener.stdout("                  unexpected disconnection. If not given and will-topic is set, a zero");
        Listener.stdout("                  length message will be sent.");
        Listener.stdout(" --will-qos : QoS level for the client Will.");
        Listener.stdout(" --will-retain : if given, make the client Will retained.");
        Listener.stdout(" -d : dispaly debug info on stderr");
        Listener.stdout(" -s : show message topics in output");
        Listener.stdout(" -q : quality of service level to use for the subscription. Defaults to 0.");
        Listener.stdout(" -t : mqtt topic to subscribe to. May be repeated multiple times.");
        Listener.stdout(" -v : MQTT version to use 3.1 or 3.1.1. (default: 3.1)");
        Listener.stdout("");
        System.exit(exitCode);
    }

    private static void stdout(Object x) {
        System.out.println(x);
    }

    private static void stderr(Object x) {
        System.err.println(x);
    }

    private static String shift(LinkedList<String> argl) {
        if (argl.isEmpty()) {
            Listener.stderr("Invalid usage: Missing argument");
            Listener.displayHelpAndExit(1);
        }
        return argl.removeFirst();
    }

    public static void main(String[] args2) throws Exception {
        Listener main = new Listener();
        QoS qos = QoS.AT_MOST_ONCE;
        LinkedList<String> argl = new LinkedList<String>(Arrays.asList(args2));
        while (!argl.isEmpty()) {
            try {
                int v;
                String arg = argl.removeFirst();
                if ("--help".equals(arg)) {
                    Listener.displayHelpAndExit(0);
                    continue;
                }
                if ("-v".equals(arg)) {
                    main.mqtt.setVersion(Listener.shift(argl));
                    continue;
                }
                if ("-h".equals(arg)) {
                    main.mqtt.setHost(Listener.shift(argl));
                    continue;
                }
                if ("-k".equals(arg)) {
                    main.mqtt.setKeepAlive(Short.parseShort(Listener.shift(argl)));
                    continue;
                }
                if ("-c".equals(arg)) {
                    main.mqtt.setCleanSession(false);
                    continue;
                }
                if ("-i".equals(arg)) {
                    main.mqtt.setClientId(Listener.shift(argl));
                    continue;
                }
                if ("-u".equals(arg)) {
                    main.mqtt.setUserName(Listener.shift(argl));
                    continue;
                }
                if ("-p".equals(arg)) {
                    main.mqtt.setPassword(Listener.shift(argl));
                    continue;
                }
                if ("--will-topic".equals(arg)) {
                    main.mqtt.setWillTopic(Listener.shift(argl));
                    continue;
                }
                if ("--will-payload".equals(arg)) {
                    main.mqtt.setWillMessage(Listener.shift(argl));
                    continue;
                }
                if ("--will-qos".equals(arg)) {
                    v = Integer.parseInt(Listener.shift(argl));
                    if (v > QoS.values().length) {
                        Listener.stderr("Invalid qos value : " + v);
                        Listener.displayHelpAndExit(1);
                    }
                    main.mqtt.setWillQos(QoS.values()[v]);
                    continue;
                }
                if ("--will-retain".equals(arg)) {
                    main.mqtt.setWillRetain(true);
                    continue;
                }
                if ("-d".equals(arg)) {
                    main.debug = true;
                    continue;
                }
                if ("-s".equals(arg)) {
                    main.showTopic = true;
                    continue;
                }
                if ("-q".equals(arg)) {
                    v = Integer.parseInt(Listener.shift(argl));
                    if (v > QoS.values().length) {
                        Listener.stderr("Invalid qos value : " + v);
                        Listener.displayHelpAndExit(1);
                    }
                    qos = QoS.values()[v];
                    continue;
                }
                if ("-t".equals(arg)) {
                    main.topics.add(new Topic(Listener.shift(argl), qos));
                    continue;
                }
                Listener.stderr("Invalid usage: unknown option: " + arg);
                Listener.displayHelpAndExit(1);
            }
            catch (NumberFormatException e) {
                Listener.stderr("Invalid usage: argument not a number");
                Listener.displayHelpAndExit(1);
            }
        }
        if (main.topics.isEmpty()) {
            Listener.stderr("Invalid usage: no topics specified.");
            Listener.displayHelpAndExit(1);
        }
        main.execute();
        System.exit(0);
    }

    private void execute() {
        final CallbackConnection connection = this.mqtt.callbackConnection();
        final CountDownLatch done = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                this.setName("MQTT client shutdown");
                if (Listener.this.debug) {
                    Listener.stderr("Disconnecting the client.");
                }
                connection.getDispatchQueue().execute(new Task(){

                    public void run() {
                        connection.disconnect(new Callback<Void>(){

                            @Override
                            public void onSuccess(Void value) {
                                done.countDown();
                            }

                            @Override
                            public void onFailure(Throwable value) {
                                done.countDown();
                            }
                        });
                    }
                });
            }
        });
        connection.listener(new org.fusesource.mqtt.client.Listener(){

            public void onConnected() {
                if (Listener.this.debug) {
                    Listener.stderr("Connected");
                }
            }

            public void onDisconnected() {
                if (Listener.this.debug) {
                    Listener.stderr("Disconnected");
                }
            }

            public void onPublish(UTF8Buffer topic, Buffer body, Runnable ack) {
                try {
                    if (Listener.this.showTopic) {
                        Listener.stdout("");
                        Listener.stdout("Topic: " + topic);
                        body.writeTo(System.out);
                        Listener.stdout("");
                    } else {
                        body.writeTo(System.out);
                    }
                    ack.run();
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Throwable value) {
                if (Listener.this.debug) {
                    value.printStackTrace();
                } else {
                    Listener.stderr(value);
                }
                System.exit(2);
            }
        });
        connection.resume();
        connection.connect(new Callback<Void>(){

            @Override
            public void onFailure(Throwable value) {
                if (Listener.this.debug) {
                    value.printStackTrace();
                } else {
                    Listener.stderr(value);
                }
                System.exit(2);
            }

            @Override
            public void onSuccess(Void value) {
                final Topic[] ta = Listener.this.topics.toArray(new Topic[Listener.this.topics.size()]);
                connection.subscribe(ta, new Callback<byte[]>(){

                    @Override
                    public void onSuccess(byte[] value) {
                        if (Listener.this.debug) {
                            for (int i = 0; i < value.length; ++i) {
                                Listener.stderr("Subscribed to Topic: " + ta[i].name() + " with QoS: " + (Object)((Object)QoS.values()[value[i]]));
                            }
                        }
                    }

                    @Override
                    public void onFailure(Throwable value) {
                        Listener.stderr("Subscribe failed: " + value);
                        if (Listener.this.debug) {
                            value.printStackTrace();
                        }
                        System.exit(2);
                    }
                });
            }
        });
        try {
            done.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

