/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.zen;

import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.InternalException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.objects.ResponseObject;
import jamiebalfour.zpe.parser.v4.ZenithParsingEngine;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.zen.YASSWebByteCodes;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class ZENWebParser {
    ZPERuntimeEnvironment zx;
    YASSWebByteCodes codes = new YASSWebByteCodes();
    long parseTime = 0L;
    PrintStream oldWriter = null;

    public ZENWebParser(int permission_level) {
        this.zx = new ZPERuntimeEnvironment(permission_level);
    }

    public String parse(String code, Map<String, ZPEType> variables) throws ExitHalt, InternalException {
        this.oldWriter = System.out;
        variables.put("response", new ResponseObject(this.zx, ZPEKit.getGlobalFunction(this.zx)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stringWriter = new PrintStream(baos);
        System.setOut(stringWriter);
        ZenithParsingEngine parser = new ZenithParsingEngine(code, false, this.codes);
        StringBuilder output = new StringBuilder();
        long start = System.nanoTime();
        ZPEInstance.setToInteractive(true);
        boolean br = false;
        parser.ignoreQuotes(true);
        while (parser.hasNext() && !br) {
            if (parser.getCurrentSymbol() == 3 && parser.peekAhead() == 5) {
                parser.getNextSymbol();
                parser.ignoreQuotes(false);
                if (parser.hasNext()) {
                    parser.getNextSymbol();
                    if (parser.getCurrentSymbol() == 2) {
                        output.append(parser.getWhitespace());
                        System.out.print(output);
                        output = new StringBuilder();
                        String program = "";
                        program = parser.parseTo((byte)2);
                        byte nxt = parser.peekAhead();
                        if (nxt == 5) {
                            try {
                                ZPEKit.interpret(this.zx, program, new ZPEType[0], true, variables, true);
                            }
                            catch (CompileException | ZPERuntimeException e) {
                                System.err.println(e.getMessage());
                            }
                            catch (BreakPointHalt e) {
                                ZPEHelperFunctions.throwBreakPointException(this.zx);
                            }
                            parser.getNextSymbol();
                            parser.getNextSymbol();
                        }
                    }
                }
                parser.ignoreQuotes(true);
            } else {
                output.append(parser.getWhitespace()).append(parser.getCurrentWord());
            }
            parser.getNextSymbol();
        }
        if (!output.toString().isEmpty()) {
            System.out.println(output);
        }
        this.parseTime = System.nanoTime() - start;
        System.out.flush();
        System.setOut(this.oldWriter);
        return baos.toString();
    }

    public HashMap<String, String> getHeaders() {
        ZPEType o = ZPEKit.getGlobalVariable(this.zx, "$_RESPONSE_HEADERS");
        if (o instanceof ZPEMap) {
            ZPEMap a = (ZPEMap)o;
            return (HashMap)a.toMap();
        }
        return new HashMap<String, String>();
    }
}

