/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.types;

import jamiebalfour.zpe.interfaces.ZPECoreType;
import java.math.BigDecimal;
import java.util.Objects;

public class ZPENumber
implements Comparable<ZPENumber>,
ZPECoreType {
    Number n;

    public ZPENumber(Number n) {
        this.n = n;
    }

    public ZPENumber(ZPENumber n) {
        this.n = n.n;
    }

    @Override
    public int compareTo(ZPENumber o) {
        BigDecimal b1 = BigDecimal.valueOf(this.n.doubleValue());
        BigDecimal b2 = BigDecimal.valueOf(o.doubleValue());
        return b1.compareTo(b2);
    }

    public Number currentValue() {
        return this.n;
    }

    public String toString() {
        if (("" + this.currentValue()).endsWith(".0")) {
            return "" + this.longValue();
        }
        return "" + this.currentValue();
    }

    public int intValue() {
        return this.n.intValue();
    }

    public long longValue() {
        return this.n.longValue();
    }

    public float floatValue() {
        return this.n.floatValue();
    }

    public double doubleValue() {
        return this.n.doubleValue();
    }

    public void increment(Number val) {
        this.n = this.n.doubleValue() + val.doubleValue();
    }

    public void increment(ZPENumber val) {
        this.n = this.n.doubleValue() + val.doubleValue();
    }

    public void decrement(Number val) {
        this.n = this.n.doubleValue() - val.doubleValue();
    }

    public void decrement(ZPENumber val) {
        this.n = this.n.doubleValue() - val.doubleValue();
    }

    public void setValue(Number n) {
        this.n = n;
    }

    public ZPENumber negate() {
        this.setValue(0.0 - this.doubleValue());
        return this;
    }

    @Override
    public ZPENumber copyOfMe() {
        return new ZPENumber(this.n);
    }

    public boolean equals(Object o) {
        if (o instanceof ZPENumber) {
            return Objects.equals(((ZPENumber)o).n, this.n);
        }
        return false;
    }

    public int hashCode() {
        return this.n.hashCode();
    }
}

