/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.parser.v4;

import jamiebalfour.zpe.parser.Tokeniser;
import jamiebalfour.zpe.parser.ZPEComment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ZenithParsingEngine {
    public static final String VERSION = "1.4.3";
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String CRLF = "\r\n";
    private final Tokeniser tokens;
    private final ArrayList<String> word_list = new ArrayList();
    private final ArrayList<Byte> byte_list = new ArrayList();
    private final Map<String, String> replaceables = new HashMap<String, String>();
    private String program;
    private byte current_symbol = (byte)-128;
    private String current_word = "";
    private int current_line = 0;
    private byte previous_symbol;
    private int program_counter = 0;
    private final boolean case_insensitive;
    private String whitespaces = "";
    private ArrayList<ZPEComment> comments = new ArrayList();
    private boolean ignore_quotes = false;
    private boolean ignoreEscapes = false;
    private String program_so_far;
    private static char TAB;
    private static char NL;
    private static char CRR;
    private static int ASCII_ZERO;
    private static int ASCII_NINE;

    static {
        ASCII_ZERO = 0;
        ASCII_NINE = 0;
    }

    public static String translateEscapes(String input) {
        StringBuilder output = new StringBuilder();
        boolean escaping = false;
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (escaping) {
                switch (c) {
                    case 'n': {
                        output.append('\n');
                        break;
                    }
                    case 't': {
                        output.append('\t');
                        break;
                    }
                    case 'r': {
                        output.append('\r');
                        break;
                    }
                    case 'b': {
                        output.append('\b');
                        break;
                    }
                    case 'f': {
                        output.append('\f');
                        break;
                    }
                    case '\'': {
                        output.append('\'');
                        break;
                    }
                    case '\"': {
                        output.append('\"');
                        break;
                    }
                    case '\\': {
                        output.append('\\');
                        break;
                    }
                    default: {
                        output.append('\\').append(c);
                    }
                }
                escaping = false;
            } else if (c == '\\') {
                escaping = true;
            } else {
                output.append(c);
            }
            ++i;
        }
        if (escaping) {
            output.append('\\');
        }
        return output.toString();
    }

    public ZenithParsingEngine(String program_code, boolean caseInsensitive, Tokeniser t) {
        TAB = ZenithParsingEngine.translateEscapes("\t").charAt(0);
        NL = ZenithParsingEngine.translateEscapes("\n").charAt(0);
        CRR = ZenithParsingEngine.translateEscapes("\r").charAt(0);
        ASCII_ZERO = 48;
        ASCII_NINE = 57;
        this.case_insensitive = caseInsensitive;
        this.tokens = t;
        if (this.tokens.listOfComments() != null) {
            this.comments = this.tokens.listOfComments();
        }
        this.program = program_code;
        this.program_so_far = "";
    }

    public static void main(String[] args2) {
        System.out.println("Zenith Parsing Engine version 1.4.3 copyright (c) Jamie Balfour 2017 - 2024");
    }

    private static boolean isNumeric(char c) {
        return c >= ASCII_ZERO && c <= ASCII_NINE;
    }

    private static boolean isNumeric(Object s) {
        if (s == null) {
            return false;
        }
        return s.toString().matches("(-)?[0-9]+(\\.[0-9]+)?(E(-?)[0-9]+)?");
    }

    public void ignoreQuotes(boolean v) {
        this.ignore_quotes = v;
    }

    public void skipSymbol(byte s) {
        if (this.getCurrentSymbol() == s) {
            this.getNextSymbol();
        }
    }

    public String getProgramTo(int point) throws IndexOutOfBoundsException {
        try {
            return this.program.substring(0, this.program_counter);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public byte stringToByte(String s) {
        return this.tokens.stringToByteCode(s);
    }

    public void insertProgramAtCounter(String p) {
        String start = this.program.substring(0, this.program_counter);
        String end = this.program.substring(this.program_counter + 1);
        this.program = String.valueOf(start) + p + end;
    }

    public String getProgram_so_far() {
        return this.program_so_far;
    }

    public ArrayList<Byte> getByteList() {
        return this.byte_list;
    }

    public ArrayList<String> getWordList() {
        return this.word_list;
    }

    public String getProgram() {
        return this.program;
    }

    public void setProgram(String p) {
        this.program = p;
    }

    public int getProgramCounter() {
        return this.program_counter;
    }

    public byte getCurrentSymbol() {
        return this.current_symbol;
    }

    public void setCurrentSymbol(byte s) {
        this.current_symbol = s;
    }

    public int getCurrentLine() {
        return this.current_line;
    }

    public void addConstant(String n, String v) {
        this.replaceables.put(n, v);
    }

    public String getWhitespace() {
        return this.whitespaces;
    }

    public char getNextChar() {
        ++this.program_counter;
        return this.program.charAt(this.program_counter);
    }

    public String parseTo(byte symb) {
        StringBuilder output = new StringBuilder();
        this.next(false);
        while (this.program_counter < this.program.length()) {
            if (this.current_symbol == symb) {
                return output.toString();
            }
            output.append(this.whitespaces).append(this.current_word);
            this.next(false);
        }
        return output.toString();
    }

    public String getCurrentWord() {
        return this.getCurrentWord(true);
    }

    public void setCurrentWord(String s) {
        this.current_word = s;
    }

    public String getCurrentWord(boolean replaceQuotes) {
        String s = this.current_word;
        if (replaceQuotes && s != null && !s.isEmpty()) {
            char currChar = s.charAt(0);
            if (this.tokens.quoteTypes() != null && this.tokens.quoteTypes().contains("" + currChar) && (s = s.substring(1)).charAt(s.length() - 1) == currChar) {
                s = s.substring(0, s.length() - 1);
            }
        }
        if (this.replaceables.containsKey(s)) {
            s = this.current_word = this.replaceables.get(s);
        }
        return s;
    }

    public boolean hasNext() {
        return this.current_symbol != -2;
    }

    private void addSymbolsToArray() {
        this.word_list.add(this.current_word);
        this.byte_list.add(this.current_symbol);
    }

    public byte getNextSymbol() {
        this.current_symbol = this.next(false);
        this.addSymbolsToArray();
        return this.current_symbol;
    }

    public int getPreviousSymbol() {
        return this.previous_symbol;
    }

    public boolean checkProgramCounter() {
        return this.program_counter < this.program.length();
    }

    public byte peekAhead() {
        return this.peekAhead(1);
    }

    public byte peekAhead(int n) {
        int tempPc = this.program_counter;
        byte curSymb = this.current_symbol;
        byte curPrevSymb = this.previous_symbol;
        int cline = this.current_line;
        String curWord = this.current_word;
        String cWhitespace = this.whitespaces;
        byte i = 0;
        int q = 0;
        while (q < n) {
            i = this.next(true);
            ++q;
        }
        this.program_counter = tempPc;
        this.current_symbol = curSymb;
        this.previous_symbol = curPrevSymb;
        this.current_word = curWord;
        this.current_line = cline;
        this.whitespaces = cWhitespace;
        return i;
    }

    public String peekAheadWord(int n) {
        int tempPc = this.program_counter;
        byte curSymb = this.current_symbol;
        byte curPrevSymb = this.previous_symbol;
        int cline = this.current_line;
        String curWord = this.current_word;
        String cWhitespace = this.whitespaces;
        int q = 0;
        q = 0;
        while (q < n) {
            this.next(true);
            ++q;
        }
        String returnValue = this.current_word;
        this.program_counter = tempPc;
        this.current_symbol = curSymb;
        this.previous_symbol = curPrevSymb;
        this.current_word = curWord;
        this.current_line = cline;
        this.whitespaces = cWhitespace;
        return returnValue;
    }

    private byte next(boolean peeking) {
        this.whitespaces = "";
        if (this.program_counter >= this.program.length()) {
            return -2;
        }
        this.previous_symbol = this.current_symbol;
        String word = "";
        word = this.getNextWord(peeking);
        if (word == null || word.isEmpty()) {
            return -2;
        }
        this.current_word = word;
        if (!peeking) {
            this.program_so_far = String.valueOf(this.program_so_far) + word;
        }
        this.current_symbol = this.case_insensitive ? this.tokens.stringToByteCode(word.toLowerCase()) : this.tokens.stringToByteCode(word);
        return this.current_symbol;
    }

    private boolean isBoundWord(String s) {
        String[] stringArray = this.tokens.listOfBoundWords();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String q = stringArray[n2];
            if (q.equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void throwBoundWordError() {
        System.err.println("Zenith Parsing Engine: Bound word exception found at " + this.program_counter);
    }

    /*
     * Unable to fully structure code
     */
    private String getNextWord(boolean peeking) {
        word = new StringBuilder();
        in_comment = this.parserIsCommentStart();
        if (in_comment != null) {
            this.parserEatComments(in_comment);
        }
        this.whitespaces = String.valueOf(this.whitespaces) + this.parser_eat_whitespace();
        if (this.program_counter >= this.program.length()) {
            return null;
        }
        ch = this.program.charAt(this.program_counter);
        if (ch != '\u0000') ** GOTO lbl117
        return null;
lbl-1000:
        // 1 sources

        {
            ch = this.program.charAt(this.program_counter);
            var8_11 = this.tokens.listOfSubsequentCharacters();
            var7_10 = var8_11.length;
            var6_7 = 0;
            while (var6_7 < var7_10) {
                s = var8_11[var6_7];
                end = this.program.length() - this.program_counter + s.length();
                if (end < this.program.length() && end > this.program_counter && this.program.substring(this.program_counter, end).equals(s)) {
                    if (!word.toString().isEmpty()) {
                        return word.toString();
                    }
                    this.program_counter += s.length();
                    if (this.isBoundWord(s) && this.isWhitespace() != null) {
                        this.throwBoundWordError();
                    }
                    return s;
                }
                ++var6_7;
            }
            if (this.program_counter + 1 < this.program.length()) {
                double_char = String.valueOf(String.valueOf(ch)) + this.program.charAt(this.program_counter + 1);
                var9_14 = this.tokens.listOfSubsequentCharacters();
                var8_12 = var9_14.length;
                var7_10 = 0;
                while (var7_10 < var8_12) {
                    s = var9_14[var7_10];
                    if (s.startsWith(double_char)) {
                        new_word = new StringBuilder(double_char);
                        if (s.length() > 2) {
                            for (count = 2; this.program_counter + count < this.program.length() && count < s.length(); ++count) {
                                new_word.append(this.program.charAt(this.program_counter + count));
                                if (!new_word.toString().equals(s)) continue;
                                this.program_counter += new_word.length();
                                if (!word.toString().isEmpty()) {
                                    return word.toString();
                                }
                                return new_word.toString();
                            }
                        } else {
                            if (!word.toString().isEmpty()) {
                                return word.toString();
                            }
                            this.program_counter += 2;
                            return double_char;
                        }
                        if (this.isBoundWord(new_word.toString()) && this.isWhitespace() != null) {
                            this.throwBoundWordError();
                        }
                        if (new_word.toString().equals(s)) {
                            this.program_counter += new_word.length();
                            if (!word.toString().isEmpty()) {
                                return word.toString();
                            }
                            return new_word.toString();
                        }
                    }
                    ++var7_10;
                }
            }
            if (ch == '.' && (allNumeric = word.toString().matches("[0-9]+"))) {
                word.append(".");
                ++this.program_counter;
                while (this.program_counter < this.program.length()) {
                    ch = this.program.charAt(this.program_counter);
                    if (ZenithParsingEngine.isNumeric(ch)) {
                        word.append(ch);
                        ++this.program_counter;
                        continue;
                    }
                    if (ch == 'E') {
                        if (this.program_counter + 1 < this.program.length()) {
                            chnext = this.program.charAt(this.program_counter + 1);
                            if (ZenithParsingEngine.isNumeric(String.valueOf(word.toString()) + 'E' + chnext)) {
                                word.append('E');
                                ++this.program_counter;
                                continue;
                            }
                            return word.toString();
                        }
                        return word.toString();
                    }
                    return word.toString();
                }
            }
            if (ch == 'E' && word.toString().matches("[0-9]+")) {
                word.append("E");
                ++this.program_counter;
                while (this.program_counter < this.program.length()) {
                    ch = this.program.charAt(this.program_counter);
                    if (ch == '-') {
                        word.append("-");
                        if (this.program_counter + 1 < this.program.length()) {
                            ++this.program_counter;
                            ch = this.program.charAt(this.program_counter);
                        }
                    }
                    if (ZenithParsingEngine.isNumeric("" + ch)) {
                        word.append(ch);
                        ++this.program_counter;
                        continue;
                    }
                    return word.toString();
                }
            }
            if (this.parserIsDelimiterCharacter(ch)) {
                ch = this.program.charAt(this.program_counter);
                if (word.toString().isEmpty()) {
                    ++this.program_counter;
                    if (this.isBoundWord("" + ch) && this.isWhitespace() != null) {
                        this.throwBoundWordError();
                    }
                    return "" + ch;
                }
                if (this.isBoundWord(word.toString()) && this.isWhitespace() != null) {
                    this.throwBoundWordError();
                }
                return word.toString();
            }
            if (!this.ignore_quotes && this.parserIsQuote(ch)) {
                if (!word.toString().isEmpty()) {
                    return word.toString();
                }
                word = new StringBuilder(this.readString(ch));
            } else {
                word.append(ch);
            }
            ++this.program_counter;
lbl117:
            // 2 sources

            ** while (this.program_counter < this.program.length())
        }
lbl118:
        // 1 sources

        return word.toString();
    }

    public boolean disableEscapeCharacters(boolean b) {
        this.ignoreEscapes = b;
        return this.ignoreEscapes;
    }

    private String readString(char quoteSymbol) {
        StringBuilder word = new StringBuilder("\"");
        ++this.program_counter;
        boolean c = true;
        while (this.program_counter < this.program.length() && c) {
            if (this.program.charAt(this.program_counter) == quoteSymbol) {
                if (word.toString().endsWith("\\") && !this.ignoreEscapes) {
                    if (word.toString().endsWith("\\\\")) {
                        word = new StringBuilder(word.substring(0, word.length() - 1));
                        c = false;
                    } else {
                        word = new StringBuilder(word.substring(0, word.length() - 1));
                    }
                } else {
                    c = false;
                }
            }
            if (!c) continue;
            if (word.toString().endsWith("\\")) {
                if (this.program.charAt(this.program_counter) == 'n') {
                    word = new StringBuilder(String.valueOf(word.substring(0, word.length() - 1)) + NL);
                    ++this.program_counter;
                    continue;
                }
                if (this.program.charAt(this.program_counter) == 't') {
                    word = new StringBuilder(String.valueOf(word.substring(0, word.length() - 1)) + TAB);
                    ++this.program_counter;
                    continue;
                }
                if (this.program.charAt(this.program_counter) == 'r') {
                    word = new StringBuilder(String.valueOf(word.substring(0, word.length() - 1)) + CRR);
                    ++this.program_counter;
                    continue;
                }
                word.append(this.program.charAt(this.program_counter));
                ++this.program_counter;
                continue;
            }
            word.append(this.program.charAt(this.program_counter));
            ++this.program_counter;
        }
        word.append("\"");
        return word.toString();
    }

    private String parser_eat_whitespace() {
        StringBuilder output = new StringBuilder();
        boolean terminate = false;
        while (this.program_counter < this.program.length() && !terminate) {
            String ws = this.isWhitespace();
            if (ws == null) {
                terminate = true;
                continue;
            }
            this.program_counter += ws.length();
            output.append(ws);
        }
        ZPEComment in_comment = this.parserIsCommentStart();
        if (in_comment != null) {
            this.parserEatComments(in_comment);
        }
        return output.toString();
    }

    private String isWhitespace() {
        String[] stringArray = this.tokens.listOfWhitespaces();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (this.nextWordMatches(t)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    private boolean parserIsQuote(char comp) {
        String c = "" + comp;
        return this.tokens.quoteTypes() != null && this.tokens.quoteTypes().contains(c);
    }

    private ZPEComment parserIsCommentStart() {
        for (ZPEComment s : this.comments) {
            if (this.program_counter >= this.program.length() || this.program.charAt(this.program_counter) != s.getStart().charAt(0) || !this.nextWordMatches(s.getStart())) continue;
            return s;
        }
        return null;
    }

    private void parserEatComments(ZPEComment comment_type) {
        char searchChar = comment_type.getEnd().charAt(0);
        while (this.program_counter < this.program.length()) {
            if (this.program.charAt(this.program_counter) == searchChar && this.nextWordMatches(comment_type.getEnd())) {
                this.program_counter += comment_type.getEnd().length();
                this.parser_eat_whitespace();
                ZPEComment in_comment = this.parserIsCommentStart();
                if (in_comment != null) {
                    this.parserEatComments(in_comment);
                }
                return;
            }
            ++this.program_counter;
        }
    }

    private boolean nextWordMatches(String comp) {
        int t = 0;
        while (t + this.program_counter < this.program.length() && t < comp.length()) {
            if (this.program.charAt(t + this.program_counter) != comp.charAt(t)) {
                return false;
            }
            ++t;
        }
        return true;
    }

    private boolean parserIsDelimiterCharacter(char comp) {
        String c = "" + comp;
        return this.tokens.delimiterCharacters().contains(c);
    }

    public String toString() {
        return String.valueOf(this.current_symbol) + " : " + this.current_word + " : " + this.program_counter;
    }
}

