/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.objects;

import jamiebalfour.HelperFunctions;
import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPENumber;
import java.util.HashMap;

public class CalculatorObject
extends ZPEStructure {
    private static final long serialVersionUID = 9040614377578230173L;
    ZPERuntimeEnvironment tempRuntime = new ZPERuntimeEnvironment(0);
    IAST codeFAST;
    HashMap<String, ZPENumber> vars = new HashMap();
    String expression = "";

    public CalculatorObject(ZPERuntimeEnvironment z, ZPEPropertyWrapper parent) throws ZPERuntimeException {
        super(z, parent, "ZPECalculator");
        this.addNativeMethod("add_variable", new add_variable_Command());
        this.addNativeMethod("set_expression", new set_expression_Command());
        this.addNativeMethod("compile", new compile_Command());
        this.addNativeMethod("evaluate", new evaluate_Command());
        new ZPERuntimeEnvironment(z.getPermissionLevel());
    }

    private void addVariable(String id, ZPEObject owner) throws ZPERuntimeException {
        this.vars.put(id, new ZPENumber(0.0));
        set_variable_Command m = new set_variable_Command();
        m.id = id;
        owner.addPropertyByName("set_" + id);
        owner.setProperty("set_" + id, m);
    }

    public double Evaluate() throws ZPERuntimeException, ExitHalt, BreakPointHalt {
        if (this.codeFAST != null) {
            HashMap<String, ZPEType> parameterMap = new HashMap<String, ZPEType>();
            for (String k : this.vars.keySet()) {
                parameterMap.put("$" + k, this.vars.get(k));
            }
            ZPEType val = ZPEKit.runCode(this.tempRuntime, IAST.copy(this.codeFAST), parameterMap);
            return HelperFunctions.stringToDouble(val.toString());
        }
        ZPE.printWarning("Code not compiled");
        return 0.0;
    }

    class compile_Command
    implements ZPEObjectNativeMethod {
        compile_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            String expr = CalculatorObject.this.expression;
            for (String k : CalculatorObject.this.vars.keySet()) {
                expr = expr.replace(k, "$" + k);
            }
            String code = "return " + expr;
            try {
                CalculatorObject.this.codeFAST = ZPEKit.compile(code);
            }
            catch (CompileException e) {
                ZPE.printWarning("Code could not be compiled in Calculator object");
            }
            return new ZPEBoolean(true);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "compile";
        }
    }

    class set_expression_Command
    implements ZPEObjectNativeMethod {
        set_expression_Command() {
        }

        @Override
        public String[] getParameterNames() {
            String[] vars = new String[]{"expr"};
            return vars;
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            CalculatorObject.this.expression = parameters.get("expr").toString();
            return new ZPEBoolean(true);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "set_expression";
        }
    }

    class set_variable_Command
    implements ZPEObjectNativeMethod {
        String id = "";

        set_variable_Command() {
        }

        @Override
        public String[] getParameterNames() {
            String[] vars = new String[]{"value"};
            return vars;
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            CalculatorObject.this.vars.put(this.id, new ZPENumber(HelperFunctions.stringToDouble(parameters.get("value").toString())));
            return new ZPEBoolean(true);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "set_variable";
        }
    }

    class evaluate_Command
    implements ZPEObjectNativeMethod {
        evaluate_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) throws ExitHalt {
            try {
                return new ZPENumber(CalculatorObject.this.Evaluate());
            }
            catch (ZPERuntimeException e) {
                ZPE.log("Error in Calculator object evaluation. Check the syntax.");
                return null;
            }
            catch (ExitHalt e) {
                throw new RuntimeException(e);
            }
            catch (BreakPointHalt e) {
                ZPEHelperFunctions.throwBreakPointException(CalculatorObject.this.getRuntime());
                throw new ExitHalt(0);
            }
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "evaluate";
        }
    }

    class add_variable_Command
    implements ZPEObjectNativeMethod {
        add_variable_Command() {
        }

        @Override
        public String[] getParameterNames() {
            String[] vars = new String[]{"id"};
            return vars;
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            try {
                CalculatorObject.this.addVariable(parameters.get("id").toString(), parent);
            }
            catch (ZPERuntimeException zPERuntimeException) {
                // empty catch block
            }
            return new ZPEBoolean(true);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "add_variable";
        }
    }
}

