/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.objects;

import jamiebalfour.HelperFunctions;
import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPENumber;
import javax.sound.sampled.Clip;

public class AudioStreamObject
extends ZPEStructure {
    private static final long serialVersionUID = -2752529375666084798L;
    Clip clip;

    public AudioStreamObject(ZPERuntimeEnvironment z, ZPEPropertyWrapper p) throws ZPERuntimeException {
        super(z, p, "AudioStreamObject");
        this.addNativeMethod("open_stream", new open_stream_Command());
        this.addNativeMethod("play", new play_Command());
        this.addNativeMethod("play_async", new play_async_Command());
        this.addNativeMethod("length", new length_Command());
    }

    public void open(String url) throws Exception {
        this.clip = HelperFunctions.openAudioClip(url);
    }

    class length_Command
    implements ZPEObjectNativeMethod {
        length_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return new ZPENumber(AudioStreamObject.this.clip.getMicrosecondLength() / 1000L);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "length";
        }
    }

    class play_async_Command
    implements ZPEObjectNativeMethod {
        play_async_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            AudioStreamObject.this.clip.start();
            AudioStreamObject.this.clip.setFramePosition(0);
            return new ZPEBoolean(true);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "play_async";
        }
    }

    class play_Command
    implements ZPEObjectNativeMethod {
        play_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            AudioStreamObject.this.clip.start();
            HelperFunctions.delay(AudioStreamObject.this.clip.getMicrosecondLength() / 1000L);
            AudioStreamObject.this.clip.setFramePosition(0);
            return new ZPEBoolean(true);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "play";
        }
    }

    class open_stream_Command
    implements ZPEObjectNativeMethod {
        open_stream_Command() {
        }

        @Override
        public String[] getParameterNames() {
            String[] n = new String[]{"url"};
            return n;
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            try {
                AudioStreamObject.this.open(parameters.get("url").toString());
                return new ZPEBoolean(true);
            }
            catch (Exception e) {
                return new ZPEBoolean(false);
            }
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "open_stream";
        }
    }
}

