/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.gui;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.interfaces.ZPEType;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class CommandWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Dimension defaultDimension = new Dimension(500, 114);
    private static final Dimension resizeDimension = new Dimension(500, 400);
    private static Point defaultLocation;
    private static Point resizeLocation;
    private static final Color foregroundColor;
    private static final Color backgroundColor;
    private static final Color altBackgroundColor;
    private final JTextField txtCommand;
    private final JTextArea outputConsole;
    final JFrame me = this;
    boolean toShow = false;

    public CommandWindow() {
        Point loc;
        int newWidth;
        this.setType(Window.Type.POPUP);
        this.setDefaultCloseOperation(3);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = screenSize.getWidth();
        CommandWindow.defaultDimension.width = newWidth = (int)(width - 200.0);
        CommandWindow.resizeDimension.width = newWidth;
        this.setAlwaysOnTop(true);
        this.setSize(defaultDimension);
        this.setTitle("ZPE Command Window");
        this.getContentPane().setForeground(foregroundColor);
        this.getContentPane().setBackground(altBackgroundColor);
        JPanel panel = new JPanel();
        panel.setBackground(backgroundColor);
        this.getContentPane().add((Component)panel, "North");
        panel.setLayout(new BorderLayout(0, 0));
        panel.setBorder(BorderFactory.createMatteBorder(10, 25, 25, 10, backgroundColor));
        this.txtCommand = new JTextField();
        this.txtCommand.setForeground(foregroundColor);
        this.txtCommand.setBackground(backgroundColor);
        this.txtCommand.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CommandWindow.this.collect();
                } else {
                    CommandWindow.this.hideContent();
                }
            }
        });
        this.setLocationRelativeTo(null);
        panel.add(this.txtCommand);
        this.txtCommand.setToolTipText("Insert a command in here.");
        this.txtCommand.setFont(new Font("Consolas", 0, 61));
        this.txtCommand.setColumns(10);
        this.txtCommand.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, Color.white));
        this.outputConsole = new JTextArea();
        this.outputConsole.setForeground(foregroundColor);
        this.outputConsole.setBackground(altBackgroundColor);
        this.outputConsole.setFont(new Font("Lucida Grande", 0, 22));
        this.outputConsole.setEditable(false);
        this.outputConsole.setMargin(new Insets(0, 25, 25, 0));
        this.getContentPane().add((Component)this.outputConsole, "Center");
        this.setBackground(backgroundColor);
        this.setForeground(foregroundColor);
        this.setResizable(false);
        defaultLocation = loc = new Point(this.getLocation().x, this.getLocation().y - 100);
        this.setLocation(defaultLocation);
        resizeLocation = new Point(loc.x, loc.y - 152);
        this.genTray();
        HelperFunctions.redirectSystemOutput(this.outputConsole);
    }

    private void collect() {
        this.showContent();
        String currentLine = this.txtCommand.getText();
        String code = "print(run_command(\"" + currentLine + "\"))";
        try {
            ZPEKit.interpret(code, new ZPEType[0], ZPEInstance.getUserDefinedPermissionLevelProperty());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.txtCommand.setText("");
    }

    private void showContent() {
        this.outputConsole.setText("");
        this.setLocation(resizeLocation);
        this.setSize(resizeDimension);
        this.toShow = true;
    }

    private void hideContent() {
        if (this.toShow) {
            this.toShow = false;
        }
        this.setLocation(defaultLocation);
        this.setSize(defaultDimension);
    }

    private void genTray() {
        ImageIcon i;
        if (!SystemTray.isSupported()) {
            System.out.println("SystemTray is not supported");
            return;
        }
        PopupMenu popup = new PopupMenu();
        try {
            i = new ImageIcon(HelperFunctions.getResource("/files/tray.gif"));
        }
        catch (Exception e) {
            i = null;
        }
        TrayIcon trayIcon = null;
        SystemTray tray = null;
        if (i != null) {
            trayIcon = new TrayIcon(i.getImage());
            tray = SystemTray.getSystemTray();
        }
        MenuItem exitItem = new MenuItem("Exit");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        popup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        popup.add(exitItem);
        if (trayIcon != null && tray != null) {
            trayIcon.setPopupMenu(popup);
            try {
                tray.add(trayIcon);
            }
            catch (AWTException e) {
                ZPE.log("TrayIcon could not be added.");
            }
        }
    }

    static {
        foregroundColor = Color.black;
        backgroundColor = new Color(238, 238, 238);
        altBackgroundColor = new Color(221, 221, 221);
    }
}

