/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.editor;

import jamiebalfour.HelperFunctions;
import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.ui.BalfAboutDialog;
import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.BalfMenuBar;
import jamiebalfour.ui.BalfRoundedButton;
import jamiebalfour.ui.BalfScrollbar;
import jamiebalfour.ui.BalfSearchBox;
import jamiebalfour.ui.BalfTitleBar;
import jamiebalfour.ui.BalfWindow;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.editor.AIAssistant;
import jamiebalfour.zpe.editor.CodeEditorView;
import jamiebalfour.zpe.editor.FunctionInformationWindow;
import jamiebalfour.zpe.editor.YASSUnfoldDialog;
import jamiebalfour.zpe.editor.ZPEChangelogDialog;
import jamiebalfour.zpe.editor.ZPEEditor;
import jamiebalfour.zpe.editor.ZPEEditorZENServerUI;
import jamiebalfour.zpe.editor.ZPEFunctionGenerator;
import jamiebalfour.zpe.editor.ZPEOnlineFileChooser;
import jamiebalfour.zpe.editor.ZPEOnlineLoginPanel;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.gui.ZPEConsole;
import jamiebalfour.zpe.gui.ZPEMacroInterface;
import jamiebalfour.zpe.interfaces.GenericEditor;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.os.macos.macOS;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPEString;
import jamiebalfour.zpe.zen.ZENServer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Taskbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

class ZPEEditorMain
extends BalfWindow
implements GenericEditor {
    private static final long serialVersionUID = -8251993208396962207L;
    static FileNameExtensionFilter filter1 = new FileNameExtensionFilter("YASS files (*.yas)", "yas");
    static FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Text files (*.txt)", "txt");
    static FileNameExtensionFilter filter3 = new FileNameExtensionFilter("YASS executable files (*.yex)", "yex");
    private static JWindow tooltipWindow;
    private final Map<String, String> autoCompleteSuggestionTypes = new HashMap<String, String>();
    protected UndoHandler undoHandler = new UndoHandler();
    protected UndoManager undoManager = new UndoManager();
    ZPEEditorMain _this = this;
    JEditorPane contentEditor;
    Properties mainProperties;
    boolean propertiesChanged = false;
    String login_username = "";
    String login_password = "";
    String lastCloudFileOpened = "";
    String lastFileOpened = "";
    BalfMenuBar.MenuItem mainLoginMenuItem;
    BalfMenuBar.Menu recentOnlineFilesMenu;
    JSeparator zpeOnlineSeparator;
    BalfMenuBar.MenuItem loadFromZPEOnlineMenuItem;
    BalfMenuBar.MenuItem saveToZPEOnlineMenuItem;
    BalfMenuBar.MenuItem loginToZPEOnlineMenuItem;
    BalfMenuBar.Menu fontFamilyMenu;
    BalfMenuBar.CheckBoxMenuItem darkModeMenuItem;
    ZPEConsole AttachedConsole;
    BalfMenuBar.CheckBoxMenuItem useMacMenuBarMenuItem;
    BalfMenuBar.MenuItem unCommentLinesMenuItem;
    BalfMenuBar.MenuItem commentLinesMenuItem;
    BalfScrollbar scrollPane;
    CodeEditorView mainSyntax;
    String fontsAllowed = "Arial,Calibri,Comic Sans MS,Consolas,Courier New,Garamond,Lucida Sans,Menlo,Monospaced,Quicksand Light,Times New Roman";
    String defaultFontFamily;
    boolean dontUndo = true;
    boolean darkMode = false;
    ZPEString[] runtimeArgs = new ZPEString[0];
    BalfMenuBar.CheckBoxMenuItem fontSizeSmallMenuItem;
    BalfMenuBar.CheckBoxMenuItem fontSizeNormalMenuItem;
    BalfMenuBar.CheckBoxMenuItem fontSizeLargeMenuItem;
    BalfMenuBar.CheckBoxMenuItem fontSizeExtraLargeMenuItem;
    BalfMenuBar.CheckBoxMenuItem caseSensitiveCompileMenuItem;
    BalfMenuBar.Menu recentItemsMenu;
    BalfMenuBar.CheckBoxMenuItem useLocalConsoleMenuItem;
    Process currentProcess;
    BalfMenuBar.MenuItem stopCodeMenuItem;
    ImageIcon lighterLogo;
    ImageIcon lighterLogoFull;
    int permission_level = 3;
    ArrayList<String> recents = ZPEEditor.getRecentFiles("");
    String lastHoveredWord = "";
    Point lastPosition = new Point(0, 0);
    JWindow autoCompletePopup = new JWindow();
    private JFrame editor;
    private UndoAction undoAction = null;
    private RedoAction redoAction = null;
    private int currentAutoCompletePosition = 0;
    private List<String> autoCompleteSuggestionWords;
    private String previousAutoCompleteWord = "";
    private Timer autoCompleteDebounceTimer;
    private Color autoCompleteItemBackgroundColor = new Color(241, 241, 241, 255);
    private Timer showTooltipTimer;
    private Timer hideTooltipTimer;
    private final ArrayList<JFrame> currentWindows = new ArrayList();
    BalfWindow _frame;
    BalfMenuBar menuBar;
    private Color mainColour = new Color(36, 0, 57);
    private Color mainColourAlt = new Color(104, 0, 136);
    boolean isMaximised = false;

    private void maximiseButtonClicked() {
        if (this.isMaximised) {
            this.setExtendedState(0);
            this.setSize(800, 600);
            this.setLocationRelativeTo(null);
            this.getContentPane().setPreferredSize(new Dimension(800, 600));
            this.getContentPane().revalidate();
            this.getContentPane().repaint();
        } else {
            this.maximiseToCurrentScreen(this._frame);
            this.getContentPane().setPreferredSize(null);
            this.getContentPane().revalidate();
            this.getContentPane().repaint();
        }
        this.isMaximised = !this.isMaximised;
    }

    public void maximiseToCurrentScreen(JFrame frame) {
        GraphicsConfiguration gc = frame.getGraphicsConfiguration();
        Rectangle screenBounds = gc.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        int x = screenBounds.x + screenInsets.left;
        int y = screenBounds.y + screenInsets.top;
        int width = screenBounds.width - screenInsets.left - screenInsets.right;
        int height = screenBounds.height - screenInsets.top - screenInsets.bottom;
        frame.setBounds(x, y, width, height);
        frame.setExtendedState(6);
    }

    public ZPEEditorMain(String name, String file) throws IOException {
        super(name, 0, new Color(36, 0, 57), new Color(104, 0, 136), Color.white);
        Object helpName;
        this.setLayout(new BorderLayout());
        boolean useMacMenuBar = true;
        String path = ZPEInstance.getInstallPath() + "gui.properties";
        File f = new File(path);
        if (!f.exists()) {
            this.saveGUISettings(new Properties());
        }
        this.mainProperties = HelperFunctions.readProperties(path);
        if (this.mainProperties.containsKey("USE_MAC_SIMPLEBAR")) {
            useMacMenuBar = !this.mainProperties.get("USE_MAC_SIMPLEBAR").toString().equals("true");
        }
        this._frame = this;
        this.setTitle("ZPE Editor");
        this.getTitleBar().setMaximiseButtonListener(e -> this.maximiseButtonClicked());
        this.getTitleBar().setCloseListener(e -> {
            this.closeUp();
            System.exit(0);
        });
        this.setForeground(Color.WHITE);
        BalfTitleBar.rightPanelButton execButton = new BalfTitleBar.rightPanelButton(new ImageIcon(Objects.requireNonNull(ZPEEditorMain.class.getResource("/files/exec.png"))), new Color(186, 186, 186));
        execButton.setToolTipText("Execute the code");
        execButton.addActionListener(e -> {
            try {
                this.executeCode();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Unable to compile or run code.", "Error", 0);
            }
        });
        this.getTitleBar().addRightButton(execButton);
        BalfTitleBar.rightPanelButton debug = new BalfTitleBar.rightPanelButton(new ImageIcon(Objects.requireNonNull(ZPEEditorMain.class.getResource("/files/debug.png"))), new Color(186, 186, 186));
        debug.setToolTipText("Debug the code");
        debug.addActionListener(e -> {
            try {
                this.debugCode();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Unable to compile or run code.", "Error", 0);
            }
        });
        this.getTitleBar().addRightButton(debug);
        BalfTitleBar.rightPanelButton validate = new BalfTitleBar.rightPanelButton(new ImageIcon(Objects.requireNonNull(ZPEEditorMain.class.getResource("/files/validate.png"))), new Color(186, 186, 186));
        validate.setToolTipText("Validate the code");
        validate.addActionListener(e -> {
            try {
                if (ZPEKit.validateCode(this.contentEditor.getText())) {
                    JOptionPane.showMessageDialog(this.editor, "Code is valid", "Code analysis", 1, this.lighterLogo);
                } else {
                    JOptionPane.showMessageDialog(this.editor, "Code is invalid", "Code analysis", 1, this.lighterLogo);
                }
            }
            catch (CompileException ex) {
                JOptionPane.showMessageDialog(this.editor, "Code is invalid", "Code analysis", 1, this.lighterLogo);
            }
        });
        this.getTitleBar().addRightButton(validate);
        this.lighterLogoFull = ZPEHelperFunctions.getLogo();
        Image newimg = this.lighterLogoFull.getImage().getScaledInstance(60, 60, 4);
        this.lighterLogo = new ImageIcon(newimg);
        HashMap<String, SimpleAttributeSet> YASSKeywords = new HashMap<String, SimpleAttributeSet>(16);
        for (String type : ZPEKit.getTypeKeywords()) {
            YASSKeywords.put(type, CodeEditorView.DEFAULT_TYPE);
        }
        for (String keyword : ZPEKit.getKeywords()) {
            YASSKeywords.put(keyword, CodeEditorView.DEFAULT_KEYWORD);
        }
        YASSKeywords.put("null", CodeEditorView.DEFAULT_NULL);
        YASSKeywords.put("NULL", CodeEditorView.DEFAULT_NULL);
        YASSKeywords.put("+", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("-", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("^", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("==", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("!", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("<", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put(">", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("<=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put(">=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("!=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("+=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("-=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("*=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("/=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("^=", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("&", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("|", CodeEditorView.DEFAULT_KEYWORD);
        YASSKeywords.put("#breakpoint#", CodeEditorView.DEFAULT_SPECIAL);
        YASSKeywords.put("true", CodeEditorView.DEFAULT_BOOLEAN);
        YASSKeywords.put("false", CodeEditorView.DEFAULT_BOOLEAN);
        YASSKeywords.put("this", CodeEditorView.DEFAULT_VAR);
        for (String directive : ZPEKit.getDirectiveKeywords()) {
            YASSKeywords.put(directive, CodeEditorView.DEFAULT_DOC);
        }
        for (String cmd : ZPEKit.getAllCommands()) {
            YASSKeywords.put(cmd, CodeEditorView.DEFAULT_PREDEFINED_FUNCTION);
        }
        for (String cmd : ZPEKit.getAllAliases()) {
            YASSKeywords.put(cmd, CodeEditorView.DEFAULT_PREDEFINED_FUNCTION);
        }
        this.mainSyntax = new CodeEditorView(YASSKeywords, "\"'", "$");
        StringBuilder supportedFontString = new StringBuilder();
        ArrayList<String> supportedFontsList = new ArrayList<String>();
        for (String s2 : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            if (!this.fontsAllowed.contains(s2)) continue;
            supportedFontString.append(s2).append(",");
            supportedFontsList.add(s2);
        }
        this.defaultFontFamily = supportedFontString.toString().contains("Menlo") ? "Menlo" : "Courier New";
        if (ZPEEditorMain.getVersion() < 9) {
            System.err.println("You must be running Java 9 or higher to open the GUI.");
            return;
        }
        this.mainSyntax.setFontSize(18);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int confirmed = JOptionPane.showConfirmDialog(ZPEEditorMain.this.editor, "Are you sure you want to exit the program?", "Exit Program Message Box", 0);
                if (confirmed == 0) {
                    ZPEEditorMain.this.dispose();
                }
                ZPEEditorMain.this.closeUp();
                System.exit(0);
            }
        });
        try {
            this.setIconImage(this.lighterLogoFull.getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (HelperFunctions.isMac()) {
            try {
                macOS a = new macOS();
                a.addAboutDialog(this::showAbout);
            }
            catch (Exception a) {
                // empty catch block
            }
            try {
                if (Taskbar.isTaskbarSupported()) {
                    Toolkit.getDefaultToolkit();
                    Taskbar taskbar = Taskbar.getTaskbar();
                    Image image = this.lighterLogoFull.getImage();
                    taskbar.setIconImage(image);
                }
            }
            catch (Exception taskbar) {
                // empty catch block
            }
        }
        this.editor = this;
        this.setMinimumSize(new Dimension(400, 400));
        int modifierKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        this.setDefaultCloseOperation(0);
        this.scrollPane = new BalfScrollbar();
        this.scrollPane.setBackground(Color.white);
        this.scrollPane.setEnabled(false);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ZPEEditorMain.this.hideTooltip();
            }
        });
        JEditorPane mainEditor = (JEditorPane)this.mainSyntax.getEditPane();
        mainEditor.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        mainEditor.setFont(new Font(this.defaultFontFamily, 0, 18));
        this.scrollPane.setViewportView(mainEditor);
        this.scrollPane.setRowHeaderView(this.mainSyntax.getEditor());
        this.add((Component)this.scrollPane, "Center");
        this.contentEditor = mainEditor;
        if (HelperFunctions.isMac() && useMacMenuBar) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        this.menuBar = new BalfMenuBar(new Color(36, 0, 57), new Color(38, 0, 50), Color.WHITE, new Color(72, 13, 106));
        String footerText = "<html><center>&copy; Jamie Balfour 2015 - 2025 version 1.13.7</center></html>";
        this.getFooter().setText(footerText);
        BalfMenuBar.Menu fileMenu = new BalfMenuBar.Menu("File", 0, this.menuBar);
        fileMenu.setMnemonic('F');
        BalfMenuBar.MenuItem newMenuItem = new BalfMenuBar.MenuItem("New", this.menuBar);
        newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.MenuItem saveMenuItem = new BalfMenuBar.MenuItem("Save", this.menuBar);
        saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.MenuItem saveAsMenuItem = new BalfMenuBar.MenuItem("Save As", this.menuBar);
        BalfMenuBar.MenuItem openMenuItem = new BalfMenuBar.MenuItem("Open", this.menuBar);
        openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, HelperFunctions.isMac() ? 256 : 128));
        this.recentItemsMenu = new BalfMenuBar.Menu("Recent files", 1, this.menuBar);
        BalfMenuBar.MenuItem printMenuItem = new BalfMenuBar.MenuItem("Print", this.menuBar);
        printMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.MenuItem exitMenuItem = new BalfMenuBar.MenuItem("Exit", this.menuBar);
        BalfMenuBar.Menu editMenu = new BalfMenuBar.Menu("Edit", 0, this.menuBar);
        editMenu.setMnemonic('E');
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        KeyStroke undoKeystroke = KeyStroke.getKeyStroke(90, HelperFunctions.isMac() ? 256 : 128);
        KeyStroke redoKeystroke = KeyStroke.getKeyStroke(89, HelperFunctions.isMac() ? 256 : 128);
        this.contentEditor.getInputMap().put(undoKeystroke, "undoKeystroke");
        this.contentEditor.getActionMap().put("undoKeystroke", this.undoAction);
        this.contentEditor.getInputMap().put(redoKeystroke, "redoKeystroke");
        this.contentEditor.getActionMap().put("redoKeystroke", this.redoAction);
        BalfMenuBar.MenuItem undoMenuItem = new BalfMenuBar.MenuItem(this.undoAction, this.menuBar);
        BalfMenuBar.MenuItem redoMenuItem = new BalfMenuBar.MenuItem(this.redoAction, this.menuBar);
        BalfMenuBar.MenuItem cutMenuItem = new BalfMenuBar.MenuItem("Cut", this.menuBar);
        cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.MenuItem copyMenuItem = new BalfMenuBar.MenuItem("Copy", this.menuBar);
        copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.MenuItem pasteMenuItem = new BalfMenuBar.MenuItem("Paste", this.menuBar);
        pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.MenuItem deleteMenuItem = new BalfMenuBar.MenuItem("Delete", this.menuBar);
        BalfMenuBar.MenuItem selectAllMenuItem = new BalfMenuBar.MenuItem("Select All", this.menuBar);
        selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.MenuItem addBreakPointMenuItem = new BalfMenuBar.MenuItem("Add breakpoint", this.menuBar);
        addBreakPointMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, HelperFunctions.isMac() ? 256 : 128));
        this.commentLinesMenuItem = new BalfMenuBar.MenuItem("Comment selected lines", this.menuBar);
        this.commentLinesMenuItem.setAccelerator(KeyStroke.getKeyStroke(47, HelperFunctions.isMac() ? 256 : 128));
        this.unCommentLinesMenuItem = new BalfMenuBar.MenuItem("Uncomment selected lines", this.menuBar);
        this.unCommentLinesMenuItem.setAccelerator(KeyStroke.getKeyStroke(92, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.Menu viewMenu = new BalfMenuBar.Menu("View", 0, this.menuBar);
        viewMenu.setMnemonic('V');
        BalfMenuBar.Menu fontSizeMenu = new BalfMenuBar.Menu("Font size", 1, this.menuBar);
        this.fontSizeSmallMenuItem = new BalfMenuBar.CheckBoxMenuItem("Small", this.menuBar);
        this.fontSizeNormalMenuItem = new BalfMenuBar.CheckBoxMenuItem("Normal", this.menuBar);
        this.fontSizeNormalMenuItem.setSelected(true);
        this.fontSizeLargeMenuItem = new BalfMenuBar.CheckBoxMenuItem("Large", this.menuBar);
        this.fontSizeExtraLargeMenuItem = new BalfMenuBar.CheckBoxMenuItem("Extra Large", this.menuBar);
        this.fontFamilyMenu = new BalfMenuBar.Menu("Font family", 1, this.menuBar);
        BalfMenuBar.CheckBoxMenuItem defaultFont = new BalfMenuBar.CheckBoxMenuItem("Default font", this.menuBar);
        BalfMenuBar.CheckBoxMenuItem makeTextBoldMenuItem = new BalfMenuBar.CheckBoxMenuItem("Make text bold", this.menuBar);
        this.darkModeMenuItem = new BalfMenuBar.CheckBoxMenuItem("Dark Mode", this.menuBar);
        BalfMenuBar.Menu dock = new BalfMenuBar.Menu("Dock", 1, this.menuBar);
        BalfMenuBar.MenuItem dockToTheTop = new BalfMenuBar.MenuItem("Dock to the Top", this.menuBar);
        dockToTheTop.setAccelerator(KeyStroke.getKeyStroke(38, modifierKey));
        BalfMenuBar.MenuItem dockToTheLeft = new BalfMenuBar.MenuItem("Dock to the Left", this.menuBar);
        dockToTheLeft.setAccelerator(KeyStroke.getKeyStroke(37, modifierKey));
        BalfMenuBar.MenuItem dockToTheRight = new BalfMenuBar.MenuItem("Dock to the Right", this.menuBar);
        dockToTheRight.setAccelerator(KeyStroke.getKeyStroke(39, modifierKey));
        BalfMenuBar.MenuItem filterMenu = new BalfMenuBar.MenuItem("Filter", this.menuBar);
        BalfMenuBar.MenuItem dockToTheBottom = new BalfMenuBar.MenuItem("Dock to the Bottom", this.menuBar);
        dockToTheBottom.setAccelerator(KeyStroke.getKeyStroke(40, modifierKey));
        if (HelperFunctions.isMac()) {
            this.useMacMenuBarMenuItem = new BalfMenuBar.CheckBoxMenuItem("Use Mac Menubar", this.menuBar);
            if (useMacMenuBar) {
                this.useMacMenuBarMenuItem.setSelected(true);
            }
        }
        BalfMenuBar.MenuItem fullScreenMenuItem = new BalfMenuBar.MenuItem("Full screen", this.menuBar);
        BalfMenuBar.Menu toolsMenu = new BalfMenuBar.Menu("Tools", 0, this.menuBar);
        toolsMenu.setMnemonic('T');
        BalfMenuBar.MenuItem setDefaultFileMenuItem = new BalfMenuBar.MenuItem("Set default file", this.menuBar);
        BalfMenuBar.MenuItem setRuntimeArgumentsMenuItem = new BalfMenuBar.MenuItem("Set runtime arguments", this.menuBar);
        BalfMenuBar.MenuItem openMacroEditorMenuItem = new BalfMenuBar.MenuItem("Open ZPE Macro Interface Editor", this.menuBar);
        BalfMenuBar.MenuItem buildWithAIAssistantMenuItem = null;
        if (ZPEInstance.getChatGPTKey() != null && ZPEInstance.getChatGPTURL() != null && ZPEInstance.getChatGPTModel() != null) {
            buildWithAIAssistantMenuItem = new BalfMenuBar.MenuItem("Build with AI Assistant", this.menuBar);
        }
        BalfMenuBar.MenuItem startZENServerMenuItem = new BalfMenuBar.MenuItem("Start ZEN Server", this.menuBar);
        BalfMenuBar.Menu currentMenu = null;
        String lastCategory = "";
        BalfMenuBar.Menu functionsMenu = new BalfMenuBar.Menu("Functions", 0, this.menuBar);
        functionsMenu.setMnemonic('F');
        HashMap<String, CallSite> allFuncNames = new HashMap<String, CallSite>();
        for (String s3 : ZPEKit.getAllCommands()) {
            if (!lastCategory.equals(ZPEKit.getFunctionCategory(s3))) {
                if (currentMenu != null) {
                    functionsMenu.add(currentMenu);
                }
                lastCategory = ZPEKit.getFunctionCategory(s3);
                currentMenu = new BalfMenuBar.Menu(1, this.menuBar);
                currentMenu.setText(lastCategory);
            }
            allFuncNames.put(s3, (CallSite)((Object)(ZPEKit.getFunctionCategory(s3).toLowerCase().replace(" ", "_").replace("/", "") + "/" + s3)));
            BalfMenuBar.MenuItem commandMenuItem = new BalfMenuBar.MenuItem(this.menuBar);
            commandMenuItem.setText(s3);
            String replacement = ZPEKit.getFunctionManualHeader(s3);
            String group = lastCategory;
            helpName = s3;
            commandMenuItem.addActionListener(arg_0 -> this.lambda$new$5((String)helpName, group, replacement, arg_0));
            assert (currentMenu != null);
            currentMenu.add(commandMenuItem);
        }
        BalfMenuBar.Menu scriptMenu = new BalfMenuBar.Menu("Script", 0, this.menuBar);
        scriptMenu.setMnemonic('S');
        this.caseSensitiveCompileMenuItem = new BalfMenuBar.CheckBoxMenuItem("Case sensitive compile", this.menuBar);
        this.caseSensitiveCompileMenuItem.setSelected(true);
        this.useLocalConsoleMenuItem = new BalfMenuBar.CheckBoxMenuItem("Use local console", this.menuBar);
        this.useLocalConsoleMenuItem.setSelected(false);
        BalfMenuBar.MenuItem runCodeMenuItem = new BalfMenuBar.MenuItem("Run code", this.menuBar);
        runCodeMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        BalfMenuBar.MenuItem runCodeWithDebuggingMenuItem = new BalfMenuBar.MenuItem("Debug code", this.menuBar);
        runCodeWithDebuggingMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, HelperFunctions.isMac() ? 256 : 128));
        this.stopCodeMenuItem = new BalfMenuBar.MenuItem("Stop code execution", this.menuBar);
        this.stopCodeMenuItem.setEnabled(false);
        this.stopCodeMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        BalfMenuBar.MenuItem compileCodeMenuItem = new BalfMenuBar.MenuItem("Compile code", this.menuBar);
        BalfMenuBar.Menu transpileCodeMenuItem = new BalfMenuBar.Menu("Transpile code", 1, this.menuBar);
        if (ZPEKit.listTranspilerNames().isEmpty()) {
            transpileCodeMenuItem.setVisible(false);
        } else {
            helpName = ZPEKit.listTranspilerNames().iterator();
            while (helpName.hasNext()) {
                String transpiler;
                String lang = transpiler = (String)helpName.next();
                String transpilerName = ZPEKit.getTranspilerByName(transpiler).transpilerName();
                BalfMenuBar.MenuItem mntmTranspileCodeToMenuItem = new BalfMenuBar.MenuItem("To " + lang + " (" + transpilerName + ")", this.menuBar);
                transpileCodeMenuItem.add(mntmTranspileCodeToMenuItem);
            }
        }
        BalfMenuBar.MenuItem analyseCodeMenuItem = new BalfMenuBar.MenuItem("Analyse code", this.menuBar);
        BalfMenuBar.MenuItem toByteCodeFileMenuItem = new BalfMenuBar.MenuItem("Compile to byte codes", this.menuBar);
        BalfMenuBar.MenuItem createOutlineMenuItem = new BalfMenuBar.MenuItem("Create code outline", this.menuBar);
        BalfMenuBar.MenuItem unfoldCodeMenuItem = new BalfMenuBar.MenuItem("Unfold code", this.menuBar);
        BalfMenuBar.Menu zpeOnlineMenu = new BalfMenuBar.Menu("ZPE Online", 0, this.menuBar);
        zpeOnlineMenu.setMnemonic('O');
        this.mainLoginMenuItem = this.loginToZPEOnlineMenuItem = new BalfMenuBar.MenuItem("Login to ZPE Online", this.menuBar);
        BalfMenuBar.MenuItem registerForZPEOnlineMenuItem = new BalfMenuBar.MenuItem("Register for ZPE Online", this.menuBar);
        BalfMenuBar.MenuItem mntmVisitZPEOnlineWebsiteMenuItem = new BalfMenuBar.MenuItem("Visit ZPE Online website", this.menuBar);
        BalfMenuBar.MenuItem viewPublicUploadsMenuItem = new BalfMenuBar.MenuItem("View public uploads", this.menuBar);
        BalfMenuBar.MenuItem loadFromPublicZPEOnlineMenuItem = new BalfMenuBar.MenuItem("Load from public ZPE Online repository", this.menuBar);
        this.zpeOnlineSeparator = new BalfMenuBar.Separator(this.menuBar);
        this.zpeOnlineSeparator.setVisible(false);
        this.recentOnlineFilesMenu = new BalfMenuBar.Menu("Recent online files", 1, this.menuBar);
        this.recentOnlineFilesMenu.setVisible(false);
        this.loadFromZPEOnlineMenuItem = new BalfMenuBar.MenuItem("Load from ZPE Online", this.menuBar);
        this.loadFromZPEOnlineMenuItem.setVisible(false);
        this.saveToZPEOnlineMenuItem = new BalfMenuBar.MenuItem("Save to ZPE Online", this.menuBar);
        this.saveToZPEOnlineMenuItem.setVisible(false);
        BalfMenuBar.Menu mnHelpMenu = new BalfMenuBar.Menu("Help", 0, this.menuBar);
        mnHelpMenu.setMnemonic('H');
        BalfMenuBar.MenuItem mntmAboutMenuItem = null;
        if (!HelperFunctions.isMac() || !useMacMenuBar) {
            mntmAboutMenuItem = new BalfMenuBar.MenuItem("About ZPE", this.menuBar);
        }
        BalfMenuBar.MenuItem mntmLearnZPEYASSMenuItem = new BalfMenuBar.MenuItem("Learn ZPE/YASS", this.menuBar);
        BalfMenuBar.MenuItem mntmOpenZPEFolderMenuItem = new BalfMenuBar.MenuItem("Open ZPE folder", this.menuBar);
        BalfMenuBar.MenuItem mntmGoToZPETracker = new BalfMenuBar.MenuItem("Go to ZPE Tracker", this.menuBar);
        BalfMenuBar.MenuItem mntmJamieBalfourItem = new BalfMenuBar.MenuItem("Contact Jamie Balfour", this.menuBar);
        BalfMenuBar.MenuItem mntmProvideFeedbackItem = new BalfMenuBar.MenuItem("Provide Feedback", this.menuBar);
        BalfMenuBar.MenuItem mntmChangelogMenuItem = new BalfMenuBar.MenuItem("Read changelog", this.menuBar);
        BalfMenuBar.MenuItem mntmVisitOfficialDocumentationMenuItem = new BalfMenuBar.MenuItem("Visit the official documentation", this.menuBar);
        mainEditor.getDocument().addUndoableEditListener(this.undoHandler);
        this.menuBar.add(fileMenu);
        fileMenu.add(newMenuItem);
        fileMenu.add(saveMenuItem);
        fileMenu.add(saveAsMenuItem);
        fileMenu.add(new BalfMenuBar.Separator(this.menuBar));
        fileMenu.add(openMenuItem);
        this.updateRecentFiles();
        if (!this.recents.isEmpty()) {
            fileMenu.add(this.recentItemsMenu);
        }
        fileMenu.add(new BalfMenuBar.Separator(this.menuBar));
        fileMenu.add(printMenuItem);
        fileMenu.add(new BalfMenuBar.Separator(this.menuBar));
        fileMenu.add(exitMenuItem);
        this.menuBar.add(editMenu);
        editMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                if (ZPEEditorMain.this.contentEditor.getSelectedText() != null && !ZPEEditorMain.this.contentEditor.getSelectedText().isEmpty()) {
                    ZPEEditorMain.this.commentLinesMenuItem.setEnabled(true);
                    ZPEEditorMain.this.unCommentLinesMenuItem.setEnabled(ZPEEditorMain.this.contentEditor.getSelectedText().startsWith("//"));
                } else {
                    ZPEEditorMain.this.commentLinesMenuItem.setEnabled(false);
                    ZPEEditorMain.this.unCommentLinesMenuItem.setEnabled(false);
                }
            }
        });
        editMenu.add(undoMenuItem);
        editMenu.add(redoMenuItem);
        editMenu.add(new BalfMenuBar.Separator(this.menuBar));
        editMenu.add(cutMenuItem);
        editMenu.add(copyMenuItem);
        editMenu.add(pasteMenuItem);
        editMenu.add(deleteMenuItem);
        editMenu.add(new BalfMenuBar.Separator(this.menuBar));
        editMenu.add(selectAllMenuItem);
        editMenu.add(new BalfMenuBar.Separator(this.menuBar));
        editMenu.add(addBreakPointMenuItem);
        editMenu.add(this.commentLinesMenuItem);
        editMenu.add(this.unCommentLinesMenuItem);
        this.menuBar.add(viewMenu);
        viewMenu.add(fontSizeMenu);
        fontSizeMenu.add(this.fontSizeSmallMenuItem);
        fontSizeMenu.add(this.fontSizeNormalMenuItem);
        fontSizeMenu.add(this.fontSizeLargeMenuItem);
        fontSizeMenu.add(this.fontSizeExtraLargeMenuItem);
        viewMenu.add(this.fontFamilyMenu);
        this.fontFamilyMenu.add(defaultFont);
        this.fontFamilyMenu.add(new BalfMenuBar.Separator(this.menuBar));
        for (String string : supportedFontsList) {
            this.createFontDropdown(string);
        }
        viewMenu.add(makeTextBoldMenuItem);
        viewMenu.add(new BalfMenuBar.Separator(this.menuBar));
        viewMenu.add(this.darkModeMenuItem);
        viewMenu.add(dock);
        dock.add(dockToTheTop);
        dock.add(dockToTheLeft);
        dock.add(dockToTheRight);
        dock.add(dockToTheBottom);
        if (HelperFunctions.isMac()) {
            viewMenu.add(this.useMacMenuBarMenuItem);
        }
        viewMenu.add(fullScreenMenuItem);
        this.menuBar.add(toolsMenu);
        toolsMenu.add(setDefaultFileMenuItem);
        toolsMenu.add(setRuntimeArgumentsMenuItem);
        toolsMenu.add(new BalfMenuBar.Separator(this.menuBar));
        toolsMenu.add(openMacroEditorMenuItem);
        if (buildWithAIAssistantMenuItem != null) {
            toolsMenu.add(buildWithAIAssistantMenuItem);
        }
        toolsMenu.add(new BalfMenuBar.Separator(this.menuBar));
        toolsMenu.add(startZENServerMenuItem);
        this.menuBar.add(functionsMenu);
        this.menuBar.add(scriptMenu);
        scriptMenu.add(this.caseSensitiveCompileMenuItem);
        scriptMenu.add(this.useLocalConsoleMenuItem);
        scriptMenu.add(new BalfMenuBar.Separator(this.menuBar));
        scriptMenu.add(runCodeMenuItem);
        scriptMenu.add(runCodeWithDebuggingMenuItem);
        scriptMenu.add(this.stopCodeMenuItem);
        scriptMenu.add(new BalfMenuBar.Separator(this.menuBar));
        scriptMenu.add(compileCodeMenuItem);
        scriptMenu.add(transpileCodeMenuItem);
        scriptMenu.add(new BalfMenuBar.Separator(this.menuBar));
        scriptMenu.add(analyseCodeMenuItem);
        scriptMenu.add(toByteCodeFileMenuItem);
        scriptMenu.add(createOutlineMenuItem);
        scriptMenu.add(new BalfMenuBar.Separator(this.menuBar));
        scriptMenu.add(unfoldCodeMenuItem);
        this.menuBar.add(zpeOnlineMenu);
        zpeOnlineMenu.add(this.loginToZPEOnlineMenuItem);
        zpeOnlineMenu.add(registerForZPEOnlineMenuItem);
        zpeOnlineMenu.add(new BalfMenuBar.Separator(this.menuBar));
        zpeOnlineMenu.add(mntmVisitZPEOnlineWebsiteMenuItem);
        zpeOnlineMenu.add(viewPublicUploadsMenuItem);
        zpeOnlineMenu.add(new BalfMenuBar.Separator(this.menuBar));
        zpeOnlineMenu.add(loadFromPublicZPEOnlineMenuItem);
        zpeOnlineMenu.add(this.zpeOnlineSeparator);
        zpeOnlineMenu.add(this.recentOnlineFilesMenu);
        zpeOnlineMenu.add(this.loadFromZPEOnlineMenuItem);
        zpeOnlineMenu.add(this.saveToZPEOnlineMenuItem);
        this.menuBar.add(mnHelpMenu);
        if (mntmAboutMenuItem != null) {
            mnHelpMenu.add(mntmAboutMenuItem);
            mnHelpMenu.add(new BalfMenuBar.Separator(this.menuBar));
        }
        mnHelpMenu.add(mntmLearnZPEYASSMenuItem);
        mnHelpMenu.add(new BalfMenuBar.Separator(this.menuBar));
        mnHelpMenu.add(mntmOpenZPEFolderMenuItem);
        mnHelpMenu.add(new BalfMenuBar.Separator(this.menuBar));
        mnHelpMenu.add(mntmGoToZPETracker);
        mnHelpMenu.add(mntmJamieBalfourItem);
        mnHelpMenu.add(mntmProvideFeedbackItem);
        mnHelpMenu.add(new BalfMenuBar.Separator(this.menuBar));
        mnHelpMenu.add(mntmChangelogMenuItem);
        mnHelpMenu.add(mntmVisitOfficialDocumentationMenuItem);
        newMenuItem.addActionListener(e -> {
            this.menuBar.setColours(Color.GREEN, Color.YELLOW, Color.BLACK);
            this.setTitleBarText("Untitled");
            this.clearUndoRedoManagers();
            this.setTextProperly("");
            this.lastCloudFileOpened = "";
        });
        saveMenuItem.addActionListener(e -> {
            if (this.lastFileOpened.isEmpty()) {
                this.saveAsDialog();
            } else {
                try {
                    HelperFunctions.writeFile(this.lastFileOpened, this.contentEditor.getText(), false);
                }
                catch (IOException ex) {
                    ZPE.log(ex.getMessage());
                }
            }
        });
        saveAsMenuItem.addActionListener(e -> this.saveAsDialog());
        openMenuItem.addActionListener(e -> this.open());
        printMenuItem.addActionListener(e -> {
            try {
                this.contentEditor.print();
            }
            catch (PrinterException e1) {
                JOptionPane.showMessageDialog(this.editor, "An error was encountered whilst trying to print.", "Error", 0);
            }
        });
        exitMenuItem.addActionListener(e -> {
            this.closeUp();
            System.exit(0);
        });
        cutMenuItem.addActionListener(e -> this.contentEditor.cut());
        copyMenuItem.addActionListener(e -> this.contentEditor.copy());
        pasteMenuItem.addActionListener(e -> this.contentEditor.paste());
        deleteMenuItem.addActionListener(e -> {
            int start = this.contentEditor.getSelectionStart();
            int end = this.contentEditor.getSelectionEnd();
            String current = this.contentEditor.getText();
            String newText = current.substring(0, start) + current.substring(end);
            this.contentEditor.setText(newText);
        });
        selectAllMenuItem.addActionListener(e -> this.contentEditor.selectAll());
        addBreakPointMenuItem.addActionListener(e -> {});
        this.commentLinesMenuItem.addActionListener(e -> {
            int start;
            int end = this.contentEditor.getSelectionEnd();
            String content = this.contentEditor.getText();
            StringBuilder out = new StringBuilder();
            for (start = this.contentEditor.getSelectionStart(); start > 0 && content.charAt(start) != '\n'; --start) {
            }
            if (start == 0) {
                out.append("//");
            }
            for (int i = start; i < end; ++i) {
                out.append(content.charAt(i));
                if (content.charAt(i) != '\n') continue;
                out.append("//");
            }
            this.setTextProperly(content.substring(0, start) + out + content.substring(end));
        });
        this.unCommentLinesMenuItem.addActionListener(e -> {
            int start;
            int end = this.contentEditor.getSelectionEnd();
            String content = this.contentEditor.getText();
            String code = content.substring(start, end);
            for (start = this.contentEditor.getSelectionStart(); start > 0 && content.charAt(start) != '\n'; --start) {
            }
            StringBuilder out = new StringBuilder();
            Scanner s = new Scanner(code);
            while (s.hasNextLine()) {
                String line = s.nextLine();
                while (line.startsWith("//")) {
                    line = line.substring(2);
                }
                out.append(line);
                if (!s.hasNextLine()) continue;
                out.append(System.lineSeparator());
            }
            s.close();
            this.setTextProperly(content.substring(0, start) + System.lineSeparator() + out + content.substring(end));
        });
        this.fontSizeSmallMenuItem.addActionListener(e -> {
            this.changeFontSize(-1);
            this.setProperty("FONT_SIZE", "-1");
            this.saveGUISettings(this.mainProperties);
        });
        this.fontSizeNormalMenuItem.addActionListener(e -> {
            this.changeFontSize(0);
            this.setProperty("FONT_SIZE", "0");
            this.saveGUISettings(this.mainProperties);
        });
        this.fontSizeLargeMenuItem.addActionListener(e -> {
            this.changeFontSize(1);
            this.setProperty("FONT_SIZE", "1");
            this.saveGUISettings(this.mainProperties);
        });
        this.fontSizeExtraLargeMenuItem.addActionListener(e -> {
            this.changeFontSize(2);
            this.setProperty("FONT_SIZE", "2");
            this.saveGUISettings(this.mainProperties);
        });
        defaultFont.addActionListener(e -> {
            this.changeFontFamily(this.defaultFontFamily);
            this.setProperty("FONT_FAMILY", this.defaultFontFamily);
            this.saveGUISettings(this.mainProperties);
        });
        makeTextBoldMenuItem.addActionListener(e -> {
            this.mainSyntax.makeBold(makeTextBoldMenuItem.isSelected());
            this.setProperty("USE_BOLD_TEXT", Boolean.toString(makeTextBoldMenuItem.isSelected()));
            this.resetScroll();
            this.saveGUISettings(this.mainProperties);
            this.updateEditor();
        });
        this.darkModeMenuItem.addActionListener(e -> {
            if (!this.darkMode) {
                this.switchOnDarkMode();
            } else {
                this.switchOffDarkMode();
            }
            this.setProperty("DARK_MODE", Boolean.toString(this.darkMode));
            this.saveGUISettings(this.mainProperties);
            this.updateEditor();
        });
        dockToTheTop.addActionListener(e -> this._frame.dockTop());
        dockToTheLeft.addActionListener(e -> this._frame.dockLeft());
        dockToTheRight.addActionListener(e -> this._frame.dockRight());
        dockToTheBottom.addActionListener(e -> this._frame.dockBottom());
        if (HelperFunctions.isMac()) {
            boolean macMenuBarEnabled = useMacMenuBar;
            this.useMacMenuBarMenuItem.addActionListener(e -> {
                this.setProperty("USE_MAC_SIMPLEBAR", Boolean.toString(macMenuBarEnabled));
                this.useMacMenuBarMenuItem.setEnabled(false);
                this.saveGUISettings(this.mainProperties);
                JOptionPane.showMessageDialog(this.editor, "This will happen on the next start.", "macOS Menubar", 2);
            });
        }
        fullScreenMenuItem.addActionListener(e -> {
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            if (gd.isFullScreenSupported()) {
                try {
                    this._this.setUndecorated(false);
                    gd.setFullScreenWindow(this._this);
                }
                catch (Exception ignored) {
                    System.err.println("Full screen not supported");
                }
            } else {
                System.err.println("Full screen not supported");
            }
        });
        setDefaultFileMenuItem.addActionListener(e -> {
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(filter1);
            fc.addChoosableFileFilter(filter2);
            int returnVal = fc.showOpenDialog(this.editor.getContentPane());
            if (returnVal == 0) {
                File selectedFile = fc.getSelectedFile();
                if (selectedFile.exists()) {
                    this.setProperty("DEFAULT_FILE", selectedFile.getAbsolutePath());
                    this.saveGUISettings(this.mainProperties);
                } else {
                    JOptionPane.showMessageDialog(this.editor, "The file could not be opened.", "Error", 0);
                }
            }
        });
        setRuntimeArgumentsMenuItem.addActionListener(e -> {
            StringBuilder joined = new StringBuilder();
            for (ZPEString s : this.runtimeArgs) {
                joined.append(" ").append(((Object)s).toString());
            }
            String args2 = JOptionPane.showInputDialog(this.editor, "Please insert your runtime arguments, separated by spaces.", joined.toString());
            if (args2 != null) {
                String[] splitArgs = args2.trim().split(" ");
                ZPEString[] new_args = new ZPEString[splitArgs.length];
                for (int i = 0; i < splitArgs.length; ++i) {
                    new_args[i] = new ZPEString(splitArgs[i]);
                }
                this.runtimeArgs = new_args;
            }
        });
        openMacroEditorMenuItem.addActionListener(e -> {
            ZPERuntimeEnvironment z = new ZPERuntimeEnvironment();
            ZPEMacroInterface i = new ZPEMacroInterface(z, new ZPEObject[]{new EditorObject(z, (ZPEPropertyWrapper)ZPEKit.getGlobalFunction(z), mainEditor)});
            i.setVisible(true);
            i.setLocationRelativeTo(this._this);
            this.currentWindows.add(i);
        });
        if (buildWithAIAssistantMenuItem != null) {
            buildWithAIAssistantMenuItem.addActionListener(e -> {
                AIAssistant ai = new AIAssistant(this.contentEditor);
                ai.setVisible(true);
                ai.setLocationRelativeTo(this._this);
                this.currentWindows.add(ai);
            });
        }
        startZENServerMenuItem.addActionListener(e -> {
            ZPEEditorZENServerUI z = new ZPEEditorZENServerUI(this.editor);
            Map<String, String> output = z.display();
            int port = HelperFunctions.stringToInteger(output.get("port"));
            int permission = HelperFunctions.stringToInteger(output.get("permission"));
            String password = output.get("password");
            Object additional = "";
            try {
                additional = " on " + InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(this.editor, "Opening ZENServer on port " + port + (String)additional, "ZENServer", 1);
            this._this.setVisible(false);
            SwingUtilities.invokeLater(() -> {
                class BackgroundServer
                implements Runnable {
                    int port;
                    int permission;
                    String password;
                    Thread thread;

                    BackgroundServer() {
                    }

                    @Override
                    public void run() {
                        this.thread = new Thread((Runnable)this, "ZENServer");
                        this.thread.setDaemon(true);
                        this.thread.start();
                    }

                    public void start() {
                        ZENServer s = new ZENServer();
                        s.Start(this.port, this.permission, this.password, null);
                    }
                }
                BackgroundServer s = new BackgroundServer();
                s.port = port;
                s.permission = permission;
                s.password = password;
                s.start();
            });
        });
        runCodeMenuItem.addActionListener(e -> {
            try {
                this.executeCode();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Unable to compile or run code.", "Error", 0);
            }
        });
        runCodeWithDebuggingMenuItem.addActionListener(e -> {
            try {
                this.debugCode();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Unable to compile or run code.", "Error", 0);
            }
        });
        this.stopCodeMenuItem.addActionListener(e -> {
            this.currentProcess.destroy();
            this.currentProcess = null;
            this.stopCodeMenuItem.setEnabled(false);
        });
        compileCodeMenuItem.addActionListener(e -> {
            String name1 = JOptionPane.showInputDialog(this.editor, (Object)"Please insert the name of the compiled application.");
            String extension = "";
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(filter3);
            fc.setAcceptAllFileFilterUsed(false);
            int returnVal = fc.showSaveDialog(this.editor.getContentPane());
            if (returnVal != 0) {
                return;
            }
            File file12 = fc.getSelectedFile();
            if (!file12.getAbsolutePath().endsWith(ZPEEditorMain.getSaveExtension(fc.getFileFilter()))) {
                extension = ZPEEditorMain.getSaveExtension(fc.getFileFilter());
            }
            try {
                ZPEKit.compile(this.contentEditor.getText(), file12 + "." + extension, name1, "", !this.caseSensitiveCompileMenuItem.isSelected(), false, null, null);
                JOptionPane.showMessageDialog(this.editor, "YASS compile success. The file has been successfully compiled to " + file12 + ".", "YASS compiler", 2);
            }
            catch (CompileException ex) {
                JOptionPane.showMessageDialog(this.editor, "YASS compile failure. " + ex.getMessage() + ".", "YASS compiler", 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.editor, "YASS compile failure. The error was -1.", "YASS compiler", 0);
            }
        });
        Iterator<String> macMenuBarEnabled = ZPEKit.listTranspilerNames().iterator();
        while (macMenuBarEnabled.hasNext()) {
            String string;
            String lang = string = macMenuBarEnabled.next();
            for (Component c : transpileCodeMenuItem.getMenuComponents()) {
                if (!(c instanceof BalfMenuBar.MenuItem) || !((BalfMenuBar.MenuItem)c).getText().contains("To " + lang)) continue;
                ((BalfMenuBar.MenuItem)c).addActionListener(e -> {
                    JFileChooser fc = new JFileChooser();
                    fc.addChoosableFileFilter(new FileNameExtensionFilter(lang + " files (*." + ZPEKit.getTranspilerByName(lang).getFileExtension() + ")", "txt"));
                    fc.setAcceptAllFileFilterUsed(false);
                    int returnVal = fc.showSaveDialog(this.editor.getContentPane());
                    if (returnVal != 0) {
                        return;
                    }
                    try {
                        Object fpath = fc.getSelectedFile().getPath();
                        if (!((String)fpath).endsWith("." + ZPEKit.getTranspilerByName(lang).getFileExtension())) {
                            fpath = (String)fpath + "." + ZPEKit.getTranspilerByName(lang).getFileExtension();
                        }
                        HelperFunctions.writeFile((String)fpath, ZPEKit.convertCode(this.contentEditor.getText(), "", ZPEKit.getTranspilerByName(string)), false);
                        JOptionPane.showMessageDialog(this.editor, "Code transpiled to " + lang + " successfully.\nSaved at: " + (String)fpath, "Successful transpile", 1);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(this.editor, "Transpilation failed: " + ex.getMessage(), "Error", 0);
                    }
                });
            }
        }
        analyseCodeMenuItem.addActionListener(e -> {
            try {
                boolean valid = ZPEKit.validateCode(this.contentEditor.getText());
                JOptionPane.showMessageDialog(this.editor, valid ? "Code is valid" : "Code is invalid", "Code analysis", 1, this.lighterLogo);
            }
            catch (CompileException ex) {
                JOptionPane.showMessageDialog(this.editor, "Code is invalid", "Code analysis", 1, this.lighterLogo);
            }
        });
        toByteCodeFileMenuItem.addActionListener(e -> {
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(filter2);
            fc.setAcceptAllFileFilterUsed(false);
            int returnVal = fc.showSaveDialog(this.editor.getContentPane());
            if (returnVal != 0) {
                return;
            }
            File file1 = fc.getSelectedFile();
            String extension = ZPEEditorMain.getSaveExtension(fc.getFileFilter());
            try {
                StringBuilder text = new StringBuilder();
                for (byte s : ZPEKit.parseToBytes(this.contentEditor.getText())) {
                    text.append(s).append(" ");
                }
                HelperFunctions.writeFile(file1.getAbsolutePath() + "." + extension, text.toString(), false);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.editor, "The file could not be saved.", "Error", 0);
            }
        });
        createOutlineMenuItem.addActionListener(e -> {
            try {
                StringBuilder output = new StringBuilder();
                for (String s : ZPEKit.getFunctionNames(this.contentEditor.getText())) {
                    output.append(s).append(System.lineSeparator());
                }
                JOptionPane.showMessageDialog(this.editor, "Functions of this program:\n\n" + output, "Create code outline", 1, this.lighterLogo);
            }
            catch (CompileException ex) {
                JOptionPane.showMessageDialog(this.editor, "Code is invalid and an outline cannot be made", "Create code outline", 0, this.lighterLogo);
            }
        });
        unfoldCodeMenuItem.addActionListener(e -> {
            try {
                String result = ZPEKit.unfold(this.contentEditor.getText(), false);
                JOptionPane op = new JOptionPane(new YASSUnfoldDialog(result).getContentPane(), -1, -1, this.lighterLogo, new String[0]);
                JDialog dlg = op.createDialog(this._this, "YASS Unfold code explainer");
                dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                dlg.setVisible(true);
            }
            catch (CompileException ex) {
                JOptionPane.showMessageDialog(this.editor, "There was an error when using YASS Unfold.", "YASS Unfold", 1, this.lighterLogo);
            }
        });
        this.loginToZPEOnlineMenuItem.addActionListener(e -> {
            if (this.loginToZPEOnlineMenuItem.getText().equals("Login to ZPE Online")) {
                this.login();
            } else {
                this.login_username = "";
                this.login_password = "";
                this.zpeOnlineSeparator.setVisible(false);
                this.recentOnlineFilesMenu.setVisible(false);
                this.recentOnlineFilesMenu.removeAll();
                this.loadFromZPEOnlineMenuItem.setVisible(false);
                this.saveToZPEOnlineMenuItem.setVisible(false);
                this.loginToZPEOnlineMenuItem.setText("Login to ZPE Online");
                JOptionPane.showMessageDialog(this.editor.getContentPane(), "You have been logged out successfully.", "Logout successful", 1);
            }
        });
        registerForZPEOnlineMenuItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/online/register/");
            }
            catch (IOException | URISyntaxException ex) {
                JOptionPane.showMessageDialog(this.editor, "Could not connect to ZPE Online", "Failure", 0);
            }
        });
        mntmVisitZPEOnlineWebsiteMenuItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/online/");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.editor, "Could not open ZPE Online", "Failure", 0);
            }
        });
        viewPublicUploadsMenuItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/online/code/");
            }
            catch (IOException | URISyntaxException ex) {
                JOptionPane.showMessageDialog(this.editor, "Could not connect to ZPE Online", "Failure", 0);
            }
        });
        loadFromPublicZPEOnlineMenuItem.addActionListener(e -> this.loadFromPublicCloud());
        this.loadFromZPEOnlineMenuItem.addActionListener(e -> this.loadFromUsersCloud());
        this.saveToZPEOnlineMenuItem.addActionListener(e -> this.saveToTheCloud());
        if (mntmAboutMenuItem != null) {
            mntmAboutMenuItem.addActionListener(e -> this.showAbout());
        }
        mntmLearnZPEYASSMenuItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/courses/software/yass/");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.editor, "Could not open jamiebalfour.scot", "Failure", 0);
            }
        });
        mntmOpenZPEFolderMenuItem.addActionListener(e -> {
            try {
                Desktop.getDesktop().open(new File(ZPEKit.getInstallPath()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        mntmGoToZPETracker.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/tracker/");
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        mntmJamieBalfourItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/contact/");
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        mntmProvideFeedbackItem.addActionListener(e -> {
            String message = JOptionPane.showInputDialog(this.editor, (Object)"Please insert your feedback below.");
            try {
                if (ZPEHelperFunctions.sendFeedback(message, null)) {
                    JOptionPane.showMessageDialog(this.editor, "Feedback sent successfully.", "Success", 1);
                } else {
                    JOptionPane.showMessageDialog(this.editor, "Feedback could not be sent at this time.", "Error", 0);
                }
            }
            catch (ZPERuntimeException ex) {
                JOptionPane.showMessageDialog(this.editor, "Feedback could not be sent at this time.", "Error", 0);
            }
        });
        mntmChangelogMenuItem.addActionListener(e -> {
            JOptionPane op = new JOptionPane(new ZPEChangelogDialog().getContentPane(), -1, -1, this.lighterLogo, new String[0]);
            JDialog dlg = op.createDialog(this._this, "ZPE changelog");
            dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            dlg.setVisible(true);
        });
        mntmVisitOfficialDocumentationMenuItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/documentation/");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.editor, "Could not open jamiebalfour.scot", "Failure", 0);
            }
        });
        BalfSearchBox searchBox = this.menuBar.addSearchBox();
        searchBox.setSearchText("Search for a function...");
        for (String s5 : allFuncNames.keySet()) {
            BalfSearchBox.SearchSuggestion suggestion = new BalfSearchBox.SearchSuggestion(s5 + " " + ZPEKit.getFunctionManualEntry(s5), s5);
            searchBox.addSuggestion(suggestion);
        }
        searchBox.addListener(s -> {
            try {
                searchBox.setText("");
                searchBox.setFocusable(false);
                searchBox.setFocusable(true);
                FunctionInformationWindow f1 = new FunctionInformationWindow((Frame)this._frame, s, ZPEKit.getFunctionManualHeader(s).replace("{", "<span style='font-weight:bold;color:#0af;'>").replace("}", "</span>"), ZPEKit.getFunctionManualEntry(s));
                f1.setVisible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        String string = "/files/editor_program.txt";
        if (this.mainProperties.containsKey("LOGIN_USERNAME") || this.mainProperties.containsKey("LOGIN_PASSCODE")) {
            this.login_username = this.mainProperties.getProperty("LOGIN_USERNAME");
            this.login_password = this.mainProperties.getProperty("LOGIN_PASSCODE");
        }
        if (this.mainProperties.containsKey("DEFAULT_FILE")) {
            try {
                this.contentEditor.setText(HelperFunctions.readFileAsString(this.mainProperties.getProperty("DEFAULT_FILE"), "utf-8"));
            }
            catch (IOException e1) {
                try {
                    this.contentEditor.setText(HelperFunctions.getResource(string));
                }
                catch (Exception exception) {}
            }
        } else {
            try {
                this.setTextProperly(HelperFunctions.getResource(string));
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        if (this.mainProperties.containsKey("USE_BOLD_TEXT") && this.mainProperties.get("USE_BOLD_TEXT").equals("true")) {
            this.mainSyntax.makeBold(true);
            makeTextBoldMenuItem.setSelected(true);
        }
        if (this.mainProperties.containsKey("DARK_MODE")) {
            if (this.mainProperties.get("DARK_MODE").equals("true")) {
                this.switchOnDarkMode();
            } else {
                this.switchOffDarkMode();
            }
        }
        this.readStandardProperties(this.mainProperties);
        if (this.mainProperties.containsKey("FONT_SIZE")) {
            this.changeFontSize(HelperFunctions.stringToInteger(this.mainProperties.get("FONT_SIZE").toString()));
        }
        if (this.mainProperties.containsKey("FONT_FAMILY")) {
            this.changeFontFamily(this.mainProperties.get("FONT_FAMILY").toString());
        }
        this._this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                for (JFrame j : ZPEEditorMain.this.currentWindows) {
                    if (!j.isVisible() || j.isAlwaysOnTop()) continue;
                    j.setAlwaysOnTop(true);
                }
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                for (JFrame j : ZPEEditorMain.this.currentWindows) {
                    if (j.isFocused()) continue;
                    j.setAlwaysOnTop(false);
                }
            }
        });
        if (HelperFunctions.isMac() && useMacMenuBar) {
            this.setJMenuBar(this.menuBar.toJMenuBar());
        } else {
            this.setMenu(this.menuBar);
        }
        this.setVisible(true);
        if (file != null) {
            try {
                File fil = new File(file);
                this.setTextProperly(HelperFunctions.readFileAsString(fil.getAbsolutePath()));
                this.editor.setTitle("ZPE Editor");
                this.setTitleBarText(fil.getName());
            }
            catch (IOException e2) {
                JOptionPane.showMessageDialog(this.editor, "The file could not be opened.", "Error", 0);
            }
        }
        this.autoCompleteDebounceTimer = new Timer();
        this.addKeyBindings();
    }

    static String getSaveExtension(FileFilter f) {
        if (f.equals(filter1)) {
            return "yas";
        }
        if (f.equals(filter2)) {
            return "txt";
        }
        if (f.equals(filter3)) {
            return "yex";
        }
        return null;
    }

    public static void StartEditor() throws IOException {
        new ZPEEditorMain("ZPE Editor", null);
    }

    public static void StartEditor(String file) throws IOException {
        new ZPEEditorMain("ZPE Editor", file);
    }

    private static int getVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    private static String getWordAtCaret(JEditorPane editorPane, int pos) throws BadLocationException {
        Document doc = editorPane.getDocument();
        int start = Utilities.getWordStart(editorPane, pos);
        int end = Utilities.getWordEnd(editorPane, pos);
        return doc.getText(start, end - start);
    }

    private void hideTooltip() {
        if (tooltipWindow != null) {
            tooltipWindow.setVisible(false);
            this.lastHoveredWord = "";
            this.lastPosition = new Point(0, 0);
        }
    }

    void createFontDropdown(String s) {
        BalfMenuBar.CheckBoxMenuItem i = new BalfMenuBar.CheckBoxMenuItem(s, this.menuBar);
        String thisFont = s;
        i.addActionListener(e -> {
            this.changeFontFamily(thisFont);
            this.setProperty("FONT_FAMILY", thisFont);
            this.saveGUISettings(this.mainProperties);
        });
        this.fontFamilyMenu.add(i);
    }

    private void showAbout() {
        Object msg = "";
        msg = (String)msg + "ZPE version 1.13.7." + ZPE.getBuildVersion() + " [Fossgate]\n";
        msg = (String)msg + "Built on: " + ZPE.getBuildDate() + " at " + ZPE.getBuildTime() + "\n";
        msg = (String)msg + "Copyright Jamie B Balfour 2011 - 2025";
        msg = (String)msg + "\n\nFor more information visit\nhttps://www.jamiebalfour.scot/projects/zpe/";
        BalfRoundedButton btnVisitWebsiteButton = new BalfRoundedButton("Visit website");
        btnVisitWebsiteButton.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.getContentPane(), "Could not open the ZPE website", "Failure", 0);
            }
        });
        JOptionPane op = new JOptionPane(new BalfAboutDialog("ZPE & YASS", (String)msg, btnVisitWebsiteButton).getContentPane(), -1, -1, this.lighterLogo, new String[0]);
        JDialog dlg = op.createDialog(this.editor, "About ZPE");
        dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dlg.setVisible(true);
    }

    private void addRecentsFromCloud(ZPEList recents) {
        if (!recents.isEmpty()) {
            this.zpeOnlineSeparator.setVisible(true);
            this.recentOnlineFilesMenu.setVisible(true);
            this.recentOnlineFilesMenu.removeAll();
            for (ZPEType s : recents) {
                BalfMenuBar.MenuItem recentItemMenuItem = new BalfMenuBar.MenuItem(this.menuBar);
                ZPEMap file = (ZPEMap)s;
                String filename = file.get(new ZPEString("name")).toString();
                recentItemMenuItem.setText(filename);
                this.recentOnlineFilesMenu.add(recentItemMenuItem);
                String id = file.get(new ZPEString("id")).toString();
                recentItemMenuItem.addActionListener(e -> {
                    this.lastCloudFileOpened = filename;
                    this.setTitleBarText(new File(filename).getName().split("\\.")[0]);
                    this.lastFileOpened = "";
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    arguments.put("username", this.login_username);
                    arguments.put("password", this.login_password);
                    arguments.put("id", id);
                    ZenithJSONParser p = new ZenithJSONParser();
                    try {
                        String s1 = HelperFunctions.makePOSTRequest(ZPEInstance.getOnlinePathProperty() + "/get.php?type=file&version=10", arguments);
                        ZPEMap results = (ZPEMap)p.jsonDecode(s1, false);
                        ZPEString name = (ZPEString)results.get(new ZPEString("name"));
                        this.setTitleBarText(name.toString());
                        this.setTitle("ZPE Editor");
                        String code = URLDecoder.decode(results.get(new ZPEString("string")).toString(), "UTF-8");
                        code = code.replace("\\n", System.lineSeparator());
                        this.clearUndoRedoManagers();
                        this.setTextProperly(code);
                    }
                    catch (Exception exc) {
                        ZPE.log(exc.getMessage());
                    }
                });
            }
        }
    }

    public boolean login() {
        boolean autoLogin = false;
        if (this.login_username.isEmpty() && this.login_password.isEmpty()) {
            ZPEOnlineLoginPanel z = new ZPEOnlineLoginPanel(this.editor);
            Map<String, String> output = z.display();
            this.login_username = output.get("username");
            this.login_password = output.get("password");
        } else {
            autoLogin = true;
        }
        try {
            ZPEMap login = this.goLogin();
            if (login != null) {
                if (login.get(new ZPEString("result")).toString().equals("1")) {
                    int res;
                    JOptionPane.showMessageDialog(this.editor.getContentPane(), "You have been logged in successfully.", "Login successful", 1);
                    if (!autoLogin && (res = JOptionPane.showConfirmDialog(this.editor.getContentPane(), "Do you want to save your login details?", "Save log in details?", 0, -1)) == 0) {
                        this.setProperty("LOGIN_USERNAME", this.login_username);
                        this.setProperty("LOGIN_PASSCODE", login.get(new ZPEString("login_token")).toString());
                        this.saveGUISettings(this.mainProperties);
                    }
                    this.loadFromZPEOnlineMenuItem.setVisible(true);
                    this.saveToZPEOnlineMenuItem.setVisible(true);
                    this.loginToZPEOnlineMenuItem.setText("Logout of ZPE Online");
                    this.addRecentsFromCloud((ZPEList)login.get(new ZPEString("list")));
                    return true;
                }
                this.loadFromZPEOnlineMenuItem.setVisible(true);
                this.saveToZPEOnlineMenuItem.setVisible(true);
                JOptionPane.showMessageDialog(this.editor.getContentPane(), "You could not be logged in.", "Login unsuccessful", 0);
                return false;
            }
            this.loadFromZPEOnlineMenuItem.setVisible(true);
            this.saveToZPEOnlineMenuItem.setVisible(true);
            JOptionPane.showMessageDialog(this.editor.getContentPane(), "You could not be logged in.", "Login unsuccessful", 0);
            return false;
        }
        catch (Exception ex1) {
            ZPE.log(ex1.getMessage());
            this.loadFromZPEOnlineMenuItem.setVisible(true);
            this.saveToZPEOnlineMenuItem.setVisible(true);
            JOptionPane.showMessageDialog(this.editor, "Cannot login.", "Error with ZPE Online", 0);
            return false;
        }
    }

    public void closeUp() {
        this.setProperty("HEIGHT", "" + this.editor.getHeight());
        this.setProperty("WIDTH", "" + this.editor.getWidth());
        this.setProperty("XPOS", "" + this.editor.getX());
        this.setProperty("YPOS", "" + this.editor.getY());
        if (this.isMaximised) {
            this.setProperty("MAXIMISED", "true");
        } else {
            this.setProperty("MAXIMISED", "false");
        }
        if (this.currentProcess != null) {
            this.currentProcess.destroy();
        }
        this.saveGUISettings(this.mainProperties);
    }

    public ZPEMap goLogin() throws Exception {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("username", this.login_username);
        arguments.put("password", this.login_password);
        String s = HelperFunctions.makePOSTRequest(ZPEInstance.getOnlinePathProperty() + "/get.php?type=login&version=10", arguments);
        ZPEType o = new ZenithJSONParser().jsonDecode(s, false);
        ZPEMap a = (ZPEMap)o;
        if (HelperFunctions.stringToInteger(a.get(new ZPEString("result")).toString()) != 1) {
            this.login_username = "";
            this.login_password = "";
        } else {
            this.mainLoginMenuItem.setText("Logout");
        }
        return a;
    }

    @Override
    public void saveGUISettings(Properties props) {
        if (this.propertiesChanged) {
            String path = ZPEInstance.getInstallPath() + "gui.properties";
            try {
                FileOutputStream output = new FileOutputStream(path);
                props.store(output, "This is a list of properties for the ZPE GUI editor and can be modified manually.");
            }
            catch (Exception e) {
                ZPE.log("Error saving GUI settings. " + e.getMessage());
            }
        }
    }

    @Override
    public void setProperty(String name, String value) {
        this.mainProperties.setProperty(name, value);
        this.propertiesChanged = true;
    }

    private void open() {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(filter1);
        fc.addChoosableFileFilter(filter2);
        int returnVal = fc.showOpenDialog(this.getContentPane());
        this.contentEditor.getMouseWheelListeners();
        if (returnVal == 0) {
            this.lastCloudFileOpened = "";
            File file = fc.getSelectedFile();
            try {
                this.clearUndoRedoManagers();
                this.setTextProperly(HelperFunctions.readFileAsString(file.getAbsolutePath()));
                SwingUtilities.invokeLater(() -> {
                    this.contentEditor.setCaretPosition(0);
                    this.scrollPane.getVerticalScrollBar().setValue(0);
                });
                this.recents.add(file.getAbsolutePath());
                this.setTitleBarText(file.getName().split("\\.")[0]);
                try {
                    ZPEEditor.storeRecentFiles(this.recents, "");
                    this.recents = ZPEEditor.getRecentFiles("");
                    this.updateRecentFiles();
                }
                catch (IOException ex) {
                    ZPE.log(ex.getMessage());
                }
                this.setTitleBarText(file.getName());
                this.editor.setTitle("ZPE Editor");
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.editor, "The file could not be opened.", "Error", 0);
            }
        }
    }

    private void saveAsDialog() {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(filter1);
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showSaveDialog(this.getContentPane());
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String extension = ZPEEditorMain.getSaveExtension(fc.getFileFilter());
            try {
                HelperFunctions.writeFile(file.getAbsolutePath() + "." + extension, this.contentEditor.getText(), false);
                this.setTitleBarText(file.getName().split("\\.")[0]);
                this.lastFileOpened = file.getAbsolutePath();
                this.lastCloudFileOpened = "";
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.editor, "The file could not be saved.", "Error", 0);
            }
        }
    }

    void setTextProperly(String text) {
        this.dontUndo = true;
        this.contentEditor.setText(text);
        this.dontUndo = false;
    }

    private void updateEditor() {
        this.contentEditor = (JEditorPane)this.mainSyntax.getEditPane();
        this.setTextProperly(this.contentEditor.getText());
    }

    private void clearUndoRedoManagers() {
        this.undoManager.die();
        this.undoAction.update();
        this.redoAction.update();
    }

    private void changeFontFamily(String fam) {
        this.mainSyntax.setFontName(fam);
        if (this.mainSyntax != null) {
            this.mainSyntax.updateFont(new Font(fam, this.contentEditor.getFont().getStyle(), this.contentEditor.getFont().getSize()));
            this.mainSyntax.repaint();
        } else {
            this.contentEditor.setFont(new Font(fam, this.contentEditor.getFont().getStyle(), this.contentEditor.getFont().getSize()));
        }
        if (fam.equals("Monospaced")) {
            fam = "Default font";
        }
        this.resetScroll();
    }

    private void resetScroll() {
        int caretPosition = this.contentEditor.getCaretPosition();
        int scrollPosition = this.scrollPane.getVerticalScrollBar().getValue();
        this.contentEditor.setText(this.contentEditor.getText());
        SwingUtilities.invokeLater(() -> {
            this.contentEditor.requestFocus();
            this.contentEditor.setCaretPosition(caretPosition);
            this.scrollPane.getVerticalScrollBar().setValue(scrollPosition);
        });
    }

    private void switchOnDarkMode() {
        this.darkModeMenuItem.setSelected(true);
        Color dark = Color.decode("#282D37");
        this.contentEditor.setBackground(dark);
        this.contentEditor.setForeground(Color.white);
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Normal, Color.white);
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Quote, new Color(152, 195, 119));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Keyword, new Color(198, 120, 222));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Function, new Color(97, 172, 231));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Var, new Color(224, 108, 117));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Type, new Color(105, 143, 163));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Bool, new Color(208, 154, 102));
        this.contentEditor.setCaretColor(Color.white);
        this.autoCompleteItemBackgroundColor = new Color(30, 39, 75, 255);
        this.resetScroll();
        BalfLafManager.getInstance().toggleDarkMode(true);
        this.darkMode = true;
    }

    private void switchOffDarkMode() {
        this.darkModeMenuItem.setSelected(false);
        Color light = new Color(255, 255, 255);
        this.contentEditor.setBackground(light);
        this.contentEditor.setForeground(Color.black);
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Normal, Color.black);
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Quote, new Color(0, 128, 0));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Keyword, new Color(135, 16, 148));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Function, new Color(97, 172, 231));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Var, new Color(255, 138, 0));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Type, new Color(2, 87, 172));
        this.contentEditor.setCaretColor(Color.black);
        this.autoCompleteItemBackgroundColor = new Color(241, 241, 241, 255);
        this.resetScroll();
        BalfLafManager.getInstance().toggleDarkMode(false);
        this.darkMode = false;
    }

    private void changeFontSize(int newSize) {
        this.fontSizeSmallMenuItem.setSelected(false);
        this.fontSizeNormalMenuItem.setSelected(false);
        this.fontSizeLargeMenuItem.setSelected(false);
        this.fontSizeExtraLargeMenuItem.setSelected(false);
        if (newSize == -1) {
            this.fontSizeSmallMenuItem.setSelected(true);
            this.mainSyntax.setFontSize(14);
            this.contentEditor.setFont(new Font(this.contentEditor.getFont().getName(), this.contentEditor.getFont().getStyle(), 14));
        }
        if (newSize == 0) {
            this.fontSizeNormalMenuItem.setSelected(true);
            this.mainSyntax.setFontSize(17);
            this.contentEditor.setFont(new Font(this.contentEditor.getFont().getName(), this.contentEditor.getFont().getStyle(), 17));
        }
        if (newSize == 1) {
            this.fontSizeLargeMenuItem.setSelected(true);
            this.mainSyntax.setFontSize(28);
            this.contentEditor.setFont(new Font(this.contentEditor.getFont().getName(), this.contentEditor.getFont().getStyle(), 28));
        }
        if (newSize == 2) {
            this.fontSizeExtraLargeMenuItem.setSelected(true);
            this.mainSyntax.setFontSize(35);
            this.contentEditor.setFont(new Font(this.contentEditor.getFont().getName(), this.contentEditor.getFont().getStyle(), 35));
        }
        if (this.mainSyntax != null) {
            this.mainSyntax.updateFont(new Font(this.contentEditor.getFont().getFontName(), this.contentEditor.getFont().getStyle(), this.contentEditor.getFont().getSize()));
            this.mainSyntax.repaint();
        } else {
            this.contentEditor.setFont(new Font(this.contentEditor.getFont().getFontName(), this.contentEditor.getFont().getStyle(), this.contentEditor.getFont().getSize()));
        }
        this.resetScroll();
        this.contentEditor.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                try {
                    if (ZPEEditorMain.this.autoCompletePopup.isVisible()) {
                        return;
                    }
                    int pos = ZPEEditorMain.this.contentEditor.viewToModel2D(e.getPoint());
                    String hoveredWord = ZPEEditorMain.getWordAtCaret(ZPEEditorMain.this.contentEditor, pos);
                    if (ZPEKit.internalFunctionExists(hoveredWord)) {
                        ZPEEditorMain.this.hideTooltipTimer.cancel();
                        int endOfWordPos = Utilities.getWordEnd(ZPEEditorMain.this.contentEditor, pos);
                        Rectangle2D wordEndBounds = ZPEEditorMain.this.contentEditor.modelToView2D(endOfWordPos);
                        if (wordEndBounds != null) {
                            Point tooltipPosition = new Point((int)wordEndBounds.getX(), (int)wordEndBounds.getY() + (int)wordEndBounds.getHeight());
                            if (!hoveredWord.equals(ZPEEditorMain.this.lastHoveredWord) || tooltipPosition.getX() != ZPEEditorMain.this.lastPosition.getX() || tooltipPosition.getY() != ZPEEditorMain.this.lastPosition.getY()) {
                                ZPEEditorMain.this.lastHoveredWord = hoveredWord;
                                ZPEEditorMain.this.lastPosition = tooltipPosition;
                                ZPEEditorMain.this.startShowTooltipTimer(tooltipPosition, hoveredWord);
                            }
                        }
                    } else {
                        ZPEEditorMain.this.startHideTooltipTimer();
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    private ArrayList<JLabel> getPopupItems() {
        ArrayList<JLabel> output = new ArrayList<JLabel>();
        JScrollPane pane = (JScrollPane)this.autoCompletePopup.getContentPane().getComponent(0);
        JViewport v = (JViewport)pane.getComponent(0);
        JPanel p = (JPanel)v.getComponent(0);
        for (Component c : p.getComponents()) {
            if (!(c instanceof JLabel)) continue;
            output.add((JLabel)c);
        }
        return output;
    }

    private JLabel getPopupItem(int index) {
        return this.getPopupItems().get(index);
    }

    private void resetItem() {
        this.getPopupItem(this.currentAutoCompletePosition).setBackground(this.autoCompleteItemBackgroundColor);
        if (this.autoCompleteSuggestionTypes.get(this.autoCompleteSuggestionWords.get(this.currentAutoCompletePosition)).equals("keyword")) {
            this.getPopupItem(this.currentAutoCompletePosition).setForeground(StyleConstants.getForeground(CodeEditorView.DEFAULT_KEYWORD));
        } else if (this.autoCompleteSuggestionTypes.get(this.autoCompleteSuggestionWords.get(this.currentAutoCompletePosition)).equals("type")) {
            this.getPopupItem(this.currentAutoCompletePosition).setForeground(StyleConstants.getForeground(CodeEditorView.DEFAULT_TYPE));
        } else if (this.autoCompleteSuggestionTypes.get(this.autoCompleteSuggestionWords.get(this.currentAutoCompletePosition)).equals("function")) {
            this.getPopupItem(this.currentAutoCompletePosition).setForeground(StyleConstants.getForeground(CodeEditorView.DEFAULT_PREDEFINED_FUNCTION));
        }
    }

    private void addKeyBindings() {
        this.contentEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ZPEEditorMain.this.hideTooltip();
                if (e.getKeyCode() == 27) {
                    ZPEEditorMain.this.autoCompletePopup.setVisible(false);
                    ZPEEditorMain.this.enableArrows();
                } else if (e.getKeyCode() == 8 || e.getKeyChar() == ' ' || e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                    ZPEEditorMain.this.autoCompletePopup.setVisible(false);
                    ZPEEditorMain.this.enableArrows();
                } else if ((e.getKeyCode() == 9 || e.getKeyCode() == 10) && ZPEEditorMain.this.autoCompletePopup.isVisible()) {
                    e.consume();
                    ZPEEditorMain.this.insertAutocomplete(ZPEEditorMain.this.autoCompleteSuggestionWords.get(ZPEEditorMain.this.currentAutoCompletePosition));
                } else if (e.getKeyCode() == 40 && ZPEEditorMain.this.autoCompletePopup.isVisible()) {
                    e.consume();
                    ArrayList<JLabel> p = ZPEEditorMain.this.getPopupItems();
                    if (!p.isEmpty() && ZPEEditorMain.this.currentAutoCompletePosition < p.size() - 1) {
                        ZPEEditorMain.this.resetItem();
                        ZPEEditorMain.this.getPopupItems().get(++ZPEEditorMain.this.currentAutoCompletePosition).setBackground(SystemColor.controlHighlight);
                        ZPEEditorMain.this.getPopupItems().get(ZPEEditorMain.this.currentAutoCompletePosition).setForeground(Color.WHITE);
                        ZPEEditorMain.this.getPopupItems().get(ZPEEditorMain.this.currentAutoCompletePosition).requestFocus();
                    }
                } else if (e.getKeyCode() == 38 && ZPEEditorMain.this.autoCompletePopup.isVisible()) {
                    e.consume();
                    ArrayList<JLabel> p = ZPEEditorMain.this.getPopupItems();
                    if (!p.isEmpty() && ZPEEditorMain.this.currentAutoCompletePosition > 0) {
                        ZPEEditorMain.this.resetItem();
                        ZPEEditorMain.this.getPopupItems().get(--ZPEEditorMain.this.currentAutoCompletePosition).setBackground(SystemColor.controlHighlight);
                        ZPEEditorMain.this.getPopupItems().get(ZPEEditorMain.this.currentAutoCompletePosition).setForeground(Color.WHITE);
                    }
                } else {
                    ZPEEditorMain.this.showAutocompletePopup();
                    ZPEEditorMain.this.autoCompleteDebounceTimer.cancel();
                    ZPEEditorMain.this.autoCompleteDebounceTimer = new Timer();
                    ZPEEditorMain.this.autoCompleteDebounceTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ZPEEditorMain.this.hideTooltip();
                                }
                            });
                        }
                    }, 100L);
                }
            }
        });
    }

    private void enableArrows() {
        InputMap inputMap = this.contentEditor.getInputMap(0);
        ActionMap actionMap = this.contentEditor.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("TAB"), null);
        inputMap.put(KeyStroke.getKeyStroke("UP"), null);
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), null);
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), null);
        actionMap.put("doNothing", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    private void disableArrows() {
        InputMap inputMap = this.contentEditor.getInputMap(0);
        ActionMap actionMap = this.contentEditor.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("TAB"), "doNothing");
        inputMap.put(KeyStroke.getKeyStroke("UP"), "doNothing");
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), "doNothing");
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "doNothing");
        actionMap.put("doNothing", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    private String getCurrentWord() {
        try {
            int start;
            int caretPosition = this.contentEditor.getCaretPosition();
            for (start = caretPosition - 1; start >= 0 && (Character.isLetterOrDigit(this.contentEditor.getText(start, 1).charAt(0)) || this.contentEditor.getText(start, 1).charAt(0) == '_' || this.contentEditor.getText(start, 1).charAt(0) == '#' || this.contentEditor.getText(start, 1).charAt(0) == '$'); --start) {
            }
            int next = 0;
            while (caretPosition + next < this.contentEditor.getText().length() && this.contentEditor.getText().charAt(caretPosition + next) != ' ' && this.contentEditor.getText().charAt(caretPosition + next) != '\t' && this.contentEditor.getText().charAt(caretPosition + next) != '\n') {
                ++next;
            }
            return this.contentEditor.getText(start + 1, next + caretPosition - (start + 1));
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private String getCurrentLine() {
        try {
            int start;
            int caretPosition = this.contentEditor.getCaretPosition();
            for (start = caretPosition - 1; start >= 0 && this.contentEditor.getText(start, 1).charAt(0) != '\n'; --start) {
            }
            int next = 0;
            while (caretPosition + next < this.contentEditor.getText().length() && this.contentEditor.getText().charAt(caretPosition + next) != '\n') {
                ++next;
            }
            return this.contentEditor.getText(start + 1, next + caretPosition - (start + 1));
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private List<String> getAutocompleteSuggestions(String currentWord) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (String keyword : ZPEKit.getKeywords()) {
            if (!keyword.startsWith(currentWord)) continue;
            suggestions.add(keyword);
            this.autoCompleteSuggestionTypes.put(keyword, "keyword");
        }
        for (String keyword : ZPEKit.getTypeKeywords()) {
            if (!keyword.startsWith(currentWord)) continue;
            suggestions.add(keyword);
            this.autoCompleteSuggestionTypes.put(keyword, "type");
        }
        for (String function : ZPEKit.getBuiltInFunctions()) {
            if (!function.startsWith(currentWord)) continue;
            suggestions.add(function);
            this.autoCompleteSuggestionTypes.put(function, "function");
        }
        return suggestions;
    }

    private boolean isWithinQuotes() {
        try {
            int caretPosition = this.contentEditor.getCaretPosition();
            String text = this.contentEditor.getText(0, caretPosition);
            int doubleQuotesCount = 0;
            int singleQuotesCount = 0;
            for (int i = 0; i < caretPosition; ++i) {
                char c = text.charAt(i);
                if (c == '\"') {
                    ++doubleQuotesCount;
                    continue;
                }
                if (c != '\'') continue;
                ++singleQuotesCount;
            }
            boolean insideDoubleQuotes = doubleQuotesCount % 2 != 0;
            boolean insideSingleQuotes = singleQuotesCount % 2 != 0;
            return insideDoubleQuotes || insideSingleQuotes;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void showAutocompletePopup() {
        this.currentAutoCompletePosition = 0;
        String currentWord = this.getCurrentWord();
        String currentLine = this.getCurrentLine();
        if (currentWord.equals(this.previousAutoCompleteWord)) {
            return;
        }
        this.previousAutoCompleteWord = currentWord;
        this.autoCompletePopup.getContentPane().removeAll();
        this.autoCompletePopup.getContentPane().setLayout(new BorderLayout());
        this.autoCompletePopup.setFocusableWindowState(false);
        this.autoCompletePopup.setBackground(new Color(255, 255, 255, 0));
        if (currentWord.isEmpty() || currentWord.startsWith("$") || this.isWithinQuotes() || currentLine.trim().startsWith("//")) {
            this.autoCompletePopup.setVisible(false);
            return;
        }
        this.autoCompleteSuggestionWords = this.getAutocompleteSuggestions(currentWord);
        this.autoCompletePopup.setFocusable(false);
        if (!this.autoCompleteSuggestionWords.isEmpty()) {
            HashMap<String, Boolean> added = new HashMap<String, Boolean>();
            this.autoCompletePopup.setLayout(new BorderLayout());
            JPanel suggestionPanel = new JPanel();
            suggestionPanel.setLayout(new GridBagLayout());
            suggestionPanel.setBorder(null);
            suggestionPanel.setOpaque(true);
            suggestionPanel.setBackground(this.autoCompleteItemBackgroundColor);
            suggestionPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    System.out.println("EEK");
                }
            });
            JScrollPane outerScroll = new JScrollPane(suggestionPanel);
            outerScroll.setBorder(null);
            outerScroll.setOpaque(true);
            outerScroll.getVerticalScrollBar().setOpaque(false);
            outerScroll.getVerticalScrollBar().setSize(new Dimension(0, 0));
            this.autoCompletePopup.getContentPane().add((Component)outerScroll, "North");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            for (final String suggestion : this.autoCompleteSuggestionWords) {
                final JLabel suggestionLabel = new JLabel(suggestion);
                suggestionLabel.setHorizontalAlignment(2);
                suggestionLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 0));
                suggestionLabel.setFocusable(true);
                suggestionLabel.setRequestFocusEnabled(true);
                String type = this.autoCompleteSuggestionTypes.get(suggestion);
                if (type.equals("keyword") && !added.containsKey(suggestion)) {
                    suggestionLabel.setForeground(StyleConstants.getForeground(CodeEditorView.DEFAULT_KEYWORD));
                } else if (type.equals("type")) {
                    suggestionLabel.setForeground(StyleConstants.getForeground(CodeEditorView.DEFAULT_TYPE));
                } else if (type.equals("function")) {
                    suggestionLabel.setForeground(StyleConstants.getForeground(CodeEditorView.DEFAULT_PREDEFINED_FUNCTION));
                }
                added.put(suggestion, true);
                suggestionLabel.setOpaque(true);
                suggestionLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        ZPEEditorMain.this.insertAutocomplete(suggestion);
                        ZPEEditorMain.this.autoCompletePopup.setVisible(false);
                        ZPEEditorMain.this.hideTooltip();
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        e.getComponent().setBackground(SystemColor.controlHighlight);
                        if (ZPEKit.internalFunctionExists(suggestion)) {
                            Point p = new Point();
                            p.x += e.getComponent().getWidth();
                            p.y = (int)e.getComponent().getLocation().getY();
                            ZPEEditorMain.this.showRoundedTooltip(ZPEEditorMain.this.contentEditor, p, ZPEEditorMain.this.getTooltipFunctionInfo(suggestion), suggestion);
                        } else {
                            ZPEEditorMain.this.hideTooltip();
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        suggestionLabel.setBackground(ZPEEditorMain.this.autoCompleteItemBackgroundColor);
                        ZPEEditorMain.this.startHideTooltipTimer();
                    }
                });
                suggestionLabel.setBackground(this.autoCompleteItemBackgroundColor);
                suggestionPanel.add((Component)suggestionLabel, gbc);
            }
            outerScroll.setBackground(this.autoCompleteItemBackgroundColor);
            suggestionPanel.setBackground(this.autoCompleteItemBackgroundColor);
            this.autoCompletePopup.setBackground(this.autoCompleteItemBackgroundColor);
            this.autoCompletePopup.setPreferredSize(new Dimension(200, this.autoCompleteSuggestionWords.size() * 22));
            this.autoCompletePopup.pack();
            JLabel first = this.getPopupItem(0);
            first.setBackground(SystemColor.controlHighlight);
            try {
                int caretPos = this.contentEditor.getCaretPosition();
                int endOfWordPos = Utilities.getWordEnd(this.contentEditor, caretPos);
                Rectangle wordEndBounds = this.contentEditor.modelToView2D(endOfWordPos - 1).getBounds();
                Point locationOnScreen = this.contentEditor.getLocationOnScreen();
                int popupX = (int)((RectangularShape)wordEndBounds).getX() + locationOnScreen.x;
                int popupY = (int)((RectangularShape)wordEndBounds).getY() + locationOnScreen.y + (int)((RectangularShape)wordEndBounds).getHeight();
                this.disableArrows();
                this.autoCompletePopup.setLocation(popupX, popupY);
                this.autoCompletePopup.setVisible(true);
                this.autoCompletePopup.toFront();
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.autoCompletePopup.setVisible(false);
            this.enableArrows();
        }
    }

    private void insertAutocomplete(String suggestion) {
        try {
            int caretPosition = this.contentEditor.getCaretPosition();
            String currentWord = this.getCurrentWord();
            int wordStart = caretPosition - currentWord.length();
            if (currentWord.equals(suggestion)) {
                this.autoCompletePopup.setVisible(false);
                this.enableArrows();
                return;
            }
            if (this.autoCompleteSuggestionTypes.get(suggestion).equals("function")) {
                suggestion = (String)suggestion + "()";
            }
            this.contentEditor.getDocument().remove(wordStart, currentWord.length());
            this.contentEditor.getDocument().insertString(wordStart, (String)suggestion, null);
            this.autoCompletePopup.setVisible(false);
            this.enableArrows();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void doReplacement(String rep) {
        this.contentEditor.replaceSelection(rep);
    }

    private void startShowTooltipTimer(final Point tooltipPosition, final String hoveredWord) {
        if (this.showTooltipTimer != null) {
            this.showTooltipTimer.cancel();
        }
        this.showTooltipTimer = new Timer();
        this.showTooltipTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ZPEEditorMain.this.showRoundedTooltip(ZPEEditorMain.this.contentEditor, tooltipPosition, ZPEEditorMain.this.getTooltipFunctionInfo(hoveredWord), hoveredWord);
                    }
                });
            }
        }, 500L);
    }

    private void startHideTooltipTimer() {
        if (this.hideTooltipTimer != null) {
            this.hideTooltipTimer.cancel();
        }
        this.hideTooltipTimer = new Timer();
        this.hideTooltipTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ZPEEditorMain.this.hideTooltip();
                    }
                });
            }
        }, 1000L);
    }

    private void showRoundedTooltip(JEditorPane editorPane, Point position, String info, String functionName) {
        if (tooltipWindow == null) {
            tooltipWindow = new JWindow();
            tooltipWindow.setAlwaysOnTop(true);
            tooltipWindow.setFocusableWindowState(false);
        }
        tooltipWindow.setBackground(new Color(255, 255, 255, 0));
        RoundedPanel tooltipPanel = new RoundedPanel();
        tooltipPanel.setLayout(new BorderLayout());
        tooltipPanel.setBorder(null);
        JLabel tooltipLabel = new JLabel(info);
        tooltipLabel.setHorizontalAlignment(0);
        tooltipPanel.add((Component)tooltipLabel, "Center");
        tooltipLabel.setOpaque(false);
        tooltipLabel.setBorder(null);
        tooltipLabel.setBackground(new Color(0, 0, 0, 0));
        tooltipLabel.setCursor(Cursor.getPredefinedCursor(12));
        final String path = ZPEKit.getFunctionCategory(functionName).toLowerCase().replace(" ", "_").replace("/", "") + "/" + functionName.toLowerCase().replace(" ", "_").replace("/", "");
        tooltipLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    String url = "https://www.jamiebalfour.scot/projects/zpe/documentation/functions/" + path;
                    HelperFunctions.openWebsite(url);
                    ZPEEditorMain.this.hideTooltip();
                }
                catch (IOException | URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        tooltipWindow.getContentPane().removeAll();
        tooltipWindow.getContentPane().add(tooltipPanel);
        tooltipWindow.pack();
        Point editorPaneLocationOnScreen = editorPane.getLocationOnScreen();
        tooltipWindow.setLocation(editorPaneLocationOnScreen.x + position.x, editorPaneLocationOnScreen.y + position.y);
        tooltipWindow.setVisible(true);
        tooltipWindow.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ZPEEditorMain.this.hideTooltipTimer != null) {
                    ZPEEditorMain.this.hideTooltipTimer.cancel();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ZPEEditorMain.this.startHideTooltipTimer();
            }
        });
        tooltipLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ZPEEditorMain.this.hideTooltipTimer != null) {
                    ZPEEditorMain.this.hideTooltipTimer.cancel();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ZPEEditorMain.this.startHideTooltipTimer();
            }
        });
    }

    private String getTooltipFunctionInfo(String functionName) {
        Object output = "";
        output = this.darkMode ? (String)output + "<html><div style='padding:10px;width:300px;color:#ddd;'>" : (String)output + "<html><div style='padding:10px;width:300px;color:#333;'>";
        ArrayList<AbstractMap.SimpleEntry<String, String>> params = ZPEEditor.getParams(ZPEKit.getFunctionManualHeader(functionName));
        StringBuilder header = new StringBuilder();
        for (int i = 0; i < params.size(); ++i) {
            AbstractMap.SimpleEntry<String, String> param2 = params.get(i);
            String name = param2.getKey();
            String type = param2.getValue();
            if (this.darkMode) {
                header.append("<span style='color: rgb(105, 143, 163);font-style:italic;'>").append(type).append("</span>").append(" <span style='color:#f60'>").append(name).append("</span>");
            } else {
                header.append("<span style='color: rgb(2, 87, 172);font-style:italic;'>").append(type).append("</span>").append(" <span style='color:#f60'>").append(name).append("</span>");
            }
            if (i + 1 >= params.size()) continue;
            header.append(", ");
        }
        output = (String)output + "<div style='font-weight:100;text-decoration:underline;margin-bottom:5px;'>Category: " + ZPEKit.getFunctionCategory(functionName) + "</div>";
        output = this.darkMode ? (String)output + "<div style='margin-bottom:20px;'><span style='font-weight:bold;color:rgb(198, 120, 222)'>" + functionName + "</span> (" + header + ") : " + ZPEHelperFunctions.typeByteToString(ZPEKit.getFunctionReturnType(functionName)) + "</div>" : (String)output + "<div style='margin-bottom:20px;'><span style='font-weight:bold;margin-bottom:20px;color:rgb(135, 16, 148)'>" + functionName + "</span> (" + header + ") : " + ZPEHelperFunctions.typeByteToString(ZPEKit.getFunctionReturnType(functionName)) + "</div>";
        output = (String)output + ZPEKit.getFunctionManualEntryAsStyledHtml(functionName, this.darkMode);
        output = this.darkMode ? (String)output + "<div style='margin:10px 0; color:#222;'>Function version " + ZPEKit.getFunctionVersion(functionName) + "</div>" : (String)output + "<div style='margin:10px 0; color:#bbb;'>Function version " + ZPEKit.getFunctionVersion(functionName) + "</div>";
        output = (String)output + "<div style='color:#0af'>Click for more information online.</div>";
        output = (String)output + "</div></html>";
        return output;
    }

    public void saveToTheCloud() {
        if ((this.login_username.isEmpty() || this.login_password.isEmpty()) && !this.login()) {
            return;
        }
        try {
            if (!ZPEKit.validateCode(this.contentEditor.getText())) {
                JOptionPane.showMessageDialog(this.editor.getContentPane(), "Your code is not valid. Please validate your code before uploading.", "Save unsuccessful", 1);
                return;
            }
        }
        catch (CompileException e1) {
            System.err.println(e1.getMessage());
            JOptionPane.showMessageDialog(this.editor.getContentPane(), "Your code could not validate. Make sure it is valid before uploading.", "Save unsuccessful", 1);
            return;
        }
        String path = !this.lastCloudFileOpened.isEmpty() ? JOptionPane.showInputDialog(this.editor, "Please insert the name for this file.", this.lastCloudFileOpened) : JOptionPane.showInputDialog(this.editor, (Object)"Please insert the name for this file.");
        int public_or_private = 0;
        int res = JOptionPane.showConfirmDialog(this.editor.getContentPane(), "Do you want to make your code public?", "Make your code public", 0, -1);
        if (res == 0) {
            public_or_private = 1;
        }
        if (path != null) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("username", this.login_username);
            arguments.put("password", this.login_password);
            arguments.put("content", this.contentEditor.getText());
            arguments.put("content_name", path);
            arguments.put("public", "" + public_or_private);
            try {
                String postRes = HelperFunctions.makePOSTRequest(ZPEInstance.getOnlinePathProperty() + "/save.php?version=10", arguments);
                if (postRes.isEmpty()) {
                    JOptionPane.showMessageDialog(this.editor, "Your file could not be saved at this time.", "Save failed", 0);
                } else {
                    ZenithJSONParser p = new ZenithJSONParser();
                    ZPEMap a = (ZPEMap)p.jsonDecode(postRes, false);
                    if (a.get(new ZPEString("result")).toString().equals("1")) {
                        this.lastCloudFileOpened = path;
                        this.setTitleBarText(path);
                        this.lastFileOpened = "";
                        JOptionPane.showMessageDialog(this.editor.getContentPane(), "Your file has been saved to your ZPE Online account.", "Save successful", 1);
                        if (a.containsKey(new ZPEString("list"))) {
                            this.addRecentsFromCloud((ZPEList)a.get(new ZPEString("list")));
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.editor, "Your file could not be saved at this time.", "Save failed", 0);
                    }
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.editor, "Your file could not be saved at this time.", "Save failed", 0);
                System.err.println(e.getMessage());
            }
        }
    }

    private void loadFromUsersCloud() {
        if ((this.login_username.isEmpty() || this.login_password.isEmpty()) && !this.login()) {
            return;
        }
        try {
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("username", this.login_username);
            arguments.put("password", this.login_password);
            String lst = HelperFunctions.makePOSTRequest(ZPEInstance.getOnlinePathProperty() + "/get.php?type=list&version=10", arguments);
            ZenithJSONParser p = new ZenithJSONParser();
            ZPEMap a = (ZPEMap)p.jsonDecode(lst, false);
            if (a.containsKey(new ZPEString("result")) && HelperFunctions.stringToInteger(a.get(new ZPEString("result")).toString()) == 1) {
                ZPEType l = a.get(new ZPEString("list"));
                ZPEList arr = (ZPEList)l;
                ArrayList<String> choices = new ArrayList<String>();
                ZPEMap selections = new ZPEMap();
                String first = "";
                for (ZPEType k : arr) {
                    ZPEMap file = (ZPEMap)k;
                    choices.add(file.get(new ZPEString("name")).toString());
                    selections.put(new ZPEString(file.get(new ZPEString("name")).toString()), new ZPEString(file.get(new ZPEString("id")).toString()));
                    if (!first.isEmpty()) continue;
                    first = file.get(new ZPEString("name")).toString();
                }
                new ZPEOnlineFileChooser(this._this, arguments, selections, choices, false);
            }
        }
        catch (Exception e) {
            ZPE.log(e.getMessage());
        }
    }

    private void loadFromPublicCloud() {
        try {
            HashMap<String, String> arguments = new HashMap<String, String>();
            String lst = HelperFunctions.makePOSTRequest(ZPEInstance.getOnlinePathProperty() + "/public.php?type=list&version=10", arguments);
            ZenithJSONParser p = new ZenithJSONParser();
            ZPEMap a = (ZPEMap)p.jsonDecode(lst, false);
            if (a.containsKey(new ZPEString("result")) && HelperFunctions.stringToInteger(a.get(new ZPEString("result")).toString()) == 1) {
                ZPEType l = a.get(new ZPEString("list"));
                ZPEList arr = (ZPEList)l;
                ArrayList<String> choices = new ArrayList<String>();
                ZPEMap selections = new ZPEMap();
                String first = "";
                for (ZPEType k : arr) {
                    ZPEMap file = (ZPEMap)k;
                    choices.add(file.get(new ZPEString("name")).toString());
                    selections.put(new ZPEString(file.get(new ZPEString("name")).toString()), new ZPEString(file.get(new ZPEString("id")).toString()));
                    if (!first.isEmpty()) continue;
                    first = file.get(new ZPEString("name")).toString();
                }
                new ZPEOnlineFileChooser(this._this, arguments, selections, choices, true);
            }
        }
        catch (Exception e) {
            ZPE.log(e.getMessage());
        }
    }

    void loadFromCloudFile(String file, Map<String, String> arguments, ZPEMap selections, boolean publicrepo) {
        ZenithJSONParser p = new ZenithJSONParser();
        arguments.put("id", selections.get(new ZPEString(file)).toString());
        try {
            String s = !publicrepo ? HelperFunctions.makePOSTRequest(ZPEInstance.getOnlinePathProperty() + "/get.php?type=file&version=10", arguments) : HelperFunctions.makePOSTRequest(ZPEInstance.getOnlinePathProperty() + "/public.php?type=file&version=10", arguments);
            ZPEMap results = (ZPEMap)p.jsonDecode(s, false);
            String code = URLDecoder.decode(results.get(new ZPEString("string")).toString(), "UTF-8");
            code = code.replace("\\n", System.lineSeparator());
            this.clearUndoRedoManagers();
            this.setTextProperly(code);
            this.lastCloudFileOpened = file;
            this.lastFileOpened = "";
            this.setTitleBarText(file);
            this.setTitle("ZPE Editor");
            if (publicrepo) {
                this.lastCloudFileOpened = "";
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.editor, "File cannot be opened.", "Error", 0);
        }
    }

    @Override
    public Properties getProperties() {
        return this.mainProperties;
    }

    @Override
    public void destroyConsole() {
        this.AttachedConsole = null;
    }

    private void updateRecentFiles() {
        this.recentItemsMenu.removeAll();
        for (String fStr : this.recents) {
            BalfMenuBar.MenuItem item = new BalfMenuBar.MenuItem(new File(fStr).getName(), this.menuBar);
            item.addActionListener(e -> {
                try {
                    this.clearUndoRedoManagers();
                    this.setTextProperly(HelperFunctions.readFileAsString(new File(fStr).getAbsolutePath()));
                    SwingUtilities.invokeLater(() -> {
                        this.contentEditor.setCaretPosition(0);
                        this.scrollPane.getVerticalScrollBar().setValue(0);
                    });
                    this.setTitleBarText(new File(fStr).getName().split("\\.")[0]);
                    this.editor.setTitle("ZPE Editor");
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
            this.recentItemsMenu.add((Component)item, 0);
        }
    }

    private void debugCode() throws IOException {
        ZPEKit.setDebugging(true);
        String t = "ZPE";
        if (!this.lastFileOpened.isEmpty()) {
            t = "ZPE Editor";
        } else if (!this.lastCloudFileOpened.isEmpty()) {
            t = "ZPE Editor";
        }
        this.setTitle(t);
        this.setTitleBarText(t);
        Object extras = " --debugging";
        if (this.caseSensitiveCompileMenuItem.isSelected()) {
            extras = (String)extras + " --case_insensitive";
        }
        if (this.currentProcess != null) {
            this.currentProcess.destroy();
        }
        HelperFunctions.writeFile(ZPEInstance.getInstallPath() + "/tmp.yas", this.contentEditor.getText(), false);
        if (HelperFunctions.isJavaAvailable()) {
            if (ZPEInstance.getJarExecPath().isEmpty()) {
                if (new File(ZPEInstance.getExecutablePath() + "/zpe.jar").exists()) {
                    this.currentProcess = Runtime.getRuntime().exec("java -jar " + ZPEInstance.getExecutablePath() + "/zpe.jar -g " + ZPEInstance.getInstallPath() + "/tmp.yas --console" + (String)extras);
                    this.stopCodeMenuItem.setEnabled(true);
                }
            } else {
                this.currentProcess = Runtime.getRuntime().exec("java -jar " + ZPEInstance.getJarExecPath() + " -g " + ZPEInstance.getInstallPath() + "/tmp.yas --console" + (String)extras);
                this.stopCodeMenuItem.setEnabled(true);
            }
        } else {
            ZPEConsole console = new ZPEConsole(5, ZPEInstance.getInstallPath() + "/tmp.yas", true);
            this.stopCodeMenuItem.setEnabled(false);
        }
    }

    private void executeCode() throws IOException {
        ZPEKit.setDebugging(false);
        Object t = "ZPE";
        if (!this.lastFileOpened.isEmpty()) {
            t = "ZPE : " + this.lastFileOpened;
        } else if (!this.lastCloudFileOpened.isEmpty()) {
            t = "ZPE : " + this.lastCloudFileOpened;
        }
        Object extras = "";
        if (this.caseSensitiveCompileMenuItem.isSelected()) {
            extras = (String)extras + " --case_insensitive";
        }
        if (this.currentProcess != null) {
            this.currentProcess.destroy();
        }
        HelperFunctions.writeFile(ZPEInstance.getInstallPath() + "/tmp.yas", this.contentEditor.getText(), false);
        if (HelperFunctions.isJavaAvailable() && !this.useLocalConsoleMenuItem.isSelected()) {
            if (!ZPEInstance.getJarExecPath().isEmpty()) {
                if (new File(ZPEInstance.getJarExecPath()).exists()) {
                    this.currentProcess = Runtime.getRuntime().exec("java -jar " + ZPEInstance.getJarExecPath() + " -g " + ZPEInstance.getInstallPath() + "/tmp.yas --console" + (String)extras);
                    this.stopCodeMenuItem.setEnabled(true);
                    this.stopCodeMenuItem.setVisible(true);
                }
            } else {
                ZPEConsole c = new ZPEConsole(this, (String)t, this.contentEditor.getFont(), this.permission_level);
                c.runCode(this.contentEditor.getText(), new ZPEString[0], this.caseSensitiveCompileMenuItem.isSelected());
                this.stopCodeMenuItem.setVisible(false);
            }
        } else {
            ZPEConsole c = new ZPEConsole(this, (String)t, this.contentEditor.getFont(), this.permission_level);
            c.runCode(this.contentEditor.getText(), new ZPEString[0], this.caseSensitiveCompileMenuItem.isSelected());
            this.stopCodeMenuItem.setVisible(false);
        }
    }

    private /* synthetic */ void lambda$new$5(String helpName, String group, String replacement, ActionEvent e) {
        JOptionPane op = new JOptionPane(new ZPEFunctionGenerator(helpName, group, replacement, this._this).getContentPane(), 1, -1, this.lighterLogo, new String[0]);
        JDialog dlg = op.createDialog(this.editor, "ZPE Function Machine");
        dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dlg.setVisible(true);
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -2308035050104867155L;

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ZPEEditorMain.this.undoManager.redo();
            }
            catch (CannotRedoException ex) {
                JOptionPane.showMessageDialog(ZPEEditorMain.this.editor, "Cannot redo.", "Error", 0);
            }
            this.update();
            ZPEEditorMain.this.undoAction.update();
        }

        protected void update() {
            if (ZPEEditorMain.this.undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", ZPEEditorMain.this.undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -3804879849241500100L;

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ZPEEditorMain.this.undoManager.undo();
                this.update();
                ZPEEditorMain.this.redoAction.update();
            }
            catch (CannotUndoException ex) {
                JOptionPane.showMessageDialog(ZPEEditorMain.this.editor, "Cannot undo.", "Error", 0);
            }
        }

        protected void update() {
            if (ZPEEditorMain.this.undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", ZPEEditorMain.this.undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            if (!e.getEdit().getPresentationName().equals("style change") && !ZPEEditorMain.this.dontUndo) {
                ZPEEditorMain.this.undoManager.addEdit(e.getEdit());
                ZPEEditorMain.this.undoAction.update();
                ZPEEditorMain.this.redoAction.update();
            }
        }
    }

    class RoundedPanel
    extends JPanel {
        private static final int ARC_WIDTH = 20;
        private static final int ARC_HEIGHT = 20;

        public RoundedPanel() {
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.setBackground(new Color(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (ZPEEditorMain.this.darkMode) {
                g2.setColor(new Color(33, 33, 33));
            } else {
                g2.setColor(new Color(255, 255, 255));
            }
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 20, 20);
            g2.setColor(new Color(0, 0, 0, 0));
            g2.drawRoundRect(0, 0, 1, 1, 20, 20);
        }
    }

    static class EditorObject
    extends ZPEStructure {
        JEditorPane editor;

        protected EditorObject(ZPERuntimeEnvironment z, ZPEPropertyWrapper parent, JEditorPane editor) {
            super(z, parent, "editor");
            this.editor = editor;
            this.addNativeMethod("write", new write_Command());
            this.addNativeMethod("write_line", new write_line_Command());
            this.addNativeMethod("replace", new replace_Command());
        }

        class replace_Command
        implements ZPEObjectNativeMethod {
            replace_Command() {
            }

            @Override
            public String[] getParameterNames() {
                String[] n = new String[]{"find", "replace"};
                return n;
            }

            public void replaceText(JEditorPane editorPane, String target, String replacement) {
                try {
                    String currentText = editorPane.getDocument().getText(0, editorPane.getDocument().getLength());
                    String updatedText = currentText.replace(target, replacement);
                    editorPane.getDocument().remove(0, editorPane.getDocument().getLength());
                    editorPane.getDocument().insertString(0, updatedText, null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            @Override
            public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
                try {
                    String find = parameters.get("find").toString();
                    String replace = parameters.get("replace").toString();
                    while (EditorObject.this.editor.getText().contains(find)) {
                        this.replaceText(EditorObject.this.editor, find, replace);
                    }
                    return new ZPEBoolean(true);
                }
                catch (Exception e) {
                    return new ZPEBoolean(false);
                }
            }

            @Override
            public int getRequiredPermissionLevel() {
                return 0;
            }

            @Override
            public String getName() {
                return "replace";
            }
        }

        class write_line_Command
        implements ZPEObjectNativeMethod {
            write_line_Command() {
            }

            @Override
            public String[] getParameterNames() {
                String[] n = new String[]{"text"};
                return n;
            }

            @Override
            public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
                SwingUtilities.invokeLater(() -> {
                    String txt = ((ZPEType)parameters.get("text")).toString();
                    int caretPosition = EditorObject.this.editor.getCaretPosition();
                    int currentWordLength = 0;
                    if (EditorObject.this.editor.getSelectedText() != null) {
                        currentWordLength = EditorObject.this.editor.getSelectedText().length();
                    }
                    int wordStart = caretPosition - currentWordLength;
                    try {
                        EditorObject.this.editor.getDocument().remove(wordStart, currentWordLength);
                        EditorObject.this.editor.getDocument().insertString(wordStart, txt + System.lineSeparator(), null);
                    }
                    catch (BadLocationException e) {
                        throw new RuntimeException(e);
                    }
                });
                return new ZPEBoolean(true);
            }

            @Override
            public int getRequiredPermissionLevel() {
                return 0;
            }

            @Override
            public String getName() {
                return "write_line";
            }
        }

        class write_Command
        implements ZPEObjectNativeMethod {
            write_Command() {
            }

            @Override
            public String[] getParameterNames() {
                String[] n = new String[]{"text"};
                return n;
            }

            @Override
            public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
                SwingUtilities.invokeLater(() -> {
                    String txt = ((ZPEType)parameters.get("text")).toString();
                    int caretPosition = EditorObject.this.editor.getCaretPosition();
                    int currentWordLength = 0;
                    if (EditorObject.this.editor.getSelectedText() != null) {
                        currentWordLength = EditorObject.this.editor.getSelectedText().length();
                    }
                    int wordStart = caretPosition - currentWordLength;
                    try {
                        EditorObject.this.editor.getDocument().remove(wordStart, currentWordLength);
                        EditorObject.this.editor.getDocument().insertString(wordStart, txt, null);
                    }
                    catch (BadLocationException e) {
                        throw new RuntimeException(e);
                    }
                });
                return new ZPEBoolean(true);
            }

            @Override
            public int getRequiredPermissionLevel() {
                return 0;
            }

            @Override
            public String getName() {
                return "write";
            }
        }
    }
}

