/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.editor;

import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEInstance;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

class LineNumberEditor
extends JComponent
implements DocumentListener,
CaretListener,
ComponentListener {
    final JTextComponent editor;
    private Font font;
    int marginSize = 50;

    public LineNumberEditor(JTextComponent editor) {
        this.editor = editor;
        editor.getDocument().addDocumentListener(this);
        editor.addComponentListener(this);
        editor.addCaretListener(this);
    }

    public void updateFont(Font f) {
        this.font = f;
        this.marginSize = f.getSize() > 30 ? 100 : (f.getSize() > 20 ? 80 : 50);
        this.updateSize();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            super.paintComponent(g);
            Rectangle clip = g.getClipBounds();
            int startOffset = this.editor.viewToModel2D(new Point(0, clip.y));
            int endOffset = this.editor.viewToModel2D(new Point(0, clip.y + clip.height));
            g.setColor(this.editor.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            boolean stop = false;
            while (startOffset <= endOffset && !stop) {
                try {
                    String lineNumber = this.getLineNumber(startOffset);
                    if (lineNumber != null) {
                        int x = this.getInsets().left + 2;
                        int y = this.getOffsetY(startOffset);
                        this.font = this.font != null ? this.font : new Font(this.editor.getFont().getFamily(), 0, this.editor.getFont().getSize());
                        g.setFont(this.font);
                        g.setColor(this.isCurrentLine(startOffset) ? new Color(0, 200, 0) : new Color(130, 130, 130));
                        g.drawString(lineNumber, x, y);
                    }
                    startOffset = Utilities.getRowEnd(this.editor, startOffset) + 1;
                }
                catch (BadLocationException e) {
                    if (ZPEInstance.getErrorLevelProperty() == 2) {
                        ZPE.log(e.getMessage());
                    }
                    stop = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getLineNumber(int offset) {
        int index;
        Element root = this.editor.getDocument().getDefaultRootElement();
        Element line = root.getElement(index = root.getElementIndex(offset));
        return line.getStartOffset() == offset ? String.format("%3d", index + 1) : null;
    }

    private int getOffsetY(int offset) throws BadLocationException {
        FontMetrics fontMetrics = this.editor.getFontMetrics(this.editor.getFont());
        int descent = fontMetrics.getDescent();
        Rectangle r = this.editor.modelToView(offset);
        return r.y + r.height - descent;
    }

    private boolean isCurrentLine(int offset) {
        int caretPosition = this.editor.getCaretPosition();
        Element root = this.editor.getDocument().getDefaultRootElement();
        return root.getElementIndex(offset) == root.getElementIndex(caretPosition);
    }

    private void documentChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LineNumberEditor.this.repaint();
            }
        });
    }

    private void updateSize() {
        Dimension size = new Dimension(this.marginSize, this.editor.getHeight());
        this.setPreferredSize(size);
        this.setSize(size);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.documentChanged();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateSize();
        this.documentChanged();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.updateSize();
        this.documentChanged();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

