/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.interfaces.ZPECustomFunction;
import jamiebalfour.zpe.interfaces.ZPELibrary;
import jamiebalfour.zpe.interfaces.ZPESyntaxTranspiler;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class ZPEPluginManager {
    static Map<String, ZPECustomFunction> IMPORTED_CUSTOM_COMMANDS = null;
    static Map<String, ZPELibrary> IMPORTED_PLUGINS = null;
    static ArrayList<String> loadedPlugins = null;

    ZPEPluginManager() {
    }

    static void traverseDirectory(String directory) {
        File[] directoryListing;
        File dir = new File(directory);
        if (dir.exists() && (directoryListing = dir.listFiles()) != null) {
            for (File child : directoryListing) {
                if (!child.getName().startsWith("libZPE_") || !child.getName().endsWith(".jar")) continue;
                ZPEPluginManager.getLibrary(child);
                loadedPlugins.add(child.getAbsolutePath());
            }
        }
    }

    static String[] addPlugins() {
        if (loadedPlugins == null) {
            loadedPlugins = new ArrayList();
        }
        if (IMPORTED_CUSTOM_COMMANDS == null) {
            IMPORTED_CUSTOM_COMMANDS = new HashMap<String, ZPECustomFunction>();
            ZPEPluginManager.traverseDirectory(ZPEInstance.LIBRARY_IMPORT_DIRECTORY);
        }
        if (IMPORTED_PLUGINS == null) {
            IMPORTED_PLUGINS = new HashMap<String, ZPELibrary>();
            ZPEPluginManager.traverseDirectory(ZPEInstance.PLUGIN_DIRECTORY);
        }
        String[] output = new String[loadedPlugins.size()];
        int i = 0;
        Iterator<String> iterator2 = loadedPlugins.iterator();
        while (iterator2.hasNext()) {
            String s;
            output[i] = s = iterator2.next();
            ++i;
        }
        return output;
    }

    public static ArrayList<String> listTranspilerNames() {
        File[] directoryListing;
        ArrayList<String> output = new ArrayList<String>();
        File dir = new File(ZPEInstance.TRANSPILERS_DIRECTORY);
        if (dir.exists() && (directoryListing = dir.listFiles()) != null) {
            for (File child : directoryListing) {
                if (!child.toString().endsWith(".jar")) continue;
                try {
                    URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{child.toURI().toURL()});
                    Class<?> plug = classLoader.loadClass("Transpiler");
                    ZPESyntaxTranspiler lib = (ZPESyntaxTranspiler)plug.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    output.add(lib.getLanguageName());
                }
                catch (Exception e) {
                    ZPE.log("Plugin " + child.getName() + " could not be loaded.");
                }
            }
        }
        return output;
    }

    public static ZPESyntaxTranspiler getTranspiler(String language_name) {
        File dir = new File(ZPEInstance.TRANSPILERS_DIRECTORY);
        if (!dir.exists()) {
            return null;
        }
        File[] directoryListing = dir.listFiles();
        if (directoryListing == null) {
            return null;
        }
        for (File child : directoryListing) {
            if (!child.toString().endsWith(".jar")) continue;
            try {
                URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{child.toURI().toURL()});
                Class<?> plug = classLoader.loadClass("Transpiler");
                ZPESyntaxTranspiler lib = (ZPESyntaxTranspiler)plug.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!lib.getLanguageName().equals(language_name)) continue;
                return lib;
            }
            catch (Exception e) {
                ZPE.log("The transpiler found at " + child + " could not be added.");
            }
        }
        return null;
    }

    public static void getLibrary(File child) {
        try {
            URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{child.toURI().toURL()});
            Class<?> plug = classLoader.loadClass("Plugin");
            Object p = plug.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (p instanceof ZPELibrary) {
                ZPELibrary lib = (ZPELibrary)p;
                IMPORTED_PLUGINS.put(lib.getName(), lib);
                if (lib.getFunctions() != null) {
                    for (String c : lib.getFunctions().keySet()) {
                        IMPORTED_CUSTOM_COMMANDS.put(c, lib.getFunctions().get(c));
                    }
                }
                if (lib.getObjects() != null) {
                    for (String n : lib.getObjects().keySet()) {
                        ZPEInstance.BUILT_IN_STRUCTURES.put(n, lib.getObjects().get(n));
                    }
                }
            } else {
                ZPE.log("The plugin " + child.getName() + " is not a valid plugin library");
            }
        }
        catch (Exception e) {
            e.getMessage();
            ZPE.log("The plugin " + child.getName() + " is not a valid plugin library");
        }
    }
}

