/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.Pair;
import jamiebalfour.zpe.core.YASSByteCodes;
import jamiebalfour.zpe.core.YASSCompiler;
import jamiebalfour.zpe.core.YASSPredefinedFunctions;
import jamiebalfour.zpe.core.YASSUnfold;
import jamiebalfour.zpe.core.ZPEFunction;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEPluginManager;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.InternalException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEException;
import jamiebalfour.zpe.interfaces.ZPEInternalFunction;
import jamiebalfour.zpe.interfaces.ZPESyntaxTranspiler;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.parser.v4.ZenithParsingEngine;
import jamiebalfour.zpe.types.ZPEString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ZPEKit {
    public static IAST compile(String code) throws CompileException {
        YASSCompiler compiler = new YASSCompiler();
        return compiler.compile(code);
    }

    public static Pair compile(String code, String file, String name, String author, boolean includeMainFunction) throws IOException, CompileException {
        return ZPEKit.compile(code, file, name, author, false, includeMainFunction, null, null);
    }

    public static Pair compile(String code, String file, String name, String author, boolean includeMainFunction, String passcode) throws IOException, CompileException {
        return ZPEKit.compile(code, file, name, author, false, includeMainFunction, passcode, null);
    }

    public static Pair compile(String code, String file, String name, String author, boolean caseInsensitive, boolean includeMainFunction, String passcode, String[] filesToInclude) throws IOException, CompileException {
        YASSCompiler compiler = new YASSCompiler();
        YASSCompiler.CompileDetails details = new YASSCompiler.CompileDetails(name, author);
        return compiler.compile(code, file, details, caseInsensitive, includeMainFunction, passcode, filesToInclude);
    }

    public static boolean validateCode(String code) throws CompileException {
        YASSCompiler compiler = new YASSCompiler();
        return compiler.validateCode(code);
    }

    public static ArrayList<String> getFunctionNames(String code) throws CompileException {
        YASSCompiler compiler = new YASSCompiler();
        return compiler.getFunctionNames(code);
    }

    public static ZPEType runApplication(String file, ZPEString[] arguments, String passcode, int permissionLevel) throws Exception {
        ZPERuntimeEnvironment runtime = new ZPERuntimeEnvironment(permissionLevel);
        return runtime.runApplication(file, arguments, passcode);
    }

    public static String getFunctionManualHeader(String func) {
        Class<? extends ZPEInternalFunction> c = YASSPredefinedFunctions.getInternalMethod(func);
        if (c == null && YASSPredefinedFunctions.hasInternalAlias(func)) {
            c = YASSPredefinedFunctions.getInternalMethod(YASSPredefinedFunctions.getFunctionFromAlias(func));
        }
        return YASSPredefinedFunctions.getManualHeader(c);
    }

    public static String getFunctionManualEntry(String func) {
        Class<? extends ZPEInternalFunction> c = YASSPredefinedFunctions.getInternalMethod(func);
        return YASSPredefinedFunctions.getManualEntry(c);
    }

    public static String getFunctionManualEntryAsHtml(String func) {
        Class<? extends ZPEInternalFunction> c = YASSPredefinedFunctions.getInternalMethod(func);
        return YASSPredefinedFunctions.getManualEntryAsHTML(c);
    }

    public static String getFunctionManualEntryAsStyledHtml(String func, boolean darkStyle) {
        Class<? extends ZPEInternalFunction> c = YASSPredefinedFunctions.getInternalMethod(func);
        return YASSPredefinedFunctions.getManualEntryAsStyledHTML(c, darkStyle);
    }

    public static String getFunctionCategory(String func) {
        Class<? extends ZPEInternalFunction> c = YASSPredefinedFunctions.getInternalMethod(func);
        return YASSPredefinedFunctions.getCategory(c);
    }

    public static byte getFunctionReturnType(String func) {
        Class<? extends ZPEInternalFunction> c = YASSPredefinedFunctions.getInternalMethod(func);
        return YASSPredefinedFunctions.getReturnType(c);
    }

    public static double getFunctionVersion(String func) {
        Class<? extends ZPEInternalFunction> c = YASSPredefinedFunctions.getInternalMethod(func);
        return YASSPredefinedFunctions.getVersion(c);
    }

    public static int getFunctionMinimumPermissionLevels(String func) {
        Class<? extends ZPEInternalFunction> c = YASSPredefinedFunctions.getInternalMethod(func);
        return YASSPredefinedFunctions.requiredPermissionLevels(c);
    }

    public static byte[] parseToBytes(String code) {
        return new ZPERuntimeEnvironment(5).parseToBytes(code);
    }

    public static ZPEType interpret(String code, int permissionLevel) throws CompileException, ZPERuntimeException, ExitHalt, BreakPointHalt {
        return new ZPERuntimeEnvironment(permissionLevel).interpret(code);
    }

    public static ZPEType interpret(String code, ZPEType[] parameters, int permissionLevel) throws CompileException, ZPERuntimeException, ExitHalt, BreakPointHalt {
        return new ZPERuntimeEnvironment(permissionLevel).interpret(code, parameters);
    }

    public static ZPEType interpret(String code, ZPEType[] parameters, boolean caseInsensitive, int permissionLevel) throws CompileException, ZPERuntimeException, ExitHalt, BreakPointHalt {
        return new ZPERuntimeEnvironment(permissionLevel).interpret(code, parameters, caseInsensitive);
    }

    public static ZPEType interpret(ZPERuntimeEnvironment runtime, String code, ZPEType[] parameters, boolean caseInsensitive) throws CompileException, ZPERuntimeException, ExitHalt, BreakPointHalt {
        return runtime.interpret(code, parameters, caseInsensitive);
    }

    public static ZPEType interpret(ZPERuntimeEnvironment runtime, String code, ZPEType[] parameters, boolean caseInsensitive, Map<String, ZPEType> globalVariables, boolean retainVariableState) throws CompileException, ZPERuntimeException, ExitHalt, BreakPointHalt {
        runtime.globalVariables = globalVariables;
        runtime.retainVariableState = retainVariableState;
        return runtime.interpret(code, parameters, caseInsensitive);
    }

    public static String cleanUpString(String code) {
        ZenithParsingEngine parser = new ZenithParsingEngine(code, ZPEInstance.CASE_INSENSITIVE, new YASSByteCodes());
        StringBuilder out = new StringBuilder();
        parser.getNextSymbol();
        while (parser.getCurrentSymbol() != -2) {
            out.append(" ").append(parser.getCurrentWord());
            parser.getNextSymbol();
        }
        return out.toString();
    }

    public static String[] parseToString(String code) {
        ZenithParsingEngine parser = new ZenithParsingEngine(code, ZPEInstance.CASE_INSENSITIVE, new YASSByteCodes());
        ArrayList<String> out = new ArrayList<String>();
        parser.getNextSymbol();
        int pos = 0;
        while (parser.getCurrentSymbol() != -2) {
            YASSByteCodes b = new YASSByteCodes();
            out.add(b.symbolToString(parser.getCurrentSymbol()));
            parser.getNextSymbol();
        }
        String[] arr = new String[out.size()];
        for (String s : out) {
            arr[pos++] = s;
        }
        return arr;
    }

    public static ArrayList<String> getAllCommands() {
        return YASSPredefinedFunctions.getCommands();
    }

    public static ArrayList<String> getAllAliases() {
        return YASSPredefinedFunctions.getAliases();
    }

    public static boolean internalFunctionExists(String func) {
        return YASSPredefinedFunctions.hasInternalMethod(func);
    }

    public static boolean internalAliasExists(String alias) {
        return YASSPredefinedFunctions.hasInternalAlias(alias);
    }

    public static String getFunctionNameFromAlias(String alias) {
        if (YASSPredefinedFunctions.hasInternalAlias(alias)) {
            return YASSPredefinedFunctions.getFunctionFromAlias(alias);
        }
        return null;
    }

    public static String convertCode(String code, String className, ZPESyntaxTranspiler transpiler) throws ZPEException, InternalException {
        return new ZPERuntimeEnvironment(5).convertCode(code, className, transpiler);
    }

    public static String unfold(String code, boolean asHtml) throws CompileException {
        YASSUnfold y = new YASSUnfold();
        StringBuilder description = new StringBuilder();
        ArrayList<String> sentences = y.explain(code, asHtml);
        for (int i = 0; i < sentences.size(); ++i) {
            String current = ZPEHelperFunctions.capitalize(sentences.get(i));
            if (i + 1 == sentences.size() - 1) {
                description.append(current);
                continue;
            }
            if (i == sentences.size() - 1 && sentences.size() != 1) {
                if (!description.toString().endsWith(" ")) {
                    description.append(" ");
                }
                description.append("Finally, ");
                description.append(sentences.get(i));
                continue;
            }
            if (sentences.size() > 1) {
                description.append(current);
                description.append(". ").append(System.lineSeparator());
                continue;
            }
            description.append(current);
        }
        String output = description.toString();
        if (asHtml) {
            return output.replaceAll(System.lineSeparator(), "<br>");
        }
        return output;
    }

    public static String getInstallPath() {
        return ZPEInstance.INSTALL_PATH;
    }

    public static ArrayList<String> listTranspilerNames() {
        return ZPEPluginManager.listTranspilerNames();
    }

    public static ZPESyntaxTranspiler getTranspilerByName(String name) {
        return ZPEPluginManager.getTranspiler(name);
    }

    public static String[] getBuiltInFunctions() {
        return YASSPredefinedFunctions.getCommands().toArray(new String[YASSPredefinedFunctions.getCommands().size()]);
    }

    public static String[] getKeywords() {
        return new String[]{"module", "if", "else", "elseif", "for", "while", "loop", "do", "until", "match", "function", "structure", "define", "declare", "var", "let", "each", "when", "is", "switch", "case", "end", "default", "class", "new", "as", "in", "to", "and", "or", "equal", "nequal", "asserts", "then", "not", "return", "import", "includes", "try", "catch", "public", "private", "protected", "break", "inherits", "be", "by", "static", "record", "create", "global", "cast", "count", "is_set", "unset", "empty", "online", "namespace", "#breakpoint#"};
    }

    public static String[] getTypeKeywords() {
        return new String[]{"string", "number", "boolean", "object", "record", "list", "map", "fn", "mixed"};
    }

    public static String[] getDirectiveKeywords() {
        return new String[]{"@doc", "@author", "@date", "@directive"};
    }

    public static String[] getKeySymbols() {
        return new String[]{"+", "-", "*", "/", "^", "=", "==", "!=", "!", "<", ">", "<=", ">=", "+=", "-=", "*=", "/=", "^=", "&", "|", "?", ":"};
    }

    public static HashMap<Integer, String> getByteCodes() {
        HashMap<Integer, String> output = new HashMap<Integer, String>();
        YASSByteCodes b = new YASSByteCodes();
        for (int i = -127; i < 128; ++i) {
            if (b.symbolToString(i).equals("UNUSED")) continue;
            output.put(i, b.symbolToString(i));
        }
        return output;
    }

    public static ZPEType getGlobalVariable(ZPERuntimeEnvironment environment, String name) {
        return environment.getGlobalVariable(name);
    }

    public static ZPEType runPredefinedInternalFunction(ZPERuntimeEnvironment runtime, String name, IAST parameters) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        return runtime.runInternalFunction(name, parameters);
    }

    public static ZPEType runCode(ZPERuntimeEnvironment runtime, String code, HashMap<String, ZPEType> params) throws CompileException, ZPERuntimeException, ExitHalt, BreakPointHalt {
        return runtime.runCode(code, params);
    }

    public static ZPEType runCode(ZPERuntimeEnvironment runtime, IAST code, HashMap<String, ZPEType> params) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
        return runtime.runCode(code, params);
    }

    public static void setDebugging(boolean on) {
        ZPEInstance.DEBUGGING = on;
    }

    public static boolean isDebugging() {
        return ZPEInstance.DEBUGGING;
    }

    public static String getConfigurationPath() {
        return ZPEInstance.CONFIGURATION_PATH;
    }

    public static String getBaseSettingsPath() {
        return ZPEInstance.BASE_SETTINGS_PATH;
    }

    public static ZPEType runFunction(ZPEFunction f, ZPEType[] arguments) throws ZPERuntimeException, ExitHalt, BreakPointHalt, InternalException {
        return new ZPERuntimeEnvironment().runFunction(f, arguments);
    }

    public static ZPEFunction getGlobalFunction(ZPERuntimeEnvironment z) {
        return z.globalFunction;
    }
}

