/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.YASSByteCodes;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEEntity;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEModule;
import jamiebalfour.zpe.core.ZPEMultipleReturnArray;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.core.ZPEVariable;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.IncorrectDataTypeException;
import jamiebalfour.zpe.exceptions.InternalException;
import jamiebalfour.zpe.exceptions.UnacceptableTypeException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPECoreType;
import jamiebalfour.zpe.interfaces.ZPEException;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPERecord;
import jamiebalfour.zpe.types.ZPEString;
import java.io.Serializable;
import java.util.ArrayList;

public class ZPEFunction
extends ZPEEntity
implements ZPEPropertyWrapper,
Serializable {
    private static final long serialVersionUID = -850016119239300066L;
    ZPEPropertyWrapper parent = null;
    int scope = 0;
    String name;
    BinarySearchTree<String, ZPEVariable> variableMap = new BinarySearchTree();
    BinarySearchTree<String, ZPEVariable> parameterMap = new BinarySearchTree();
    ArrayList<String> parameterNames = new ArrayList();
    BinarySearchTree<String, ZPEFunction> functionMap = new BinarySearchTree();
    Object documentation = null;
    IAST code;
    ZPEType lastReturn = null;
    boolean mustReturn = false;
    int breakBubbles = 0;
    boolean acceptInfiniteParams = false;
    boolean isAnAnonymousFunction;
    byte[] returnTypes = new byte[]{118};

    @Override
    public ZPEPropertyWrapper getParent() {
        return this.parent;
    }

    @Override
    public ZPERuntimeEnvironment getRuntime() {
        return this.ownerRuntime;
    }

    void setParent(ZPEPropertyWrapper p) {
        this.parent = p;
    }

    public ArrayList<String> getParameterNames() {
        return this.parameterNames;
    }

    void addParameter(String id) throws ZPERuntimeException {
        this.addParameter(id, (byte)118);
    }

    public void addParameter(String id, byte type) throws ZPERuntimeException {
        if (!this.parameterMap.containsKey(id)) {
            ZPEVariable v = this.createGeneralVariable(id, null, 1, 0, this, type);
            this.parameterMap.put(id, v);
            this.parameterNames.add(id);
        }
    }

    public void setParameter(String id, ZPEType value) throws ZPERuntimeException {
        try {
            this.parameterMap.get(id).setValue(value);
        }
        catch (ClassCastException e) {
            if (this.name.isEmpty()) {
                ZPE.printError(this.getIncorrect() + " type passed for parameter `" + id + "` in anonymous function");
            }
            ZPE.printError("Incorrect type passed for parameter `" + id + "` in function `" + this.name + "`");
        }
    }

    private String getIncorrect() {
        return "Incorrect";
    }

    ZPEList getParameterIds() {
        ZPEList output = new ZPEList();
        output.addAll(this.parameterMap.keySet());
        return output;
    }

    public String toString() {
        if (this.name.isEmpty()) {
            return "FUNCTION: {Anonymous}";
        }
        return "FUNCTION: {" + this.name + "}";
    }

    ZPEFunction(ZPERuntimeEnvironment zx, String n, IAST c, boolean anonymous) {
        this.name = n;
        this.code = c;
        this.isAnAnonymousFunction = anonymous;
        this.ownerRuntime = zx;
    }

    @Override
    public boolean hasVariable(String id) {
        return this.variableMap.containsKey(id);
    }

    @Override
    public void removeProperty(String n) {
        if (this.variableMap.containsKey(n)) {
            this.variableMap.get(n).destroy();
            this.variableMap.put(n, null);
            this.variableMap.remove(n);
            this.variableMap.keySet().remove(n);
        } else if (this.parent != null) {
            if (this.parent.hasVariable(n)) {
                this.parent.removeProperty(n);
            }
        } else if (this.getRuntime().globalVariableExists(n)) {
            this.getRuntime().removeGlobalVariable(n);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setProperty(String n, ZPEType value) throws ZPERuntimeException {
        this.setProperty(n, value, (byte)118);
    }

    @Override
    public void setProperty(String n, ZPEType value, byte type) throws ZPERuntimeException {
        try {
            if (this.ownerRuntime.monitorFunction != null && this.ownerRuntime.monitorVar != null && this.name.equals(this.ownerRuntime.monitorFunction) && n.equals("$" + this.ownerRuntime.monitorVar)) {
                System.out.println(ZPEHelperFunctions.setConsoleEffectToMagenta("<Watched variable `$" + this.ownerRuntime.monitorVar + "` in function `" + this.ownerRuntime.monitorFunction + "` has changed to " + value + ">"));
            }
            if (this.variableMap.containsKey(n)) {
                this.getRawVariable(n).setValue(value);
            } else if (this.parameterMap.containsKey(n)) {
                this.parameterMap.remove(n);
                this.pushProperty(n, this.createGeneralVariable(n, value, 0, 0, this, (byte)118));
            } else if (this.parent != null && this.parent.hasVariable(n)) {
                ZPEVariable var = this.getParent().getRawVariable(n);
                var.setValue(value);
            } else if (this.getRuntime().globalVariableExists(n)) {
                this.getRuntime().addGlobalVariable(n, value, 0, type);
            } else {
                this.pushProperty(n, this.createGeneralVariable(n, value, 0, 0, this, type));
            }
        }
        catch (ClassCastException e) {
            if (this.name.isEmpty()) {
                ZPE.printError("Incorrect type assigned to variable `" + n + "` in anonymous function");
            }
            ZPE.printError("Incorrect type assigned to variable `" + n + "` in function `" + this.name + "`");
        }
    }

    @Override
    public ZPEVariable getRawVariable(String n) {
        if (this.hasVariable(n)) {
            return this.variableMap.get(n);
        }
        return null;
    }

    void pushProperty(String n, ZPEVariable v) {
        this.variableMap.put(n, v);
    }

    @Override
    public ZPEType getVariable(String n) {
        if (this.variableMap.containsKey(n)) {
            return this.variableMap.get(n).getValue();
        }
        if (this.parameterMap.containsKey(n)) {
            return this.parameterMap.get(n).getValue();
        }
        if (this.parent != null) {
            return this.parent.getVariable(n);
        }
        if (this.getRuntime().globalVariableExists(n)) {
            return this.getRuntime().getGlobalVariable(n);
        }
        return ZPE.UNDEFINED;
    }

    private boolean isValidReturnType() {
        for (byte returnType : this.returnTypes) {
            if (!ZPEHelperFunctions.checkType(this.lastReturn, returnType)) continue;
            return true;
        }
        return false;
    }

    public ZPEType run() throws ExitHalt, ZPERuntimeException, BreakPointHalt {
        try {
            this.mustReturn = false;
            this.lastReturn = null;
            this.getRuntime().pushToCallStack(this);
            if (this.isAnAnonymousFunction) {
                this.traverse(this.code);
            } else if (this.code.left != null) {
                this.traverse(this.code.left);
            }
            this.getRuntime().removeFromCallStack();
            if (this.lastReturn != null && !this.isValidReturnType()) {
                YASSByteCodes y = new YASSByteCodes();
                throw new UnacceptableTypeException("Runtime exception occurred in '" + this.name + "' => \"Incorrect data type " + y.symbolToString(ZPEHelperFunctions.getDataType(this.lastReturn)) + " returned.\"");
            }
            return this.lastReturn;
        }
        catch (ClassCastException e) {
            Object msg = "Casting error";
            ZPE.log(e.getMessage());
            if (!e.getMessage().contains("java")) {
                msg = "Casting error: " + e.getMessage();
            }
            if (ZPEInstance.ERROR_LEVEL >= 3) {
                ZPE.printError("Java stack trace as follows:");
                e.printStackTrace();
            }
            ZPE.printError("Runtime exception occurred in '" + this.name + "' => \"" + (String)msg + "\"");
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            Object msg = "Index out of range";
            if (!e.getMessage().contains("java")) {
                msg = "Index out of range: " + e.getMessage();
            }
            ZPE.log(e.getMessage());
            ZPE.printError("Runtime exception occurred in '" + this.name + "' => \"" + (String)msg + "\"");
            if (ZPEInstance.ERROR_LEVEL >= 3) {
                ZPE.printError("Java stack trace as follows:");
                e.printStackTrace();
            }
            return null;
        }
        catch (BreakPointHalt | ExitHalt | ZPERuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Error has been logged if logging is enabled.";
            ZPE.log(e.getMessage());
            ZPE.printError("Runtime exception occurred in \"" + this.name + "\" => \"" + msg + "\"");
            this.printZPEStack();
            if (ZPEInstance.ERROR_LEVEL >= 3) {
                ZPE.printError("Java stack trace as follows:");
                e.printStackTrace();
            }
            return null;
        }
    }

    ZPEType evaluateTemplate(IAST n) throws ExitHalt, BreakPointHalt, ZPEException {
        IAST current = (IAST)n.value;
        StringBuilder output = new StringBuilder();
        while (current != null) {
            if (current.type == 4) {
                output.append(current.value.toString());
            } else {
                output.append(this.getRuntime().evaluateExpression((IAST)current.value, this));
            }
            current = current.next;
        }
        return new ZPEString(output.toString());
    }

    void assignVariable(IAST node) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ZPEType current;
        ZPEType value = null;
        IAST var = node.middle;
        if (node.value instanceof String) {
            value = new ZPEString((String)node.value);
        } else if (node.value instanceof IAST) {
            IAST innerNode = (IAST)node.value;
            if (innerNode.type == -9 && innerNode.value instanceof IAST && ((IAST)innerNode.value).type == 4) {
                value = this.getRuntime().evaluateExpression(innerNode, this);
                if (value instanceof ZPECoreType && ((IAST)((IAST)node.value).value).type != 87) {
                    value = ((ZPECoreType)value).copyOfMe();
                }
            } else if (innerNode.value instanceof IAST && ((IAST)innerNode.value).type == -16) {
                value = this.evaluateTemplate((IAST)innerNode.value);
            } else {
                value = this.getRuntime().evaluateExpression(innerNode, this);
                IAST nVal = (IAST)node.value;
                if (value instanceof ZPECoreType && nVal.value != null && ((IAST)nVal.value).type != 87) {
                    value = ((ZPECoreType)value).copyOfMe();
                }
            }
        }
        if (node.left != null && node.left.type == 62) {
            this.setProperty(var.id, value, (Byte)node.left.value);
            return;
        }
        if (var.type == 88) {
            if (var.left.type == 4) {
                var.left.type = (byte)87;
            }
            current = this.getRuntime().evaluateExpression(var.left, this);
            ZPEType index = this.getRuntime().evaluateExpression((IAST)var.value, this);
            ZPEType output = ZPERuntimeEnvironment.setIndex(current, index, value);
            this.setProperty(var.id, output);
        } else if (var.type == 111) {
            current = this.getVariable(var.id);
            if (current instanceof ZPERecord) {
                ZPERecord r = (ZPERecord)current;
                r.setField(var.left.id, value);
            }
        } else if (var.type == 66) {
            current = var.middle.type == 70 ? this.getParentObject() : this.getRuntime().evaluateExpression(var.middle, this);
            if (!(current instanceof ZPEObject)) {
                throw new IncorrectDataTypeException("object or structure", "accessor evaluate");
            }
            ZPEObject obj = (ZPEObject)current;
            IAST access = (IAST)var.value;
            obj = obj.setInnerValue(access, this.getRuntime().evaluateExpression((IAST)node.value, this), this);
            this.setProperty(var.middle.id, obj);
        } else if (value instanceof ZPEMultipleReturnArray) {
            value = ((ZPEMultipleReturnArray)value).elements.get(0);
            this.setProperty(var.id, value, (byte)118);
        } else {
            this.setProperty(var.id, value, (byte)118);
        }
    }

    void printStack() {
        for (StackTraceElement o : Thread.currentThread().getStackTrace()) {
            ZPE.print(o.getMethodName());
        }
    }

    void printZPEStack() {
        System.err.println("Call stack {" + this.hashCode() + "} as follows:");
        while (!this.getRuntime().callStack.empty()) {
            System.err.println(this.getRuntime().callStack.pop().toString());
        }
    }

    ZPEType traverse(IAST code) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        IAST current = code;
        ZPEType last = null;
        while (current != null) {
            if (current.type == 84 && !this.mustReturn) {
                ZPEType value;
                if (current.left.next != null) {
                    ZPEMultipleReturnArray arr = new ZPEMultipleReturnArray();
                    IAST currentReturn = current.left;
                    while (currentReturn != null) {
                        arr.elements.add(this.getRuntime().LAME.evaluateExpressions(currentReturn));
                        currentReturn = currentReturn.next;
                    }
                    this.lastReturn = arr;
                    this.mustReturn = true;
                    return arr;
                }
                this.lastReturn = value = this.getRuntime().LAME.evaluateExpressions(current.left);
                this.mustReturn = true;
                return value;
            }
            last = ZPERuntimeEnvironment.constructTraverse(current, this, this.getRuntime());
            current = current.next;
        }
        return last;
    }

    boolean mustBreak() {
        if (this.breakBubbles > 0) {
            this.breakBubbles = 0;
            return true;
        }
        return false;
    }

    public ZPEFunction getFunction(String id) {
        if (id.contains("~")) {
            String[] parts = id.split("~");
            ZPEModule m = this.ownerRuntime.modules.get(parts[0]);
            return m.getFunction(parts[1]);
        }
        if (this.functionMap.containsKey(id)) {
            return this.functionMap.get(id);
        }
        if (this.parent != null) {
            if (this.parent instanceof ZPEFunction) {
                ZPEFunction p = (ZPEFunction)this.parent;
                return p.getFunction(id);
            }
            if (this.parent instanceof ZPEStructure) {
                ZPEStructure p = (ZPEStructure)this.parent;
                return p.getFunction(id);
            }
            if (this.parent instanceof ZPEObject) {
                ZPEObject p = (ZPEObject)this.parent;
                return p.getFunction(id);
            }
            if (this.parent instanceof ZPEModule) {
                ZPEModule p = (ZPEModule)this.parent;
                return p.getFunction(id);
            }
        }
        return null;
    }

    public ZPEFunction getInstanceOfMe() throws ZPERuntimeException {
        ZPEFunction functionCopy = new ZPEFunction(this.getRuntime(), this.name, this.code, this.name.isEmpty());
        functionCopy.returnTypes = this.returnTypes;
        functionCopy.parent = this.parent;
        functionCopy.parameterNames = this.parameterNames;
        for (String s : this.parameterMap.keySet()) {
            ZPEVariable x = this.parameterMap.get(s);
            ZPEType value = x.getValue();
            functionCopy.parameterMap.put(s, ZPEHelperFunctions.createTypedVariable(s, value, 0, 0, functionCopy, x.getAssignedType()));
        }
        functionCopy.acceptInfiniteParams = this.acceptInfiniteParams;
        return functionCopy;
    }

    @Override
    public ZPEType copyOfMe() {
        return this.getInstanceOfMe();
    }
}

