/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe;

import jamiebalfour.zpe.parser.Tokeniser;
import jamiebalfour.zpe.parser.ZPEComment;
import java.util.ArrayList;

public class SQARLParserByteCodes
implements Tokeniser {
    static final String INTEGER_REGEX = "(((-?[1-9]+)|[0-9][0-9]*)(E[0-9]+)?)";
    static final String DOUBLE_REGEX = "(-?[0-9]+((\\.)[0-9]+))(E[0-9]+)?";
    static final String STRING_REGEX = "(\".*\")|('.*')";
    static final String NULL_REGEX = "null";
    static final String BOOLEAN_REGEX = "(true|false)";
    static final String IDENTIFIER_REGEX = "([A-z][A-z0-9_]*)";
    static final byte ARRAY = -1;
    static final byte DECLARE = 0;
    static final byte AS = 1;
    static final byte TYPE = 2;
    static final byte INITIALLY = 3;
    static final byte FROM = 4;
    static final byte KEYBOARD = 5;
    static final byte RECEIVE = 6;
    static final byte SEND = 7;
    static final byte TO = 8;
    static final byte DISPLAY = 9;
    static final byte SET = 10;
    static final byte IDENTIFIER = 11;
    static final byte REPEAT = 12;
    static final byte UNTIL = 13;
    static final byte IF = 14;
    static final byte THEN = 15;
    static final byte END = 16;
    static final byte WHILE = 17;
    static final byte DO = 18;
    static final byte FOR = 19;
    static final byte EACH = 20;
    static final byte ELSE = 21;
    static final byte INT = 29;
    static final byte STRING = 30;
    static final byte BOOLEAN = 31;
    static final byte REAL = 32;
    static final byte ASSIGNMENT = 33;
    static final byte AND = 40;
    static final byte OR = 41;
    static final byte NOT = 42;
    static final byte NEQUAL = 43;
    static final byte EQUAL = 44;
    static final byte GT = 45;
    static final byte LT = 46;
    static final byte GTE = 47;
    static final byte LTE = 48;
    static final byte PLUS = 49;
    static final byte MINUS = 50;
    static final byte DIVIDE = 51;
    static final byte MULT = 52;
    static final byte MOD = 53;
    static final byte CONCAT = 54;
    static final byte LBRACE = 58;
    static final byte RBRACE = 59;
    static final byte LBRA = 60;
    static final byte RBRA = 61;
    static final byte LSQBR = 62;
    static final byte RSQBR = 63;
    static final byte COMMA = 70;
    static final byte PROCEDURE = 71;
    static final byte FUNCTION = 72;
    static final byte RETURN = 73;
    static final byte CLASS = 74;
    static final byte IS = 75;
    static final byte OF = 76;
    static final byte METHODS = 77;
    static final byte CONSTRUCTOR = 78;
    static final byte RETURNS = 79;
    static final byte RECORD = 80;

    @Override
    public byte stringToByteCode(String w) {
        switch (w) {
            case "DECLARE": {
                return 0;
            }
            case "AS": {
                return 1;
            }
            case "INTEGER": 
            case "BOOLEAN": 
            case "REAL": 
            case "STRING": {
                return 2;
            }
            case "ARRAY": {
                return -1;
            }
            case "INITIALLY": {
                return 3;
            }
            case "FROM": {
                return 4;
            }
            case "KEYBOARD": {
                return 5;
            }
            case "RECEIVE": {
                return 6;
            }
            case "CLASS": {
                return 74;
            }
            case "RECORD": {
                return 80;
            }
            case "IS": {
                return 75;
            }
            case "OF": {
                return 76;
            }
            case "METHODS": {
                return 77;
            }
            case "CONSTRUCTOR": {
                return 78;
            }
            case "SEND": {
                return 7;
            }
            case "TO": {
                return 8;
            }
            case "DISPLAY": {
                return 9;
            }
            case "SET": {
                return 10;
            }
            case "AND": {
                return 40;
            }
            case "OR": {
                return 41;
            }
            case "NOT": {
                return 42;
            }
            case "&": {
                return 54;
            }
            case "!=": {
                return 43;
            }
            case "=": {
                return 33;
            }
            case "==": {
                return 44;
            }
            case ">": {
                return 45;
            }
            case "<": {
                return 46;
            }
            case ">=": {
                return 47;
            }
            case "<=": {
                return 48;
            }
            case "(": {
                return 60;
            }
            case ")": {
                return 61;
            }
            case "{": {
                return 58;
            }
            case "}": {
                return 59;
            }
            case "[": {
                return 62;
            }
            case "]": {
                return 63;
            }
            case ",": {
                return 70;
            }
            case "+": {
                return 49;
            }
            case "ELSE": {
                return 21;
            }
            case "-": {
                return 50;
            }
            case "/": {
                return 51;
            }
            case "*": {
                return 52;
            }
            case "MOD": {
                return 53;
            }
            case "REPEAT": {
                return 12;
            }
            case "IF": {
                return 14;
            }
            case "THEN": {
                return 15;
            }
            case "WHILE": {
                return 17;
            }
            case "FOR": {
                return 19;
            }
            case "EACH": {
                return 20;
            }
            case "DO": {
                return 18;
            }
            case "UNTIL": {
                return 13;
            }
            case "PROCEDURE": {
                return 71;
            }
            case "FUNCTION": {
                return 72;
            }
            case "END": {
                return 16;
            }
            case "RETURN": {
                return 73;
            }
            case "RETURNS": {
                return 79;
            }
        }
        if (w.matches(INTEGER_REGEX)) {
            return 29;
        }
        if (w.matches(BOOLEAN_REGEX)) {
            return 31;
        }
        if (w.matches(DOUBLE_REGEX)) {
            return 32;
        }
        if (w.matches(STRING_REGEX)) {
            return 30;
        }
        if (w.matches(IDENTIFIER_REGEX)) {
            return 11;
        }
        return -2;
    }

    @Override
    public String symbolToString(int i) {
        return null;
    }

    @Override
    public String[] listOfSubsequentCharacters() {
        return new String[]{"<=", ">=", "=="};
    }

    @Override
    public String[] listOfBoundWords() {
        return new String[0];
    }

    @Override
    public String[] listOfWhitespaces() {
        return new String[]{" ", "\n", "\r", "\r\n", "\t", System.lineSeparator()};
    }

    @Override
    public ArrayList<ZPEComment> listOfComments() {
        ArrayList<ZPEComment> a = new ArrayList<ZPEComment>();
        a.add(new ZPEComment("#", System.lineSeparator()));
        a.add(new ZPEComment("(<", ")"));
        return a;
    }

    @Override
    public String delimiterCharacters() {
        return " (),[]=<>!&|{}+-/*%@.;?:$^\u2227\r\n" + System.lineSeparator();
    }

    @Override
    public String quoteTypes() {
        return "\"'";
    }
}

