/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe;

import jamiebalfour.HelperFunctions;
import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.BalfWindow;
import jamiebalfour.zpe.PythonTranspiler;
import jamiebalfour.zpe.SQARLAboutDialog;
import jamiebalfour.zpe.SQARLParser;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.editor.CodeEditorView;
import jamiebalfour.zpe.editor.ZPEEditor;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.gui.ZPEConsole;
import jamiebalfour.zpe.interfaces.GenericEditor;
import jamiebalfour.zpe.os.macos.macOS;
import jamiebalfour.zpe.types.ZPEString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Taskbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

class SQARLEditorMain
extends BalfWindow
implements GenericEditor {
    SQARLEditorMain _this = this;
    CodeEditorView mainSyntax;
    protected UndoHandler undoHandler = new UndoHandler();
    protected UndoManager undoManager = new UndoManager();
    ZPEConsole AttachedConsole;
    Process currentProcess;
    boolean propertiesChanged = false;
    Properties mainProperties;
    private final UndoAction undoAction;
    private final RedoAction redoAction;
    JEditorPane contentEditor;
    JScrollPane scrollPane;
    JCheckBoxMenuItem mnDarkModeMenuItem;
    JMenuItem mntmRecentMenuItem;
    String lastFileOpened = "";
    private boolean darkMode = false;
    JMenuItem mntmStopCodeMenuItem;
    JMenuItem mntmClearConsoleBeforeRunMenuItem;
    static FileNameExtensionFilter filter1 = new FileNameExtensionFilter("Text files (*.txt)", "txt");
    static FileNameExtensionFilter filter2 = new FileNameExtensionFilter("YASS Executable files (*.yex)", "yex");
    private final JFrame editor;
    JCheckBoxMenuItem chckbxmntmCaseSensitiveCompileCheckItem;
    ArrayList<String> recents = ZPEEditor.getRecentFiles("sqarl/");
    ImageIcon lighterLogo;
    ImageIcon lighterLogoFull;
    boolean dontUndo = true;
    Color borderColor = new Color(40, 75, 99);
    boolean isMaximised = false;

    private void maximiseButtonClicked() {
        if (this.isMaximised) {
            this.setExtendedState(0);
            this.setSize(800, 600);
            this.setLocationRelativeTo(null);
            this.getContentPane().setPreferredSize(new Dimension(800, 600));
            this.getContentPane().revalidate();
            this.getContentPane().repaint();
        } else {
            this.maximiseToCurrentScreen(this._this);
            this.getContentPane().setPreferredSize(null);
            this.getContentPane().revalidate();
            this.getContentPane().repaint();
        }
        this.isMaximised = !this.isMaximised;
    }

    public void maximiseToCurrentScreen(JFrame frame) {
        GraphicsConfiguration gc = frame.getGraphicsConfiguration();
        Rectangle screenBounds = gc.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        int x = screenBounds.x + screenInsets.left;
        int y = screenBounds.y + screenInsets.top;
        int width = screenBounds.width - screenInsets.left - screenInsets.right;
        int height = screenBounds.height - screenInsets.top - screenInsets.bottom;
        frame.setBounds(x, y, width, height);
        frame.setExtendedState(6);
    }

    public SQARLEditorMain() {
        super("SQARL Editor", 0, new Color(40, 75, 99), new Color(30, 60, 80), Color.white);
        this.setLayout(new BorderLayout());
        this.getTitleBar().setLabelText("Untitled");
        this.getTitleBar().setMaximiseButtonListener(e -> this.maximiseButtonClicked());
        this.getTitleBar().setCloseListener(e -> {
            this.closeUp();
            System.exit(0);
        });
        this.setBackground(this.borderColor);
        this.setTitle("SQARL Editor");
        URL imagePath = HelperFunctions.isMac() ? SQARLEditorMain.class.getResource("/files/SQARLLogoMacOS.png") : SQARLEditorMain.class.getResource("/files/SQARLLogoMacOS.png");
        assert (imagePath != null);
        this.lighterLogoFull = new ImageIcon(imagePath);
        Image newimg = this.lighterLogoFull.getImage().getScaledInstance(60, 60, 4);
        this.lighterLogo = new ImageIcon(newimg);
        HashMap<String, SimpleAttributeSet> SQARL_KEYWORDS = new HashMap<String, SimpleAttributeSet>(16);
        SQARL_KEYWORDS.put("DECLARE", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("INITIALLY", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("WHILE", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("RECEIVE", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("FROM", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("KEYBOARD", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("END", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("SEND", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("FOR", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("EACH", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("DO", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("IF", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("THEN", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("SET", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("TO", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("DISPLAY", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("ARRAY", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("STRING", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("RECORD", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("CLASS", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("INTEGER", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("REAL", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("BOOLEAN", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("CHARACTER", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("FUNCTION", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("RETURN", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("PROCEDURE", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("AND", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("OR", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("NOT", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("MOD", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("OPEN", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("CLOSE", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("CREATE", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("METHODS", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("THIS", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("WITH", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("OVERRIDE", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("INHERITS", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("CONSTRUCTOR", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("IS", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("AS", CodeEditorView.DEFAULT_KEYWORD);
        SQARL_KEYWORDS.put("ELSE", CodeEditorView.DEFAULT_KEYWORD);
        this.mainSyntax = new CodeEditorView(SQARL_KEYWORDS, "\"'", "");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int confirmed = JOptionPane.showConfirmDialog(SQARLEditorMain.this.editor, "Are you sure you want to exit the program?", "Exit Program Message Box", 0);
                if (confirmed == 0) {
                    SQARLEditorMain.this.dispose();
                    SQARLEditorMain.this.closeUp();
                    System.exit(0);
                }
            }
        });
        File f = new File(ZPEKit.getInstallPath() + "/sqarl/");
        if (!f.exists() && !f.mkdirs()) {
            ZPE.log(f + " could not be created");
        }
        String path = ZPEKit.getInstallPath() + "/sqarl/gui.properties";
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
        }
        try {
            this.mainProperties = HelperFunctions.readProperties(path);
        }
        catch (Exception e2) {
            // empty catch block
        }
        this.editor = this;
        if (this.mainProperties.containsKey("HEIGHT")) {
            this.editor.setSize(this.editor.getWidth(), HelperFunctions.stringToInteger(this.mainProperties.get("HEIGHT").toString()));
        }
        if (this.mainProperties.containsKey("WIDTH")) {
            this.editor.setSize(HelperFunctions.stringToInteger(this.mainProperties.get("WIDTH").toString()), this.editor.getHeight());
        }
        if (this.mainProperties.containsKey("XPOS")) {
            this.editor.setLocation(new Point(HelperFunctions.stringToInteger(this.mainProperties.get("XPOS").toString()), this.editor.getY()));
        }
        if (this.mainProperties.containsKey("YPOS")) {
            this.editor.setLocation(new Point(this.editor.getX(), HelperFunctions.stringToInteger(this.mainProperties.get("YPOS").toString())));
        }
        if (this.mainProperties.containsKey("MAXIMISED") && this.mainProperties.get("MAXIMISED").toString().equals("true")) {
            this.maximiseButtonClicked();
        }
        this.setSize(new Dimension(600, 400));
        this.scrollPane = new JScrollPane();
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setEnabled(false);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setBackground(Color.WHITE);
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.contentEditor = (JEditorPane)this.mainSyntax.getEditPane();
        this.contentEditor.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        this.contentEditor.setFont(new Font("Monospaced", 0, 18));
        this.contentEditor.setText("RECORD pupil IS {STRING name, INTEGER age}\r\nDECLARE total INITIALLY 0\r\nDECLARE counter INITIALLY 0\r\nDECLARE nextInput INITIALLY 0\r\nWHILE counter < 10 DO\r\n  SEND \"Insert a number\" TO DISPLAY\r\n  RECEIVE nextInput FROM KEYBOARD\r\n  SET total TO total + nextInput\r\n  SET counter TO counter + 1\r\nEND WHILE\r\nSEND total / 10.0 TO DISPLAY");
        this.scrollPane.setViewportView(this.contentEditor);
        this.scrollPane.setRowHeaderView(this.mainSyntax.getEditor());
        this.getFooter().setText("<html>&copy; J Balfour 2019 - 2025</html>");
        if (HelperFunctions.isMac()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            try {
                macOS a = new macOS();
                a.addAboutDialog(this::showAbout);
            }
            catch (Exception a) {
                // empty catch block
            }
        }
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        int modifier = 128;
        if (HelperFunctions.isMac()) {
            modifier = 256;
        }
        this.setDefaultCloseOperation(0);
        JMenu mnFileMenu = new JMenu("File");
        mnFileMenu.setMnemonic('F');
        menuBar.add(mnFileMenu);
        JMenuItem mntmNewMenuItem = new JMenuItem("New");
        mntmNewMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, modifier));
        mntmNewMenuItem.addActionListener(e -> {
            this.clearUndoRedoManagers();
            this.setTextProperly("");
        });
        mnFileMenu.add(mntmNewMenuItem);
        JMenuItem mntmSaveMenuItem = new JMenuItem("Save");
        mntmSaveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, modifier));
        mntmSaveMenuItem.addActionListener(e -> {
            if (this.lastFileOpened.isEmpty()) {
                this.saveAsDialog();
            } else {
                try {
                    HelperFunctions.writeFile(this.lastFileOpened, this.contentEditor.getText(), false);
                }
                catch (IOException ex) {
                    ZPE.log("SQARL Runtime error: " + ex.getMessage());
                }
            }
        });
        mnFileMenu.add(mntmSaveMenuItem);
        JMenuItem mntmSaveAsMenuItem = new JMenuItem("Save As");
        mntmSaveAsMenuItem.addActionListener(e -> this.saveAsDialog());
        mnFileMenu.add(mntmSaveAsMenuItem);
        mnFileMenu.add(new JSeparator());
        JMenuItem mntmOpenMenuItem = new JMenuItem("Open");
        mntmOpenMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, modifier));
        mntmOpenMenuItem.addActionListener(e -> this.open());
        mnFileMenu.add(mntmOpenMenuItem);
        this.mntmRecentMenuItem = new JMenu("Recent files");
        this.updateRecentFiles();
        if (!this.recents.isEmpty()) {
            mnFileMenu.add(this.mntmRecentMenuItem);
        }
        mnFileMenu.add(new JSeparator());
        JMenuItem mntmPrintMenuItem = new JMenuItem("Print");
        mntmPrintMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, modifier));
        mntmPrintMenuItem.addActionListener(e -> {
            try {
                this.contentEditor.print();
            }
            catch (PrinterException e1) {
                JOptionPane.showMessageDialog(this.editor, "An error was encountered whilst trying to print.", "Error", 0);
            }
        });
        mnFileMenu.add(mntmPrintMenuItem);
        mnFileMenu.add(new JSeparator());
        JMenuItem mntmExitMenuItem = new JMenuItem("Exit");
        mntmExitMenuItem.addActionListener(e -> {
            this.closeUp();
            System.exit(0);
        });
        mnFileMenu.add(mntmExitMenuItem);
        this.contentEditor.getDocument().addUndoableEditListener(this.undoHandler);
        KeyStroke undoKeystroke = KeyStroke.getKeyStroke(90, modifier);
        KeyStroke redoKeystroke = KeyStroke.getKeyStroke(89, modifier);
        this.undoAction = new UndoAction();
        this.contentEditor.getInputMap().put(undoKeystroke, "undoKeystroke");
        this.contentEditor.getActionMap().put("undoKeystroke", this.undoAction);
        this.redoAction = new RedoAction();
        this.contentEditor.getInputMap().put(redoKeystroke, "redoKeystroke");
        this.contentEditor.getActionMap().put("redoKeystroke", this.redoAction);
        JMenu mnEditMenu = new JMenu("Edit");
        mnEditMenu.setMnemonic('E');
        menuBar.add(mnEditMenu);
        JMenuItem mntmUndoMenuItem = new JMenuItem(this.undoAction);
        mntmUndoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, modifier));
        mnEditMenu.add(mntmUndoMenuItem);
        JMenuItem mntmRedoMenuItem = new JMenuItem(this.redoAction);
        mntmRedoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, modifier));
        mnEditMenu.add(mntmRedoMenuItem);
        mnEditMenu.add(new JSeparator());
        JMenuItem mntmCutMenuItem = new JMenuItem("Cut");
        mntmCutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, modifier));
        mntmCutMenuItem.addActionListener(e -> this.contentEditor.cut());
        mnEditMenu.add(mntmCutMenuItem);
        JMenuItem mntmCopyMenuItem = new JMenuItem("Copy");
        mntmCopyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, modifier));
        mntmCopyMenuItem.addActionListener(e -> this.contentEditor.copy());
        mnEditMenu.add(mntmCopyMenuItem);
        JMenuItem mntmPasteMenuItem = new JMenuItem("Paste");
        mntmPasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, modifier));
        mntmPasteMenuItem.addActionListener(e -> this.contentEditor.paste());
        mnEditMenu.add(mntmPasteMenuItem);
        JMenuItem mntmDeleteMenuItem = new JMenuItem("Delete");
        mntmDeleteMenuItem.addActionListener(e -> {
            int start = this.contentEditor.getSelectionStart();
            int end = this.contentEditor.getSelectionEnd();
            String current = this.contentEditor.getText();
            String newText = current.substring(0, start) + current.substring(end);
            this.contentEditor.setText(newText);
        });
        mnEditMenu.add(mntmDeleteMenuItem);
        mnEditMenu.add(new JSeparator());
        JMenuItem mntmSelectAllMenuItem = new JMenuItem("Select All");
        mntmSelectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, modifier));
        mntmSelectAllMenuItem.addActionListener(e -> this.contentEditor.selectAll());
        mnEditMenu.add(mntmSelectAllMenuItem);
        JMenu mnViewMenu = new JMenu("View");
        mnEditMenu.setMnemonic('V');
        menuBar.add(mnViewMenu);
        this.mnDarkModeMenuItem = new JCheckBoxMenuItem("Dark Mode");
        mnViewMenu.add(this.mnDarkModeMenuItem);
        this.mnDarkModeMenuItem.addActionListener(e -> {
            if (!this.darkMode) {
                this.switchOnDarkMode();
            } else {
                this.switchOffDarkMode();
            }
            this.setProperty("DARK_MODE", "" + this.darkMode);
            this.saveGUISettings(this.mainProperties);
            this.updateEditor();
        });
        JMenu mnScriptMenu = new JMenu("Script");
        mnScriptMenu.setMnemonic('S');
        menuBar.add(mnScriptMenu);
        this.chckbxmntmCaseSensitiveCompileCheckItem = new JCheckBoxMenuItem("Case sensitive compile");
        this.chckbxmntmCaseSensitiveCompileCheckItem.setSelected(true);
        mnScriptMenu.add(this.chckbxmntmCaseSensitiveCompileCheckItem);
        this.mntmClearConsoleBeforeRunMenuItem = new JCheckBoxMenuItem("Clear console before running");
        this.mntmClearConsoleBeforeRunMenuItem.setSelected(true);
        mnScriptMenu.add(this.mntmClearConsoleBeforeRunMenuItem);
        mnScriptMenu.add(new JSeparator());
        JMenuItem mntmRunCodeMenuItem = new JMenuItem("Run code");
        mntmRunCodeMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        mntmRunCodeMenuItem.addActionListener(e -> {
            try {
                Object extras = "";
                if (this.chckbxmntmCaseSensitiveCompileCheckItem.isSelected()) {
                    extras = (String)extras + " --case_insensitive";
                }
                SQARLParser sqarl = new SQARLParser();
                String yass = sqarl.parseToYASS(this.contentEditor.getText());
                HelperFunctions.writeFile(ZPEInstance.getInstallPath() + "/tmp.yas", yass, false);
                if (!ZPEInstance.getJarExecPath().isEmpty()) {
                    if (new File(ZPEInstance.getJarExecPath()).exists()) {
                        this.currentProcess = Runtime.getRuntime().exec("java -jar " + ZPEInstance.getJarExecPath() + " -g " + ZPEInstance.getInstallPath() + "/tmp.yas --console" + (String)extras);
                        this.mntmStopCodeMenuItem.setEnabled(true);
                        this.mntmStopCodeMenuItem.setVisible(true);
                    }
                } else {
                    this.AttachedConsole = new ZPEConsole(this, "", this.contentEditor.getFont(), 5);
                    this.AttachedConsole.runCode(yass, new ZPEString[0], this.chckbxmntmCaseSensitiveCompileCheckItem.isSelected());
                    this.mntmStopCodeMenuItem.setVisible(false);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        mnScriptMenu.add(mntmRunCodeMenuItem);
        this.mntmStopCodeMenuItem = new JMenuItem("Stop code");
        this.mntmStopCodeMenuItem.setEnabled(false);
        this.mntmStopCodeMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.mntmStopCodeMenuItem.addActionListener(e -> {
            this.currentProcess.destroy();
            this.currentProcess = null;
            this.mntmStopCodeMenuItem.setEnabled(false);
        });
        mnScriptMenu.add(this.mntmStopCodeMenuItem);
        mnScriptMenu.add(new JSeparator());
        JMenuItem mntmCompileCodeMenuItem = this.getjMenuItem();
        mnScriptMenu.add(mntmCompileCodeMenuItem);
        JMenuItem mntmTranspileCodeMenuItem = new JMenuItem("Transpile code to Python");
        mntmTranspileCodeMenuItem.addActionListener(e -> {
            String extension = ".py";
            JFileChooser fc = new JFileChooser();
            FileNameExtensionFilter pythonFilter = new FileNameExtensionFilter("Python files (*.py)", "py");
            fc.addChoosableFileFilter(pythonFilter);
            fc.setAcceptAllFileFilterUsed(false);
            int returnVal = fc.showSaveDialog(this.editor.getContentPane());
            if (returnVal != 0) {
                return;
            }
            File file = fc.getSelectedFile();
            try {
                SQARLParser sqarl = new SQARLParser();
                String yass = sqarl.parseToYASS(this.contentEditor.getText());
                PythonTranspiler t = new PythonTranspiler();
                String code = t.Transpile(ZPEKit.compile(yass), "");
                Object path1 = file.getPath();
                if (!((String)path1).endsWith(extension)) {
                    path1 = (String)path1 + extension;
                }
                HelperFunctions.writeFile((String)path1, code, false);
                JOptionPane.showMessageDialog(this.editor, "Python transpile success. The file has been successfully compiled to " + (String)path1 + ".", "Python transpiler", 2);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        });
        mnScriptMenu.add(mntmTranspileCodeMenuItem);
        mnScriptMenu.add(new JSeparator());
        JMenuItem mntmAnalyseCodeMenuItem = new JMenuItem("Analyse code");
        mntmAnalyseCodeMenuItem.addActionListener(e -> {
            SQARLParser sqarl = new SQARLParser();
            String yass = sqarl.parseToYASS(this.contentEditor.getText());
            try {
                if (ZPEKit.validateCode(yass)) {
                    JOptionPane.showMessageDialog(this.editor, "Code is valid", "Code analysis", 1);
                } else {
                    JOptionPane.showMessageDialog(this.editor, "Code is invalid", "Code analysis", 1);
                }
            }
            catch (CompileException ex) {
                JOptionPane.showMessageDialog(this.editor, "Code is invalid", "Code analysis", 1);
            }
        });
        mnScriptMenu.add(mntmAnalyseCodeMenuItem);
        JMenuItem mntmToByteCodeFileMenuItem = new JMenuItem("Compile to byte codes");
        mntmToByteCodeFileMenuItem.addActionListener(e -> {
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(filter2);
            fc.setAcceptAllFileFilterUsed(false);
            int returnVal = fc.showSaveDialog(this.editor.getContentPane());
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                String extension = SQARLEditorMain.getSaveExtension(fc.getFileFilter());
                try {
                    SQARLParser sqarl = new SQARLParser();
                    String yass = sqarl.parseToYASS(this.contentEditor.getText());
                    StringBuilder text = new StringBuilder();
                    for (byte s : ZPEKit.parseToBytes(yass)) {
                        text.append(s).append(" ");
                    }
                    HelperFunctions.writeFile(file.getAbsolutePath() + "." + extension, text.toString(), false);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this.editor, "The file could not be saved.", "Error", 0);
                }
            }
        });
        mnScriptMenu.add(mntmToByteCodeFileMenuItem);
        JMenuItem mntmUnfoldCodeMenuItem = new JMenuItem("Unfold (explain) code");
        mntmUnfoldCodeMenuItem.addActionListener(e -> {
            try {
                SQARLParser sqarl = new SQARLParser();
                String yass = sqarl.parseToYASS(this.contentEditor.getText());
                String result = ZPEKit.unfold(yass, false);
                JOptionPane.showMessageDialog(this.editor, ZPEHelperFunctions.smartSplit(result, 100), "Code Explanation", 1);
            }
            catch (CompileException ex) {
                throw new RuntimeException(ex);
            }
        });
        mnScriptMenu.add(mntmUnfoldCodeMenuItem);
        JMenu mnHelpMenu = new JMenu("Help");
        mnHelpMenu.setMnemonic('H');
        menuBar.add(mnHelpMenu);
        if (!HelperFunctions.isMac()) {
            JMenuItem mntmAboutFileMenuItem = new JMenuItem("About");
            mntmAboutFileMenuItem.addActionListener(e -> this.showAbout());
            mnHelpMenu.add(mntmAboutFileMenuItem);
            mnHelpMenu.add(new JSeparator());
        }
        JMenuItem mntmSQARLSpecificationWebsiteMenuItem = new JMenuItem("Read the SQARL Specification");
        mntmSQARLSpecificationWebsiteMenuItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.sqa.org.uk/sqa/files_ccc/Reference-language-for-Computing-Science-Sep2016.pdf");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.editor, "Could not open SQA website", "Failure", 0);
            }
        });
        mnHelpMenu.add(mntmSQARLSpecificationWebsiteMenuItem);
        JMenuItem mntmSQAWebsiteMenuItem = new JMenuItem("Visit SQA Website");
        mntmSQAWebsiteMenuItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.sqa.org.uk/sqa/48486.html");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.editor, "Could not open SQA website", "Failure", 0);
            }
        });
        try {
            this.setIconImage(this.lighterLogoFull.getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Taskbar.isTaskbarSupported()) {
                Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
                Taskbar taskbar = Taskbar.getTaskbar();
                Image image = this.lighterLogoFull.getImage();
                taskbar.setIconImage(image);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        mnHelpMenu.add(mntmSQAWebsiteMenuItem);
        ZPEInstance.setErrorLevel(1);
        if (this.mainProperties.containsKey("DARK_MODE")) {
            if (this.mainProperties.get("DARK_MODE").equals("true")) {
                this.switchOnDarkMode();
            } else {
                this.switchOffDarkMode();
            }
        }
        this.pack();
    }

    private void closeUp() {
        this.setProperty("HEIGHT", "" + this.editor.getHeight());
        this.setProperty("WIDTH", "" + this.editor.getWidth());
        this.setProperty("XPOS", "" + this.editor.getX());
        this.setProperty("YPOS", "" + this.editor.getY());
        if (this.isMaximised) {
            this.setProperty("MAXIMISED", "true");
        } else {
            this.setProperty("MAXIMISED", "false");
        }
        this.saveGUISettings(this.mainProperties);
    }

    private JMenuItem getjMenuItem() {
        JMenuItem mntmCompileCodeMenuItem = new JMenuItem("Compile code");
        mntmCompileCodeMenuItem.addActionListener(e -> {
            String name = JOptionPane.showInputDialog(this.editor, (Object)"Please insert the name of the compiled application.");
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(filter2);
            fc.setAcceptAllFileFilterUsed(false);
            int returnVal = fc.showSaveDialog(this.editor.getContentPane());
            if (returnVal != 0) {
                return;
            }
            File file = fc.getSelectedFile();
            String extension = SQARLEditorMain.getSaveExtension(fc.getFileFilter());
            try {
                SQARLParser sqarl = new SQARLParser();
                String yass = sqarl.parseToYASS(this.contentEditor.getText());
                ZPEKit.compile(yass, file.toString() + "." + extension, name, "", !this.chckbxmntmCaseSensitiveCompileCheckItem.isSelected(), false, null, null);
                JOptionPane.showMessageDialog(this.editor, "YASS compile success. The file has been successfully compiled to " + file + ".", "YASS compiler", 2);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.editor, "YASS compile failure. The YASS compiler could not compile the code given due to an IOException.", "YASS compiler", 0);
            }
            catch (CompileException ex) {
                JOptionPane.showMessageDialog(this.editor, "YASS compile failure. The YASS compiler could not compile the code given. The error was: " + ex.getMessage(), "YASS compiler", 0);
            }
        });
        return mntmCompileCodeMenuItem;
    }

    private void clearUndoRedoManagers() {
        this.undoManager.die();
        this.undoAction.update();
        this.redoAction.update();
    }

    private void open() {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(filter1);
        int returnVal = fc.showOpenDialog(this.getContentPane());
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                this.clearUndoRedoManagers();
                this.setTextProperly(HelperFunctions.readFileAsString(file.getAbsolutePath()));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SQARLEditorMain.this.contentEditor.setCaretPosition(0);
                        SQARLEditorMain.this.scrollPane.getVerticalScrollBar().setValue(0);
                    }
                });
                this.recents.add(file.getAbsolutePath());
                try {
                    ZPEEditor.storeRecentFiles(this.recents, "sqarl/");
                    this.recents = ZPEEditor.getRecentFiles("sqarl/");
                    this.updateRecentFiles();
                }
                catch (IOException ex) {
                    ZPE.log(ex.getMessage());
                }
                this.editor.setTitle("ZPE Editor " + file.getAbsolutePath());
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.editor, "The file could not be opened.", "Error", 0);
            }
        }
    }

    private void saveAsDialog() {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(filter1);
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showSaveDialog(this.getContentPane());
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String extension = SQARLEditorMain.getSaveExtension(fc.getFileFilter());
            try {
                HelperFunctions.writeFile(file.getAbsolutePath() + "." + extension, this.contentEditor.getText(), false);
                this.lastFileOpened = file.getAbsolutePath();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.editor, "The file could not be saved.", "Error", 0);
            }
        }
    }

    private void showAbout() {
        JOptionPane op = new JOptionPane(new SQARLAboutDialog().getContentPane(), -1, -1, null, new String[0]);
        JDialog dlg = op.createDialog(this.editor, "About SQA Reference Language Runtime");
        dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dlg.setVisible(true);
    }

    @Override
    public void saveGUISettings(Properties props) {
        if (this.propertiesChanged) {
            File f = new File(ZPEKit.getInstallPath() + "/sqarl/");
            if (!f.exists() && !f.mkdirs()) {
                ZPE.log(f + " could not be created.");
            }
            String path = ZPEKit.getInstallPath() + "/sqarl/gui.properties";
            try {
                FileOutputStream output = new FileOutputStream(path);
                props.store(output, null);
            }
            catch (Exception e) {
                ZPE.log("SQARL Runtime error: GUI cannot save" + e.getMessage());
            }
        }
    }

    @Override
    public void setProperty(String name, String value) {
        this.mainProperties.setProperty(name, value);
        this.propertiesChanged = true;
    }

    static String getSaveExtension(FileFilter f) {
        if (f.equals(filter1)) {
            return "txt";
        }
        return null;
    }

    void setTextProperly(String text) {
        this.dontUndo = true;
        this.contentEditor.setText(text);
        this.dontUndo = false;
    }

    @Override
    public void destroyConsole() {
        this.AttachedConsole = null;
    }

    @Override
    public Properties getProperties() {
        return this.mainProperties;
    }

    private void updateEditor() {
        this.contentEditor = (JEditorPane)this.mainSyntax.getEditPane();
        this.setTextProperly(this.contentEditor.getText());
    }

    private void setUpScrollBar(final String trackColour, final String thumbColour) {
        this.scrollPane.getVerticalScrollBar().setUI(new BasicScrollBarUI(){

            @Override
            protected void configureScrollBarColors() {
                this.thumbColor = Color.decode(thumbColour);
                this.trackColor = Color.decode(trackColour);
                this.scrollBarWidth = 7;
            }

            @Override
            protected JButton createDecreaseButton(int orientation) {
                return SQARLEditorMain.this.createZeroButton();
            }

            @Override
            protected JButton createIncreaseButton(int orientation) {
                return SQARLEditorMain.this.createZeroButton();
            }

            @Override
            protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(this.thumbColor);
                int arc = 10;
                g2.fillRoundRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, arc, arc);
                g2.dispose();
            }
        });
    }

    private JButton createZeroButton() {
        JButton button = new JButton();
        Dimension zeroDim = new Dimension(0, 0);
        button.setPreferredSize(zeroDim);
        button.setMinimumSize(zeroDim);
        button.setMaximumSize(zeroDim);
        return button;
    }

    private void resetScroll() {
        final int caretPosition = this.contentEditor.getCaretPosition();
        final int scrollPosition = this.scrollPane.getVerticalScrollBar().getValue();
        this.contentEditor.setText(this.contentEditor.getText());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SQARLEditorMain.this.contentEditor.requestFocus();
                SQARLEditorMain.this.contentEditor.setCaretPosition(caretPosition);
                SQARLEditorMain.this.scrollPane.getVerticalScrollBar().setValue(scrollPosition);
            }
        });
    }

    private void switchOnDarkMode() {
        BalfLafManager.getInstance().toggleDarkMode(true);
        this.mnDarkModeMenuItem.setSelected(true);
        Color dark = Color.decode("#282D37");
        this.scrollPane.setBackground(dark);
        this.contentEditor.setBackground(dark);
        this.contentEditor.setForeground(Color.white);
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Normal, Color.white);
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Quote, new Color(152, 195, 119));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Keyword, new Color(198, 120, 222));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Function, new Color(97, 172, 231));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Var, new Color(224, 108, 117));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Type, new Color(105, 143, 163));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Bool, new Color(208, 154, 102));
        this.contentEditor.setCaretColor(Color.white);
        this.resetScroll();
        this.setUpScrollBar("#282D37", "#444444");
        this.darkMode = true;
    }

    private void switchOffDarkMode() {
        BalfLafManager.getInstance().toggleDarkMode(false);
        this.mnDarkModeMenuItem.setSelected(false);
        Color light = new Color(255, 255, 255);
        this.contentEditor.setBackground(light);
        this.contentEditor.setForeground(Color.black);
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Normal, Color.black);
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Quote, new Color(0, 128, 0));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Keyword, new Color(200, 0, 255));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Var, new Color(255, 138, 0));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Type, new Color(150, 0, 150));
        this.contentEditor.setCaretColor(Color.black);
        this.resetScroll();
        this.setUpScrollBar("#dddddd", "#aaaaaa");
        this.darkMode = false;
    }

    private void updateRecentFiles() {
        this.mntmRecentMenuItem.removeAll();
        for (String fStr : this.recents) {
            JMenuItem item = new JMenuItem(new File(fStr).getName());
            item.addActionListener(e -> {
                try {
                    this.clearUndoRedoManagers();
                    this.setTextProperly(HelperFunctions.readFileAsString(new File(fStr).getAbsolutePath()));
                    this.editor.setTitle("ZPE Editor " + new File(fStr).getAbsolutePath());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SQARLEditorMain.this.contentEditor.setCaretPosition(0);
                            SQARLEditorMain.this.scrollPane.getVerticalScrollBar().setValue(0);
                        }
                    });
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
            this.mntmRecentMenuItem.add((Component)item, 0);
        }
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -2308035050104867155L;

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                SQARLEditorMain.this.undoManager.redo();
            }
            catch (CannotRedoException ex) {
                JOptionPane.showMessageDialog(SQARLEditorMain.this.editor, "Cannot redo.", "Error", 0);
            }
            this.update();
            SQARLEditorMain.this.undoAction.update();
        }

        protected void update() {
            if (SQARLEditorMain.this.undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", SQARLEditorMain.this.undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -3804879849241500100L;

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                SQARLEditorMain.this.undoManager.undo();
            }
            catch (CannotUndoException ex) {
                JOptionPane.showMessageDialog(SQARLEditorMain.this.editor, "Cannot undo.", "Error", 0);
            }
            this.update();
            SQARLEditorMain.this.redoAction.update();
        }

        protected void update() {
            if (SQARLEditorMain.this.undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", SQARLEditorMain.this.undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            if (!e.getEdit().getPresentationName().equals("style change") && !SQARLEditorMain.this.dontUndo) {
                SQARLEditorMain.this.undoManager.addEdit(e.getEdit());
                SQARLEditorMain.this.undoAction.update();
                SQARLEditorMain.this.redoAction.update();
            }
        }
    }
}

