/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui;

import jamiebalfour.ui.BalfFooter;
import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.BalfMenuBar;
import jamiebalfour.ui.BalfPanel;
import jamiebalfour.ui.BalfTitleBar;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.RoundRectangle2D;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.LineBorder;

public class BalfWindow
extends JFrame {
    private final BalfPanel mainPanel;
    private final BalfTitleBar titleBar;
    private final BalfFooter footer;
    private BalfMenuBar menu;
    private final Color mainColour;
    private final Color lighterColour;
    private final Color foregroundColour;
    BalfPanel top;
    JPanel owner;

    public BalfWindow(String title, int rounding, Color mainColour, Color lighterColour, Color foreground) {
        this.mainColour = mainColour;
        this.lighterColour = lighterColour;
        this.foregroundColour = foreground;
        this.owner = new JPanel();
        super.setLayout(new BorderLayout());
        this.titleBar = new BalfTitleBar(this, rounding, mainColour, lighterColour);
        this.setTitle(title);
        this.top = new BalfPanel(new BorderLayout());
        this.top.add((Component)this.titleBar, "North");
        this.top.setOpaque(true);
        this.top.setBackground(mainColour);
        BorderedRoot b = new BorderedRoot(this, mainColour, 3, rounding);
        BalfPanel outerMain = new BalfPanel();
        outerMain.setLayout(new BorderLayout());
        this.mainPanel = new BalfPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.owner.setLayout(new BorderLayout());
        super.getContentPane().add((Component)this.owner, "Center");
        outerMain.add((Component)this.mainPanel, "Center");
        b.add((Component)outerMain, "Center");
        this.owner.add((Component)this.top, "North");
        this.footer = new BalfFooter("", mainColour, foreground);
        this.owner.add((Component)this.footer, "South");
        this.owner.add(b);
        super.setPreferredSize(new Dimension(800, 600));
        super.setLocation(new Point(100, 100));
        BalfLafManager.getInstance().addListener(e -> {
            if (e) {
                if (rounding == 0) {
                    this.owner.setBorder(new LineBorder(new Color(85, 85, 85), 1));
                }
            } else {
                this.owner.setBorder(null);
            }
        });
        this.pack();
    }

    public void dockTop() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        Rectangle bounds = device.getDefaultConfiguration().getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        int x = bounds.x + screenInsets.left;
        int y = bounds.y + screenInsets.top;
        int width = bounds.width - screenInsets.left - screenInsets.right;
        int height = bounds.height - screenInsets.top - screenInsets.bottom;
        this.setBounds(x, y, width, height / 2);
        this.setState(0);
    }

    public void dockLeft() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        Rectangle bounds = device.getDefaultConfiguration().getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        int x = bounds.x + screenInsets.left;
        int y = bounds.y + screenInsets.top;
        int width = (bounds.width - screenInsets.left - screenInsets.right) / 2;
        int height = bounds.height - screenInsets.top - screenInsets.bottom;
        this.setBounds(x, y, width, height);
        this.setState(0);
    }

    public void dockRight() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        Rectangle bounds = device.getDefaultConfiguration().getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        int y = bounds.y + screenInsets.top;
        int width = (bounds.width - screenInsets.left - screenInsets.right) / 2;
        int x = bounds.x + screenInsets.left + width;
        int height = bounds.height - screenInsets.top - screenInsets.bottom;
        this.setBounds(x, y, width, height);
        this.setState(0);
    }

    public void dockBottom() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        Rectangle bounds = device.getDefaultConfiguration().getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        int x = bounds.x + screenInsets.left;
        int height = bounds.height - screenInsets.top - screenInsets.bottom;
        int y = bounds.y + screenInsets.top + height / 2;
        int width = bounds.width - screenInsets.left - screenInsets.right;
        this.setBounds(x, y, width, height / 2);
        this.setState(0);
    }

    public void readStandardProperties(Properties mainProperties) {
        if (mainProperties.containsKey("HEIGHT")) {
            this.setSize(this.getWidth(), this.stringToInteger(mainProperties.get("HEIGHT").toString()));
        }
        if (mainProperties.containsKey("WIDTH")) {
            this.setSize(this.stringToInteger(mainProperties.get("WIDTH").toString()), this.getHeight());
        }
        if (mainProperties.containsKey("XPOS")) {
            this.setLocation(new Point(this.stringToInteger(mainProperties.get("XPOS").toString()), this.getY()));
        }
        if (mainProperties.containsKey("YPOS")) {
            this.setLocation(new Point(this.getX(), this.stringToInteger(mainProperties.get("YPOS").toString())));
        }
        if (mainProperties.containsKey("MAXIMISED") && mainProperties.get("MAXIMISED").toString().equals("true")) {
            this.titleBar.activateMaximise();
        }
    }

    static double stringToDouble(String s) {
        if (s == null) {
            return 0.0;
        }
        if (s.equals("true")) {
            return 1.0;
        }
        if (!BalfWindow.isNumeric(s)) {
            return 0.0;
        }
        return Double.parseDouble(s);
    }

    static boolean isNumeric(Object s) {
        if (s == null) {
            return false;
        }
        return s.toString().matches("(-)?[0-9]+(\\.[0-9]+)?(E(-?)[0-9]+)?");
    }

    int stringToInteger(String s) {
        return (int)Math.floor(BalfWindow.stringToDouble(s));
    }

    @Override
    public void setLayout(LayoutManager manager) {
        if (this.mainPanel != null) {
            this.mainPanel.setLayout(manager);
        } else {
            super.setLayout(new BorderLayout());
        }
    }

    @Override
    public Component add(Component comp) {
        this.mainPanel.add(comp);
        return comp;
    }

    @Override
    public void add(Component comp, Object layout) {
        if (this.mainPanel != null) {
            this.mainPanel.add(comp, layout);
        } else {
            super.add(comp, layout);
        }
    }

    public static void main(String[] args2) {
        BalfWindow b = new BalfWindow("Test", 0, Color.green, Color.blue, Color.WHITE);
        b.setPreferredSize(new Dimension(800, 600));
        b.setLayout(new BorderLayout());
        b.add((Component)new JButton("Test"), "Center");
        b.setVisible(true);
        b.pack();
    }

    public void setTitleBarText(String title) {
        this.titleBar.setLabelText(title);
    }

    public BalfMenuBar getMenu(Color menuBackground) {
        if (this.menu == null) {
            this.menu = new BalfMenuBar(this.mainColour, this.lighterColour, this.foregroundColour, menuBackground);
            this.top.add((Component)this.menu, "South");
        }
        return this.menu;
    }

    public void setMenu(BalfMenuBar menu) {
        this.menu = menu;
        this.top.add((Component)menu, "South");
        this.titleBar.attachMenu(menu);
    }

    @Override
    public void setJMenuBar(JMenuBar menu) {
        this.top.add((Component)menu, "South");
    }

    public BalfFooter getFooter() {
        return this.footer;
    }

    public BalfTitleBar getTitleBar() {
        return this.titleBar;
    }

    public void useMacMenuBar() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
    }

    static class ShadowPane
    extends JComponent {
        private final int arc;
        private final int shadowSize;

        public ShadowPane(int arc, int shadowSize) {
            this.arc = arc;
            this.shadowSize = shadowSize;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color shadowColor = new Color(0, 0, 0, 60);
            g2.setPaint(new RadialGradientPaint(new Point(width / 2, height / 2), (float)Math.max(width, height) / 2.0f, new float[]{0.0f, 1.0f}, new Color[]{shadowColor, new Color(0, 0, 0, 0)}));
            g2.fillRoundRect(this.shadowSize / 2, this.shadowSize / 2, width - this.shadowSize, height - this.shadowSize, this.arc, this.arc);
            g2.dispose();
        }
    }

    static class BorderedRoot
    extends JPanel {
        boolean darkMode = false;

        public BorderedRoot(final JFrame frame, Color borderColor, int thickness, final int arc) {
            this.setLayout(new BorderLayout());
            if (arc > 0) {
                this.setBorder(new RoundedLineBorder(frame, borderColor, thickness, arc, this));
            } else {
                this.setBorder(new SquareLineBorder(borderColor, thickness, this));
            }
            frame.getContentPane().setBackground(borderColor);
            this.setBackground(BalfLafManager.getInstance().getDarkColorComponentBackground());
            this.setOpaque(true);
            frame.setUndecorated(true);
            frame.setLayout(new BorderLayout());
            if (arc > 0) {
                frame.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        frame.setShape(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), arc, arc));
                    }
                });
            }
            frame.setBackground(borderColor);
            ResizableWindowSupport r = new ResizableWindowSupport();
            r.enableResizing(frame);
            BalfLafManager.getInstance().addListener(enabled -> {
                if (enabled) {
                    this.enableDarkMode();
                } else {
                    this.disableDarkMode();
                }
                this.repaint();
            });
        }

        private void enableDarkMode() {
            this.darkMode = true;
        }

        private void disableDarkMode() {
            this.darkMode = false;
        }

        static class ResizableWindowSupport {
            private static final int BORDER_DRAG = 8;
            boolean dragging = false;
            Point initialClick;

            ResizableWindowSupport() {
            }

            private void updateCursor(JFrame frame, Point px) {
                int width = frame.getWidth();
                int height = frame.getHeight();
                int x = px.x;
                int y = px.y;
                int cursor = 0;
                if (x < 8 && y > height - 8) {
                    cursor = 4;
                } else if (x > width - 8 && y > height - 8) {
                    cursor = 5;
                } else if (x < 8) {
                    cursor = 10;
                } else if (x > width - 8) {
                    cursor = 11;
                } else if (y > height - 8) {
                    cursor = 9;
                }
                frame.setCursor(Cursor.getPredefinedCursor(cursor));
            }

            public void enableResizing(final JFrame frame) {
                JPanel content = (JPanel)frame.getContentPane();
                content.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        initialClick = e.getPoint();
                        dragging = true;
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        frame.setCursor(Cursor.getDefaultCursor());
                        dragging = false;
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        if (!dragging) {
                            frame.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                });
                content.addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        this.updateCursor(frame, e.getPoint());
                    }

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        if (initialClick == null) {
                            return;
                        }
                        int dx = e.getX() - initialClick.x;
                        int dy = e.getY() - initialClick.y;
                        Rectangle bounds = frame.getBounds();
                        int cursorType = frame.getCursor().getType();
                        switch (cursorType) {
                            case 9: {
                                bounds.height += dy;
                                break;
                            }
                            case 11: {
                                bounds.width += dx;
                                break;
                            }
                            case 10: {
                                bounds.x += dx;
                                bounds.width -= dx;
                                break;
                            }
                            case 4: {
                                bounds.x += dx;
                                bounds.width -= dx;
                                bounds.height += dy;
                                break;
                            }
                            case 5: {
                                bounds.width += dx;
                                bounds.height += dy;
                            }
                        }
                        frame.setBounds(bounds);
                        initialClick = e.getPoint();
                    }
                });
            }

            private void resizeFrame(JFrame frame, Point current) {
                Point click = (Point)frame.getRootPane().getClientProperty("mousePress");
                if (click == null) {
                    return;
                }
                int dx = current.x - click.x;
                int dy = current.y - click.y;
                Rectangle bounds = frame.getBounds();
                int cursor = frame.getCursor().getType();
                switch (cursor) {
                    case 6: {
                        bounds.x += dx;
                        bounds.y += dy;
                        bounds.width -= dx;
                        bounds.height -= dy;
                        break;
                    }
                    case 7: {
                        bounds.y += dy;
                        bounds.width += dx;
                        bounds.height -= dy;
                        break;
                    }
                    case 4: {
                        bounds.x += dx;
                        bounds.width -= dx;
                        bounds.height += dy;
                        break;
                    }
                    case 5: {
                        bounds.width += dx;
                        bounds.height += dy;
                        break;
                    }
                    case 10: {
                        bounds.x += dx;
                        bounds.width -= dx;
                        break;
                    }
                    case 11: {
                        bounds.width += dx;
                        break;
                    }
                    case 8: {
                        bounds.y += dy;
                        bounds.height -= dy;
                        break;
                    }
                    case 9: {
                        bounds.height += dy;
                    }
                }
                if (bounds.height < frame.getMinimumSize().height) {
                    bounds.height = frame.getMinimumSize().height;
                }
                if (bounds.width < frame.getMinimumSize().width) {
                    bounds.width = frame.getMinimumSize().width;
                }
                frame.setBounds(bounds);
                frame.getRootPane().putClientProperty("mousePress", current);
            }
        }

        static class SquareLineBorder
        extends AbstractBorder {
            private final Color color;
            private final int thickness;
            BorderedRoot parent;

            public SquareLineBorder(Color color, int thickness, BorderedRoot parent) {
                this.color = color;
                this.thickness = thickness;
                this.parent = parent;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setColor(this.color);
                if (this.parent.darkMode) {
                    g2.setColor(BalfLafManager.getInstance().getDarkColorBackground());
                }
                g2.setStroke(new BasicStroke(this.thickness));
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                float offset = (float)this.thickness / 2.0f;
                g2.drawRect(Math.round((float)x + offset), Math.round((float)y + offset), Math.round(width - this.thickness), Math.round(height - this.thickness));
                g2.dispose();
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, this.thickness, this.thickness, this.thickness);
            }

            @Override
            public Insets getBorderInsets(Component c, Insets insets) {
                insets.set(0, this.thickness, this.thickness, this.thickness);
                return insets;
            }
        }

        static class RoundedLineBorder
        extends AbstractBorder {
            private final Color color;
            private final int thickness;
            private final int arc;
            private JFrame frame;
            BorderedRoot parent;

            public RoundedLineBorder(JFrame f, Color color, int thickness, int arc, BorderedRoot parent) {
                this.color = color;
                this.frame = f;
                this.thickness = thickness;
                this.arc = arc;
                this.parent = parent;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setColor(this.color);
                if (this.parent.darkMode) {
                    g2.setColor(BalfLafManager.getInstance().getDarkColorBackground());
                }
                g2.setStroke(new BasicStroke(this.thickness));
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                boolean isMaximised = false;
                Window window = SwingUtilities.getWindowAncestor(c);
                if (window instanceof JFrame) {
                    isMaximised = (this.frame.getExtendedState() & 6) == 6;
                }
                float offset = (float)Math.ceil((double)this.thickness / 2.0);
                if (isMaximised) {
                    g2.drawRect(Math.round((float)x + offset), Math.round((float)y + offset), Math.round(width - this.thickness), Math.round(height - this.thickness));
                } else {
                    g2.drawRoundRect(Math.round((float)x + offset), Math.round((float)y + offset), Math.round(width - this.thickness), Math.round(height - this.thickness), this.arc, this.arc);
                }
                g2.dispose();
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
            }

            @Override
            public Insets getBorderInsets(Component c, Insets insets) {
                insets.set(this.thickness, this.thickness, this.thickness, this.thickness);
                return insets;
            }
        }
    }
}

