/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui;

import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.BalfMenuBar;
import jamiebalfour.ui.BalfSeparator;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RescaleOp;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonUI;

public class BalfTitleBar
extends JPanel {
    final int roundedCorners;
    final JPanel leftPanel;
    final JPanel rightPanel;
    final JPanel rightButtons;
    private final Point dragOffset = new Point();
    private final Color[] colors = new Color[]{new Color(173, 122, 255), new Color(255, 128, 0), new Color(0, 128, 0), new Color(37, 160, 170)};
    JPanel _this = this;
    boolean _rounded = true;
    JFrame _frame;
    int _roundedCornerArc;
    WindowsCloseButton windowsCloseButton = null;
    GlowingLabel glowingLabel;
    private final Color mainColor;
    private final Color lighterColor;
    private BalfMenuBar _menu;
    private TitleBarLabelListener titleBarLabelListener;
    private CloseListener closeListener;
    MaximiseButtonListener maximiseButtonListener;
    boolean darkMode = false;

    public static BalfTitleBar generateCustomTitleBar(JFrame frame, int roundedCorners) {
        return new BalfTitleBar(frame, roundedCorners, new Color(40, 75, 99), new Color(45, 80, 104));
    }

    public BalfTitleBar(final JFrame frame, int roundedCornerArc, Color mainColor, Color lighterColor) {
        JPanel buttonPanel;
        this._frame = frame;
        this._roundedCornerArc = roundedCornerArc;
        this.roundedCorners = roundedCornerArc;
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.mainColor = mainColor;
        this.lighterColor = lighterColor;
        this.setForeground(Color.WHITE);
        this.setPreferredSize(new Dimension(frame.getWidth() + 1, 40));
        BalfLafManager.getInstance().addListener(enabled -> {
            if (enabled) {
                this.enableDarkMode();
            } else {
                this.disableDarkMode();
            }
            this.repaint();
        });
        int randomNum = (int)(Math.random() * (double)this.colors.length);
        Color chosenColor = this.colors[randomNum];
        this.leftPanel = new JPanel();
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 0));
        this.leftPanel.setAlignmentX(0.0f);
        this.glowingLabel = new GlowingLabel(chosenColor, this.leftPanel);
        this.glowingLabel.setAlignmentX(0.0f);
        this._frame.addPropertyChangeListener("title", evt -> this.repaint());
        this.glowingLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (BalfTitleBar.this.titleBarLabelListener != null) {
                    BalfTitleBar.this.titleBarLabelListener.onGlowingLabelClicked(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (BalfTitleBar.this.glowingLabel.isVisible() && !BalfTitleBar.this.glowingLabel.getText().isEmpty()) {
                    if (BalfTitleBar.this.titleBarLabelListener != null) {
                        BalfTitleBar.this.glowingLabel.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        BalfTitleBar.this.glowingLabel.setCursor(Cursor.getPredefinedCursor(0));
                    }
                } else {
                    BalfTitleBar.this.glowingLabel.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        if (!BalfTitleBar.isMac()) {
            buttonPanel = new JPanel(new FlowLayout(2, 0, 0));
            buttonPanel.setOpaque(false);
            buttonPanel.setSize(new Dimension(130, 40));
            buttonPanel.setMaximumSize(new Dimension(130, 40));
            WindowControlButton minBtn = new WindowControlButton("min");
            minBtn.addActionListener(e -> frame.setState(1));
            buttonPanel.add(minBtn);
            WindowControlButton maxBtn = new WindowControlButton("max");
            maxBtn.addActionListener(e -> {
                if (this.maximiseButtonListener != null) {
                    this.maximiseButtonListener.onMaximiseButtonClicked(e);
                }
                this.activateMaximise();
            });
            buttonPanel.add(maxBtn);
            this.windowsCloseButton = new WindowsCloseButton(this._rounded);
            this.windowsCloseButton.addActionListener(e -> {
                if (this.closeListener != null) {
                    this.closeListener.onCloseButtonClicked(e);
                }
            });
            this.windowsCloseButton.setRounded(this._rounded);
            this.windowsCloseButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    BalfTitleBar.this.windowsCloseButton.setBackground(new Color(128, 128, 128));
                    BalfTitleBar.this.windowsCloseButton.setForeground(Color.WHITE);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    BalfTitleBar.this.windowsCloseButton.setBackground(new Color(51, 51, 51));
                    BalfTitleBar.this.windowsCloseButton.setForeground(new Color(200, 200, 200));
                }
            });
            this.windowsCloseButton.setCursor(Cursor.getPredefinedCursor(12));
            buttonPanel.add(this.windowsCloseButton);
        } else {
            buttonPanel = new JPanel(new FlowLayout(0, 6, 12));
            buttonPanel.setOpaque(false);
            buttonPanel.setSize(new Dimension(50, 40));
            buttonPanel.setMaximumSize(new Dimension(50, 40));
            JButton closeBtn = this.createMacWindowButton("red");
            closeBtn.setToolTipText("Close");
            closeBtn.addActionListener(e -> {
                if (this.closeListener != null) {
                    this.closeListener.onCloseButtonClicked(e);
                }
            });
            buttonPanel.add(closeBtn);
            JButton minBtn = this.createMacWindowButton("yellow");
            minBtn.setToolTipText("Minimise");
            minBtn.addActionListener(e -> frame.setState(1));
            buttonPanel.add(minBtn);
            JButton maxBtn = this.createMacWindowButton("green");
            maxBtn.setToolTipText("Zoom");
            maxBtn.addActionListener(e -> {
                if (this.maximiseButtonListener != null) {
                    this.maximiseButtonListener.onMaximiseButtonClicked(e);
                }
                this._rounded = roundedCornerArc > 0 ? (frame.getExtendedState() & 6) != 6 : false;
                if (this.windowsCloseButton != null) {
                    this.windowsCloseButton.setRounded(this._rounded);
                }
                this.paintComponent(this.getGraphics());
            });
            buttonPanel.add(maxBtn);
        }
        this.leftPanel.setOpaque(false);
        this.leftPanel.setPreferredSize(null);
        this.rightPanel = new JPanel(new FlowLayout(2));
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 0));
        this.rightPanel.setOpaque(false);
        if (BalfTitleBar.isMac()) {
            this.leftPanel.add(buttonPanel);
        }
        this.glowingLabel.setAlignmentX(0.5f);
        this.leftPanel.add(new BalfSeparator(10, 10));
        this.leftPanel.add(this.glowingLabel);
        this.rightButtons = new rightPanelZone(new FlowLayout(0));
        this.rightButtons.setBorder(new EmptyBorder(0, 0, 0, 10));
        this.rightButtons.setOpaque(false);
        this.rightButtons.setVisible(false);
        this.rightPanel.add(this.rightButtons);
        if (!BalfTitleBar.isMac()) {
            this.rightPanel.add(buttonPanel);
        }
        this.add((Component)this.leftPanel, "West");
        this.add((Component)this.rightPanel, "East");
        this.enableDragging(this);
        this.enableDragging(this.leftPanel);
        this.enableDragging(this.rightPanel);
        this.enableDragging(this.glowingLabel);
        this.enableMaximise(this);
        this.enableMaximise(this.leftPanel);
        this.enableMaximise(this.rightPanel);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                if (frame.getWidth() < 800) {
                    BalfTitleBar.this.glowingLabel.hide();
                } else {
                    BalfTitleBar.this.glowingLabel.show();
                }
            }
        });
    }

    static boolean isMac() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.contains("mac");
    }

    public void setTitleBarLabelListener(TitleBarLabelListener listener) {
        this.titleBarLabelListener = listener;
    }

    public void setMaximiseButtonListener(MaximiseButtonListener maximiseButtonListener) {
        this.maximiseButtonListener = maximiseButtonListener;
    }

    public void setCloseListener(CloseListener listener) {
        this.closeListener = listener;
    }

    void activateMaximise() {
        if (this.roundedCorners > 0) {
            boolean bl = this._rounded = (this._frame.getExtendedState() & 6) != 6;
            if (this.windowsCloseButton != null) {
                this.windowsCloseButton.setRounded(this._rounded);
            }
        } else {
            this._rounded = false;
        }
        this.maximiseButtonListener.onMaximiseButtonClicked(null);
        this.paintComponent(this.getGraphics());
    }

    public void addRightButton(rightPanelButton button) {
        button.setPreferredSize(new Dimension(30, 30));
        button.setMaximumSize(new Dimension(30, 30));
        button.setHorizontalAlignment(0);
        button.setVerticalAlignment(0);
        button.setOpaque(false);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusPainted(false);
        button.setCursor(new Cursor(12));
        this.rightButtons.setVisible(true);
        this.rightButtons.add(button);
    }

    private void enableMaximise(JComponent c) {
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    if (BalfTitleBar.this.maximiseButtonListener != null) {
                        BalfTitleBar.this.maximiseButtonListener.onMaximiseButtonClicked(null);
                    }
                    BalfTitleBar.this._rounded = BalfTitleBar.this._roundedCornerArc > 0 ? (BalfTitleBar.this._frame.getExtendedState() & 6) != 6 : false;
                    if (BalfTitleBar.this.windowsCloseButton != null) {
                        BalfTitleBar.this.windowsCloseButton.setRounded(BalfTitleBar.this._rounded);
                    }
                }
            }
        });
    }

    private void enableDragging(JComponent t) {
        t.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BalfTitleBar.this.dragOffset.setLocation(e.getPoint());
            }
        });
        t.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (BalfTitleBar.this._frame.getExtendedState() == 0) {
                    Point framePos = BalfTitleBar.this._frame.getLocation();
                    BalfTitleBar.this._frame.setLocation(framePos.x + e.getX() - BalfTitleBar.this.dragOffset.x, framePos.y + e.getY() - BalfTitleBar.this.dragOffset.y);
                }
            }
        });
    }

    private void enableSnapToTop(final JFrame frame) {
        this._frame = frame;
        final Point dragOffset = new Point();
        int SNAP_THRESHOLD = 5;
        Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        final boolean[] wasMaximised = new boolean[]{false};
        JRootPane dragArea = frame.getRootPane();
        dragArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                dragOffset.setLocation(e.getPoint());
            }
        });
        dragArea.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if ((frame.getExtendedState() & 6) == 6) {
                    frame.setExtendedState(0);
                    dragOffset.setLocation(e.getPoint());
                }
                Point screenPoint = e.getLocationOnScreen();
                int newX = screenPoint.x - dragOffset.x;
                int newY = screenPoint.y - dragOffset.y;
                frame.setLocation(newX, newY);
                if (newY <= 5 && !wasMaximised[0]) {
                    frame.setExtendedState(6);
                    wasMaximised[0] = true;
                } else if (newY > 5 && wasMaximised[0]) {
                    frame.setExtendedState(0);
                    wasMaximised[0] = false;
                }
            }
        });
    }

    private void enableDarkMode() {
        this.darkMode = true;
    }

    private void disableDarkMode() {
        this.darkMode = false;
    }

    private JButton createWindowsTitleButton(String text) {
        JButton button = new JButton(text);
        button.setFont(new Font("Segoe UI", 0, 24));
        button.setPreferredSize(new Dimension(40, 40));
        button.setFocusPainted(false);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setOpaque(false);
        button.setForeground(new Color(200, 200, 200));
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.addMouseListener(new HoverColor(button, new Color(128, 128, 128), new Color(51, 51, 51)));
        return button;
    }

    private JButton createMacWindowButton(String color) {
        macButton button = new macButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/files/" + color + "MacButton.png"))));
        button.setPreferredSize(new Dimension(12, 12));
        button.setContentAreaFilled(false);
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setOpaque(false);
        return button;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        int arc = this.roundedCorners;
        int width = this.getWidth();
        int height = this.getHeight();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean isMaximised = false;
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof JFrame) {
            boolean bl = isMaximised = (this._frame.getExtendedState() & 6) == 6;
        }
        if (!isMaximised && arc > 0) {
            RoundRectangle2D.Double topRounded = new RoundRectangle2D.Double(0.0, 0.0, width, height + arc, arc, arc);
            Area clip = new Area(new Rectangle(0, 0, width, height));
            clip.intersect(new Area(topRounded));
            g2.setClip(clip);
        }
        Color baseColor = this.mainColor;
        Color lighter = this.lighterColor;
        if (this.darkMode) {
            lighter = baseColor = BalfLafManager.getInstance().getDarkColorBackground();
        }
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, lighter, 0.0f, height, baseColor);
        g2.setPaint(gradient);
        g2.fillRect(0, 0, width, height);
        g2.fillRect(width - 1, 0, 2, height);
        String title = this._frame.getTitle();
        Font titleFont = BalfTitleBar.isMac() ? new Font("San Francisco", 1, 16) : new Font("Segoe UI", 1, 16);
        g2.setFont(titleFont);
        g2.setColor(Color.WHITE);
        FontMetrics fm = g2.getFontMetrics();
        int textWidth = fm.stringWidth(title);
        int textHeight = fm.getAscent();
        int x = (width - textWidth) / 2;
        int y = (height + textHeight) / 2 - 4;
        g2.drawString(title, x, y);
        g2.dispose();
        super.paintComponent(g);
    }

    public void setThemeColours(Color bg, Color fg) {
        this.setBackground(bg);
        this.setForeground(fg);
        if (this._menu != null) {
            this._menu.setBackground(this.getBackground());
            this._menu.setForeground(this.getForeground());
        }
    }

    public void attachMenu(BalfMenuBar menu) {
        this._menu = menu;
        if (this._menu != null) {
            this._menu.attachTitleBar(this);
            this.enableDragging(this._menu);
        }
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public String getLabelText() {
        return this.glowingLabel.getText();
    }

    public void setLabelText(String text) {
        this.glowingLabel.setVisible(true);
        this.glowingLabel.setText(text);
        int randomNum = (int)(Math.random() * (double)this.colors.length);
        Color chosenColor = this.colors[randomNum];
        this.glowingLabel.setGlowColor(chosenColor);
    }

    static class GlowingLabel
    extends JComponent {
        private String text = "";
        final Font font = new Font("SansSerif", 0, 14);
        private final Color textColor = Color.WHITE;
        private Color glowColor;
        GlowingLabel _this = this;
        JPanel parent;
        int parentWidth;
        boolean hidden = false;

        public GlowingLabel(Color glowColor, JPanel parent) {
            this.parent = parent;
            this.parentWidth = parent.getWidth();
            this.glowColor = glowColor;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2dMain = (Graphics2D)g.create();
            g2dMain.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontMetrics metrics = g2dMain.getFontMetrics(this.font);
            int textWidth = metrics.stringWidth(this.text) + 10;
            int textHeight = metrics.getAscent();
            this._this.setSize(textWidth, this.getHeight());
            this.parentWidth = 0;
            for (Component c : this.parent.getComponents()) {
                if (c == this) continue;
                this.parentWidth += c.getSize().width;
            }
            this.parent.setSize(this.parentWidth + textWidth, this.getHeight());
            this.parent.setMinimumSize(new Dimension(this.parentWidth + textWidth, this.getHeight()));
            this.parent.setPreferredSize(new Dimension(this.parentWidth + this._this.getSize().width, this.parent.getHeight()));
            if (!this.hidden) {
                int width = this.getWidth();
                int height = this.getHeight();
                int x = 2;
                int y = (height + textHeight) / 2 - 4;
                BufferedImage glowImg = new BufferedImage(width, height, 2);
                Graphics2D gGlow = glowImg.createGraphics();
                gGlow.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                gGlow.setFont(this.font);
                gGlow.setColor(new Color(this.glowColor.getRed(), this.glowColor.getGreen(), this.glowColor.getBlue(), 60));
                for (int dx = -2; dx <= 2; ++dx) {
                    for (int dy = -2; dy <= 2; ++dy) {
                        if (dx == 0 && dy == 0) continue;
                        gGlow.drawString(this.text, x + dx, y + dy);
                    }
                }
                gGlow.dispose();
                g2dMain.drawImage((Image)this.blurImage(glowImg, 8), 0, 0, null);
                g2dMain.setFont(this.font);
                g2dMain.setColor(this.textColor);
                g2dMain.drawString(this.text, x, y);
            }
            g2dMain.dispose();
        }

        @Override
        public void hide() {
            this.hidden = true;
        }

        @Override
        public void show() {
            this.hidden = false;
        }

        private BufferedImage blurImage(BufferedImage img, int radius) {
            float[] kernel = this.createGaussianKernel(radius);
            BufferedImage temp = new BufferedImage(img.getWidth(), img.getHeight(), 2);
            BufferedImage result = new BufferedImage(img.getWidth(), img.getHeight(), 2);
            ConvolveOp op = new ConvolveOp(new Kernel(kernel.length, 1, kernel), 1, null);
            op.filter(img, temp);
            op = new ConvolveOp(new Kernel(1, kernel.length, kernel), 1, null);
            op.filter(temp, result);
            return result;
        }

        private float[] createGaussianKernel(int radius) {
            int i;
            float[] kernel = new float[radius * 2 + 1];
            float sigma = (float)radius / 3.0f;
            float sum = 0.0f;
            for (i = 0; i < kernel.length; ++i) {
                float x = i - radius;
                kernel[i] = (float)Math.exp(-(x * x) / (2.0f * sigma * sigma));
                sum += kernel[i];
            }
            i = 0;
            while (i < kernel.length) {
                int n = i++;
                kernel[n] = kernel[n] / sum;
            }
            return kernel;
        }

        void setText(String text) {
            this.text = text;
            FontMetrics metrics = this.getFontMetrics(this.font);
            this.repaint();
        }

        String getText() {
            return this.text;
        }

        void setGlowColor(Color glowColor) {
            this.glowColor = glowColor;
        }
    }

    class WindowsCloseButton
    extends JButton {
        private boolean rounded;
        boolean hovered = false;

        public WindowsCloseButton(boolean rounded) {
            this.rounded = rounded;
            this.setText("<html><center>\u2715</center></html>");
            this.setFont(new Font("SansSerif", 1, 16));
            this.setFocusable(false);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setOpaque(false);
            this.setUI(new BasicButtonUI());
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setPreferredSize(new Dimension(40, 40));
            this.setForeground(new Color(200, 200, 200));
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    WindowsCloseButton.this.hovered = true;
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    WindowsCloseButton.this.hovered = false;
                }
            });
        }

        public void setRounded(boolean rounded) {
            this.rounded = rounded;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            Shape shape;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int width = this.getWidth();
            int height = this.getHeight();
            int arc = 10;
            if (this.rounded && BalfTitleBar.this.roundedCorners > 0) {
                Path2D.Double path = new Path2D.Double();
                ((Path2D)path).moveTo(0.0, 0.0);
                ((Path2D)path).lineTo(width - arc, 0.0);
                ((Path2D)path).quadTo(width, 0.0, width, arc);
                ((Path2D)path).lineTo(width, height);
                ((Path2D)path).lineTo(0.0, height);
                path.closePath();
                shape = path;
            } else {
                shape = new Rectangle(0, 0, width, height);
            }
            if (this.hovered) {
                g2.setColor(new Color(100, 100, 100));
                g2.fill(shape);
            }
            super.paintComponent(g2);
            g2.dispose();
        }
    }

    public class WindowControlButton
    extends JButton {
        private final String type;
        boolean hovered = false;

        public WindowControlButton(String type) {
            this.type = type;
            this.setOpaque(false);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.setPreferredSize(new Dimension(40, 40));
            this.setForeground(new Color(200, 200, 200));
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    WindowControlButton.this.hovered = true;
                    WindowControlButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    WindowControlButton.this.hovered = false;
                    WindowControlButton.this.repaint();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.WHITE);
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.hovered) {
                g2.setColor(new Color(100, 100, 100));
                g2.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            }
            g2.setColor(Color.WHITE);
            switch (this.type) {
                case "min": {
                    g2.fillRect(w / 2 - 6, h / 2 + 3, 12, 1);
                    break;
                }
                case "max": {
                    g2.drawRoundRect(w / 2 - 6, h / 2 - 6, 12, 12, 4, 4);
                }
            }
            g2.dispose();
        }
    }

    class rightPanelZone
    extends JPanel {
        public rightPanelZone(LayoutManager layout) {
            this.setLayout(layout);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int width = this.getWidth() - 10;
            int height = this.getHeight() - 2;
            g2.setColor(new Color(56, 58, 66));
            int arc = 8;
            int strokeThickness = 1;
            g2.setColor(new Color(51, 51, 51));
            g2.fillRoundRect(3, 3, width - strokeThickness - 6, height - strokeThickness - 6, arc, arc);
            g2.setStroke(new BasicStroke(strokeThickness));
            g2.drawRoundRect(3, 3, width - strokeThickness - 6, height - strokeThickness - 6, arc, arc);
            g2.setColor(new Color(106, 107, 112));
            g2.drawRoundRect(2, 2, width - strokeThickness - 4, height - strokeThickness - 4, arc, arc);
            g2.dispose();
        }
    }

    private class macButton
    extends JButton {
        Image myImage;
        BufferedImage hoverImage;
        boolean mouseIn = false;

        public macButton(ImageIcon image) {
            this.myImage = image.getImage();
            BufferedImage original = new BufferedImage(this.myImage.getWidth(null), this.myImage.getHeight(null), 2);
            Graphics2D g = original.createGraphics();
            g.drawImage(this.myImage, 0, 0, null);
            g.dispose();
            this.hoverImage = this.darkenImage(original, 0.7f);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    macButton.this.mouseIn = true;
                    BalfTitleBar.this._this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    macButton.this.mouseIn = false;
                    BalfTitleBar.this._this.repaint();
                }
            });
        }

        public BufferedImage darkenImage(BufferedImage image, float darkenFactor) {
            RescaleOp op = new RescaleOp(darkenFactor, 0.0f, null);
            return op.filter(image, null);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.myImage != null) {
                int targetWidth = this.getWidth();
                int targetHeight = this.getHeight();
                Image i = this.myImage;
                if (this.mouseIn) {
                    i = this.hoverImage;
                }
                g2d.drawImage(i, 0, 0, targetWidth, targetHeight, null);
            }
            g2d.dispose();
        }
    }

    public static class rightPanelButton
    extends JButton {
        Image myImage;
        int height;
        int width;
        rightPanelButton _this = this;
        boolean mouseIn = false;
        Color hoverColour;

        public rightPanelButton(ImageIcon image, Color hoverColour) {
            this.myImage = image.getImage();
            this.height = this.myImage.getHeight(null);
            this.width = this.myImage.getWidth(null);
            this.hoverColour = hoverColour;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    mouseIn = true;
                    _this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    mouseIn = false;
                    _this.repaint();
                }
            });
        }

        @Override
        public void setIcon(Icon icon) {
            if (icon instanceof ImageIcon) {
                this.myImage = ((ImageIcon)icon).getImage();
            } else {
                int w = icon.getIconWidth();
                int h = icon.getIconHeight();
                BufferedImage image = new BufferedImage(w, h, 2);
                Graphics2D g2 = image.createGraphics();
                icon.paintIcon(null, g2, 0, 0);
                g2.dispose();
                this.myImage = image;
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.mouseIn) {
                g2d.setColor(this._this.hoverColour);
                g2d.fillRoundRect(1, 1, this.getWidth() - 2 - 2, this.getHeight() - 2 - 2, 10, 10);
            }
            if (this.myImage != null) {
                int targetWidth = this.width - 2;
                int targetHeight = this.height - 2;
                g2d.drawImage(this.myImage, (this.getWidth() - targetWidth) / 2 - 1, (this.getHeight() - targetHeight) / 2 - 1, targetWidth, targetHeight, null);
            }
            g2d.dispose();
        }
    }

    private static class HoverColor
    extends MouseAdapter {
        private final JComponent comp;
        private final Color hoverColor;
        private final Color defaultColor;

        public HoverColor(JComponent comp, Color hoverColor, Color defaultColor) {
            this.comp = comp;
            this.hoverColor = hoverColor;
            this.defaultColor = defaultColor;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.comp.setBackground(this.hoverColor);
            this.comp.setOpaque(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.comp.setBackground(this.defaultColor);
            this.comp.setOpaque(false);
        }
    }

    public static interface CloseListener {
        public void onCloseButtonClicked(ActionEvent var1);
    }

    public static interface MaximiseButtonListener {
        public void onMaximiseButtonClicked(ActionEvent var1);
    }

    public static interface TitleBarLabelListener {
        public void onGlowingLabelClicked(MouseEvent var1);
    }
}

