/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui;

import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.BalfScrollbar;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BalfSearchBox
extends JTextField {
    private boolean darkMode = false;
    JPopupMenu suggestionPopup = new JPopupMenu();
    SuggestionList suggestionList = new SuggestionList();
    ArrayList<SearchSuggestion> suggestions = new ArrayList();
    String searchText = "Search...";
    private final List<SearchSuggestedClickListener> listeners = new ArrayList<SearchSuggestedClickListener>();

    public BalfSearchBox() {
        this.setup();
    }

    public BalfSearchBox(String searchText) {
        this.searchText = searchText;
        this.setup();
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    private void setup() {
        this.setMaximumSize(new Dimension(190, 25));
        this.setPreferredSize(new Dimension(190, 35));
        this.setBorder(new EmptyBorder(16, 3, 16, 3));
        this.setForeground(Color.BLACK);
        this.setOpaque(false);
        BalfLafManager.getInstance().addListener((boolean enabled) -> {
            this.darkMode = enabled;
            if (this.darkMode) {
                this.setForeground(Color.WHITE);
            } else {
                this.setForeground(Color.BLACK);
            }
        });
        if (this.darkMode) {
            this.setForeground(Color.WHITE);
        } else {
            this.setForeground(Color.BLACK);
        }
        this.suggestionPopup.setBorder(new EmptyBorder(0, 0, 0, 0));
        BalfScrollbar b = new BalfScrollbar(this.suggestionList);
        this.suggestionList.setBorder(new EmptyBorder(0, 0, 0, 0));
        b.setBorder(new EmptyBorder(0, 0, 0, 0));
        b.setHorizontalScrollBarPolicy(31);
        this.suggestionPopup.add(b);
        this.suggestionPopup.setFocusable(false);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BalfSearchBox.this.showSuggestions();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BalfSearchBox.this.showSuggestions();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BalfSearchBox.this.showSuggestions();
            }
        });
        this.suggestionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String selected = (String)BalfSearchBox.this.suggestionList.getSelectedValue();
                if (selected != null) {
                    for (SearchSuggestedClickListener l : BalfSearchBox.this.listeners) {
                        l.onSearchSuggestionClicked(selected);
                    }
                    BalfSearchBox.this.suggestionPopup.setVisible(false);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                if (BalfSearchBox.this.suggestionList != null) {
                    int cur = BalfSearchBox.this.suggestionList.getSelectedIndex();
                    if (e.getKeyCode() == 40) {
                        if (cur + 1 < BalfSearchBox.this.suggestions.size()) {
                            BalfSearchBox.this.suggestionList.setSelectedIndex(cur + 1);
                        }
                    } else if (e.getKeyCode() == 38) {
                        if (cur - 1 > -1) {
                            BalfSearchBox.this.suggestionList.setSelectedIndex(cur - 1);
                        }
                    } else if (e.getKeyCode() == 10 && BalfSearchBox.this.suggestionList.getSelectedIndex() != -1) {
                        for (SearchSuggestedClickListener l : BalfSearchBox.this.listeners) {
                            l.onSearchSuggestionClicked((String)BalfSearchBox.this.suggestionList.getSelectedValue());
                        }
                    }
                }
            }
        });
    }

    public void addSuggestion(SearchSuggestion suggestion) {
        this.suggestions.add(suggestion);
    }

    public void deleteSuggestion(SearchSuggestion suggestion) {
        this.suggestions.remove(suggestion);
    }

    public void deleteAllSuggestions() {
        this.suggestions.clear();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int arcWidth = this.getHeight();
        int arcHeight = this.getHeight();
        int inset = 1;
        int width = this.getWidth();
        int height = this.getHeight();
        g2.setColor(Color.WHITE);
        if (this.darkMode) {
            g2.setColor(BalfLafManager.getInstance().getDarkColorInputBackground());
        }
        g2.fillRoundRect(inset, inset, width - inset * 2, height - inset * 2, arcWidth, arcHeight);
        if (this.getText().isEmpty() && !this.hasFocus()) {
            g2.setColor(Color.lightGray);
            g2.setFont(new Font(this.getFont().getName(), 2, this.getFont().getSize()));
            FontMetrics fm = g2.getFontMetrics();
            int textWidth = fm.stringWidth(this.searchText);
            int textHeight = fm.getAscent();
            int y = (height - fm.getHeight()) / 2 + fm.getAscent();
            g2.drawString(this.searchText, 7, y);
        }
        super.paintComponent(g);
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 10, 0, 10);
    }

    private void showSuggestions() {
        String input = this.getText().trim().toLowerCase();
        if (input.isEmpty()) {
            this.suggestionPopup.setVisible(false);
            return;
        }
        ArrayList<String> matches = new ArrayList<String>();
        for (SearchSuggestion i : this.suggestions) {
            if (!i.suggestion.toLowerCase().contains(input)) continue;
            matches.add(i.displayText);
        }
        if (matches.isEmpty()) {
            this.suggestionPopup.setVisible(false);
            return;
        }
        this.suggestionList.setListData(matches.toArray(new String[0]));
        try {
            int height;
            Point location = this.getLocationOnScreen();
            int index = 0;
            Rectangle bounds = this.suggestionList.getCellBounds(index, index);
            int n = height = bounds != null ? bounds.height : -1;
            if (matches.size() < 10) {
                this.suggestionPopup.setPopupSize(this.getWidth() + 100, matches.size() * height);
            } else {
                this.suggestionPopup.setPopupSize(this.getWidth() + 100, 200);
            }
            this.suggestionPopup.show(this, -100, this.getHeight());
            this.suggestionList.setSelectedIndex(0);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    public void addListener(SearchSuggestedClickListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SearchSuggestedClickListener listener) {
        this.listeners.remove(listener);
    }

    public static class SearchSuggestion {
        public String suggestion;
        public String displayText;

        public SearchSuggestion(String suggestionText, String displayText) {
            this.suggestion = suggestionText;
            this.displayText = displayText;
        }
    }

    public class SuggestionList
    extends JList<String> {
        boolean darkMode = false;

        public SuggestionList() {
            this.setOpaque(false);
            this.setCellRenderer((list, value, index, isSelected, cellHasFocus) -> {
                JLabel label = new JLabel((String)value);
                label.setOpaque(true);
                if (this.darkMode) {
                    label.setBackground(isSelected ? new Color(60, 60, 80) : new Color(40, 40, 40));
                    label.setForeground(Color.WHITE);
                } else {
                    label.setBackground(isSelected ? new Color(220, 220, 255) : Color.WHITE);
                    label.setForeground(Color.BLACK);
                }
                return label;
            });
            BalfLafManager.getInstance().addListener(enabled -> {
                this.darkMode = enabled;
                if (this.darkMode) {
                    this.setForeground(Color.WHITE);
                } else {
                    this.setForeground(Color.BLACK);
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            if (this.darkMode) {
                g2d.setColor(new Color(40, 40, 40));
            } else {
                g2d.setColor(Color.WHITE);
            }
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.dispose();
            super.paintComponent(g);
        }
    }

    public static interface SearchSuggestedClickListener {
        public void onSearchSuggestionClicked(String var1);
    }
}

