/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.parsers.jbml;

import jamiebalfour.HelperFunctions;
import jamiebalfour.parsers.jbml.MalformedJBMLException;
import jamiebalfour.parsers.jbml.ZenithJBMLParserByteCodes;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.parser.v4.ZenithParsingEngine;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPEString;
import java.util.ArrayList;
import java.util.Objects;

public class ZenithJBMLParser {
    ArrayList<String> keys = new ArrayList();
    ZenithParsingEngine parser;
    ZPEMap group = null;

    private static void eatNewLines(ZenithParsingEngine parser) {
        while (parser.getCurrentSymbol() == 4) {
            parser.getNextSymbol();
        }
    }

    private static ZPEType produceOne(ZenithJBMLParser jbml) throws MalformedJBMLException {
        if (jbml.parser.getCurrentSymbol() == 5) {
            if (jbml.keys.contains(jbml.parser.getCurrentWord()) && jbml.group != null && jbml.group.containsKey(new ZPEString(jbml.parser.getCurrentWord()))) {
                ZPEType output = jbml.group.get(new ZPEString(jbml.parser.getCurrentWord()));
                if (jbml.parser.peekAhead() == 14) {
                    jbml.parser.getNextSymbol();
                    jbml.parser.getNextSymbol();
                    return new ZPEString(output.toString() + ZenithJBMLParser.produceOne(jbml));
                }
                return output;
            }
        } else {
            if (jbml.parser.getCurrentSymbol() == 8) {
                Object output = jbml.parser.getCurrentWord();
                if (jbml.parser.peekAhead() == 14) {
                    jbml.parser.getNextSymbol();
                    jbml.parser.getNextSymbol();
                    output = (String)output + ZenithJBMLParser.produceOne(jbml);
                }
                return new ZPEString((String)output);
            }
            if (jbml.parser.getCurrentSymbol() == 7) {
                return new ZPENumber(HelperFunctions.stringToDouble(jbml.parser.getCurrentWord()));
            }
            if (jbml.parser.getCurrentSymbol() == 6) {
                return new ZPENumber(HelperFunctions.stringToLong(jbml.parser.getCurrentWord()));
            }
            if (jbml.parser.getCurrentSymbol() == 9) {
                return new ZPEBoolean(ZPEHelperFunctions.ToBoolean(jbml.parser.getCurrentWord()));
            }
            if (jbml.parser.getCurrentSymbol() == 1) {
                ZPEList list = new ZPEList();
                jbml.parser.getNextSymbol();
                while (jbml.parser.getCurrentSymbol() != 2) {
                    ZenithJBMLParser.eatNewLines(jbml.parser);
                    ZPEType k = ZenithJBMLParser.produceOne(jbml);
                    list.add(k);
                    jbml.parser.getNextSymbol();
                    ZenithJBMLParser.eatNewLines(jbml.parser);
                    if (jbml.parser.getCurrentSymbol() == 2) break;
                    ZenithJBMLParser.eatNewLines(jbml.parser);
                    if (jbml.parser.getCurrentSymbol() != 10) {
                        throw new MalformedJBMLException("ZenithJBMLParser: Expected comma.");
                    }
                    jbml.parser.getNextSymbol();
                    ZenithJBMLParser.eatNewLines(jbml.parser);
                }
                return list;
            }
            if (jbml.parser.getCurrentSymbol() == 12) {
                ZPEMap map = new ZPEMap();
                jbml.parser.getNextSymbol();
                while (jbml.parser.getCurrentSymbol() != 13) {
                    ZenithJBMLParser.eatNewLines(jbml.parser);
                    ZPEType k = ZenithJBMLParser.produceOne(jbml);
                    jbml.parser.getNextSymbol();
                    ZenithJBMLParser.eatNewLines(jbml.parser);
                    if (jbml.parser.getCurrentSymbol() != 11) {
                        throw new MalformedJBMLException("ZenithJBMLParser: Expected colon.");
                    }
                    jbml.parser.getNextSymbol();
                    ZenithJBMLParser.eatNewLines(jbml.parser);
                    ZPEType v = ZenithJBMLParser.produceOne(jbml);
                    jbml.parser.getNextSymbol();
                    ZenithJBMLParser.eatNewLines(jbml.parser);
                    map.put(k, v);
                    if (jbml.parser.getCurrentSymbol() == 13) {
                        return map;
                    }
                    ZenithJBMLParser.eatNewLines(jbml.parser);
                    if (jbml.parser.getCurrentSymbol() != 10) {
                        throw new MalformedJBMLException("ZenithJBMLParser: Expected comma.");
                    }
                    jbml.parser.getNextSymbol();
                    ZenithJBMLParser.eatNewLines(jbml.parser);
                }
                return map;
            }
        }
        return null;
    }

    public ZPEMap parseJBMLToMap(String s) throws MalformedJBMLException {
        ZPEMap output = new ZPEMap();
        String currentGroup = "";
        this.parser = new ZenithParsingEngine(s, false, new ZenithJBMLParserByteCodes());
        this.parser.getNextSymbol();
        while (this.parser.getCurrentSymbol() != -2) {
            while (this.parser.getCurrentSymbol() == 4) {
                this.parser.getNextSymbol();
            }
            if (this.parser.getCurrentSymbol() == -2) continue;
            if (this.parser.getCurrentSymbol() == 1) {
                String newGroup = this.parser.parseTo((byte)2).trim();
                if (!newGroup.equals(currentGroup) && !currentGroup.isEmpty()) {
                    output.put(new ZPEString(currentGroup), this.group);
                }
                currentGroup = newGroup;
                this.group = new ZPEMap();
                this.parser.getNextSymbol();
                continue;
            }
            if (this.parser.getCurrentSymbol() == 4) continue;
            String key = this.parser.getCurrentWord();
            this.keys.add(key);
            this.parser.getNextSymbol();
            if (!this.parser.getCurrentWord().equals("=")) {
                throw new MalformedJBMLException("ZenithJBMLParser: Unexpected value " + this.parser.getCurrentWord());
            }
            this.parser.getNextSymbol();
            ZPEType value = ZenithJBMLParser.produceOne(this);
            this.parser.getNextSymbol();
            Objects.requireNonNullElse(this.group, output).put(new ZPEString(key), value);
        }
        if (!output.containsKey(new ZPEString(currentGroup))) {
            output.put(new ZPEString(currentGroup), this.group);
        }
        return output;
    }
}

