/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.fusesource.hawtdispatch.Dispatcher;
import org.fusesource.hawtdispatch.Metrics;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;

public class JmxService {
    private static CompositeType METRICS_COMPOSITE_TYPE;

    public static ObjectName objectName(HawtDispatcher dispatcher) {
        try {
            return new ObjectName("org.hawtdispatch:type=Dispatcher,name=" + ObjectName.quote(dispatcher.getLabel()));
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static void register(HawtDispatcher dispatcher) throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        server.registerMBean(new JmxDispatcher(dispatcher), JmxService.objectName(dispatcher));
    }

    static {
        CompositeTypeFactory factory2 = new CompositeTypeFactory();
        factory2.addItem("label", "The queue label", SimpleType.STRING);
        factory2.addItem("duration", "The length of time spent gathering metricsN", SimpleType.DOUBLE);
        factory2.addItem("enqueued", "The number of tasks enqueued", SimpleType.LONG);
        factory2.addItem("enqueueTimeMean", "The mean amount of time an enqueued tasks waited before it was executed", SimpleType.DOUBLE);
        factory2.addItem("enqueueTimeMax", "The maximum amount of time a single enqueued task waited before it was executed", SimpleType.DOUBLE);
        factory2.addItem("enqueueTimeTotal", "The total amount of time all enqueued tasks spent waiting to be executed", SimpleType.DOUBLE);
        factory2.addItem("executed", "The number of tasks executed", SimpleType.LONG);
        factory2.addItem("executeTimeMean", "The mean amount of time tasks took to execute", SimpleType.DOUBLE);
        factory2.addItem("executeTimeMax", "The maximum amount of time a single task took to execute", SimpleType.DOUBLE);
        factory2.addItem("executeTimeTotal", "The total amount of time all tasks spent executing", SimpleType.DOUBLE);
        METRICS_COMPOSITE_TYPE = factory2.create(Metrics.class);
    }

    static class CompositeTypeFactory {
        private final List<String> itemNamesList = new ArrayList<String>();
        private final List<String> itemDescriptionsList = new ArrayList<String>();
        private final List<OpenType> itemTypesList = new ArrayList<OpenType>();

        CompositeTypeFactory() {
        }

        protected void addItem(String name, String description, OpenType type) {
            this.itemNamesList.add(name);
            this.itemDescriptionsList.add(description);
            this.itemTypesList.add(type);
        }

        protected CompositeType create(Class clazz) {
            return this.create(clazz.getName(), clazz.getName());
        }

        protected CompositeType create(String name, String description) {
            try {
                String[] itemNames = this.itemNamesList.toArray(new String[this.itemNamesList.size()]);
                String[] itemDescriptions = this.itemDescriptionsList.toArray(new String[this.itemDescriptionsList.size()]);
                OpenType[] itemTypes = this.itemTypesList.toArray(new OpenType[this.itemTypesList.size()]);
                return new CompositeType(name, description, itemNames, itemDescriptions, itemTypes);
            }
            catch (OpenDataException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class JmxDispatcher {
        final Dispatcher dispatcher;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;

        public JmxDispatcher(Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }
    }
}

