/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtbuf;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.HexSupport;
import org.fusesource.hawtbuf.UTF8Buffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Buffer
implements Comparable<Buffer> {
    public byte[] data;
    public int offset;
    public int length;

    public Buffer(Buffer other) {
        this(other.data, other.offset, other.length);
    }

    public Buffer(int size) {
        this(new byte[size]);
    }

    public Buffer(byte[] data) {
        this(data, 0, data.length);
    }

    public Buffer(byte[] data, int offset, int length) {
        assert (data != null) : "data cannot be null";
        assert (offset + length <= data.length) : String.format("offset %d + length %d must be <= the data.length %d", offset, length, data.length);
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public final byte[] getData() {
        return this.data;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final byte[] toByteArray() {
        int length = this.length;
        byte[] data = this.data;
        if (length != data.length) {
            byte[] t = new byte[length];
            System.arraycopy(data, this.offset, t, 0, length);
            data = t;
        }
        return data;
    }

    public final byte get(int i) {
        return this.data[this.offset + i];
    }

    public final boolean equals(Buffer obj) {
        byte[] data = this.data;
        int offset = this.offset;
        int length = this.length;
        if (length != obj.length) {
            return false;
        }
        byte[] objData = obj.data;
        int objOffset = obj.offset;
        for (int i = 0; i < length; ++i) {
            if (objData[objOffset + i] == data[offset + i]) continue;
            return false;
        }
        return true;
    }

    public final int indexOf(byte value) {
        return this.indexOf(value, 0);
    }

    public final int indexOf(byte value, int pos) {
        byte[] data = this.data;
        int offset = this.offset;
        int length = this.length;
        for (int i = pos; i < length; ++i) {
            if (data[offset + i] != value) continue;
            return i;
        }
        return -1;
    }

    public final AsciiBuffer ascii() {
        return new AsciiBuffer(this);
    }

    public final UTF8Buffer utf8() {
        return new UTF8Buffer(this);
    }

    public int hashCode() {
        byte[] data = this.data;
        int offset = this.offset;
        int length = this.length;
        byte[] target = new byte[4];
        for (int i = 0; i < length; ++i) {
            int n = i % 4;
            target[n] = (byte)(target[n] ^ data[offset + i]);
        }
        return target[0] << 24 | target[1] << 16 | target[2] << 8 | target[3];
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != Buffer.class) {
            return false;
        }
        return this.equals((Buffer)obj);
    }

    @Override
    public int compareTo(Buffer o) {
        if (this == o) {
            return 0;
        }
        byte[] data = this.data;
        int offset = this.offset;
        int length = this.length;
        int oLength = o.length;
        int oOffset = o.offset;
        byte[] oData = o.data;
        int minLength = Math.min(length, oLength);
        if (offset == oOffset) {
            int limit = minLength + offset;
            for (int pos = offset; pos < limit; ++pos) {
                int b1 = 0xFF & data[pos];
                int b2 = 0xFF & oData[pos];
                if (b1 == b2) continue;
                return b1 - b2;
            }
        } else {
            int offset1 = offset;
            int offset2 = oOffset;
            while (minLength-- != 0) {
                int b2;
                int b1;
                if ((b1 = 0xFF & data[offset1++]) == (b2 = 0xFF & oData[offset2++])) continue;
                return b1 - b2;
            }
        }
        return length - oLength;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.data, this.offset, this.length);
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.data, this.offset, this.length);
    }

    public static UTF8Buffer utf8(String value) {
        return UTF8Buffer.utf8(value);
    }

    public String toString() {
        int size = this.length;
        boolean asciiPrintable = true;
        for (int i = 0; i < size; ++i) {
            int c = this.data[this.offset + i] & 0xFF;
            if (c <= 126 && c >= 32 || c == 10 || c == 13 | c == 10 | c == 27) continue;
            asciiPrintable = false;
            break;
        }
        if (asciiPrintable) {
            return "ascii: " + this.ascii();
        }
        return "hex: " + HexSupport.toHexFromBuffer(this);
    }
}

