/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.gui;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.editor.ZPEVariableWatchWindow;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.InternalException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.GenericEditor;
import jamiebalfour.zpe.types.ZPEString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Taskbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Properties;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ZPEConsole
extends JFrame {
    private static final long serialVersionUID = 4086525518278830649L;
    final ZPEConsole console;
    final GenericEditor parent;
    JTextPane consoleOutput;
    PrintStream defaultOut;
    PrintStream defaultErr;
    InputStream defaultIn;
    String lastCode = "";
    ZPEString[] lastArgs;
    boolean lastWasCI;
    ZPERuntimeEnvironment yass;
    int permission_level = 3;
    Properties mainProperties;
    static FileNameExtensionFilter filter1 = new FileNameExtensionFilter("YASS files (*.yas)", "yas");
    static FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Text files (*.txt)", "txt");
    static FileNameExtensionFilter filter3 = new FileNameExtensionFilter("YASS executable files (*.yex)", "yex");
    Thread currentThread;

    public ZPEConsole(int permission_level, String file, boolean caseInsensitive) {
        this.parent = null;
        this.permission_level = permission_level;
        this.console = this;
        this.console.setSize(400, 400);
        URL imagePath = HelperFunctions.isMac() ? this.getClass().getResource("/files/ZPELogomacOS.png") : this.getClass().getResource("/files/ZPELogoLighter.png");
        assert (imagePath != null);
        ImageIcon lighterLogo = new ImageIcon(imagePath);
        Image newimg = lighterLogo.getImage().getScaledInstance(60, 60, 4);
        lighterLogo = new ImageIcon(newimg);
        try {
            this.setIconImage(lighterLogo.getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Taskbar.isTaskbarSupported()) {
                Toolkit.getDefaultToolkit();
                Taskbar taskbar = Taskbar.getTaskbar();
                Image image = lighterLogo.getImage();
                taskbar.setIconImage(image);
            }
        }
        catch (Exception taskbar) {
            // empty catch block
        }
        String path = ZPEInstance.getInstallPath() + "gui.properties";
        File f = new File(path);
        if (f.exists()) {
            try {
                this.mainProperties = HelperFunctions.readProperties(path);
                if (this.mainProperties.containsKey("CONSOLE_HEIGHT")) {
                    this.console.setSize(this.console.getWidth(), HelperFunctions.stringToInteger(this.mainProperties.get("CONSOLE_HEIGHT").toString()));
                }
                if (this.mainProperties.containsKey("CONSOLE_WIDTH")) {
                    this.console.setSize(HelperFunctions.stringToInteger(this.mainProperties.get("CONSOLE_WIDTH").toString()), this.console.getHeight());
                }
                if (this.mainProperties.containsKey("CONSOLE_XPOS")) {
                    this.console.setLocation(new Point(HelperFunctions.stringToInteger(this.mainProperties.get("CONSOLE_XPOS").toString()), this.console.getY()));
                }
                if (this.mainProperties.containsKey("CONSOLE_YPOS")) {
                    this.console.setLocation(new Point(this.console.getX(), HelperFunctions.stringToInteger(this.mainProperties.get("CONSOLE_YPOS").toString())));
                }
                if (this.mainProperties.containsKey("CONSOLE_MAXIMISED") && this.mainProperties.get("CONSOLE_MAXIMISED").toString().equals("true")) {
                    this.console.setExtendedState(6);
                }
                boolean useMacMenuBar = true;
                if (this.mainProperties.containsKey("USE_MAC_SIMPLEBAR")) {
                    boolean bl = useMacMenuBar = !this.mainProperties.get("USE_MAC_SIMPLEBAR").toString().equals("true");
                }
                if (HelperFunctions.isMac() && useMacMenuBar) {
                    System.setProperty("apple.laf.useScreenMenuBar", "true");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.startup(new Font("Consolas", 0, 18));
            try {
                this.runCode(HelperFunctions.readFileAsString(file), new ZPEString[0], caseInsensitive);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ZPEConsole.this.mainProperties.put("CONSOLE_HEIGHT", "" + ZPEConsole.this.console.getHeight());
                ZPEConsole.this.mainProperties.put("CONSOLE_WIDTH", "" + ZPEConsole.this.console.getWidth());
                ZPEConsole.this.mainProperties.put("CONSOLE_XPOS", "" + ZPEConsole.this.console.getX());
                ZPEConsole.this.mainProperties.put("CONSOLE_YPOS", "" + ZPEConsole.this.console.getY());
                if (ZPEConsole.this.console.getExtendedState() == 6) {
                    ZPEConsole.this.mainProperties.put("CONSOLE_MAXIMISED", "true");
                } else {
                    ZPEConsole.this.mainProperties.put("CONSOLE_MAXIMISED", "false");
                }
                String path = ZPEInstance.getInstallPath() + "gui.properties";
                try {
                    FileOutputStream output = new FileOutputStream(path);
                    ZPEConsole.this.mainProperties.store(output, null);
                }
                catch (Exception ex) {
                    ZPE.log("Error saving GUI settings. " + ex.getMessage());
                }
                System.exit(0);
            }
        });
    }

    public ZPEConsole(GenericEditor owner, String title, Font font, int permission_level) {
        this.parent = owner;
        this.console = this;
        this.permission_level = permission_level;
        this.setSize(new Dimension(400, 350));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ZPEConsole.this.parent != null) {
                    ZPEConsole.this.parent.setProperty("CONSOLE_HEIGHT", "" + ZPEConsole.this.console.getHeight());
                    ZPEConsole.this.parent.setProperty("CONSOLE_WIDTH", "" + ZPEConsole.this.console.getWidth());
                    ZPEConsole.this.parent.setProperty("CONSOLE_XPOS", "" + ZPEConsole.this.console.getX());
                    ZPEConsole.this.parent.setProperty("CONSOLE_YPOS", "" + ZPEConsole.this.console.getY());
                    if (ZPEConsole.this.console.getExtendedState() == 6) {
                        ZPEConsole.this.parent.setProperty("CONSOLE_MAXIMISED", "true");
                    } else {
                        ZPEConsole.this.parent.setProperty("CONSOLE_MAXIMISED", "false");
                    }
                    ZPEConsole.this.parent.saveGUISettings(ZPEConsole.this.parent.getProperties());
                }
                ZPEConsole.this.parent.destroyConsole();
            }
        });
        this.setTitle(title);
        if (this.parent.getProperties().containsKey("CONSOLE_HEIGHT")) {
            this.console.setSize(this.console.getWidth(), HelperFunctions.stringToInteger(this.parent.getProperties().get("CONSOLE_HEIGHT").toString()));
        }
        if (this.parent.getProperties().containsKey("CONSOLE_WIDTH")) {
            this.console.setSize(HelperFunctions.stringToInteger(this.parent.getProperties().get("CONSOLE_WIDTH").toString()), this.console.getHeight());
        }
        if (this.parent.getProperties().containsKey("CONSOLE_XPOS")) {
            this.console.setLocation(new Point(HelperFunctions.stringToInteger(this.parent.getProperties().get("CONSOLE_XPOS").toString()), this.console.getY()));
        }
        if (this.parent.getProperties().containsKey("CONSOLE_YPOS")) {
            this.console.setLocation(new Point(this.console.getX(), HelperFunctions.stringToInteger(this.parent.getProperties().get("CONSOLE_YPOS").toString())));
        }
        if (this.parent.getProperties().containsKey("CONSOLE_MAXIMISED") && this.parent.getProperties().get("CONSOLE_MAXIMISED").toString().equals("true")) {
            this.console.setExtendedState(6);
        }
        this.startup(font);
    }

    private void startup(Font font) {
        this.getContentPane().setLayout(new GridLayout(1, 0, 0, 0));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.getContentPane().add((Component)scrollPane, "Center");
        this.consoleOutput = new JTextPane();
        this.consoleOutput.setForeground(new Color(255, 255, 255));
        this.consoleOutput.setBackground(new Color(0, 0, 0));
        this.consoleOutput.setBorder(BorderFactory.createEmptyBorder());
        this.consoleOutput.setFont(font);
        scrollPane.setViewportView(this.consoleOutput);
        int modifier = 2;
        if (HelperFunctions.isMac()) {
            modifier = 4;
        }
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBorderPainted(false);
        menuBar.setForeground(Color.BLACK);
        menuBar.setBackground(Color.WHITE);
        this.setJMenuBar(menuBar);
        JMenu mnFileMenu = new JMenu("File");
        menuBar.add(mnFileMenu);
        JMenuItem mntmSaveOutputMenuItem = new JMenuItem("Save output");
        mntmSaveOutputMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.addChoosableFileFilter(filter2);
                fc.setAcceptAllFileFilterUsed(false);
                int returnVal = fc.showSaveDialog(ZPEConsole.this.console.getContentPane());
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    String extension = ZPEConsole.getSaveExtension(fc.getFileFilter());
                    try {
                        HelperFunctions.writeFile(file.getAbsolutePath() + "." + extension, ZPEConsole.this.consoleOutput.getText(), false);
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(ZPEConsole.this.console, "The file could not be saved.", "Error", 0);
                    }
                }
            }
        });
        mnFileMenu.add(mntmSaveOutputMenuItem);
        JMenuItem mntmReRunCodeMenuItem = new JMenuItem("Rerun this code");
        mntmReRunCodeMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        mntmReRunCodeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZPEKit.setDebugging(false);
                ZPEConsole.this.runCode(ZPEConsole.this.lastCode, ZPEConsole.this.lastArgs, ZPEConsole.this.lastWasCI);
            }
        });
        mnFileMenu.add(mntmReRunCodeMenuItem);
        JMenuItem mntmDebugThisCodeMenuItem = new JMenuItem("Debug this code");
        mntmDebugThisCodeMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 1));
        mntmDebugThisCodeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZPEKit.setDebugging(true);
                ZPEConsole.this.runCode(ZPEConsole.this.lastCode, ZPEConsole.this.lastArgs, ZPEConsole.this.lastWasCI);
            }
        });
        mnFileMenu.add(mntmDebugThisCodeMenuItem);
        JMenu mnEditMenu = new JMenu("Edit");
        mnEditMenu.setMnemonic('E');
        menuBar.add(mnEditMenu);
        JMenuItem mntmCopyMenuItem = new JMenuItem("Copy");
        mntmCopyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, modifier));
        mntmCopyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZPEConsole.this.consoleOutput.copy();
            }
        });
        mnEditMenu.add(mntmCopyMenuItem);
        this.defaultOut = System.out;
        this.defaultErr = System.err;
        this.defaultIn = System.in;
        this.setVisible(true);
        this.setAutoRequestFocus(true);
        OutputStream out = new OutputStream(){

            @Override
            public void write(int b) {
                SwingUtilities.invokeLater(new updateText("" + b, Color.white));
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                SwingUtilities.invokeLater(new updateText(new String(b, off, len), Color.white));
            }

            @Override
            public void write(byte[] b) throws IOException {
                SwingUtilities.invokeLater(new updateText(new String(b), Color.white));
            }
        };
        OutputStream err = new OutputStream(){

            @Override
            public void write(int b) {
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                String str = new String(b, off, len);
                if (!str.contains("at java")) {
                    SwingUtilities.invokeLater(new updateText(str, Color.red));
                }
            }

            @Override
            public void write(byte[] b) throws IOException {
                String str = new String(b);
                if (!str.contains("at java")) {
                    SwingUtilities.invokeLater(new updateText(str, Color.red));
                }
            }
        };
        System.setOut(new PrintStream(out, true));
        System.setIn(new TextFieldStreamer(this.consoleOutput));
        System.setErr(new PrintStream(err, true));
    }

    public void runCode(String code, ZPEString[] args2, boolean caseInsensitive) {
        CodeExecutionWorker worker = new CodeExecutionWorker(code, args2, caseInsensitive);
        worker.execute();
    }

    private static String getSaveExtension(FileFilter f) {
        if (f.equals(filter1)) {
            return "yas";
        }
        if (f.equals(filter2)) {
            return "txt";
        }
        if (f.equals(filter3)) {
            return "yex";
        }
        return null;
    }

    class TextFieldStreamer
    extends InputStream {
        private final JTextPane textfield;
        private String str = null;
        private int pos = 0;

        public TextFieldStreamer(JTextPane jtf) {
            this.textfield = jtf;
            this.textfield.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    e.consume();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void keyPressed(KeyEvent e) {
                    block11: {
                        try {
                            boolean mods;
                            boolean bl = mods = e.isAltDown() || e.isMetaDown() || e.isControlDown() || e.isAltGraphDown() || e.isActionKey();
                            if (mods) break block11;
                            if (e.getKeyCode() == 10) {
                                TextFieldStreamer.this.pos = 0;
                                Scanner s = new Scanner(TextFieldStreamer.this.textfield.getText());
                                while (s.hasNext()) {
                                    TextFieldStreamer.this.str = s.nextLine() + "\n";
                                }
                                1 var4_5 = this;
                                synchronized (var4_5) {
                                    this.notifyAll();
                                    break block11;
                                }
                            }
                            if (e.getKeyCode() == 8) {
                                if (TextFieldStreamer.this.textfield.getText().endsWith("\n")) {
                                    e.consume();
                                }
                            } else if (e.getKeyCode() != 16 && e.getKeyCode() != 0 && TextFieldStreamer.this.textfield.isEditable()) {
                                System.out.print(e.getKeyChar());
                            }
                        }
                        catch (Exception ex) {
                            ZPE.print("Error");
                        }
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    e.consume();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() {
            try {
                this.textfield.requestFocus();
                this.textfield.setEditable(true);
                if (this.str != null && this.pos == this.str.length()) {
                    this.str = null;
                    return -1;
                }
                while (this.str == null || this.pos >= this.str.length()) {
                    try {
                        TextFieldStreamer textFieldStreamer = this;
                        synchronized (textFieldStreamer) {
                            this.wait(100L);
                        }
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                this.textfield.setEditable(false);
                return this.str.charAt(this.pos++);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }

    private class updateText
    implements Runnable {
        String s = "";
        Color c = Color.white;

        updateText(String t, Color col) {
            if (!(t.trim().startsWith("java.") || t.contains("Cannot invoke \"javax.swing.text.View.paint(java.awt.Graphics, java.awt.Shape)\" because \"this.view\" is null") || t.contains("Exception in thread \"AWT-EventQueue"))) {
                this.s = t;
                this.c = col;
            }
        }

        @Override
        public void run() {
            int len = ZPEConsole.this.consoleOutput.getDocument().getLength();
            ZPEConsole.this.consoleOutput.setCaretPosition(len);
            ZPEConsole.this.consoleOutput.replaceSelection(this.s);
        }
    }

    class CodeExecutionWorker
    extends SwingWorker<Void, String> {
        public CodeExecutionWorker(String code, ZPEString[] args2, boolean caseInsensitive) {
            ZPEConsole.this.lastCode = code;
            ZPEConsole.this.lastArgs = args2;
            ZPEConsole.this.lastWasCI = caseInsensitive;
        }

        @Override
        protected Void doInBackground() {
            try {
                ZPEConsole.this.consoleOutput.setText("");
                ZPEConsole.this.yass = new ZPERuntimeEnvironment(ZPEConsole.this.permission_level);
                try {
                    ZPEKit.interpret(ZPEConsole.this.yass, ZPEConsole.this.lastCode, ZPEConsole.this.lastArgs, ZPEConsole.this.lastWasCI);
                }
                catch (CompileException | InternalException e) {
                    System.err.println(e.getMessage());
                }
                catch (ZPERuntimeException e) {
                    System.err.println(e.getMessage());
                    if (ZPEKit.isDebugging()) {
                        ZPEVariableWatchWindow bp = new ZPEVariableWatchWindow();
                        bp.setVisible(true);
                        bp.setSize(new Dimension(400, 200));
                        bp.toFront();
                        bp.setAlwaysOnTop(true);
                        bp.update(ZPEHelperFunctions.listAllVariables(ZPEConsole.this.yass));
                    }
                }
                catch (ExitHalt e) {
                    System.err.println("Exit interrupt fired.");
                }
                catch (BreakPointHalt e) {
                    ZPEVariableWatchWindow bp = new ZPEVariableWatchWindow();
                    bp.setVisible(true);
                    bp.setSize(new Dimension(400, 200));
                    bp.toFront();
                    bp.setAlwaysOnTop(true);
                    bp.update(ZPEHelperFunctions.listAllVariables(ZPEConsole.this.yass));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void done() {
            System.out.println("Code execution finished.");
        }
    }
}

