/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.editor;

import jamiebalfour.ui.BalfRoundedButton;
import jamiebalfour.zpe.editor.ZPEEditorMain;
import jamiebalfour.zpe.types.ZPEMap;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ZPEOnlineFileChooser
extends JFrame {
    private static final long serialVersionUID = -1652914532483459930L;
    JList<String> list;
    DefaultListModel<String> listModel = new DefaultListModel();
    ZPEEditorMain parent;

    public ZPEOnlineFileChooser(final ZPEEditorMain parent, final Map<String, String> arguments, final ZPEMap selections, ArrayList<String> files, final boolean publicrepo) {
        this.parent = parent;
        this.setTitle("ZPE Online file picker");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setPreferredSize(new Dimension(300, 400));
        this.getContentPane().add((Component)scrollPane, "Center");
        JPanel panel = new JPanel();
        scrollPane.setViewportView(panel);
        this.list = new JList<String>(this.listModel);
        panel.add(this.list);
        panel.setBackground(this.list.getBackground());
        this.list.setLayoutOrientation(0);
        this.addFiles(files);
        JPanel panel_1 = new JPanel();
        this.getContentPane().add((Component)panel_1, "South");
        final BalfRoundedButton btnCancelButton = new BalfRoundedButton("Cancel");
        btnCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZPEOnlineFileChooser.this.close(btnCancelButton);
            }
        });
        panel_1.add(btnCancelButton);
        final BalfRoundedButton btnOpenButton = new BalfRoundedButton("Open");
        btnOpenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                parent.loadFromCloudFile(ZPEOnlineFileChooser.this.list.getSelectedValue(), arguments, selections, publicrepo);
                ZPEOnlineFileChooser.this.close(btnOpenButton);
            }
        });
        panel_1.add(btnOpenButton);
        this.setMaximumSize(new Dimension(300, 400));
        JOptionPane op = new JOptionPane(this.getContentPane(), 0, 1, new ImageIcon(), new String[0]);
        JDialog dlg = op.createDialog(null, "ZPE Online file picker");
        dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dlg.setVisible(true);
    }

    private void close(Component c) {
        Window w = SwingUtilities.getWindowAncestor(c);
        if (w != null) {
            w.setVisible(false);
        }
    }

    private void addFiles(ArrayList<String> files) {
        for (String s : files) {
            this.listModel.addElement(s);
        }
    }
}

