/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.editor;

import jamiebalfour.HelperFunctions;
import jamiebalfour.ui.BalfRoundedButton;
import jamiebalfour.zpe.editor.ZPEEditorMain;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ZPEFunctionGenerator
extends JDialog {
    private static final long serialVersionUID = -1057101846395915703L;
    JPanel unitPanel;
    JLabel lblFunctionNameLabel;
    ZPEFunctionGenerator _this = this;

    ZPEFunctionGenerator(String name, String group, String function, ZPEEditorMain owner) {
        int i;
        this.setTitle("ZPE Function Machine");
        ZPEEditorMain parent = owner;
        Font paramFont = new Font("Courier New", 0, 13);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.lblFunctionNameLabel = new JLabel("New label");
        this.lblFunctionNameLabel.setFont(new Font("Courier New", 0, 18));
        this.getContentPane().add((Component)this.lblFunctionNameLabel, "North");
        JScrollPane scrollPane = new JScrollPane();
        this.getContentPane().add((Component)scrollPane, "Center");
        JPanel bottom = new JPanel();
        this.getContentPane().add((Component)bottom, "South");
        BalfRoundedButton readDocumentation = new BalfRoundedButton("Read documentation");
        String path = (group.toLowerCase() + "/" + name.toLowerCase()).replace(" ", "_");
        readDocumentation.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/documentation/functions/" + path);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.getContentPane(), "Could not open the ZPE website", "Failure", 0);
            }
        });
        BalfRoundedButton submit = new BalfRoundedButton("Insert code");
        submit.addActionListener(e -> {
            StringBuilder output = new StringBuilder(this.lblFunctionNameLabel.getText() + "(");
            ArrayList<String> values2 = new ArrayList<String>();
            for (Component c : this.unitPanel.getComponents()) {
                if (!(c instanceof JPanel)) continue;
                JLabel currentLabel = null;
                JPanel p = (JPanel)c;
                for (Component ele : p.getComponents()) {
                    if (ele instanceof JLabel) {
                        currentLabel = (JLabel)ele;
                    }
                    if (!(ele instanceof JTextField)) continue;
                    String current = ((JTextField)ele).getText();
                    if (current.isEmpty() && Objects.requireNonNull(currentLabel).getText().endsWith("*")) {
                        JOptionPane.showMessageDialog(this._this, "Required parameter " + currentLabel.getText().substring(0, currentLabel.getText().length() - 1) + " is empty.");
                        continue;
                    }
                    if (current.isEmpty()) continue;
                    values2.add(current);
                }
            }
            int i = 0;
            for (String current : values2) {
                output.append(current);
                if (i < values2.size() - 1) {
                    output.append(", ");
                }
                ++i;
            }
            output.append(")");
            Window w = SwingUtilities.getWindowAncestor(submit);
            if (w != null) {
                w.setVisible(false);
            }
            parent.doReplacement(output.toString());
        });
        bottom.add(readDocumentation);
        bottom.add(submit);
        this.unitPanel = new JPanel();
        scrollPane.setViewportView(this.unitPanel);
        scrollPane.setPreferredSize(new Dimension(300, 300));
        GridLayout g = new GridLayout(1, 0, 0, 0);
        this.unitPanel.setLayout(g);
        StringBuilder functionName = new StringBuilder();
        for (i = 0; i < function.length() && function.charAt(i) != ' '; ++i) {
            functionName.append(function.charAt(i));
        }
        ArrayList<param> params = this.getParams(function.substring(i));
        this.lblFunctionNameLabel.setText(functionName.toString());
        for (param p : params) {
            JPanel paramPanel = new JPanel();
            paramPanel.setLayout(new GridLayout(2, 0, 0, 0));
            JLabel paramName = new JLabel();
            paramName.setFont(paramFont);
            String opt = "";
            if (!p.getOptional()) {
                opt = "*";
            }
            paramName.setText("{" + p.getDataType() + "} " + p.getParam() + opt);
            paramPanel.add(paramName);
            JTextField paramValue = new JTextField();
            paramValue.setPreferredSize(new Dimension(200, 30));
            if (p.dataType.equals("string")) {
                paramValue.setText("\"\"");
            }
            paramPanel.add(paramValue);
            g.setRows(g.getRows() + 1);
            this.unitPanel.add(paramPanel);
        }
    }

    private ArrayList<param> getParams(String function) {
        int i;
        ArrayList<param> params = new ArrayList<param>();
        for (i = 0; i < function.length(); ++i) {
            if (function.charAt(i) != '(') continue;
            ++i;
            break;
        }
        boolean optional = false;
        while (i < function.length() && function.charAt(i) != ')') {
            if (function.charAt(i) == '[') {
                optional = true;
                ++i;
            }
            if (function.charAt(i) == '{') {
                StringBuilder dataType = new StringBuilder();
                StringBuilder name = new StringBuilder();
                ++i;
                while (i < function.length() && function.charAt(i) != '}') {
                    dataType.append(function.charAt(i));
                    ++i;
                }
                ++i;
                while (i < function.length() && function.charAt(i) == ' ') {
                    ++i;
                }
                while (i < function.length() && function.charAt(i) != ',' && function.charAt(i) != ')' && function.charAt(i) != '[' && function.charAt(i) != ']' && function.charAt(i) != '.') {
                    name.append(function.charAt(i));
                    ++i;
                }
                while (i < function.length() && function.charAt(i) == '.') {
                    ++i;
                }
                if (function.charAt(i) == '[') {
                    --i;
                }
                param p = new param();
                p.setParam(name.toString());
                p.setDataType(dataType.toString());
                p.setOptional(optional);
                params.add(p);
                if (function.charAt(i) == ']') {
                    optional = false;
                    ++i;
                }
            }
            ++i;
        }
        return params;
    }

    private static class param {
        private String paramName;
        private String dataType;
        private boolean optional;

        private param() {
        }

        public String getParam() {
            return this.paramName;
        }

        public void setParam(String v) {
            this.paramName = v;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String v) {
            this.dataType = v;
        }

        public boolean getOptional() {
            return this.optional;
        }

        public void setOptional(boolean v) {
            this.optional = v;
        }
    }
}

