/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.editor;

import jamiebalfour.HelperFunctions;
import jamiebalfour.ui.BalfSplashScreen;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.editor.ZPEEditorMain;
import jamiebalfour.zpe.gui.ZPEConsole;
import jamiebalfour.zpe.interfaces.GenericEditor;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class ZPEEditor {
    public static void StartEditor() {
        ZPEEditor.StartEditor(null);
    }

    public static void StartEditor(String f) {
        try {
            URL imagePath = HelperFunctions.isMac() ? ZPEEditorMain.class.getResource("/files/ZPELogomacOS.png") : ZPEEditorMain.class.getResource("/files/ZPELogoLighter.png");
            ImageIcon lighterLogo = new ImageIcon(imagePath);
            new BalfSplashScreen("ZPE Editor", "ZPE Editor", "Copyright Jamie Balfour 2015 - 2025", "Loading ZPE Editor", lighterLogo, new Color(118, 65, 146), lighterLogo).showFor(1000);
            new ZPEEditorMain("ZPE Editors", f);
        }
        catch (NoSuchMethodError | UnsatisfiedLinkError e) {
            e.printStackTrace();
            System.err.println("The editor could not be started. This is possibly due to being in a headless (non-GUI supporting) environment.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Other type of error occurred.");
        }
    }

    public static ZPEConsole createConsole(GenericEditor editor, String title, Font f, int permission_level) {
        return new ZPEConsole(editor, title, f, permission_level);
    }

    public static ArrayList<String> getRecentFiles(String path) {
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(ZPEInstance.getInstallPath() + path + "recent-files.lst"));
            ArrayList<String> lines = new ArrayList<String>();
            while ((str = in.readLine()) != null) {
                if (lines.contains(str)) continue;
                lines.add(str);
            }
            ArrayList<String> list = new ArrayList<String>();
            if (lines.size() > 7) {
                int start;
                for (int i = start = lines.size() - 7; i < lines.size(); ++i) {
                    list.add(lines.get(i));
                }
            } else {
                return lines;
            }
            return list;
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    public static void storeRecentFiles(ArrayList<String> files, String path) throws IOException {
        StringBuilder output = new StringBuilder();
        for (String s : files) {
            output.append(s).append('\n');
        }
        HelperFunctions.writeFile(ZPEInstance.getInstallPath() + path + "recent-files.lst", output.toString(), false);
    }

    static ArrayList<AbstractMap.SimpleEntry<String, String>> getParams(String function) {
        int i;
        ArrayList<AbstractMap.SimpleEntry<String, String>> array = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        for (i = 0; i < function.length(); ++i) {
            if (function.charAt(i) != '(') continue;
            ++i;
            break;
        }
        boolean optional = false;
        while (i < function.length() && function.charAt(i) != ')') {
            if (function.charAt(i) == '[') {
                optional = true;
                ++i;
            }
            if (function.charAt(i) == '{') {
                StringBuilder dataType = new StringBuilder();
                StringBuilder name = new StringBuilder();
                ++i;
                while (i < function.length() && function.charAt(i) != '}') {
                    dataType.append(function.charAt(i));
                    ++i;
                }
                ++i;
                while (i < function.length() && function.charAt(i) == ' ') {
                    ++i;
                }
                while (i < function.length() && function.charAt(i) != ',' && function.charAt(i) != ')' && function.charAt(i) != '[' && function.charAt(i) != ']' && function.charAt(i) != '.') {
                    name.append(function.charAt(i));
                    ++i;
                }
                while (i < function.length() && function.charAt(i) == '.') {
                    ++i;
                }
                if (function.charAt(i) == '[') {
                    --i;
                }
                AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(name.toString(), dataType.toString());
                array.add(entry);
                if (function.charAt(i) == ']') {
                    optional = false;
                    ++i;
                }
            }
            ++i;
        }
        return array;
    }

    public static ImageIcon getIcon() {
        return new ImageIcon(ZPEEditorMain.class.getResource("/files/ZPELogoLighter.png"));
    }
}

