/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.editor;

import jamiebalfour.parsers.json.MalformedJSONException;
import jamiebalfour.ui.BalfRoundedButton;
import jamiebalfour.zpe.core.ChatGPT;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.editor.AIAssistantResult;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class AIAssistant
extends JFrame {
    JTextArea mainEditor;
    AIAssistant _this = this;

    public AIAssistant(JEditorPane edit) {
        JPanel mainPanel = new JPanel();
        this.getContentPane().add(mainPanel);
        mainPanel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBackground(Color.white);
        scrollPane.setEnabled(false);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(32);
        this.mainEditor = new JTextArea();
        this.mainEditor.setBorder(new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(10, 10, 10, 10);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }
        });
        scrollPane.setViewportView(this.mainEditor);
        mainPanel.add((Component)scrollPane, "Center");
        BalfRoundedButton generateBtn = new BalfRoundedButton("Generate");
        generateBtn.addActionListener(e -> {
            ChatGPT c = null;
            try {
                c = ChatGPT.getInstance();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "ChatGPT is not configured correctly.");
            }
            String result = "";
            if (c != null) {
                try {
                    result = c.sendMessage("Build a program in Jamie Balfour's YASS language (https://www.jamiebalfour.scot/projects/zpe/documentation/) and give only code (absolutely nothing else) that does the following " + this.mainEditor.getText());
                    String results = ChatGPT.parseResultsToMessage(result);
                    AIAssistantResult aiRes = new AIAssistantResult(results, edit);
                    aiRes.setVisible(true);
                    aiRes.setLocationRelativeTo(this._this);
                    this._this.dispose();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, "Error generating code using ChatGPT.");
                }
                catch (MalformedJSONException ex) {
                    ZPE.log(result);
                    JOptionPane.showMessageDialog(this, "The result sent back was the wrong format.");
                }
            }
        });
        mainPanel.add((Component)generateBtn, "South");
        this.setSize(new Dimension(600, 400));
    }
}

