/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.HelperFunctions;
import jamiebalfour.parsers.json.MalformedJSONException;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

class ZULEPackageManager {
    ZULEPackageManager() {
    }

    static void list() throws ZPERuntimeException, MalformedJSONException {
        String list;
        System.out.println("Searching the main repository");
        try {
            list = HelperFunctions.readString(ZPEInstance.ZULE_PATH + "/?command=list");
        }
        catch (Exception e) {
            list = null;
        }
        ZenithJSONParser parser = new ZenithJSONParser();
        System.out.println("");
        String currentType = "";
        for (ZPEType s : (ZPEList)parser.jsonDecode(list, false)) {
            ZPEMap a = (ZPEMap)s;
            if (!currentType.equals(a.get("type").toString())) {
                currentType = a.get("type").toString();
                System.out.println(currentType);
            }
            System.out.println("  [+] " + a.get("name").toString() + " => " + a.get("size").toString());
        }
    }

    static boolean install(String resource) throws Exception {
        int count;
        String d = "";
        System.out.println("Searching the main repository...");
        String list = HelperFunctions.readString(ZPEInstance.ZULE_PATH + "/?command=list");
        ZenithJSONParser parser = new ZenithJSONParser();
        for (ZPEType s : (ZPEList)parser.jsonDecode(list, false)) {
            ZPEMap a = (ZPEMap)s;
            if (!a.get("name").toString().toLowerCase().equals(((String)resource).toLowerCase())) continue;
            resource = a.get("name").toString();
            d = a.get("type").toString();
            break;
        }
        String p = ZPEInstance.ZULE_PATH + "/?command=install&vector=" + (String)resource;
        int i = 0;
        URL url = new URL(p);
        BufferedInputStream br = new BufferedInputStream(url.openStream());
        if (d.equals("Plugin")) {
            resource = ZPEInstance.PLUGIN_DIRECTORY + (String)resource;
        } else if (d.equals("Library")) {
            resource = ZPEInstance.ZPE_LIBRARY_IMPORT_DIRECTORY + (String)resource;
        } else if (d.equals("Converter")) {
            resource = ZPEInstance.TRANSPILERS_DIRECTORY + (String)resource;
        }
        FileOutputStream fw = new FileOutputStream((String)resource);
        byte[] data = new byte[1024];
        while ((count = br.read(data, 0, 1024)) != -1) {
            ++i;
            fw.write(data, 0, count);
        }
        if (i == 0) {
            System.out.println("No such file found in the ZULE repository.");
        } else {
            System.out.println("Written file to " + (String)resource);
        }
        br.close();
        fw.close();
        return true;
    }

    static ReadableByteChannel zuleFetch(String resource) throws Exception {
        URL website = new URL(ZPEInstance.ZULE_PATH + "/?command=install&vector=" + resource);
        return Channels.newChannel(website.openStream());
    }
}

